@extends('layouts.app')
@section('title', 'Edit User')
@section('content')


<section class="content">
  <div class="row">       
    <div class="col-lg-12 col-12">
      <div class="box">
      <form method="post" name="userform" id="userform" action="{{url('save-edit-extension')}}">
                            @csrf
                            <input type="hidden" class="form-control" name="extension_id" value="{{$extension_list->id}}" id ="extension_id" required>

          <div class="box-body"><!--bg-lightest-->
            <h4 class="box-title text-info mb-0"><i class="fa fa-edit me-15"></i> Edit Extension Info</h4>
            <a href="{{url('/extension')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i> Extensions</a>

            <hr class="my-15">
            <div class="row">
              <div class="col-md-6">
                <div class="form-group @error('first_name') has-error @enderror">
                  <label class="form-label">First Name</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('first_name') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <input type="text" class="form-control" name="first_name" value="{{$extension_list->first_name}}" id ="first-name" required oninput="validateInput(this)">
                  </div>
                  <div id="nameError" class="text-danger" style="display: none;">Special characters are not allowed in the First Name </div>

                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Last Name</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <input type="text" class="form-control" name="last_name" value="{{$extension_list->last_name}}" id ="last-name" required oninput="validateInputLastName(this)">
                  </div>
                  <div id="nameError1" class="text-danger" style="display: none;">Special characters are not allowed in the Last Name </div>

                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-md-6">
                <div class="form-group @error('extension') has-error @enderror">
                  <label class="form-label">Extension</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('extension') text-danger border-danger @enderror"><i class="ti-mobile"></i></span>
                    <input type="text" class="form-control" name="user_ext" value="{{substr($extension_list->extension,-4,4)}}" disabled>

                  </div>
                </div>
              </div>
              <input type="hidden" id="old_email" value="{{$extension_list->email}}" />

              <div class="col-md-6">
                <div class="form-group @error('email') has-error @enderror">
                  <label class="form-label">E-mail<span id="errorEmailExtension"></span></label>
                  <div class="input-group mb-3 ">
                    <span class="input-group-text @error('email') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                    <input type="text" class="form-control" disabled id="email"  name="email" value="{{$extension_list->email}}" id ="email">
                    @if(Session::get('level') >= 7)
                                <div class="input-group-btn closed" id="editOption">
                                    <button type="button" onclick="editEmail();" class="btn btn-primary ">Edit</button>
                                </div>
                                 <div class="input-group-btn open" id="update" style="display: none;">
                                    <button type="button"  id="updateEmail" class="btn btn-info ">Update</button>
                                </div>
                                 <div class="input-group-btn open" style="display: none;padding: 0px 3px;">
                                    <a type="button" id="showEdit"    class="btn btn-warning ">Cancel</a>
                                </div>


                                @endif
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
           
              <div class="col-md-6">
                <div class="form-group @error('asterisk_server_id') has-error @enderror">
                  <label class="form-label">Voice Server</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text"><i class="ti-server"></i></span>

                    <select class="form-select"   name="asterisk_server_id" id="asterisk_server_id" @if(Session::get('role') !== 'system_administrator') disabled @endif>
                            @if(!empty($server_list))
                                @foreach($server_list as $skey => $slists)
                                @php
                                                        if(!empty($slists->detail))
                                                        $details = "-".$slists->detail;
                                                        else
                                                        $details="";

                                                        @endphp
                                    <option value={{$slists->id}}
                                    @if(!empty($server_list))
                                        @if ($extension_list->asterisk_server_id == $slists->id)
                                                    {{'selected="selected"'}}
                                        @endif
                                    @endif
                                    >{{$slists->title_name}}{{$details}}</option>
                                @endforeach
                            @endif
                            </select>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group @error('follow_me') has-error @enderror">
                  <label class="form-label">Follow Me</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text"><i class="ti-world"></i></span>
                    <select class="form-select" name="follow_me" id ="follow-me">
                                    <option @if($extension_list->follow_me == 1) selected @endif value="1">Yes</option>
                                    <option @if($extension_list->follow_me == 2) selected @endif value="2">No</option>
                                </select>
                  </div>
                </div>
              </div>
            </div>


            <div class="row">
          

              <div class="col-md-6">
                <div class="form-group @error('call_forward') has-error @enderror">
                  <label class="form-label">Call Forward</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text"><i class="ti-world"></i></span>
                    <select class="form-control" name="call_forward" id ="call-forward">
                                    <option @if($extension_list->call_forward == 1) selected @endif value="1">Yes</option>
                                    <option @if($extension_list->call_forward == 2) selected @endif value="2">No</option>


                                </select>
                  </div>
                </div>
              </div>

              <div class="col-md-3">
                <div class="form-group @error('enable_2fa') has-error @enderror">
                  <label class="form-label">Enable 2FA</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text"><i class="ti-world"></i></span>
                    <select class="form-select" name="enable_2fa" id="enable_2fa" >
                                                        <option @if($extension_list->enable_2fa == 0) selected @endif value="0">No</option>
                                                        <option @if($extension_list->enable_2fa == 1) selected @endif value="1">Yes</option>
                                                    </select>
                  </div>
                </div>
              </div>

              <div class="col-md-3">
                <div class="form-group @error('app_status') has-error @enderror">
                  <label class="form-label">Allow Mobile App Login</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text"><i class="ti-world"></i></span>
                    <select class="form-select" name="app_status" id="app_status">
                    <option @if($extension_list->app_status == 0) selected @endif value="0">No</option>
                                                        <option @if($extension_list->app_status == 1) selected @endif value="1">Yes</option>
                                                </select>
                  </div>
                </div>
              </div>

              <div class="col-md-3">
                <div class="form-group @error('voicemail') has-error @enderror">
                  <label class="form-label">VoiceMail</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text"><i class="ti-world"></i></span>
                    <select class="form-select" name="voicemail" id ="voicemail">
                                    <option @if($extension_list->voicemail == 1) selected @endif value="1">Yes</option>
                                    <option @if($extension_list->voicemail == 2) selected @endif value="2">No</option>
                                </select>
                  </div>
                </div>
              </div>

              <div class="col-md-3">
                <div class="form-group @error('voicemail_send_to_email') has-error @enderror">
                  <label class="form-label">Send Voicemail to email</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text"><i class="ti-world"></i></span>
                    <select class="form-select" name="voicemail_send_to_email" id ="send-voicemail">
                                    <option @if($extension_list->voicemail_send_to_email == 1) selected @endif value="1">Yes</option>
                                    <option @if($extension_list->voicemail_send_to_email == 2) selected @endif value="2">No</option>
                                </select>
                  </div>
                </div>
              </div>

              <div class="col-md-3">
                <div class="form-group @error('twinning') has-error @enderror">
                  <label class="form-label">Twinning</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text"><i class="ti-world"></i></span>
                    <select class="form-select" name="twinning" id ="twinning">
                                    <option @if($extension_list->twinning == 1) selected @endif value="1">Yes</option>
                                    <option @if($extension_list->twinning == 2) selected @endif value="2">No</option>
                                </select>
                  </div>
                </div>
              </div>

              <div class="col-md-3">
                <div class="form-group @error('ip_filtering') has-error @enderror">
                  <label class="form-label">IP Filtering</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text"><i class="ti-world"></i></span>
                    <select class="form-select" name="ip_filtering" id="ip_filtering" >
                                                        <option @if($extension_list->ip_filtering == 0) selected @endif value="0">No</option>
                                                        <option @if($extension_list->ip_filtering == 1) selected @endif value="1">Yes</option>
                                                    </select>
                  </div>
                </div>
              </div>
            </div>

            <div class="row">

              <div class="col-md-6">
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group">
                      <label class="form-label">Select</label>
                        <div class="input-group mb-3">
                          <span class="input-group-text"><i class="ti-world"></i></span>
                          <select  class="form-select sms_grid" name="countryCode" id="countryCode">
                          <option @if($extension_list->country_code == '44') selected @endif data-countryCode="GB" value="44" >UK (+44)</option>
                                            <option @if($extension_list->country_code == '1') selected @endif data-countryCode="CA" value="1">Canada (+1)</option>
                                            <option @if($extension_list->country_code == '1') selected @endif data-countryCode="US" value="1">USA (+1)</option>
                                            <optgroup label="Other countries">
                                                <option @if($extension_list->country_code == '213') selected @endif data-countryCode="DZ" value="213">Algeria (+213)</option>
                                                <option @if($extension_list->country_code == '376') selected @endif data-countryCode="AD" value="376">Andorra (+376)</option>
                                                <option @if($extension_list->country_code == '244') selected @endif data-countryCode="AO" value="244">Angola (+244)</option>
                                                <option @if($extension_list->country_code == '1264') selected @endif data-countryCode="AI" value="1264">Anguilla (+1264)</option>
                                                <option @if($extension_list->country_code == '1268') selected @endif data-countryCode="AG" value="1268">Antigua &amp; Barbuda (+1268)</option>
                                                <option @if($extension_list->country_code == '54') selected @endif data-countryCode="AR" value="54">Argentina (+54)</option>
                                                <option @if($extension_list->country_code == '374') selected @endif data-countryCode="AM" value="374">Armenia (+374)</option>
                                                <option @if($extension_list->country_code == '297') selected @endif data-countryCode="AW" value="297">Aruba (+297)</option>
                                                <option @if($extension_list->country_code == '61') selected @endif data-countryCode="AU" value="61">Australia (+61)</option>
                                                <option @if($extension_list->country_code == '43') selected @endif data-countryCode="AT" value="43">Austria (+43)</option>
                                                <option @if($extension_list->country_code == '994') selected @endif data-countryCode="AZ" value="994">Azerbaijan (+994)</option>
                                                <option @if($extension_list->country_code == '1242') selected @endif data-countryCode="BS" value="1242">Bahamas (+1242)</option>
                                                <option @if($extension_list->country_code == '973') selected @endif data-countryCode="BH" value="973">Bahrain (+973)</option>
                                                <option @if($extension_list->country_code == '880') selected @endif data-countryCode="BD" value="880">Bangladesh (+880)</option>
                                                <option @if($extension_list->country_code == '1246') selected @endif data-countryCode="BB" value="1246">Barbados (+1246)</option>
                                                <option @if($extension_list->country_code == '375') selected @endif data-countryCode="BY" value="375">Belarus (+375)</option>
                                                <option @if($extension_list->country_code == '32') selected @endif data-countryCode="BE" value="32">Belgium (+32)</option>
                                                <option @if($extension_list->country_code == '501') selected @endif data-countryCode="BZ" value="501">Belize (+501)</option>
                                                <option @if($extension_list->country_code == '229') selected @endif data-countryCode="BJ" value="229">Benin (+229)</option>
                                                <option @if($extension_list->country_code == '1441') selected @endif data-countryCode="BM" value="1441">Bermuda (+1441)</option>
                                                <option @if($extension_list->country_code == '975') selected @endif data-countryCode="BT" value="975">Bhutan (+975)</option>
                                                <option @if($extension_list->country_code == '591') selected @endif data-countryCode="BO" value="591">Bolivia (+591)</option>
                                                <option @if($extension_list->country_code == '387') selected @endif data-countryCode="BA" value="387">Bosnia Herzegovina (+387)</option>
                                                <option @if($extension_list->country_code == '267') selected @endif data-countryCode="BW" value="267">Botswana (+267)</option>
                                                <option @if($extension_list->country_code == '55') selected @endif data-countryCode="BR" value="55">Brazil (+55)</option>
                                                <option @if($extension_list->country_code == '673') selected @endif data-countryCode="BN" value="673">Brunei (+673)</option>
                                                <option @if($extension_list->country_code == '359') selected @endif data-countryCode="BG" value="359">Bulgaria (+359)</option>
                                                <option @if($extension_list->country_code == '226') selected @endif data-countryCode="BF" value="226">Burkina Faso (+226)</option>
                                                <option @if($extension_list->country_code == '257') selected @endif data-countryCode="BI" value="257">Burundi (+257)</option>
                                                <option @if($extension_list->country_code == '855') selected @endif data-countryCode="KH" value="855">Cambodia (+855)</option>
                                                <option @if($extension_list->country_code == '237') selected @endif data-countryCode="CM" value="237">Cameroon (+237)</option>

                                                <option @if($extension_list->country_code == '238') selected @endif data-countryCode="CV" value="238">Cape Verde Islands (+238)</option>
                                                <option @if($extension_list->country_code == '1345') selected @endif data-countryCode="KY" value="1345">Cayman Islands (+1345)</option>
                                                <option @if($extension_list->country_code == '236') selected @endif data-countryCode="CF" value="236">Central African Republic (+236)</option>
                                                <option @if($extension_list->country_code == '53') selected @endif data-countryCode="CL" value="56">Chile (+56)</option>
                                                <option @if($extension_list->country_code == '86') selected @endif data-countryCode="CN" value="86">China (+86)</option>
                                                <option @if($extension_list->country_code == '57') selected @endif data-countryCode="CO" value="57">Colombia (+57)</option>
                                                <option @if($extension_list->country_code == '269') selected @endif data-countryCode="KM" value="269">Comoros (+269)</option>
                                                <option @if($extension_list->country_code == '242') selected @endif data-countryCode="CG" value="242">Congo (+242)</option>
                                                <option @if($extension_list->country_code == '682') selected @endif data-countryCode="CK" value="682">Cook Islands (+682)</option>
                                                <option @if($extension_list->country_code == '506') selected @endif data-countryCode="CR" value="506">Costa Rica (+506)</option>
                                                <option @if($extension_list->country_code == '385') selected @endif data-countryCode="HR" value="385">Croatia (+385)</option>
                                                <option @if($extension_list->country_code == '53') selected @endif data-countryCode="CU" value="53">Cuba (+53)</option>
                                                <option @if($extension_list->country_code == '90392') selected @endif data-countryCode="CY" value="90392">Cyprus North (+90392)</option>
                                                <option @if($extension_list->country_code == '357') selected @endif data-countryCode="CY" value="357">Cyprus South (+357)</option>
                                                <option @if($extension_list->country_code == '42') selected @endif data-countryCode="CZ" value="42">Czech Republic (+42)</option>
                                                <option @if($extension_list->country_code == '45') selected @endif data-countryCode="DK" value="45">Denmark (+45)</option>
                                                <option @if($extension_list->country_code == '253') selected @endif data-countryCode="DJ" value="253">Djibouti (+253)</option>

                                                <option @if($extension_list->country_code == '1809') selected @endif data-countryCode="DO" value="1809">Dominican Republic (+1809)</option>
                                                <option @if($extension_list->country_code == '593') selected @endif data-countryCode="EC" value="593">Ecuador (+593)</option>
                                                <option @if($extension_list->country_code == '20') selected @endif data-countryCode="EG" value="20">Egypt (+20)</option>
                                                <option @if($extension_list->country_code == '503') selected @endif data-countryCode="SV" value="503">El Salvador (+503)</option>
                                                <option @if($extension_list->country_code == '240') selected @endif data-countryCode="GQ" value="240">Equatorial Guinea (+240)</option>
                                                <option @if($extension_list->country_code == '291') selected @endif data-countryCode="ER" value="291">Eritrea (+291)</option>
                                                <option @if($extension_list->country_code == '372') selected @endif data-countryCode="EE" value="372">Estonia (+372)</option>
                                                <option @if($extension_list->country_code == '251') selected @endif data-countryCode="ET" value="251">Ethiopia (+251)</option>
                                                <option @if($extension_list->country_code == '500') selected @endif data-countryCode="FK" value="500">Falkland Islands (+500)</option>
                                                <option @if($extension_list->country_code == '298') selected @endif data-countryCode="FO" value="298">Faroe Islands (+298)</option>
                                                <option @if($extension_list->country_code == '679') selected @endif data-countryCode="FJ" value="679">Fiji (+679)</option>
                                                <option @if($extension_list->country_code == '358') selected @endif data-countryCode="FI" value="358">Finland (+358)</option>
                                                <option @if($extension_list->country_code == '33') selected @endif data-countryCode="FR" value="33">France (+33)</option>
                                                <option @if($extension_list->country_code == '594') selected @endif data-countryCode="GF" value="594">French Guiana (+594)</option>
                                                <option @if($extension_list->country_code == '689') selected @endif data-countryCode="PF" value="689">French Polynesia (+689)</option>
                                                <option @if($extension_list->country_code == '241') selected @endif data-countryCode="GA" value="241">Gabon (+241)</option>
                                                <option @if($extension_list->country_code == '220') selected @endif data-countryCode="GM" value="220">Gambia (+220)</option>
                                                <option @if($extension_list->country_code == '7880') selected @endif data-countryCode="GE" value="7880">Georgia (+7880)</option>
                                                <option @if($extension_list->country_code == '49') selected @endif data-countryCode="DE" value="49">Germany (+49)</option>
                                                <option @if($extension_list->country_code == '233') selected @endif data-countryCode="GH" value="233">Ghana (+233)</option>
                                                <option @if($extension_list->country_code == '350') selected @endif data-countryCode="GI" value="350">Gibraltar (+350)</option>
                                                <option @if($extension_list->country_code == '30') selected @endif data-countryCode="GR" value="30">Greece (+30)</option>
                                                <option @if($extension_list->country_code == '299') selected @endif data-countryCode="GL" value="299">Greenland (+299)</option>
                                                <option @if($extension_list->country_code == '1473') selected @endif data-countryCode="GD" value="1473">Grenada (+1473)</option>
                                                <option @if($extension_list->country_code == '590') selected @endif  data-countryCode="GP" value="590">Guadeloupe (+590)</option>
                                                <option @if($extension_list->country_code == '671') selected @endif data-countryCode="GU" value="671">Guam (+671)</option>
                                                <option @if($extension_list->country_code == '502') selected @endif data-countryCode="GT" value="502">Guatemala (+502)</option>
                                                <option @if($extension_list->country_code == '224') selected @endif data-countryCode="GN" value="224">Guinea (+224)</option>
                                                <option @if($extension_list->country_code == '245') selected @endif data-countryCode="GW" value="245">Guinea - Bissau (+245)</option>
                                                <option @if($extension_list->country_code == '592') selected @endif data-countryCode="GY" value="592">Guyana (+592)</option>
                                                <option @if($extension_list->country_code == '509') selected @endif data-countryCode="HT" value="509">Haiti (+509)</option>
                                                <option @if($extension_list->country_code == '504') selected @endif data-countryCode="HN" value="504">Honduras (+504)</option>
                                                <option @if($extension_list->country_code == '852') selected @endif data-countryCode="HK" value="852">Hong Kong (+852)</option>
                                                <option @if($extension_list->country_code == '36') selected @endif data-countryCode="HU" value="36">Hungary (+36)</option>
                                                <option @if($extension_list->country_code == '354') selected @endif data-countryCode="IS" value="354">Iceland (+354)</option>
                                                <option @if($extension_list->country_code == '91') selected @endif data-countryCode="IN" value="91">India (+91)</option>
                                                <option @if($extension_list->country_code == '62') selected @endif data-countryCode="ID" value="62">Indonesia (+62)</option>
                                                <option @if($extension_list->country_code == '98') selected @endif data-countryCode="IR" value="98">Iran (+98)</option>
                                                <option @if($extension_list->country_code == '964') selected @endif data-countryCode="IQ" value="964">Iraq (+964)</option>
                                                <option @if($extension_list->country_code == '353') selected @endif data-countryCode="IE" value="353">Ireland (+353)</option>
                                                <option @if($extension_list->country_code == '972') selected @endif data-countryCode="IL" value="972">Israel (+972)</option>
                                                <option @if($extension_list->country_code == '39') selected @endif data-countryCode="IT" value="39">Italy (+39)</option>
                                                <option @if($extension_list->country_code == '1876') selected @endif data-countryCode="JM" value="1876">Jamaica (+1876)</option>
                                                <option @if($extension_list->country_code == '81') selected @endif @if($extension_list->country_code == '81') selected @endif data-countryCode="JP" value="81">Japan (+81)</option>
                                                <option @if($extension_list->country_code == '962') selected @endif data-countryCode="JO" value="962">Jordan (+962)</option>
                                                <option @if($extension_list->country_code == '7') selected @endif data-countryCode="KZ" value="7">Kazakhstan (+7)</option>
                                                <option @if($extension_list->country_code == '254') selected @endif data-countryCode="KE" value="254">Kenya (+254)</option>
                                                <option @if($extension_list->country_code == '686') selected @endif data-countryCode="KI" value="686">Kiribati (+686)</option>
                                                <option @if($extension_list->country_code == '850') selected @endif data-countryCode="KP" value="850">Korea North (+850)</option>
                                                <option @if($extension_list->country_code == '82') selected @endif data-countryCode="KR" value="82">Korea South (+82)</option>
                                                <option @if($extension_list->country_code == '965') selected @endif data-countryCode="KW" value="965">Kuwait (+965)</option>
                                                <option @if($extension_list->country_code == '996') selected @endif data-countryCode="KG" value="996">Kyrgyzstan (+996)</option>
                                                <option @if($extension_list->country_code == '856') selected @endif data-countryCode="LA" value="856">Laos (+856)</option>
                                                <option @if($extension_list->country_code == '371') selected @endif data-countryCode="LV" value="371">Latvia (+371)</option>
                                                <option @if($extension_list->country_code == '961') selected @endif data-countryCode="LB" value="961">Lebanon (+961)</option>
                                                <option @if($extension_list->country_code == '266') selected @endif data-countryCode="LS" value="266">Lesotho (+266)</option>
                                                <option @if($extension_list->country_code == '231') selected @endif data-countryCode="LR" value="231">Liberia (+231)</option>
                                                <option @if($extension_list->country_code == '218') selected @endif data-countryCode="LY" value="218">Libya (+218)</option>
                                                <option @if($extension_list->country_code == '417') selected @endif data-countryCode="LI" value="417">Liechtenstein (+417)</option>
                                                <option @if($extension_list->country_code == '370') selected @endif data-countryCode="LT" value="370">Lithuania (+370)</option>
                                                <option @if($extension_list->country_code == '352') selected @endif data-countryCode="LU" value="352">Luxembourg (+352)</option>
                                                <option @if($extension_list->country_code == '853') selected @endif data-countryCode="MO" value="853">Macao (+853)</option>
                                                <option @if($extension_list->country_code == '389') selected @endif data-countryCode="MK" value="389">Macedonia (+389)</option>
                                                <option @if($extension_list->country_code == '261') selected @endif data-countryCode="MG" value="261">Madagascar (+261)</option>
                                                <option @if($extension_list->country_code == '265') selected @endif data-countryCode="MW" value="265">Malawi (+265)</option>
                                                <option @if($extension_list->country_code == '60') selected @endif data-countryCode="MY" value="60">Malaysia (+60)</option>
                                                <option @if($extension_list->country_code == '960') selected @endif data-countryCode="MV" value="960">Maldives (+960)</option>
                                                <option @if($extension_list->country_code == '223') selected @endif data-countryCode="ML" value="223">Mali (+223)</option>
                                                <option @if($extension_list->country_code == '356') selected @endif data-countryCode="MT" value="356">Malta (+356)</option>
                                                <option @if($extension_list->country_code == '692') selected @endif data-countryCode="MH" value="692">Marshall Islands (+692)</option>
                                                <option @if($extension_list->country_code == '596') selected @endif data-countryCode="MQ" value="596">Martinique (+596)</option>
                                                <option @if($extension_list->country_code == '222') selected @endif data-countryCode="MR" value="222">Mauritania (+222)</option>
                                                <option @if($extension_list->country_code == '269') selected @endif data-countryCode="YT" value="269">Mayotte (+269)</option>
                                                <option @if($extension_list->country_code == '52') selected @endif data-countryCode="MX" value="52">Mexico (+52)</option>
                                                <option @if($extension_list->country_code == '691') selected @endif data-countryCode="FM" value="691">Micronesia (+691)</option>
                                                <option @if($extension_list->country_code == '373') selected @endif data-countryCode="MD" value="373">Moldova (+373)</option>
                                                <option @if($extension_list->country_code == '377') selected @endif data-countryCode="MC" value="377">Monaco (+377)</option>
                                                <option @if($extension_list->country_code == '976') selected @endif data-countryCode="MN" value="976">Mongolia (+976)</option>
                                                <option @if($extension_list->country_code == '1664') selected @endif data-countryCode="MS" value="1664">Montserrat (+1664)</option>
                                                <option @if($extension_list->country_code == '212') selected @endif data-countryCode="MA" value="212">Morocco (+212)</option>
                                                <option @if($extension_list->country_code == '258') selected @endif data-countryCode="MZ" value="258">Mozambique (+258)</option>
                                                <option @if($extension_list->country_code == '95') selected @endif data-countryCode="MN" value="95">Myanmar (+95)</option>
                                                <option @if($extension_list->country_code == '264') selected @endif data-countryCode="NA" value="264">Namibia (+264)</option>
                                                <option @if($extension_list->country_code == '674') selected @endif data-countryCode="NR" value="674">Nauru (+674)</option>
                                                <option @if($extension_list->country_code == '977') selected @endif data-countryCode="NP" value="977">Nepal (+977)</option>
                                                <option @if($extension_list->country_code == '31') selected @endif data-countryCode="NL" value="31">Netherlands (+31)</option>
                                                <option @if($extension_list->country_code == '687') selected @endif data-countryCode="NC" value="687">New Caledonia (+687)</option>
                                                <option @if($extension_list->country_code == '64') selected @endif data-countryCode="NZ" value="64">New Zealand (+64)</option>
                                                <option @if($extension_list->country_code == '505') selected @endif data-countryCode="NI" value="505">Nicaragua (+505)</option>
                                                <option @if($extension_list->country_code == '227') selected @endif data-countryCode="NE" value="227">Niger (+227)</option>
                                                <option @if($extension_list->country_code == '234') selected @endif data-countryCode="NG" value="234">Nigeria (+234)</option>
                                                <option @if($extension_list->country_code == '683') selected @endif data-countryCode="NU" value="683">Niue (+683)</option>
                                                <option @if($extension_list->country_code == '672') selected @endif data-countryCode="NF" value="672">Norfolk Islands (+672)</option>
                                                <option @if($extension_list->country_code == '670') selected @endif data-countryCode="NP" value="670">Northern Marianas (+670)</option>
                                                <option @if($extension_list->country_code == '47') selected @endif data-countryCode="NO" value="47">Norway (+47)</option>
                                                <option @if($extension_list->country_code == '968') selected @endif data-countryCode="OM" value="968">Oman (+968)</option>
                                                <option @if($extension_list->country_code == '680') selected @endif data-countryCode="PW" value="680">Palau (+680)</option>
                                                <option @if($extension_list->country_code == '507') selected @endif data-countryCode="PA" value="507">Panama (+507)</option>
                                                <option @if($extension_list->country_code == '675') selected @endif data-countryCode="PG" value="675">Papua New Guinea (+675)</option>
                                                <option @if($extension_list->country_code == '595') selected @endif data-countryCode="PY" value="595">Paraguay (+595)</option>
                                                <option @if($extension_list->country_code == '51') selected @endif data-countryCode="PE" value="51">Peru (+51)</option>
                                                <option @if($extension_list->country_code == '63') selected @endif data-countryCode="PH" value="63">Philippines (+63)</option>
                                                <option @if($extension_list->country_code == '48') selected @endif data-countryCode="PL" value="48">Poland (+48)</option>
                                                <option @if($extension_list->country_code == '351') selected @endif data-countryCode="PT" value="351">Portugal (+351)</option>
                                                <option @if($extension_list->country_code == '1787') selected @endif data-countryCode="PR" value="1787">Puerto Rico (+1787)</option>
                                                <option @if($extension_list->country_code == '974') selected @endif data-countryCode="QA" value="974">Qatar (+974)</option>
                                                <option @if($extension_list->country_code == '262') selected @endif data-countryCode="RE" value="262">Reunion (+262)</option>
                                                <option @if($extension_list->country_code == '40') selected @endif data-countryCode="RO" value="40">Romania (+40)</option>
                                                <option @if($extension_list->country_code == '7') selected @endif data-countryCode="RU" value="7">Russia (+7)</option>
                                                <option @if($extension_list->country_code == '250') selected @endif data-countryCode="RW" value="250">Rwanda (+250)</option>
                                                <option @if($extension_list->country_code == '378') selected @endif data-countryCode="SM" value="378">San Marino (+378)</option>
                                                <option @if($extension_list->country_code == '239') selected @endif data-countryCode="ST" value="239">Sao Tome &amp; Principe (+239)</option>
                                                <option @if($extension_list->country_code == '966') selected @endif data-countryCode="SA" value="966">Saudi Arabia (+966)</option>
                                                <option @if($extension_list->country_code == '221') selected @endif data-countryCode="SN" value="221">Senegal (+221)</option>
                                                <option @if($extension_list->country_code == '381') selected @endif data-countryCode="CS" value="381">Serbia (+381)</option>
                                                <option @if($extension_list->country_code == '248') selected @endif data-countryCode="SC" value="248">Seychelles (+248)</option>
                                                <option @if($extension_list->country_code == '232') selected @endif data-countryCode="SL" value="232">Sierra Leone (+232)</option>
                                                <option @if($extension_list->country_code == '65') selected @endif data-countryCode="SG" value="65">Singapore (+65)</option>
                                                <option @if($extension_list->country_code == '421') selected @endif data-countryCode="SK" value="421">Slovak Republic (+421)</option>
                                                <option @if($extension_list->country_code == '386') selected @endif data-countryCode="SI" value="386">Slovenia (+386)</option>
                                                <option @if($extension_list->country_code == '677') selected @endif data-countryCode="SB" value="677">Solomon Islands (+677)</option>
                                                <option @if($extension_list->country_code == '252') selected @endif data-countryCode="SO" value="252">Somalia (+252)</option>
                                                <option @if($extension_list->country_code == '27') selected @endif data-countryCode="ZA" value="27">South Africa (+27)</option>
                                                <option @if($extension_list->country_code == '34') selected @endif data-countryCode="ES" value="34">Spain (+34)</option>
                                                <option @if($extension_list->country_code == '94') selected @endif data-countryCode="LK" value="94">Sri Lanka (+94)</option>
                                                <option @if($extension_list->country_code == '262') selected @endif data-countryCode="SH" value="290">St. Helena (+290)</option>
                                                <option @if($extension_list->country_code == '1869') selected @endif data-countryCode="KN" value="1869">St. Kitts (+1869)</option>
                                                <option @if($extension_list->country_code == '1758') selected @endif data-countryCode="SC" value="1758">St. Lucia (+1758)</option>
                                                <option @if($extension_list->country_code == '249') selected @endif data-countryCode="SD" value="249">Sudan (+249)</option>
                                                <option @if($extension_list->country_code == '597') selected @endif data-countryCode="SR" value="597">Suriname (+597)</option>
                                                <option @if($extension_list->country_code == '268') selected @endif data-countryCode="SZ" value="268">Swaziland (+268)</option>
                                                <option @if($extension_list->country_code == '46') selected @endif data-countryCode="SE" value="46">Sweden (+46)</option>
                                                <option @if($extension_list->country_code == '41') selected @endif data-countryCode="CH" value="41">Switzerland (+41)</option>
                                                <option @if($extension_list->country_code == '963') selected @endif data-countryCode="SI" value="963">Syria (+963)</option>
                                                <option @if($extension_list->country_code == '886') selected @endif data-countryCode="TW" value="886">Taiwan (+886)</option>
                                                <option @if($extension_list->country_code == '7') selected @endif data-countryCode="TJ" value="7">Tajikstan (+7)</option>
                                                <option @if($extension_list->country_code == '66') selected @endif data-countryCode="TH" value="66">Thailand (+66)</option>
                                                <option @if($extension_list->country_code == '228') selected @endif data-countryCode="TG" value="228">Togo (+228)</option>
                                                <option @if($extension_list->country_code == '676') selected @endif data-countryCode="TO" value="676">Tonga (+676)</option>
                                                <option @if($extension_list->country_code == '1868') selected @endif data-countryCode="TT" value="1868">Trinidad &amp; Tobago (+1868)</option>
                                                <option @if($extension_list->country_code == '216') selected @endif data-countryCode="TN" value="216">Tunisia (+216)</option>
                                                <option @if($extension_list->country_code == '90') selected @endif data-countryCode="TR" value="90">Turkey (+90)</option>
                                                <option @if($extension_list->country_code == '7') selected @endif data-countryCode="TM" value="7">Turkmenistan (+7)</option>
                                                <option @if($extension_list->country_code == '993') selected @endif data-countryCode="TM" value="993">Turkmenistan (+993)</option>
                                                <option @if($extension_list->country_code == '1649') selected @endif data-countryCode="TC" value="1649">Turks &amp; Caicos Islands (+1649)</option>
                                                <option @if($extension_list->country_code == '688') selected @endif data-countryCode="TV" value="688">Tuvalu (+688)</option>
                                                <option @if($extension_list->country_code == '256') selected @endif data-countryCode="UG" value="256">Uganda (+256)</option>
                                                <!-- <option data-countryCode="GB" value="44">UK (+44)</option> -->
                                                <option @if($extension_list->country_code == '380') selected @endif data-countryCode="UA" value="380">Ukraine (+380)</option>
                                                <option @if($extension_list->country_code == '971') selected @endif data-countryCode="AE" value="971">United Arab Emirates (+971)</option>
                                                <option @if($extension_list->country_code == '598') selected @endif data-countryCode="UY" value="598">Uruguay (+598)</option>
                                                <!-- <option data-countryCode="US" value="1">USA (+1)</option> -->
                                                <option @if($extension_list->country_code == '7') selected @endif data-countryCode="UZ" value="7">Uzbekistan (+7)</option>
                                                <option @if($extension_list->country_code == '678') selected @endif data-countryCode="VU" value="678">Vanuatu (+678)</option>
                                                <option @if($extension_list->country_code == '379') selected @endif data-countryCode="VA" value="379">Vatican City (+379)</option>
                                                <option @if($extension_list->country_code == '58') selected @endif data-countryCode="VE" value="58">Venezuela (+58)</option>
                                                <option @if($extension_list->country_code == '84') selected @endif data-countryCode="VN" value="84">Vietnam (+84)</option>
                                                <option @if($extension_list->country_code == '84') selected @endif data-countryCode="VG" value="84">Virgin Islands - British (+1284)</option>
                                                <option @if($extension_list->country_code == '84') selected @endif data-countryCode="VI" value="84">Virgin Islands - US (+1340)</option>
                                                <option @if($extension_list->country_code == '681') selected @endif data-countryCode="WF" value="681">Wallis &amp; Futuna (+681)</option>
                                                <option @if($extension_list->country_code == '969') selected @endif data-countryCode="YE" value="969">Yemen (North)(+969)</option>
                                                <option @if($extension_list->country_code == '967') selected @endif data-countryCode="YE" value="967">Yemen (South)(+967)</option>
                                                <option @if($extension_list->country_code == '260') selected @endif data-countryCode="ZM" value="260">Zambia (+260)</option>
                                                <option @if($extension_list->country_code == '263') selected @endif data-countryCode="ZW" value="263">Zimbabwe (+263)</option>

                                            </optgroup>
                                                    </select>

                      <!-- <select class="form-select"  name="country_code">

                        @if(!empty($phone_country))
                          @foreach($phone_country as $phone_code)
                            <option @if($phone_code->phone_code == 1) selected @endif {{ old('country_code') == $phone_code->phone_code ? "selected" : "" }} value="{{$phone_code->phone_code}}">{{$phone_code->country_name}} (+{{$phone_code->phone_code}})</option>
                          @endforeach
                        @endif
                      </select> -->
                    </div>

                    </div>
                  </div>

                  <div class="col-md-6"class="sms_grid">
                    <div class="form-group @error('mobile') has-error @enderror">
                      <label class="form-label">Phone Number</label>
                        <div class="input-group mb-3">
                          <span class="input-group-text @error('mobile') text-danger border-danger @enderror"><i class="ti-mobile"></i></span>
                          <input type="text" name="mobile"  value="{{$extension_list->mobile}}" id="mobile" class="form-control @error('mobile') border-danger @enderror" placeholder="Type Phone Number">

                        </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group @error('vm_pin') has-error @enderror">
                  <label class="form-label">VoiceMail Pin</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('vm_pin') text-danger border-danger @enderror"><i class="ti-mobile"></i></span>
                    <input type="text" class="form-control" name="vm_pin" value="{{$extension_list->vm_pin}}" id="vm-pin">
                    <button type="button" onclick="document.getElementById('vm-pin').value =  getVoicemail(1000,9999)" class="btn btn-primary btn-sm btn-sms">Auto Generate</button>
                  </div>
                </div>
              </div>
            </div>


            <div class="row">
              <div class="col-md-6">
                <div class="form-group @error('cli_setting') has-error @enderror">
                  <label class="form-label">CLI Setting</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('cli_setting') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="cli_setting" id ="cli_setting" onchange="return show_box(this.value)">
                                    <option @if($extension_list->cli_setting == 0) selected @endif value="0">Area Code</option>
                                    <option @if($extension_list->cli_setting == 1) selected @endif value="1">Custom</option>
                                    <option @if($extension_list->cli_setting == 2) selected @endif value="2">AreaCode And Randomizer</option>
                                   

                                </select>
                  </div>
                </div>
              </div>
              <div class="col-md-6 cli_box_view" @if($extension_list->cli_setting == 0 || $extension_list->cli_setting == 2) style='display:none' @endif>
                <div class="form-group @error('cli_setting') has-error @enderror">
                  <span class="cli_box_view" >
                  <label class="form-label">Custom CLI</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('cli_setting') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                      <select  class="form-select" name="cli" value="" id="cli">
                                <option value="">Select DID</option>
                                    @if(count($did_list) > 0)
                                        @foreach(array_reverse($did_list) as $key => $lists)
                                            <option data-cnam="{{$lists->cnam}}" @if($extension_list->cli == $lists->cli) selected @endif value="<?php echo $lists->cli ?>"><?php echo $lists->cli ?> <?php if(!empty($lists->cnam)) echo '-'.$lists->cnam ?>
                                                            @if($lists->dest_type>0)
                                    -{{ !empty($destTypeList[$lists->dest_type]) ? $destTypeList[$lists->dest_type] : ''  }}
                                @else
                                    @if($lists->cnam != null)
                                        -IVR
                                    @else
                                        
                                    @endif
                                @endif
                                @if($lists->dest_type > 0)
                                    @if($lists->dest_type == 1)
                                        @foreach($user_extension_list as $extension)
                                            @if($lists->extension == $extension->id)
                                                -{{$extension->first_name}} {{$extension->last_name}} - {{$extension->extension}} 
                                            @endif
                                        @endforeach
                                    @elseif($lists->dest_type == 2)
                                        @foreach($user_extension_list as $extension)
                                            @if($lists->voicemail_id == $extension->id)
                                                -{{$extension->first_name}} {{$extension->last_name}} - {{$extension->extension}} 
                                            @endif
                                        @endforeach
                                    @elseif($lists->dest_type == 8)
                                        @foreach($ring_group_list as $ring)
                                            @if($lists->ingroup == $ring->id)
                                                -{{$ring->description}} - {{$ring->title}}
                                            @endif
                                        @endforeach
                                    @elseif($lists->dest_type == 5)
                                        @foreach($conferencing as $conf)
                                            @if($lists->conf_id == $conf->id)
                                                -{{$conf->title}} - {{$conf->conference_id}}
                                            @endif
                                        @endforeach
                                    @elseif($lists->dest_type == 4)
                                        {{$lists->forward_number}}

                                    @elseif($lists->dest_type == 10)
                                        Run CNAM

                                         @elseif($lists->dest_type == 12)
                                        Voice AI
                                    @else
                                        -
                                    @endif
                                @else
                                    @foreach($ivr_list as $ivr)
                                        @if($lists->ivr_id == $ivr->ivr_id)
                                            -{{$ivr->ivr_desc}} 
                                        @endif
                                    @endforeach
                                @endif
                                            
                                            </option>
                                        @endforeach
                                    @endif
                      </select>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group @error('extension_type') has-error @enderror">
                  <label class="form-label">Extension Type</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('extension_type') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="extension_type" id ="extension_type" >
                                    <option @if($extension_list->extension_type == 1) selected @endif value="1">Extension</option>
                                    <option @if($extension_list->extension_type == 2) selected @endif value="2">Ring Group</option>
                                </select>
                  </div>
                </div>
              </div>
              <input type="hidden" class="form-control" name="sms_setting_id" value="0" id ="sms_setting_id" >

         
           
              <div class="col-md-6"id="cnam_show" @if($extension_list->cli_setting == 0 || $extension_list->cli_setting == 2) style='display:none' @endif>
                <div class="form-group @error('cli_setting') has-error @enderror">
                <span  class="cnam_show" >
                  <label class="form-label">CNAM</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('cli_setting') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <input type="text" class="form-control" name="cnam" value="{{$extension_list->cnam}}" id ="cnam">

                  </div>
                </span>
                </div>
              </div>
             
         
              <div class="col-md-6">
                <div class="form-group @error('group_id') has-error @enderror">
                  <label class="form-label">Group</label> 
                  <div class="input-group mb-3">
                  <select class="select2" multiple="multiple" name="group_id[]" autocomplete="off" data-placeholder="Select Group" style="width: 100%;">

                                @foreach($group as $groups)

                                    <option @if(in_array($groups->id, $mapping))  selected  @endif value="{{$groups->id}}">{{$groups->title}}</option>
                                    @endforeach;
                    </select>
                </div>
              </div>
         
              </div>
       

              @if($assigned_package)
              <div class="col-md-6">
                <div class="form-group @error('package_id') has-error @enderror">
                  <label class="form-label">Package Assigned </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('package_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <input type="text" class="form-control" disabled  name="package-assigned" value="{{$assigned_package}}" id ="package-assigned">

                  </div>
                </div>
              </div>
             @endif
              <!-- @if(!empty($voip_configurations))
              <div class="col-md-6">
                <div class="form-group @error('extension_type') has-error @enderror">
                  <label class="form-label">Outbound Line </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('extension_type') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" required name="voip_configurations" autocomplete="off" data-placeholder="Select Disposition" >
                            <option value="">Select VOIP</option>
                            @foreach($voip_configurations as $key => $voip)
                            <option @if($extension_list->voip_configuration_id == $voip->id) selected @endif  value="{{$voip->id}}">{{$voip->name}}</option>
                            @endforeach;
                        </select>
                  </div>
                </div>
              </div>
              @endif -->
              <div class="col-md-6">
                <div class="form-group @error('cli_setting') has-error @enderror">
                <span id="cnam_show" class="" >
                  <label class="form-label">Forward Incoming SMS To</label> 
                  <div class="input-group mb-3">
                    <div class="demo-checkbox">
                      <input type="checkbox" id="receive_sms_on_email"name="receive_sms_on_email"  @if($extension_list->receive_sms_on_email == 1) checked  @endif  />
                      <label for="receive_sms_on_email">Email</label>
                      <input type="checkbox" name="receive_sms_on_mobile"id="receive_sms_on_mobile" @if($extension_list->receive_sms_on_mobile == 1) checked  @endif />
                      <label for="receive_sms_on_mobile">SMS</label>
                    </div>
                  </div>
                    </span>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group @error('package_id') has-error @enderror">
                  <label class="form-label">Timezone</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('package_id') text-danger border-danger @enderror"><i class="ti-time"></i></span>
                    <select class="form-select" name="timezone" required>
                                    <option value="">Select Timezone</option>
                                    <option @if($extension_list->timezone == 'Pacific/Midway') selected @endif value="Pacific/Midway">(GMT-11:00) Midway Island, Samoa</option>

                                    <option @if($extension_list->timezone == 'America/Adak') selected @endif value="America/Adak">(GMT-10:00) Hawaii-Aleutian</option>

                                    <option @if($extension_list->timezone == 'Etc/GMT+10') selected @endif value="Etc/GMT+10">(GMT-10:00) Hawaii</option>

                                    <option @if($extension_list->timezone == 'Pacific/Marquesas') selected @endif value="Pacific/Marquesas">(GMT-09:30) Marquesas Islands</option>

                                    <option @if($extension_list->timezone == 'Pacific/Gambier') selected @endif value="Pacific/Gambier">(GMT-09:00) Gambier Islands</option>

                                    <option @if($extension_list->timezone == 'America/Anchorage') selected @endif value="America/Anchorage">(GMT-09:00) Alaska</option>

                                    <option @if($extension_list->timezone == 'America/Ensenada') selected @endif value="America/Ensenada">(GMT-08:00) Tijuana, Baja California</option>

                                    <option @if($extension_list->timezone == 'Etc/GMT+8') selected @endif value="Etc/GMT+8">(GMT-08:00) Pitcairn Islands</option>

                                    <option @if($extension_list->timezone == 'America/Los_Angeles') selected @endif value="America/Los_Angeles">(GMT-08:00) Pacific Time (US & Canada)</option>

                                    <option @if($extension_list->timezone == 'America/Denver') selected @endif value="America/Denver">(GMT-07:00) Mountain Time (US & Canada)</option>

                                    <option @if($extension_list->timezone == 'America/Chihuahua') selected @endif value="America/Chihuahua">(GMT-07:00) Chihuahua, La Paz, Mazatlan</option>

                                    <option @if($extension_list->timezone == 'America/Dawson_Creek') selected @endif value="America/Dawson_Creek">(GMT-07:00) Arizona</option>

                                    <option @if($extension_list->timezone == 'America/Belize') selected @endif value="America/Belize">(GMT-06:00) Saskatchewan, Central America</option>

                                    <option @if($extension_list->timezone == 'America/Cancun') selected @endif value="America/Cancun">(GMT-06:00) Guadalajara, Mexico City, Monterrey</option>

                                    <option @if($extension_list->timezone == 'Chile/EasterIsland') selected @endif value="Chile/EasterIsland">(GMT-06:00) Easter Island</option>

                                    <option @if($extension_list->timezone == 'America/Chicago') selected @endif value="America/Chicago">(GMT-06:00) Central Time (US & Canada)</option>

                                    <option @if($extension_list->timezone == 'America/New_York') selected @endif value="America/New_York">(GMT-05:00) Eastern Time (US & Canada)</option>

                                    <option @if($extension_list->timezone == 'America/Havana') selected @endif value="America/Havana">(GMT-05:00) Cuba</option>

                                    <option @if($extension_list->timezone == 'America/Bogota') selected @endif value="America/Bogota">(GMT-05:00) Bogota, Lima, Quito, Rio Branco</option>

                                    <option @if($extension_list->timezone == 'America/Caracas') selected @endif  value="America/Caracas">(GMT-04:30) Caracas</option>

                                    <option @if($extension_list->timezone == 'America/Santiago') selected @endif  value="America/Santiago">(GMT-04:00) Santiago</option>

                                    <option @if($extension_list->timezone == 'America/La_Paz') selected @endif  value="America/La_Paz">(GMT-04:00) La Paz</option>

                                    <option @if($extension_list->timezone == 'Atlantic/Stanley') selected @endif  value="Atlantic/Stanley">(GMT-04:00) Faukland Islands</option>

                                    <option @if($extension_list->timezone == 'America/Campo_Grande') selected @endif  value="America/Campo_Grande">(GMT-04:00) Brazil</option>

                                    <option @if($extension_list->timezone == 'America/Goose_Bay') selected @endif  value="America/Goose_Bay">(GMT-04:00) Atlantic Time (Goose Bay)</option>

                                    <option @if($extension_list->timezone == 'America/Glace_Bay') selected @endif  value="America/Glace_Bay">(GMT-04:00) Atlantic Time (Canada)</option>

                                    <option @if($extension_list->timezone == 'America/St_Johns') selected @endif  value="America/St_Johns">(GMT-03:30) Newfoundland</option>

                                    <option @if($extension_list->timezone == 'America/Araguaina') selected @endif  value="America/Araguaina">(GMT-03:00) UTC-3</option>

                                    <option @if($extension_list->timezone == 'America/Montevideo') selected @endif  value="America/Montevideo">(GMT-03:00) Montevideo</option>

                                    <option @if($extension_list->timezone == 'America/Miquelon') selected @endif  value="America/Miquelon">(GMT-03:00) Miquelon, St. Pierre</option>

                                    <option @if($extension_list->timezone == 'America/Godthab') selected @endif  value="America/Godthab">(GMT-03:00) Greenland</option>

                                    <option @if($extension_list->timezone == 'America/Argentina/Buenos_Aires') selected @endif  value="America/Argentina/Buenos_Aires">(GMT-03:00) Buenos Aires</option>

                                    <option @if($extension_list->timezone == 'America/Sao_Paulo') selected @endif  value="America/Sao_Paulo">(GMT-03:00) Brasilia</option>

                                    <option @if($extension_list->timezone == 'America/Noronha') selected @endif  value="America/Noronha">(GMT-02:00) Mid-Atlantic</option>

                                    <option @if($extension_list->timezone == 'Atlantic/Cape_Verde') selected @endif  value="Atlantic/Cape_Verde">(GMT-01:00) Cape Verde Is.</option>

                                    <option @if($extension_list->timezone == 'Atlantic/Azores') selected @endif  value="Atlantic/Azores">(GMT-01:00) Azores</option>

                                    <option @if($extension_list->timezone == 'Europe/Belfast') selected @endif value="Europe/Belfast">(GMT) Greenwich Mean Time : Belfast</option>

                                    <option @if($extension_list->timezone == 'Europe/Dublin') selected @endif value="Europe/Dublin">(GMT) Greenwich Mean Time : Dublin</option>

                                    <option @if($extension_list->timezone == 'Europe/Lisbon') selected @endif value="Europe/Lisbon">(GMT) Greenwich Mean Time : Lisbon</option>

                                    <option @if($extension_list->timezone == 'Europe/London') selected @endif value="Europe/London">(GMT) Greenwich Mean Time : London</option>

                                    <option @if($extension_list->timezone == 'Africa/Abidjan') selected @endif value="Africa/Abidjan">(GMT) Monrovia, Reykjavik</option>

                                    <option @if($extension_list->timezone == 'Europe/Amsterdam') selected @endif value="Europe/Amsterdam">(GMT+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna</option>

                                    <option @if($extension_list->timezone == 'Europe/Belgrade') selected @endif value="Europe/Belgrade">(GMT+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague</option>

                                    <option @if($extension_list->timezone == 'Europe/Brussels') selected @endif value="Europe/Brussels">(GMT+01:00) Brussels, Copenhagen, Madrid, Paris</option>

                                    <option @if($extension_list->timezone == 'Africa/Algiers') selected @endif value="Africa/Algiers">(GMT+01:00) West Central Africa</option>

                                    <option @if($extension_list->timezone == 'Africa/Windhoek') selected @endif value="Africa/Windhoek">(GMT+01:00) Windhoek</option>

                                    <option @if($extension_list->timezone == 'Asia/Beirut') selected @endif value="Asia/Beirut">(GMT+02:00) Beirut</option>

                                    <option @if($extension_list->timezone == 'Africa/Cairo') selected @endif value="Africa/Cairo">(GMT+02:00) Cairo</option>

                                    <option  @if($extension_list->timezone == 'Asia/Gaza') selected @endif value="Asia/Gaza">(GMT+02:00) Gaza</option>

                                    <option  @if($extension_list->timezone == 'Africa/Blantyre') selected @endif value="Africa/Blantyre">(GMT+02:00) Harare, Pretoria</option>

                                    <option  @if($extension_list->timezone == 'Asia/Jerusalem') selected @endif value="Asia/Jerusalem">(GMT+02:00) Jerusalem</option>

                                    <option  @if($extension_list->timezone == 'Europe/Minsk') selected @endif value="Europe/Minsk">(GMT+02:00) Minsk</option>

                                    <option  @if($extension_list->timezone == 'Asia/Damascus') selected @endif value="Asia/Damascus">(GMT+02:00) Syria</option>

                                    <option  @if($extension_list->timezone == 'Europe/Moscow') selected @endif value="Europe/Moscow">(GMT+03:00) Moscow, St. Petersburg, Volgograd</option>

                                    <option @if($extension_list->timezone == 'Africa/Addis_Ababa') selected @endif value="Africa/Addis_Ababa">(GMT+03:00) Nairobi</option>

                                    <option @if($extension_list->timezone == 'Asia/Tehran') selected @endif value="Asia/Tehran">(GMT+03:30) Tehran</option>

                                    <option @if($extension_list->timezone == 'Asia/Dubai') selected @endif value="Asia/Dubai">(GMT+04:00) Abu Dhabi, Muscat</option>

                                    <option @if($extension_list->timezone == 'Asia/Yerevan') selected @endif value="Asia/Yerevan">(GMT+04:00) Yerevan</option>

                                    <option @if($extension_list->timezone == 'Asia/Kabul') selected @endif value="Asia/Kabul">(GMT+04:30) Kabul</option>

                                    <option @if($extension_list->timezone == 'Asia/Yekaterinburg') selected @endif value="Asia/Yekaterinburg">(GMT+05:00) Ekaterinburg</option>

                                    <option @if($extension_list->timezone == 'Asia/Tashkent') selected @endif value="Asia/Tashkent">(GMT+05:00) Tashkent</option>

                                    <option @if($extension_list->timezone == 'Asia/Kolkata') selected @endif value="Asia/Kolkata">(GMT+05:30) Chennai, Kolkata, Mumbai, New Delhi</option>

                                    <option @if($extension_list->timezone == 'Asia/Katmandu') selected @endif value="Asia/Katmandu">(GMT+05:45) Kathmandu</option>

                                    <option @if($extension_list->timezone == 'Asia/Dhaka') selected @endif value="Asia/Dhaka">(GMT+06:00) Astana, Dhaka</option>

                                    <option @if($extension_list->timezone == 'Asia/Novosibirsk') selected @endif value="Asia/Novosibirsk">(GMT+06:00) Novosibirsk</option>

                                    <option @if($extension_list->timezone == 'Asia/Rangoon') selected @endif value="Asia/Rangoon">(GMT+06:30) Yangon (Rangoon)</option>

                                    <option @if($extension_list->timezone == 'Asia/Bangkok') selected @endif value="Asia/Bangkok">(GMT+07:00) Bangkok, Hanoi, Jakarta</option>

                                    <option @if($extension_list->timezone == 'Asia/Krasnoyarsk') selected @endif value="Asia/Krasnoyarsk">(GMT+07:00) Krasnoyarsk</option>

                                    <option @if($extension_list->timezone == 'Asia/Hong_Kong') selected @endif value="Asia/Hong_Kong">(GMT+08:00) Beijing, Chongqing, Hong Kong, Urumqi
                                    </option>

                                    <option @if($extension_list->timezone == 'Asia/Irkutsk') selected @endif  value="Asia/Irkutsk">(GMT+08:00) Irkutsk, Ulaan Bataar</option>

                                    <option @if($extension_list->timezone == 'Australia/Perth') selected @endif  value="Australia/Perth">(GMT+08:00) Perth</option>

                                    <option @if($extension_list->timezone == 'Australia/Eucla') selected @endif  value="Australia/Eucla">(GMT+08:45) Eucla</option>

                                    <option @if($extension_list->timezone == 'Asia/Tokyo') selected @endif  value="Asia/Tokyo">(GMT+09:00) Osaka, Sapporo, Tokyo</option>

                                    <option @if($extension_list->timezone == 'Asia/Seoul') selected @endif  value="Asia/Seoul">(GMT+09:00) Seoul</option>

                                    <option @if($extension_list->timezone == 'Asia/Yakutsk') selected @endif  value="Asia/Yakutsk">(GMT+09:00) Yakutsk</option>

                                    <option @if($extension_list->timezone == 'Australia/Adelaide') selected @endif  value="Australia/Adelaide">(GMT+09:30) Adelaide</option>

                                    <option @if($extension_list->timezone == 'Australia/Darwin') selected @endif  value="Australia/Darwin">(GMT+09:30) Darwin</option>

                                    <option @if($extension_list->timezone == 'Australia/Brisbane') selected @endif  value="Australia/Brisbane">(GMT+10:00) Brisbane</option>

                                    <option @if($extension_list->timezone == 'Australia/Hobart') selected @endif  value="Australia/Hobart">(GMT+10:00) Hobart</option>

                                    <option @if($extension_list->timezone == 'Asia/Vladivostok') selected @endif  value="Asia/Vladivostok">(GMT+10:00) Vladivostok</option>

                                    <option @if($extension_list->timezone == 'Australia/Lord_Howe') selected @endif  value="Australia/Lord_Howe">(GMT+10:30) Lord Howe Island</option>

                                    <option @if($extension_list->timezone == 'Etc/GMT-11') selected @endif  value="Etc/GMT-11">(GMT+11:00) Solomon Is., New Caledonia</option>

                                    <option @if($extension_list->timezone == 'Asia/Magadan') selected @endif  value="Asia/Magadan">(GMT+11:00) Magadan</option>

                                    <option @if($extension_list->timezone == 'Pacific/Norfolk') selected @endif value="Pacific/Norfolk">(GMT+11:30) Norfolk Island</option>

                                    <option @if($extension_list->timezone == 'Asia/Anadyr') selected @endif value="Asia/Anadyr">(GMT+12:00) Anadyr, Kamchatka</option>

                                    <option @if($extension_list->timezone == 'Pacific/Auckland') selected @endif value="Pacific/Auckland">(GMT+12:00) Auckland, Wellington</option>

                                    <option @if($extension_list->timezone == 'Etc/GMT-12') selected @endif value="Etc/GMT-12">(GMT+12:00) Fiji, Kamchatka, Marshall Is.</option>

                                    <option @if($extension_list->timezone == 'Pacific/Chatham') selected @endif value="Pacific/Chatham">(GMT+12:45) Chatham Islands</option>

                                    <option @if($extension_list->timezone == 'Pacific/Tongatapu') selected @endif value="Pacific/Tongatapu">(GMT+13:00) Nuku'alofa</option>

                                    <option @if($extension_list->timezone == 'Pacific/Kiritimati') selected @endif value="Pacific/Kiritimati">(GMT+14:00) Kiritimati</option>

                                   </select>
                  </div>
                </div>
              </div>
             
            </div>
            <div class="col-md-6">
                <div class="form-group @error('group_id') has-error @enderror">
                  <label class="form-label">Manager Emails</label> 
                  <div class="input-group mb-3">
                  <select class="select2" multiple="multiple" name="manager_email[]" autocomplete="off" 
        data-placeholder="Select Emails" style="width: 100%;">
 @foreach(collect($extensions)->where('role', 3) as $ext_lst)
    <option value="{{ $ext_lst->email }}"
        @if(!empty($extension_list->manager_email) && in_array($ext_lst->email, explode(',', $extension_list->manager_email))) 
            selected 
        @endif>
        {{ $ext_lst->email }}
    </option>
@endforeach
</select>

                </div>
              </div>
         
              </div>
<div class="col-md-6">
  <div class="form-group @error('cli_setting') has-error @enderror">
    <div class="input-group mb-3">
      <div class="demo-checkbox">
        <input type="checkbox" name="no_answer" id="no_answer" />
        <label for="no_answer">No Answer Redirect to Phone Number</label>
      </div>
    </div>

    <!-- Input field container -->
    <div id="extraInputs"></div>
  </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function () {
  const checkbox = document.getElementById("no_answer");
  const container = document.getElementById("extraInputs");
  const existingValue = `{{$extension_list->no_answer_redirect}}`; // Blade variable

  // Initialize checkbox and input based on existing value
  if (existingValue) {
    checkbox.checked = true;
    container.innerHTML = `
      <div class="form-group mt-2" id="phoneField">
        <input type="text" name="no_answer_redirect" value="${existingValue}" class="form-control" placeholder="Enter Phone Number" />
      </div>
    `;
  }

  // Checkbox toggle
  checkbox.addEventListener("change", function () {
    if (this.checked) {
      container.innerHTML = `
        <div class="form-group mt-2" id="phoneField">
          <input type="text" name="no_answer_redirect" value="${existingValue}" class="form-control" placeholder="Enter Phone Number" />
        </div>
      `;
    } else {
      // Remove input even if it has value
      container.innerHTML = '';
    }
  });
});
</script>

             
            <div class="box-footer text-end">
             <a href="/extension"> <button type="button" class="btn btn-warning me-1">
                  <i class="ti-trash"></i> Cancel
                </button></a>

                <a onclick="window.location.reload();"><button type="button" class="btn btn-danger me-1">
                  <i class="ti-reload"></i> Reset
                </button>
                </a>
                <button type="submit" name ="submit" value="add"class="btn btn-primary">
                  <i class="ti-save-alt"></i> Update
                </button>
              </div>  
            </form>
                       </div>  
              </div>
              <!-- /.box-body -->
                      <!-- /.box -->      
        </div>  
        <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="add-edit"></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="post" action="">
         @csrf
      <div class="modal-body">
   
      <input type="hidden" class="form-control" name="id" value="" id="edit-group-id" required>
      <div class="form-group">
                                    <label for="inputEmail3" class="col-form-label">Name</label>
                                    <input type="text" class="form-control" required name="title" id="title" placeholder="Enter Name" value="" />
                                     </div>
                                    <span id="errorGroup" style="color:red;"></span>
                                    <div class="form-group">
                                    <label for="inputPassword3" id="" class="col-form-label">Extension</label>
                                    
                                    <select class="select2" multiple="multiple"  name="extensions[]" id="extensions" autocomplete="off" data-placeholder="Select Extension" style="width: 100%;">
                                        
                                    </select>
                                    </div>
                                    <input type="hidden" class="form-control" name="status" value="1" id="status" >       
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit"name="submit"id="submitGroup" class="btn btn-danger btn-sm deleteEG">Submit</button>
      </div>
    </div>
  </div>
</div>
       
      </div>
      <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
      
      <script src="https://cdn.jsdelivr.net/npm/imask"></script>
<script>
      var phoneInput = document.getElementById('mobile');
    var phoneMask = new IMask(phoneInput, {
        mask: '(000) 000-0000'
    }); 
  
    var phoneInput = document.getElementById('vm-pin');
    var phoneMask = new IMask(phoneInput, {
        mask: '0000'
    });
    </script>
    <script>
    function validateInput(input) {
        var regex = /^[a-zA-Z]+$/;
        var isValid = regex.test(input.value);
        var errorDiv = document.getElementById("nameError");

        if (!isValid) {
            errorDiv.style.display = "block";
            input.value = input.value.replace(/[^a-zA-Z]/g, ''); // Remove any special characters

            // Hide the error message after 5 seconds
            setTimeout(function () {
                errorDiv.style.display = "none";
            }, 5000);
        } else {
            errorDiv.style.display = "none";
        }
    }
</script>
<script>
    function validateInputLastName(input) {
        var regex = /^[a-zA-Z]+$/;
        var isValid = regex.test(input.value);
        var errorDiv = document.getElementById("nameError1");

        if (!isValid) {
            errorDiv.style.display = "block";
            input.value = input.value.replace(/[^a-zA-Z]/g, ''); // Remove any special characters

            // Hide the error message after 5 seconds
            setTimeout(function () {
                errorDiv.style.display = "none";
            }, 5000);
        } else {
            errorDiv.style.display = "none";
        }
    }
</script>
<script>


$('#cli').change(function()
{
    $("#cnam_show").show();
    var criteria_value =  $(':selected',this).data('cnam');
    $('#cnam').val(criteria_value);
});

function show_box(value){
   if(value==0 || value == 2){
        $('.cli_box_view').hide();
        $("#cnam_show").hide();
   }else{
        $('.cli_box_view').show();
        $("#cnam_show").show();

   }
}

function editEmail(emailss)
{
    email = $("#email").val();
    $('#email').removeAttr("disabled");
    $(".closed").hide();
    $(".open").show();
    $("#showEdit").show();


}

$(document).on("click", "#updateEmail", function ()
{
  var csrfToken = $('#userform input[name="_token"]').val();
    var email = $("#email").val();
            if(email == "")
            {
                $("#errorEmailExtension").show();
                $("#errorEmailExtension").html("<b style='color:red;'>Please enter email</b>");
                $("#email").focus();
                return false;
            }


            const mailformat = /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
            if(email.match(mailformat))
            {

            }
            else
            {
                $("#errorEmailExtension").html("<b style='color:red;'>You have entered an invalid email address!</b>");
                $("#email").focus();
                return false;
            }

            if(email != "")
            {
                $("#errorEmailExtension").hide();
            }
            extension_id = $("#extension_id").val();
            old_email = $("#old_email").val();
            if(email == old_email)
            {
                $("#errorEmailExtension").html("<b style='color:red;'>Please change current email for update.</b>");
                return false;
            }
            $.ajax({
                url: '/updateEmail',
                type: 'post',
                data:{email:email,user_id:extension_id,  _token: csrfToken
                },
                success: function (response)
                {
                    if (response == 'true')
                    {
                          $("#errorEmailExtension").show();
                        $("#errorEmailExtension").html("<b style='color:green;'>Email changed Successfully !</b>");
                        window.location.reload(1);
                    }

                    else
                        if (response == 'false')
                    {
                          $("#errorEmailExtension").show();
                        setTimeout(function(){ $("#errorEmailExtension").hide(); }, 3000);
                        $("#errorEmailExtension").html("<b style='color:red;'>Email Already Exists</b>");
                        //$("#extension").val('');
                    }
                }
            });

});

function getVoicemail(min, max)
{
    return Math.floor(Math.random() * (max - min)) + min;
}



$("#showEdit").click(function()
{
    $("#update").hide();
    $("#showEdit").hide();
    $("#editOption").show();



})
</script>
@endsection
