@extends('layouts.app')
@section('title', 'Extension Group')

@section('content')
<style>
       .extension-item {
        display: inline-block;
        margin-right: 5px; /* Adjust the margin as needed */
    }
    .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;
    margin-top:5px;}
    .modal {
    z-index: 1050; /* Adjust the value as needed */
}

/* Set z-index for the Select2 dropdown */
.select2-container {
    z-index: 1060; /* Adjust the value as needed, make it higher than the modal */
}
.table > tbody > tr > td, .table > tbody > tr > th {
     padding: 0.5rem; 
    vertical-align: middle;
}  

div.dataTables_wrapper div.dataTables_paginate ul.pagination {
    white-space: nowrap;
    justify-content: flex-end;
}   
/* Style for the active state */
.btn-toggle.active {
    background-color: #2196f3; /* Set to the desired green color */
    color: white; /* Set to the desired text color */
    border-color: green; /* Set to the desired border color */
}

/* Style for the inactive state */
.btn-toggle:not(.active) {
    background-color: red; /* Set to the desired red color */
    color: white; /* Set to the desired text color */
    border-color: red; /* Set to the desired border color */
}

</style>
     <link href="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/css/bootstrap4-toggle.min.css" rel="stylesheet">

<!-- Main content -->
        <section class="content">

      <div class="row">

       
        
        <div class="col-12">
          <div class="box">
           <div class="box-body">           
              <h4 class="box-title text-info mb-0"style="padding:5px;"><i class="fa fa-user fa-sx"></i> Extension Group</h4>
              <a id="openAEGForm" type="submit" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5 mt-5"><i class="fa fa-plus"></i> Add Extension Group</a>

             <hr class="my-15">
              <div class="table-responsive">
                <table id="tickets" class="table mt-0 table-hover" data-page-size="10">
                  <thead>
                    <tr>
                              <th>#</th>
                              <th>Name</th>
                              <th>Extension</th>
                              <th>Status</th>
                              <th>Action</th>

                            </tr>
                  </thead>
                  <tbody>
                     @foreach($group as $key => $ext_group)
                                <tr>
                                  <th scope="row">{{$key+1}}</th>
                                  <td id="ext-title-{{$ext_group->id}}">{{$ext_group->title}}</td>
                                  <td>       <?php foreach($map as $mapped)
                                            {
                                                if($mapped->group_id == $ext_group->id)
                                                {
                                                    if($mapped->is_deleted == 0){
                                                    

                                                echo "<span class='extension-item badge badge-sm badge-primary'>".$mapped->first_name." ".$mapped->last_name."-".$mapped->extension."</span>";
                                            }
                                        }
                                                
                                            }?></td>

                                  <td>   
                                    <!-- @if($ext_group->status == '1')
                                                <span class="badge badge-sm badge-success">Active</span>
                                            @else ($ext_group->status == '0')
                                                <span class="badge badge-sm badge-warning">Inactive</span>
                                            @endif -->
                                            <button type="button"data-listid="{{$ext_group->id}}" class="btn btn-sm btn-toggle  @if($ext_group->status == '1') active @endif" data-bs-toggle="button" aria-pressed="true" autocomplete="off">
                                        <div class="handle"></div>
                                      </button>
                                        </td>
                                 
                                  <td><a style="cursor:pointer;margin-right:5px;" title="Edit" class='editEG' data-id="{{$ext_group->id}}" ><i class="fa fa-edit fa-lg"></i></a> 
                                   <a style="cursor:pointer;" title="Delete" class='openGroupDelete' data-id="{{$ext_group->id}}"><i class="fa fa-trash-o fa-lg"></i></a></td>

                             
                                </tr>

  
                            @endforeach
                         
                  </tbody>
                </table>
              </div>
            </div>
          </div>
          
        </div>
        <div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="add-edit"></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="post" action="" enctype="multipart/form-data">
      @csrf
      <input type="hidden" class="form-control" name="id" value="" id="edit-group-id" required>

      <div class="modal-body">
          <div class="form-group">
              <label for="inputEmail3" class="form-label">Name</label>
              <input type="text" class="form-control" required name="title" id="title" placeholder="Enter Name" value="" />
              
          </div>                        
          <div class="form-group">
                  <label for="inputPassword3" class="form-label">Extensions</label>                 
                  <select class="select2"  multiple name="extensions[]" id="extensions" autocomplete="off" data-placeholder="Select Extension" style="width: 100%;">
                    <option value="">Select</option>
                                        @foreach($extension_list as $key => $extension)

                                        @if((request()->session()->get('level') > 9))
                                        @if(($extension->user_level <= 9) || ($extension->extension == request()->session()->get('extension')))
                                        <option @if($extension->extension == request()->input('extension'))  selected @endif value="{{$extension->extension}}">{{$extension->first_name}} {{$extension->last_name}} - {{$extension->extension}} @if($extension->is_deleted == 1) (Removed User) @endif</option>
                                        @endif

                                        @elseif(($extension->user_level < 9) || ($extension->extension == request()->session()->get('extension')))
                                        <option @if($extension->extension == request()->input('extension'))  selected @endif value="{{$extension->extension}}">{{$extension->first_name}} {{$extension->last_name}} - {{$extension->extension}} @if($extension->is_deleted == 1) (Removed User) @endif</option>
                                        @endif


                                        @endforeach
                    
                    </select>

          </div>
          </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit"name="submit" class="btn btn-info btn-ok btn-sm">Save</button>
      </div>
        </form>
    </div>
  </div>
</div>

<div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
     
      <div class="modal-body">
      <p>You are about to delete <b><i class="title"></i></b>group.</p>
         <p>Do you want to proceed?</p>
         <input type="hidden" class="form-control" value="" id="group_id">
       
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit"name="submit" class="btn btn-danger btn-sm deleteEG">Delete</button>
      </div>
    </div>
  </div>
</div>

    </div>
      <!-- /.row -->

    </section>
        <!-- /.content -->


        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/js/bootstrap4-toggle.min.js"></script>
<script>



        $(".openGroupDelete").click(function () {
            var delete_id = $(this).data('id');
            $("#group_id").val(delete_id);
            $("#delete-title").html($("#ext-title-"+delete_id).html());
            $("#delete").modal('show');
        });
       
        $(document).on("click", "#openAEGForm", function () {
    $("#add-edit").html('Add Extension Group');
    $("#edit-group-id").val('');
    $("#title").val('');
    loadExtensionOptions([], null);
    $("#myModal").modal('show');
});

$(document).on("click", ".editEG", function () {
    var group_id = $(this).data('id');
    $("#add-edit").html('Edit Extension Group');
    $("#edit-group-id").val(group_id);
    $("#title").val($("#ext-title-" + group_id).html());
    loadExtensionOptions([], group_id);
    $("#myModal").modal('show');
});

function loadExtensionOptions(selectedExtensions, selectedGroupID) {

    $.ajax({
        url: 'mapExtensionGroup/',
        type: 'get',
        success: function (response) {
            var options = '';

            if (response.success && response.data && response.data.length > 0) {
                var uniqueExtensions = [];
                response.data.forEach(function (extension) {
                    if (extension.is_deleted === 0 && !uniqueExtensions.includes(extension.extension)) {
                        uniqueExtensions.push(extension.extension);
                        options += '<option value="' + extension.extension + '">' + extension.first_name + ' ' + extension.last_name + '-' + extension.extension + '</option>';
                    }
                });
            }

           // $("#extensions").html(options);

            if (selectedGroupID) {
                loadSelectedExtensions(selectedGroupID, selectedExtensions);
            } else {
                $('#extensions').val(selectedExtensions).trigger('change');
            }
        }
    });
}

function loadSelectedExtensions(group_id, selectedExtensions) {
    $.ajax({
        url: 'mapExtensionGroup/',
        type: 'get',
        success: function (response) {
            var extensions = [];

            if (response.success && response.data && response.data.length > 0) {
                response.data.forEach(function (extension) {
                    if (extension.group_id === group_id && extension.is_deleted === 0) {
                        extensions.push(extension.extension);
                    }
                });
            }

            if (selectedExtensions) {
                selectedExtensions.forEach(function (extension) {
                    if (!extensions.includes(extension)) {
                        extensions.push(extension);
                    }
                });
            }

            $('#extensions').val(extensions).trigger('change');
        }
    });
}


        $(document).on("click", ".deleteEG", function () {
            var group_id = $('#group_id').val();
            $.ajax({
                url: 'deleteExtensionGroup/' + group_id,
                type: 'get',
                success: function (response) {
                    console.log(response);
                    window.location.reload(1);
                }
            });
        });
    </script>
<script>
$(function()
{
    $("#tickets").on("click", ".btn-toggle", function ()
    {
       console.log('hi');
      var status = $(this).hasClass('active') ? 1 : 0;
        var listid = $(this).data('listid');    


        $.ajax({
            type: "GET",
            dataType: "json",
            url: '/updateGroupStatus/'+listid+ '/' +status,

            success: function(data)
            {
                if(data.status == 'true')
                {
                    toastr.success(data.message);
                }
                else
                {
                    toastr.error(data.message);

                }

                console.log(data.success);
                window.location.reload(1);
            }
        });
    })
})
</script>
@endsection
