@extends('layouts.app')
@section('title', 'Send New Fax')
@section('content')
<style>
    #faxpageloader
    {
        background: rgba( 255, 255, 255, 0.8 );
        display: none;
        height: 100%;
        position: fixed;
        width: 100%;
        z-index: 9999;
    }

    #faxpageloader img
    {
        left: 19%;
        margin-left: -32px;
        margin-top: -5%;
        position: absolute;
    }
</style>
<section class="content">
<div id="faxpageloader">
            <img src="{{URL::asset('assets/images/loader.gif')}}">

        </div>
        <!--Call tming div starts-->
        <div class="row">
             <div class="box-header with-border">            
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Send New Fax</h4>
            </div>
            <div class="col-md-3">
            @include('fax.menu',['page_title' => 'My Amazing Site'])       
            </div>
         
            <div class="col-md-9"style="margin-top:20px;">
                <div class="box box-primary box-solid">
               

                    <div class="box-body">
                    <h4 class="box-title"class="bg-primary">Send New Fax</h4>
                    <form method="post" id="myform" action="{{url('save-fax')}}" enctype="multipart/form-data">
                    @csrf
                        <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group" style="width:322px;">
                                        <label class="form-label">Select the phone number you wish to send fax from</label>
                                        <select name="from_id" class="form-select" id="from_id" required="">
                                            <option value="">Select Any</option>
                                             @if (is_array($group))
                                              @foreach($group as $did)
                                                    <option value="{{ $did->id }}">{{ $did->did }}</option>
                                                @endforeach

                                            @endif
                                        </select>
                                  
                                    </div>
                                </div>
                                <div class="col-md-6"style="margin-top:20px;">
                                    <div class="form-group" >
                                    <label class="form-label">Recipient Fax Number</label>
                                        <input placeholder="Recipient Fax Number" type="text" class="form-control" name="to_id" id="to_id" required="" data-inputmask="'mask': '(999) 999-9999'" data-mask="" />
                                    </div>
                                </div>
                            </div>
                            <div class="form-group"></div>
                            <div class="form-group">
                                <input type="file" name="pdf_file" id="pdf_file">
                                <p class="help-block">Max. 10MB (Only pdf files are allowed)</p>
                            </div>
                            <div class="box-footer text-end">
                            <button type="submit" name="submit" value="add"  class="btn btn-primary btn-md"><i class="fa fa-envelope-o"></i> Send</button>
                            <button type="reset" class="btn btn-default btn-md"><a href="{{ url('/fax-list') }}"><i class="fa fa-times"></i> Discard</a></button>

                        </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
        <!--Call tming div ends-->

    </section>


    <script src="https://code.jquery.com/jquery-3.7.0.min.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>           

    <script src="https://cdn.jsdelivr.net/npm/imask"></script>
<script>
      var phoneInput = document.getElementById('to_id');
    var phoneMask = new IMask(phoneInput, {
        mask: '(000) 000-0000'
    });

</script>

@endsection
