@extends('layouts.app')
@section('title', 'Receive Fax')

@section('content')

<section class="content">
        <!--Call tming div starts-->
        <div class="row">
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Receive Fax</h4>
              <hr class="my-15">
            <div class="col-md-3">
                @include('fax.menu')         
            </div>
         
            <div class="col-md-9"style="margin-top:20px;">
                <div class="box box-primary box-solid">
               

                    <div class="box-body">
                    <h4 class="box-title">Inbox</h4>

                        <div class="row">
                            <div class="col-sm-12">
                            <div class="table-responsive mailbox-messages ">
								<table id="tickets" class="table table-striped">
									<thead class="bg-primary">
										<tr>
                                        <th>#</th>
                                        <th>Sender</th>
                                        <th>Inbound Fax No</th>
                                        <th>Date</th>
                                        <th>Download</th>
										</tr>
									</thead>
									<tbody>
                                    @foreach($receiveFax as $key => $fax)
                                    <tr>
                                        <td><?php echo ++$key; ?></td>
                                        <td class="mailbox-name">
                                        <?php
                                        // Assuming $fax->callerid contains the caller ID
                                        $callerID = $fax->callerid;

                                        // Remove any non-digit characters from the caller ID
                                        $callerID = preg_replace('/[^0-9]/', '', $callerID);

                                        // Check if the caller ID is at least 10 digits long
                                        if (strlen($callerID) >= 10) {
                                            // Extract the last 10 digits
                                            $lastTenDigits = substr($callerID, -10);

                                            // Format the last 10 digits as (999) 999-9999
                                            $formattedLastTenDigits = preg_replace('/(\d{3})(\d{3})(\d{4})/', '($1) $2-$3', $lastTenDigits);

                                            // Add a "+" sign in front of the original caller ID
                                            $formattedCallerID = '+' . substr($callerID, 0, -10) . $formattedLastTenDigits;

                                            // Output the formatted caller ID
                                            echo $formattedCallerID;
                                        } else {
                                            // Handle cases where the caller ID is too short
                                            echo "Invalid caller ID";
                                        }
                                        ?>
                                        </td>
                                        <td class="mailbox-subject">
                                        <?php
                                            // Assuming $fax->dialednumber contains the phone number
                                            $phoneNumber = $fax->dialednumber;

                                            // Remove any non-digit characters from the phone number
                                            $phoneNumber = preg_replace('/[^0-9]/', '', $phoneNumber);

                                            // Check if the phone number is at least 10 digits long
                                            if (strlen($phoneNumber) >= 10) {
                                                // Extract the last 10 digits
                                                $lastTenDigits = substr($phoneNumber, -10);

                                                // Format the last 10 digits as (999) 999-9999
                                                $formattedLastTenDigits = preg_replace('/(\d{3})(\d{3})(\d{4})/', '($1) $2-$3', $lastTenDigits);

                                                // Add a "+" sign in front of the original phone number
                                                $formattedPhoneNumber = '+' . substr($phoneNumber, 0, -10) . $formattedLastTenDigits;

                                                // Output the formatted phone number
                                                echo $formattedPhoneNumber;
                                            } else {
                                                // Handle cases where the phone number is too short
                                                echo "Invalid phone number";
                                            }
                                            ?></td>                    
                                        <td class="mailbox-date">
                                            {{ date('Y-m-d h:i A',strtotime($fax->start_time)) }}
                                        </td>
                                        <td class="mailbox-attachment"><a href="{{'fax-list'}}/{{$fax->id}}" target="_blank"><i class="fa fa-download" aria-hidden="true"></i></a></td>
                                    </tr>
                                    @endforeach 

                                    @if(empty($receiveFax))
                                    <tr><td colspan="6" class="text-center">Record not found </td></tr>
                                    @endif
									</tbody>
								</table>
							</div>
                            </div>
                            <div class="box-footer no-padding">
                        <div class="mailbox-controls">
                            <!-- Check all button -->

                            <!-- /.btn-group -->

                            <!-- /.pull-right -->
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--Call tming div ends-->

    </section>








@endsection
