@extends('layouts.app')
@section('title', 'Lead Source List')

@section('content')
<style>
  .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
  </style>
<style>
       .extension-item {
        display: inline-block;
        margin-right: 5px; /* Adjust the margin as needed */
    }
    * {
  user-select: none;
  -webkit-tap-highlight-color: transparent;
}

.switch {
  transform: scale(0.5); /* Adjust the scale value as needed to reduce the size */
}
/* Style for the active state */
.btn-toggle.active {
    background-color: #2196f3; /* Set to the desired green color */
    color: white; /* Set to the desired text color */
    border-color: green; /* Set to the desired border color */
}

/* Style for the inactive state */
.btn-toggle:not(.active) {
    background-color: red; /* Set to the desired red color */
    color: white; /* Set to the desired text color */
    border-color: red; /* Set to the desired border color */
}



    </style>
<!-- Main content -->
<section class="content">

<div class="row">

 
  
  <div class="col-12">
    <div class="box">
      <div class="box-body">           
<div class="d-flex justify-content-between align-items-center">
<h4 class="box-title text-info mb-0"><i class="icon-Add-user"><span class="path1"></span><span class="path2"></span></i> Lead Source List</h4>
  <a href="#"data-bs-toggle="modal" data-bs-target="#add-new-events" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-plus"></i>Add Lead Source Url</a></div>
<hr class="my-15">
        <div class="table-responsive">
        <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
                  <thead>
                            <tr>
                            <th>#</th>
											<th>Title</th>
                      <th>Site Url</th>
                      <th>Unique Id</th>
											<th>Status</th>                             
											<th>Action</th>

                            </tr>
                  </thead>
                  <tbody>
                              
                              @if(!empty($lead_source))
                @foreach($lead_source as $key => $list)

                <tr>
                  <td>{{$key+1}}</td>
                  <td>{{$list->source_title}}</td>

                  <td>{{$list->url}}</td>
                  <td>{{$list->unique_id}}</td>
                  <td>@if($list->status == 1)
                        <span class="badge badge-success">Active</span>
                        @else
                        <span class="badge badge-danger">Inactive</span>
                        @endif
                    </td>                    
                  <td>
                    <ul class="list-inline m-0">
                      <li class="list-inline-item">
                        <a href="javascript:void(0)" data-toggle="tooltip"  data-id="{{$list->id}}" data-url="{{$list->url}}" data-sourcetitle="{{$list->source_title}}"" data-original-title="Edit" class="edit"><i class="fa fa-edit edit fa-lg"></i></a>
                      </li>                        
                    </ul>
                  </td>
                </tr>
                @endforeach
                @endif                                										
              </tbody>
                </table>
        </div>
      </div>
    </div>
  </div>
</div>




 <div class="modal fade none-border" id="ajaxModel">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title"><strong>Edit </strong> Lead Source Url</h4>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body">
                <form method="post" action="{{ route('leadsource.update') }}" id="updateLeadStatus">
              @csrf
                   <input type="hidden" name="lead_source_id" id="id">

              <div class="card-body">
                <div class="form-group">
                  <label for="exampleInputEmail1">Lead Source Title</label>
                  <input type="text" required class="form-control"  name="source_title" id="source_title" placeholder="Source Title">
                </div>


                <div class="form-group">
                  <label for="exampleInputEmail1">Lead Source Url</label>
                  <input type="text" required class="form-control" id="url" name="url" placeholder="Title">
                </div>
              </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary"><i class="fa fa-edit"
                                                                                 aria-hidden="true"></i> Update
                                </button>
                                <a type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</a>

                            </div>
                        </form>
			    </div>
		   </div>
	    </div>
    </div>
  <!-- BEGIN MODAL -->
	<!-- Modal Add Category -->
	<div class="modal fade none-border" id="add-new-events">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title"><strong>Add</strong> Lead Source Url</h4>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body">
                <form method="post" id="addLeadStatus" >
                @csrf
                <div class="card-body">
                        <div class="form-group">
                        <label for="exampleInputEmail1">Lead Source Title</label>
                        <input type="text" required class="form-control"  name="source_title" placeholder="Source Title">
                        </div>
                        <div class="form-group">
                        <label for="exampleInputEmail1">Lead Source Url</label>
                        <input type="text" required class="form-control"  name="url" placeholder="Url">
                        </div>

                        </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Submit
                                    </button>
                                    <a type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</a>

                                </div>
                            </form>
			</div>
		</div>
	</div>
<!-- END MODAL -->


</section>
  
<script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
<script>
$('.edit').click(function ()
    {
      var id = $(this).data('id');
      var url = $(this).data('url');
      var source_title = $(this).data('sourcetitle');

      var color = $(this).data('color');

      $('#ajaxModel').modal('show');
      $('#id').val(id);
      $('#url').val(url);
      $('#source_title').val(source_title);

      $('#color_code').val(color);

    });
</script>

   


@endsection
