@extends('layouts.app')
@section('title', 'Add Lead')
@section('content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
<style>
    .footer-actions {
    display: flex;
    justify-content: flex-end; /* right aligned */
    flex-wrap: nowrap;         /* ek hi row me rakhe */
    gap: 10px;                 /* buttons ke beech gap */
}

.footer-actions .btn {
    min-width: 100px;          /* buttons ek size ke दिखें */
    text-align: center;
    white-space: nowrap;       /* text wrap na ho */
}

    </style>
@php

use \App\Http\Controllers\InheritApiController;
$userdetails = InheritApiController::headerUserDetails();
@endphp

<section class="content">
  <div class="row">       
    <div class="col-lg-12 col-12">
      <div class="box">


                              <form method="post">



                                @csrf
          <div class="box-body"><!--bg-lightest-->

            
            <h4 class="box-title text-info mb-0"><i class="fa fa-plus"></i> Add Lead Info</h4>
            <a href="{{url('/leads')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i> Leads</a>

            <hr class="my-15">

              <div class="gap-items gap-y fs-20">
                  
                  @if(empty($labels))
                  <div class="text-info ">Please Add Labels before add Lead from here <a target="_blank" href="/crm-labels" style="text-decoration: none;" class="btn btn-info btn-sm">CRM Labels</a> </div>
                  @endif

                  @if(empty($lead_status))
                  <div class="text-warning ">Please Add Lead Status before add Lead from here <a target="_blank" href="/lead-status" style="text-decoration: none;" class="btn btn-warning btn-sm">Lead Status</a> </div>
                  @endif

                  @if(empty($users))
                  <div class="text-primary ">Please Add User before add Lead from here <a target="_blank" href="/add-extension" style="text-decoration: none;" class="btn btn-primary btn-sm">Users</a> </div>
                  @endif

                  @if(empty($lead_source))
                  <div class="text-danger">Please Add Lead Source before add Lead from here <a target="_blank" href="/lead-source" style="text-decoration: none;" class="btn btn-danger btn-sm">Lead Source</a> </div>
                  @endif

                  @if(empty($domain_list))
                  <div class="text-danger">Please Add Domain List in Master</div>
                  @endif

                </div>


                @if(!empty($labels) && !empty($lead_status) && !empty($users) && !empty($lead_source) && !empty($domain_list))
            <div class="row">
                                                    <div class="col-md-9">

                                                        <div class="box">
                    <div class="box-body">

            <div class="row">





             

                @if(!empty($labels))
                                            @foreach($labels as $label)
                                                @if($label->status == 1)
                                                 @if($label->column_name != 'unique_url')
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <label
                                                                class="form-label">@if($label->data_type == 'select_option')
                                                                    Select
                                                                @endif {{$label->title}} @if($label->data_type == 'date') (mm/dd/yyyy) @endif @if($label->required == 1)
                                                                    <span style="color: red;">*</span>
                                                                @endif</label>


                                                                <div class="input-group mb-3">
                    <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="{{$label->icons}}"></i></span>
                                                            @if($label->label_title_url == 'country')
                                                                <select class="form-select" name="country" id="country"
                                                                        data-country="US">
                                                                    <option value="US">United States</option>
                                                                    <!-- <option value="IN">India</option> -->
                                                                </select>


                                                                @elseif($label->label_title_url == 'state' || $label->data_type=='select_state')
                                                                <select @if($label->required == 1) required @endif class="form-select" @if($label->label_title_url == 'state') name="state" @endif @if($label->data_type == 'select_state') name="{{$label->column_name}}" @endif id="state"
                                                                        data-country="US">
                                                                        <option value="">Select State</option>

                                                                        @if(!empty($state_list))
                                                                        @foreach($state_list as $state)

                                                                    <option {{ old($label->column_name) == $state->state_name ? 'selected' : '' }} value="{{$state->state_name}}">{{$state->state_name}}</option>
                                                                    @endforeach
                                                                    @endif

                                                                </select>
                                                            

                                                            @elseif($label->data_type == 'select_option')
                                                                @php
                                                                    $values = $label->values;
                                                                    $arr = json_decode($values);
                                                                @endphp
                                                                @if(!empty($arr))
                                                                    <select @if($label->required == 1) required @endif class="form-select"
                                                                            name="{{$label->column_name}}">
                                                                             <option value="">Select Option</option>
                                                                        @php
                                                                            foreach($arr as $val)
                                                                            {
                                                                        @endphp
                                                                        <option 
                                                                            value="{{$val}}">{{ucwords($val)}}</option>
                                                                        @php
                                                                            }
                                                                        @endphp
                                                                    </select>
                                                                @endif
                                                            @elseif($label->data_type == 'date')
                                                                <input type="text" name="{{$label->column_name}}"
                                                                       
                                                                       class="form-control  "  value="{{old($label->column_name)}}"id="{{$label->column_name}}"
                                                                       
                                                                       @if($label->required == 1) required
                                                                       @endif placeholder="Enter {{$label->title}}" data-inputmask="'alias': 'mm/dd/yyyy'" data-mask />

                                                            @elseif($label->data_type == 'datetime-local')
                                                                <input type="datetime-local" name="{{$label->column_name}}"
                                                                       
                                                                       class="form-control  " value="{{old($label->column_name)}}"
                                                                       
                                                                       @if($label->required == 1) required
                                                                       @endif placeholder="Enter {{$label->title}}"/>

                                                            @elseif($label->data_type == 'email')
                                                                <input type="email" name="{{$label->column_name}}"
                                                                       
                                                                       class="form-control  " value="{{old($label->column_name)}}"
                                                                       
                                                                       @if($label->required == 1) required
                                                                       @endif placeholder="Enter {{$label->title}}"/>



                                                            @else
                                                                <input style="text-transform: capitalize;" maxlength="{{$label->number_length}}" type="text" name="{{$label->column_name}}" @if($label->required == 1) required @endif
                                                                       @if($label->data_type == 'number' || $label->data_type == 'currency') 
                                                                       @if($label->required == 1) required @endif oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" @endif
                                                                       value="{{old($label->column_name)}}"
                                                                       
                                                                       class="form-control @if($label->data_type == 'date') datepicker @endif 
                                                                        @if($label->required == 1) required
                                                                        @endif placeholder="Enter {{$label->title}}" @if($label->data_type == 'phone_number') data-inputmask="'mask':[ '(999) 999-9999']" data-mask 
                                                                       @endif />

                                                            @endif



                                                        </div>
                                                        </div>
                                                        
                                                    </div>
                                                @endif

                                                @endif
                                            @endforeach
                                        @endif

                                    </div>
                                </div>
                            </div>
                                    </div>


                                                    <div class="col-md-3">

                                                        <div class="box">
                    <div class="box-body">

            <div class="row">
             

            

              <div class="col-md-12">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Lead Status <span style="color: red;">*</span></label> 
                  <div class="input-group mb-3">
                                                <select required class="form-select bg-danger" name="lead_status" id="lead_status">
                                                    <option value="">Select Lead Status</option>

                                                    @if(!empty($lead_status))
                                                        @foreach($lead_status as $status)
                                                            <option
                                                                value="{{$status->lead_title_url}}">{{$status->title}}</option>
                                                        @endforeach
                                                    @endif
                                                </select>
                  </div>
                </div>
              </div>


               <div class="col-md-12">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Assigned To <span style="color: red;">*</span></label> 
                  <div class="input-group mb-3">
                                                <select required class="form-select bg-info" name="assigned_to" id="assigned_to">
    <option value="">Select Assigned To</option>

    @if(Session::get("level") > 5)
        @if(!empty($users))
   
            @foreach($sortedUsers as $list)
                @if($list->is_deleted == '0' && $list->user_level < 9)
                    <option value="{{$list->id}}">
                        {{$list->first_name}} {{$list->last_name}}
                    </option>
                @endif
            @endforeach
        @endif
    @else
        <option value="{{Session::get("id")}}">
            {{$userdetails->data->first_name}} {{$userdetails->data->last_name}}
        </option>
    @endif
</select>

                  </div>
                </div>
              </div>

              <div class="col-md-12">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Lead Type <span style="color: red;">*</span></label> 
                  <div class="input-group mb-3">
                                                <select class="form-select bg-warning" required name="lead_type" id="lead_type">
                                                    <option value="">Select Lead Type</option>
                                                    <option  value="hot">Hot</option>
                                                    <option  value="warm">Warm</option>
                                                    <option  value="cold">Cold</option>

                                                </select>
                  </div>
                </div>
              </div>

               <div class="col-md-12">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Lead Source <span style="color: red;">*</span></label> 
                  <div class="input-group mb-3">
                                                <select class="form-select bg-primary" required name="lead_source_id" id="lead_source_id">
                                                    <option value="">Select Lead Source</option>
                                                    @if(!empty($lead_source))
                                                        @foreach($lead_source as $source)
                                                            <option
                                                                value="{{$source->unique_id}}">{{$source->source_title}}</option>
                                                        @endforeach
                                                    @endif

                                                </select>
                  </div>
                </div>
              </div>

             

            
           
          
</div>
</div>
</div>

</div>
</div>

            <div class="box-footer">
  <div class="footer-actions">
    
    <a href="/leads" class="btn btn-warning">
      <i class="ti-trash"></i> Cancel
    </a>

    <a onclick="window.location.reload();" class="btn btn-danger">
      <i class="ti-reload"></i> Reset
    </a>

    <button type="submit" name="submit" value="add" class="btn btn-primary">
      <i class="ti-save-alt"></i> Submit
    </button>

  </div>
</div>

            <!-- <div class="box-footer text-end">
             <a href="/leads"  class="btn btn-warning me-1">
                  <i class="ti-trash"></i> Cancel
                </a>

                <a onclick="window.location.reload();"  class="btn btn-danger me-1">
                  <i class="ti-reload"></i> Reset
                </a>

                <button  type="submit" name="submit" value="add" class="btn btn-primary">
                  <i class="ti-save-alt"></i> Submit
                </button>
              </div>   -->
            </form>
                       
                
              </div>
              <!-- /.box-body -->
          
            <!-- /.box -->      
        </div>  
       
      </div>
  </section>

@endif
    


         <script>
        // Automatically remove duplicates on page load
        (function removeDuplicates() {
            const select = document.getElementById('assigned_to');
            const seenValues = new Set();

            for (let i = select.options.length - 1; i >= 0; i--) {
                const value = select.options[i].value;
                if (seenValues.has(value)) {
                    select.remove(i); // Remove duplicate option
                } else {
                    seenValues.add(value); // Add unique value to the set
                }
            }
        })();
    </script>



  
   

     
@endsection
