@extends('layouts.app')
@section('title', 'Eligible Lender List')

@section('content')
<style>
  .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
  </style>
<style>
       .extension-item {
        display: inline-block;
        margin-right: 5px; /* Adjust the margin as needed */
    }
    * {
  user-select: none;
  -webkit-tap-highlight-color: transparent;
}

.switch {
  transform: scale(0.5); /* Adjust the scale value as needed to reduce the size */
}
/* Style for the active state */
.btn-toggle.active {
    background-color: #2196f3; /* Set to the desired green color */
    color: white; /* Set to the desired text color */
    border-color: green; /* Set to the desired border color */
}

/* Style for the inactive state */
.btn-toggle:not(.active) {
    background-color: red; /* Set to the desired red color */
    color: white; /* Set to the desired text color */
    border-color: red; /* Set to the desired border color */
}



    </style>
<!-- Main content -->
        <section class="content">

      <div class="row">

       
        
        <div class="col-12">
          <div class="box">
            <div class="box-body">           
         
    <div class="d-flex justify-content-between align-items-center">
        <h4 class="box-title text-info mb-0"><i class="icon-Add-user"><span class="path1"></span><span class="path2"></span></i>Eligible Lender Sheet</h4>

  <div>

         @if(Session::get('role') === 'admin' || Session::get('role') === 'super_admin' || Session::get('role') === 'system_administrator')
              <a href="{{ route('eligible-lender', ['lead_id' => $lead_id, 'bank_id' => $bank_id]) }}?download=excel" type="button"style="float:right;"  class="waves-effect waves-light btn btn-rounded btn-warning btn-bitbucket btn-sm mb-5"><i class="fa fa-file-text"></i> Excel</a>
              @endif
              <a href="{{url('/lenders')}}" type="button"style="margin-right:10px;" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye"></i> Lenders</a>

    </div>
    </div>
<hr class="my-15">
              <div class="table-responsive">
                <table id="tickets1" class="table mt-0 table-hover table-bordered no-wrap" data-page-size="10">
                  <thead>
                  <tr>
                              <th>#</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>CC</th>
                    <th>Max Term</th>
                    <th>Position</th>
                    <th>FICO</th>
                    <th>Min Monthly Deposit</th>
                    <th>Average Daily Balance</th>
                    <th>Min Average Revenue</th>
                    <th>Min No of Deposits</th>
                    <th>Min Loan Amount</th>
                    <th> Max Loan Amount</th>
                    <th> Max Negative Days</th>
                    <th>NSFs</th>
                    <th>Daily/Weekly</th>
                    <th>Time In Business</th>
                    <th>Reverse Consolidation</th>
                    <th>Consolidation</th>
                    <th>LOC</th>
                    <th>Max MCA Payoff Amount</th>
                    <th>Ownership Percentage</th>
                    <th>CA</th>
                    <th>Construction</th>
                    <th>Trucking</th>
                    <th>Factor Rates</th>
                    <th>Restricted State</th>
                    <th>Restricted Industry</th>
                    <th>Prohibited Industry</th>
                    <th>Note</th>

                            </tr>
                  </thead>
                  <tbody>

@if(!empty($lenders))
@foreach($lenders as $key => $list)

<tr>
  <td>{{$key+1}}</td>
  <td>{{ucfirst($list->lender_name)}}</td>
  <td>{{$list->email}}</td>
  <td>{{$list->secondary_email}}</td>
  <td>{{$list->max_term}}</td>
  @php
// Check if max_position is a JSON string and decode it
$maxPosition = is_string($list->max_position) ? json_decode($list->max_position, true) : $list->max_position;

// Ensure it's an array and has values
if (is_array($maxPosition) && !empty($maxPosition)) {
// Get the minimum and maximum values from the array
$min = min($maxPosition);
$max = max($maxPosition);

// If min and max are the same, just show the single value; otherwise, show "min to max"
$range = ($min == $max) ? $min : "$min to $max";
} else {
$range = ''; // Fallback in case no valid values
}
@endphp

<td>{{ $range }}</td>

  <td>{{$list->min_credit_score}}</td>
  <td>{{$list->min_monthly_deposit}}</td>
  <td>{{$list->daily_balance}}</td>
  <td>{{$list->min_avg_revenue}}</td>
  <td>{{$list->min_deposits}}</td>
  <td>{{$list->min_amount}}</td>
  <td>{{$list->max_advance}}</td>
  <td>{{$list->nsfs}}</td>
  <td>{{$list->max_negative_days}}</td>
  <td>{{$list->daily}}</td>
  <td>{{$list->min_time_business}}</td>
  <td>{{$list->reverse_consolidation}}</td>
  <td>{{$list->consolidation}}</td>
  <td>{{$list->loc}}</td>
  <td>{{$list->max_mca_payoff_amount}}</td>
  <td>{{$list->ownership_percentage}}</td>
  @php
// Decode JSON if necessary (adjust based on how data is stored)
$guideline_state = is_string($list->guideline_state) ? json_decode($list->guideline_state, true) : $list->guideline_state;
@endphp

<td>{{ is_array($guideline_state) && in_array('CA', $guideline_state) ? 'Yes' : '' }}</td> 
@php
// Decode JSON if necessary (adjust based on how data is stored)
$construction = is_string($list->industry) ? json_decode($list->industry, true) : $list->industry;
@endphp            
<td>{{ is_array($construction) && in_array('construction', $construction) ? 'Yes' : '' }}</td> 
@php
// Decode JSON if necessary (adjust based on how data is stored)
$trucking = is_string($list->industry) ? json_decode($list->industry, true) : $list->industry;
@endphp            
<td>{{ is_array($trucking) && in_array('trucking', $construction) ? 'Yes' : '' }}</td> 
  <td>{{$list->factor_rate}}</td>
  @php
// Array to map state codes to state names
$state_names = [
'AL' => 'Alabama',
'AK' => 'Alaska',
'AS' => 'American Samoa',
'AZ' => 'Arizona',
'AR' => 'Arkansas',
'AE-A' => 'Armed Forces Africa',
'AA' => 'Armed Forces Americas',
'AE-C' => 'Armed Forces Canada',
'AE-E' => 'Armed Forces Europe',
'AE-M' => 'Armed Forces Middle East',
'AP' => 'Armed Forces Pacific',
'CA' => 'California',
'CO' => 'Colorado',
'CT' => 'Connecticut',
'DE' => 'Delaware',
'DC' => 'District of Columbia',
'FM' => 'Federated States of Micronesia',
'FL' => 'Florida',
'GA' => 'Georgia',
'GU' => 'Guam',
'HI' => 'Hawaii',
'ID' => 'Idaho',
'IL' => 'Illinois',
'IN' => 'Indiana',
'IA' => 'Iowa',
'KS' => 'Kansas',
'KY' => 'Kentucky',
'LA' => 'Louisiana',
'ME' => 'Maine',
'MD' => 'Maryland',
'MA' => 'Massachusetts',
'MI' => 'Michigan',
'MN' => 'Minnesota',
'MS' => 'Mississippi',
'MO' => 'Missouri',
'MT' => 'Montana',
'NE' => 'Nebraska',
'NV' => 'Nevada',
'NH' => 'New Hampshire',
'NJ' => 'New Jersey',
'NM' => 'New Mexico',
'NY' => 'New York',
'NC' => 'North Carolina',
'ND' => 'North Dakota',
'MP' => 'Northern Mariana Islands',
'OH' => 'Ohio',
'OK' => 'Oklahoma',
'OR' => 'Oregon',
'PA' => 'Pennsylvania',
'PR' => 'Puerto Rico',
'MH' => 'Republic of Marshall Islands',
'RI' => 'Rhode Island',
'SC' => 'South Carolina',
'SD' => 'South Dakota',
'TN' => 'Tennessee',
'TX' => 'Texas',
'UT' => 'Utah',
'VT' => 'Vermont',
'VI' => 'Virgin Islands of the U.S.',
'VA' => 'Virginia',
'WA' => 'Washington',
'WV' => 'West Virginia',
'WI' => 'Wisconsin',
'WY' => 'Wyoming',
];

// Check if the data is a JSON string and decode it
$guideline_state = is_string($list->guideline_state) ? json_decode($list->guideline_state, true) : $list->guideline_state;

// Map the state codes to their names
$state_names_list = is_array($guideline_state) 
? implode('/', array_map(function($state_code) use ($state_names) {
return $state_names[$state_code] ?? $state_code;
}, $guideline_state))
: $state_names[$list->guideline_state] ?? $list->guideline_state;
@endphp

<td>{{ $state_names_list }}</td>

  <!-- <td>{{$list->guideline_state}}</td> -->
  @php
// Check if the data is a JSON string and decode it
$industry = is_string($list->industry) ? json_decode($list->industry, true) : $list->industry;
@endphp

<td>{{ is_array($industry) ? implode('/', $industry) : $list->industry }}</td>
  <td>{{$list->prohibited_industry}}</td>

  <th>{{$list->notes}}</th>



</tr>
<div id="myModal{{$list->id}}" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg"style="width:1200px;">
<div class="modal-content">


<!-- /.box-header -->
<div class="box-body">


<!-- form itself -->
<form id="test-form" class="mfp-hide white-popup-block">
<h4><i class="icon-Add-user"><span class="path1"></span><span class="path2"></span></i> Lender Details <button style="padding: 5px 11px 5px 11px;" type="button" class="btn btn-danger float-end" data-bs-dismiss="modal">X</button></h4>
<hr>
<div class="row">
<div class="col-md-6">

<div class="form-group">
<i style="color:black;" class="ti-user"></i> <label class="form-label" for="inputName">Lender Name</label>
<p><span class="badge badge-sm badge-primary">{{$list->lender_name}}<span></p>
</div>
<div class="form-group">
<i style="color:black;" class="ti-email"></i> <label class="form-label" for="inputEmail">Lender Email</label>
<p><span class="badge badge-sm badge-primary">{{$list->email}}<span></p>

</div>
<div class="form-group">
<i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputPhone">Optional Email</label>
<p><span class="badge badge-sm badge-primary">{{$list->secondary_email}}<span></p>

</div>

<div class="form-group">
<i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputPhone">Phone</label>
<p><span class="badge badge-sm badge-primary">{{$list->phone}}<span></p>

</div>

<div class="form-group">
<i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputPhone">Contact Person</label>
<p><span class="badge badge-sm badge-primary">{{$list->contact_person}}<span></p>

</div>
<div class="form-group">
<i style="color:black;" class="ti-user"></i><label class="form-label" for="inputPhone">Min Credit Score</label>
<p><span class="badge badge-sm badge-primary">{{$list->min_credit_score}}<span></p>

</div>
<div class="form-group">
<i style="color:black;" class="ti-user"></i> <label class="form-label" for="inputPhone">Max Negative Days</label>
<p><span class="badge badge-sm badge-primary">{{$list->max_negative_days}}<span></p>

</div>
<div class="form-group">
<i style="color:black;" class="ti-user"></i> <label class="form-label" for="inputPhone">Max Advance </label>
<p><span class="badge badge-sm badge-primary">{{$list->max_advance}}<span></p>

</div>
<div class="form-group">
<i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputPhone">NSFs</label>
<p><span class="badge badge-sm badge-primary">{{$list->nsfs}}<span></p>

</div>
<div class="form-group">
<i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputPhone">CoJ Request</label>
<p><span class="badge badge-sm badge-primary">{{$list->coj_req}}<span></p>
</div>
<div class="form-group">
<i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputPhone">Bank Verification Process</label>
<p><span class="badge badge-sm badge-primary">{{$list->bank_verify}}<span></p>
<p><span class="badge badge-sm badge-@if($list->bank_verify == 'manual')danger @elseif ($list->bank_verify == 'team')success  @endif">@if($list->bank_verify == 'manual') MANUAL LOGIN @elseif ($list->bank_verify == 'team') Team Viewer @endif</p>

</div>
<div class="form-group">
<i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputPhone">Address</label>
<p><span class="badge badge-sm badge-primary">{{$list->address}}<span></p>
</div>
</div>

<div class="col-md-6">
<div class="form-group">
<i style="color:black;" class="ti-user"></i> <label class="form-label" for="inputName">Min Time In Business(Months)</label>
<p><span class="badge badge-sm badge-primary">{{$list->min_time_business}}<span></p>
</div>
<div class="form-group">
<i style="color:black;" class="ti-user"></i> <label class="form-label" for="inputName">Min Amount</label>


<p><span class="badge badge-sm badge-primary">{{$list->min_amount}}<span></p>
                                      

                                     
</div>
<div class="form-group">
<i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputPhone">Min Deposits</label>
<p><span class="badge badge-sm badge-primary">{{$list->min_deposits}}<span></p>

</div>
<div class="form-group">
<i style="color:black;" class="ti-user"></i> <label class="form-label" for="inputName">Max Position</label>
<p><span class="badge badge-sm badge-primary">{{$list->max_position}}<span></p>
</div>
<div class="form-group">
<i style="color:black;" class="ti-user"></i> <label class="form-label" for="inputEmail">Max Term(Months)</label>
<p><span class="badge badge-sm badge-primary">{{$list->max_term}}<span></p>

</div>
<div class="form-group">
<i style="color:black;" class="ti-user"></i> <label class="form-label" for="inputEmail">Min Average Daily Balance</label>
<p><span class="badge badge-sm badge-primary">{{$list->daily_balance}}<span></p>

</div>

<div class="form-group">
<i style="color:black;" class="ti-user"></i> <label class="form-label" for="inputEmail">White Label</label>
<p><span class="badge badge-sm badge-primary">{{$list->white_label}}<span></p>

</div>

<div class="form-group">
<i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputPhone">Consolidation</label>
<p><span class="badge badge-sm badge-primary">{{$list->consolidation}}<span></p>
</div>
<div class="form-group">
<i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputPhone">Sole Prop</label>
<p><span class="badge badge-sm badge-primary">{{$list->sole_prop}}<span></p>
</div>
<div class="form-group">
<i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputPhone">Home based Business</label>
<p><span class="badge badge-sm badge-primary">{{$list->home_business}}<span></p>
</div>
<div class="form-group">
<i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputPhone">Non Profit</label>
<p><span class="badge badge-sm badge-primary">{{$list->non_profit}}<span></p>
</div>
<div class="form-group">
<i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputPhone">Payment Schedule</label>
<p><span class="badge badge-sm badge-@if($list->daily == 'daily')danger @elseif ($list->daily == 'all')secondary @elseif ($list->daily == 'weekly')success @endif">@if($list->daily == 'daily')Daily @elseif ($list->daily == 'weekly') Weekly @elseif ($list->daily == 'all') All @endif</p>

</div>

<!-- <div class="form-group">
<i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputPhone">Country</label>
<p><span class="badge badge-sm badge-primary">{{$list->country}}<span></p>
</div>
<div class="form-group">
<i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputPhone">State</label>
<p><span class="badge badge-sm badge-primary">{{$list->state}}<span></p>
</div>
<div class="form-group">
<i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputPhone">City </label>
<p><span class="badge badge-sm badge-primary">{{$list->city}}<span></p>
</div> -->
</div>
</div>


</form>
</div>
<!-- /.box-body -->
<!-- /.box -->

</div>
<!-- /.modal-content -->
</div>
<!-- /.modal-dialog -->
</div>
@endforeach
@endif
</tbody>



                </table>
              </div>
            </div>
          </div>
        </div>
      </div>

    </section>



   


@endsection
