@extends('layouts.app')
@section('title', 'Add list')
@section('content')

<style>
        .wrap
        {
            white-space: pre-wrap;      /* CSS3 */   
            white-space: -moz-pre-wrap; /* Firefox */    
            white-space: -pre-wrap;     /* Opera <7 */   
            white-space: -o-pre-wrap;   /* Opera 7 */    
            word-wrap: break-word;      /* IE */
        }
    </style>
<section class="content">
  <div class="row">       
    <div class="col-lg-12 col-12">
      <div class="box">
      <form method="post" name="userform" id="userform" action="">
          @csrf
          <input type="hidden" value="{{$Api_key}}"  class="form-control" name="api_key" id="api_key">

          <input type="hidden" value="{{ Session::get('parentId')}}"  class="form-control" name="client_id" id="client_id" >
          <div class="box-body"><!--bg-lightest-->
          
         
            <h4 class="box-title text-info mb-0"><i class="ti-user me-15"></i> Add Lead Source</h4>
            <a href="{{ url('/lead-source-configs') }}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i>Show Api List</a>

            <hr class="my-15">
            <div class="row">
              <div class="col-md-3">
                <div class="form-group @error('name') has-error @enderror">
                  <label class="form-label">Title</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('name') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <input type="" class="form-control" value="{{old('title')}}"  name="title" id="title">
                </div>
                </div>
              </div>

              <div class="col-md-3">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">Description</label> 
                  <div class="input-group mb-3">
                  <span class="input-group-text @error('name') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                  <input type="" class="form-control" value="{{old('description')}}" name="description" id="description">

                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('list_id') has-error @enderror">
                  <label class="form-label">Select List</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('list_id') text-danger border-danger @enderror"><i class="ti-list"></i></span>
                    <select id="list_id" required  onchange="makeAPI(this.value,'{{$Api_key}}');" class="form-select" name="list_id" >
                    <option value="">Please Select List</option>
                                                @foreach($list_details as $list)
                                                <option @if($list->list_id == request()->input('list_id'))  selected @endif value="{{ $list->list_id }}">{{$list->list}}</option>
                                                @endforeach;
                                            </select>
                  </div>
                </div>
              </div>
              <div class="col-md-3"style="margin-top:10px;">
                <div class="form-group @error('list_id') has-error @enderror">
                  <label class="form-label"></label>
                  <div class="input-group mb-3">
                    <button type="submit" name="submit" value="Save" class="btn btn-primary btn-sm">
                  <i class="ti-save-alt"></i> Save
                </button>
                  </div>
                </div>
              </div> 
    
      </div>
      <!-- /.row -->
     <!-- /.box-body -->
     <div class="row">
     <div class="col-md-12">

              
              
                <div style="clear: both"></div>
                            <h4  class="wrap" style="margin: 30px 30px 30px 30px;display: none;">API Url :</h4>
                                    <p  style="margin: 30px;margin-top: -22px;" class="wrap"  id="showUrl"></p>
              </div>  
            </form>
            </div>
            </div>
            <!-- /.box -->      
        </div>  

    </section>


    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

    <script language="javascript">

function makeAPI(value,api_key)
{
    api_key = api_key;
    list_id = value;
    domain_url = "{{ env('PORTAL_NAME') }}";
    //domain_url = 'https://phone.performancemedia.cloud/';

    $.ajax({
        url: 'getLeadHeader/' +list_id,
        type: 'get',
        success: function (response)
        {
            var text = "";
            for (i = 0; i < response.length; i++)
            {
                text += response[i].header + "=$"+response[i].header+"&";
            }

            url = domain_url+'insertLeadSource?token='+api_key+'&';
            $(".wrap").show();
            $("#showUrl").html(url+''+text.toLowerCase().split(' ').join('_').slice(0, -1));
        }
    });
}

</script>


@endsection
