@extends('layouts.app')
@section('title', 'Lead Source Config')

@section('content')
<style>
        .wrap
        {
            white-space: pre-wrap;      /* CSS3 */   
            white-space: -moz-pre-wrap; /* Firefox */    
            white-space: -pre-wrap;     /* Opera <7 */   
            white-space: -o-pre-wrap;   /* Opera 7 */    
            word-wrap: break-word;      /* IE */
        }
    </style>
    <style>
.badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
    .page-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    margin-bottom: 15px;
}

@media (max-width: 576px) {
    .page-header {
        flex-direction: column;
        align-items: flex-start !important;
    }
    .page-header a {
        margin-top: 10px;
    }
}

    </style>
<!-- Main content -->
        <section class="content">

      <div class="row">

       
        
        <div class="col-12">
          <div class="box">
           <div class="box-body">   
            <div class="d-flex justify-content-between align-items-center flex-wrap mb-3">
    <h4 class="box-title text-info mb-0">
        <i class="fa fa-user fa-sx"></i> Lead Source Config
    </h4>
    <a href="{{ url('/lead-source-config') }}" 
       type="button" 
       class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm">
        <i class="fa fa-plus"></i> Add Lead Source Config
    </a>
</div>

<!--                       
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Lead Source Config</h4>
              <a  href="{{ url('/lead-source-config') }}" type="submit" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-plus"></i>Add Lead Source Config</a> -->
             <hr class="my-15">
              <div class="table-responsive">
                <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
                  <thead>
                    <tr>
                              <th>#</th>
                              <th>Title</th>
                              <th>Description</th> 
                              <th>Api key</th> 
                              <th>List</th>                                
                              <th>Action</th>

                            </tr>
                  </thead>
                  <tbody>
                  @foreach($leadsourceconfig as $key => $apiurl)

                                <tr>
                                  <th scope="row">{{$key+1}}</th>
                                  <td>{{$apiurl->title}}</td>                            
                                  <td>{{$apiurl->description}}</td>
                                 <td> {{$apiurl->api_key}}</td>
                                 <td>
                                        @foreach($list_details as $list)
                                        @if($list->list_id == $apiurl->list_id)
                                        {{$list->list}}
                                        @endif
                                        @endforeach
                                    </td>
                                  
                                  <td><a style="cursor:pointer;margin-right:5px;" title="Edit" onclick="makeAPI('{{$apiurl->list_id}}','{{$apiurl->api_key}}');"  class='editEG'><i class="fa fa-eye fa-lg"></i></a> 
                                   <a style="cursor:pointer;" title="Delete" data-configid="{{$apiurl->id}}"  class='openApiDelete'><i class="fa fa-trash-o fa-lg"></i></a></td>
                                  
                             
                                </tr>

  
                            @endforeach
                         
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
        <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
    
      <div class="modal-body">
      <p>You are about to delete <b><i class="title"></i></b>record.</p>
         <p>Do you want to proceed?</p>
         <input type="hidden" class="form-control" name="config_id" value="" id="config_id">
       
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit"name="submit" class="btn btn-danger btn-sm deleteKey">Delete</button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="add-edit"></h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
     
            <div class="modal-body">
                         <div class="form-group">
                                <label for="inputPassword3" id="" class="form-label">API Url</label>
                                <h4 class="wrap"  id="api_url"></h4>
                            </div>
            </div>
            <div class="modal-footer">
            <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
            </div>
    </div>
</div>

</div>
      </div>
      <!-- /.row -->

    </section>
        <!-- /.content -->



        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>



    <script language="javascript">
        $(".openApiDelete").click(function() {
        var delete_id = $(this).data('configid');
        $("#delete").modal('show');
        $("#config_id").val(delete_id);

    });


        $(document).on("click", ".deleteKey", function() {
        var key_api = $("#config_id").val();
        //alert(key_api);
        var el = this;
        $.ajax({
            url: 'deleteLeadConfig/' + key_api,
            type: 'get',
            success: function(response) {
                window.location.reload(1);
            }
        });

        //}
        /*  else
          {
              return false;
          }*/
    });

    function makeAPI(value,api_key)
    {
        list_id = value;
        api_key = api_key;
        domain_url = "{{ env('PORTAL_NAME') }}";
        //domain_url = 'https://phone.performancemedia.cloud/';

        $.ajax({
            url: 'getLeadHeader/' +list_id,
            type: 'get',
            success: function (response)
            {
                var text = "";
                for (i = 0; i < response.length; i++)
                {
                    text += response[i].header + "=$"+response[i].header+"&";
                }

                url = domain_url+'insertLeadSource?token='+api_key+'&';
                $("#myModal").modal('show');
                $("#api_url").html(url+''+text.toLowerCase().split(' ').join('_').slice(0, -1));
            }
        });
    }

</script>


@endsection
