@extends('layouts.app')
@section('title', 'Lead Status List')
@section('content')
<style>
	.btn-toggle.active {
    background-color: #2196f3; /* Set to the desired green color */
    color: white; /* Set to the desired text color */
    border-color: green; /* Set to the desired border color */
}

/* Style for the inactive state */
.btn-toggle:not(.active) {
    background-color: red; /* Set to the desired red color */
    color: white; /* Set to the desired text color */
    border-color: red; /* Set to the desired border color */
}
	</style>
	<style>
    .list-inline {
        margin: 0; /* Remove the default margin */
        padding: 0; /* Remove padding to align with the icons */
    }

    .list-inline-item {
        margin-right:1px; /* Adjust the right margin to control spacing between icons */
    }

</style>
<link href="{{asset('assets/css/bootstrap4-toggle.min.css')}}" rel="stylesheet">

<section class="content">
  <div class="row">       
    <div class="col-lg-12 col-12">
      <div class="box">                  
          <div class="box-body"><!--bg-lightest-->
             <h4 class="box-title text-info mb-0"><i class="fa fa-plus"></i> Lead Status List</h4>
              <a data-bs-toggle="modal" data-bs-target="#add-new-events" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-plus"></i> Add Lead Status</a>
                  <hr class="my-15">
                                                <div class="row">
                                                    <div class="col-md-9">
                                                        <div class="box">
                                                              <div class="box-body">
                                                                        <div class="row">
                                                                          <div class="table-responsive mailbox-messages ">
                                                                            <table id="tickets1" class="table mt-0 table-hover no-wrap" data-page-size="10">
                                                                              <thead>
                                                                                  <tr>
                                                                                    <th>#</th>
                                                                                    <th>Title</th>
                                                                                    <th>Show on dashboard</th>                            
                                                                                    <th>Status</th> 
                                                                                    <th>Action</th>

                                                                                  </tr>
                                                                              </thead>
                                                                              <tbody>
                                                                                @if(!empty($lead_status))
                                                                                @foreach($lead_status as $key => $list)

                                                                                <tr>
                                                                                  <td>{{$key+1}}</td>
                                                                                  <td>{{$list->title}}</td>
                                                                                  <td>
                                                                                      <a  style="margin-right:5px;cursor:pointer;color:#2f579a"title="View On Lead" href="javascript:void(0)" data-toggle="tooltip"
                                                                                                      data-id="{{$list->id}}" data-view="{{$list->view_on_dashboard}}" 
                                                                                                      data-original-title="Edit" class="view">
                                                                                                      @if($list->view_on_dashboard == 1)
                                                                                                      <i  class="fa fa-eye fa-lg"></i>
                                                                                                      @else
                                                                                                      <i style="opacity: 0.6;cursor: pointer;" class="fa fa-eye-slash fa-lg"></i>

                                                                                                      @endif  </a>
                                                                                  </td>
                                                                                  <td>
                                                                                          <button type="button"data-id="{{$list->id}}"  class="btn btn-sm btn-toggle  @if($list->status == '1') active @endif" data-bs-toggle="button" aria-pressed="true" autocomplete="off">
                                                                                            <div class="handle"></div>
                                                                                          </button>
                                                                                  </td>
                                                                                  <td>                     
                                                                                    <a href="javascript:void(0)"style="color:#2f579a;margin-right:5px;" data-toggle="tooltip"  data-id="{{$list->id}}" data-title="{{$list->title}}" data-color="{{$list->color_code}}"  data-url="{{$list->webhook_url}}" data-token="{{$list->webhook_token}}" data-method="{{$list->webhook_method}}" data-enabled="{{$list->webhook_status}}" data-original-title="Edit" class="edit"><i class="fa fa-edit edit fa-lg"></i></a>                                                                                                           
                                                                                    <a style="cursor:pointer;color:#2f579a" href="#" class="show_confirm" data-id="{{$list->id}}"><i class="fa fa-trash-o fa-lg"></i></a>
                                                                                  </td>
                                                                                </tr>
                                                                                @endforeach
                                                                                @endif
                                                                                    
                                                                              </tbody>
                                                                            </table>
                                                                          </div>
                                                                        </div>
                                                              </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="box">
                                                            <div class="box-body">
                                                                <div class="row">
                                                                  <div class="col-md-12">
                                                                        <h4 class="box-title">Display Order(Drag & Drop)</h4>
                                                                      <div class="box-body">
                                                                        <!-- the events -->
                                                                        <div id="external-events">
                                                                                <table class="table">                             
                                                                                  <tbody class="row_position external-event">
                                                                                      @if(!empty($lead_status))
                                                                                      @foreach($lead_status as $key => $list)
                                                                                      @if($list->view_on_dashboard == 1 && $list->status == 1)
                                                                                      <tr   id="<?php echo $list->id; ?>"class="rounded-tr">
                                                                                        <td style="cursor: pointer;width:100%;"class="waves-effect waves-light btn btn-primary mb-5">
                                                                                            <?php echo $list->title ?>
                                                                                      </td>
                                                                                      </tr>
                                                                                      @endif
                                                                                      @endforeach
                                                                                      @endif
                                                                                    </tbody>
                                                                                </table>
                                                                        </div>
                                                                      </div>                 
                                                                  </div>          
                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>   
            </div>
              <!-- /.box-body -->
          
            <!-- /.box -->      
        </div>         
      </div>
  </section>



  
  <!-- BEGIN MODAL -->
	<!-- Modal Add Category -->
	<div class="modal fade none-border" id="add-new-events">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title"><strong>Add</strong> Lead Status Title</h4>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body">
				<form method="post" id="addLeadStatus" >
              @csrf
              <div class="card-body">
                <div class="form-group">
                  <label for="exampleInputEmail1">Lead Status Title</label>
                  <input type="text" required class="form-control"  name="title" placeholder="Title">
                </div>

                <div class="form-group">
                  <label for="exampleInputEmail1">Color Picker</label>
                <input type="color" required class="form-control" id="" name="color_code" value="#ff0000">

                </div>

                <div class="form-group">
                  <label for="exampleInputEmail1">Vector Image</label>
                  <select class="form-control" name="image">
                    <option value="fa-th">fa-th</option>
                  </select>
                </div>

                <div class="form-group">
                  <label for="exampleInputEmail1">Webhook Status</label>
                  <select class="form-control" name="webhook_status">
                    <option value="0">No</option>
                    <option value="1">Yes</option>

                  </select>
                </div>

                 <div class="form-group">
                  <label for="exampleInputEmail1">Webhook Method</label>
                  <select class="form-control" name="webhook_method">
                    <option value="post">Post</option>
                    <option value="get">Get</option>

                  </select>
                </div>

                 <div class="form-group">
                  <label for="exampleInputEmail1">Webhook Url</label>
                  <input type="text"  class="form-control"  name="webhook_url" placeholder="Url">
                </div>

                <div class="form-group">
                  <label for="exampleInputEmail1">Webhook Token</label>
                  <input type="text"  class="form-control"  name="webhook_token" placeholder="Token">
                </div>
              </div>

          
			</div>
			<div class="modal-footer">
				<button type="submit" class="btn btn-success save-category">Submit</button>
				<a  type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</a>
			</div>
		</form>
			</div>
		</div>
	</div>
	<!-- END MODAL -->
<!-- edit modal -->
    <div class="modal fade none-border" id="ajaxModel">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title"><strong>Edit </strong> Lead Status Title</h4>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body">
						<form method="post" action="{{ route('leadstatus.update') }}" id="updateLeadStatus">
							@csrf
							<input type="hidden" name="lead_status_id" id="id">
								<div class="card-body">
									<div class="form-group">
									<label for="exampleInputEmail1">Lead Status Title</label>
									<input type="text" required class="form-control" id="title" name="title" placeholder="Title">
									</div>

									<div class="form-group">
									<label for="exampleInputEmail1">Color Picker</label>
									<input type="color" required class="form-control" id="color_code" name="color_code" value="#ff0000">

									</div>

                  <div class="form-group">
                  <label for="exampleInputEmail1">Webhook Status</label>
                  <select class="form-control" name="webhook_status" id="webhook_status">
                    <option value="0">No</option>
                    <option value="1">Yes</option>

                  </select>
                </div>

                 <div class="form-group">
                  <label for="exampleInputEmail1">Webhook Method</label>
                  <select class="form-control" name="webhook_method" id="webhook_method">
                    <option value="post">Post</option>
                    <option value="get">Get</option>

                  </select>
                </div>

                 <div class="form-group">
                  <label for="exampleInputEmail1">Webhook Url</label>
                  <input type="text"  class="form-control"  name="webhook_url" id="webhook_url" placeholder="Token">
                </div>


                  <div class="form-group">
                  <label for="exampleInputEmail1">Webhook Token</label>
                  <input type="text"  class="form-control"  name="webhook_token" id="webhook_token" placeholder="Token">
                </div>



								</div>
								<div class="card-footer">
									<button type="submit" class="btn btn-primary"><i class="fa fa-edit" id="webhook_status" aria-hidden="true"></i> Update</button>
									<a type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</a>
								</div>
						</form>
			    </div>
		   </div>
	    </div>
    </div>
	<!-- delete modal -->
	<div class="modal fade none-border" id="delete">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title"><strong>Delete </strong> Lead Status Title</h4>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body">
			
							
							<p>You are about to delete <b><i class="title"></i></b> Record </p>
							<input  type="hidden"name="deleteStatus"id="deleteStatus">
                                    <p>Do you want to proceed?</p>
								</div>
								<div class="card-footer">
									<button type="submit" class="btn btn-danger deleteLead"> Delete</button>
									<a type="button" class="btn btn-primary" data-bs-dismiss="modal">Close</a>
								</div>
						
			    </div>
		   </div>
	    </div>
    </div>
<!-- END MODAL -->
<!-- edit modal -->


<!-- /.row -->

  
 <script src="{{asset('assets/vendor_components/jquery-ui/jquery-ui.min.js')}}"></script>	
	<script src="{{asset('assets/js/pages/calendar.js')}}"></script>
	<script src="{{asset('assets/js/bootstrap4-toggle.min.js')}}"></script>
  <script>
$(document).ready(function() {
    $('#tickets1').DataTable({
        columnDefs: [
            {
                targets: [0, 2, 3], // Columns to disable sorting
                orderable: false
            },
            {
                targets: [1], // Name column, enable sorting
                orderable: true
            }
        ]
    });
});
</script>
	<script>
 $(document).ready(function() {
    $("#tickets1").on("click", ".btn-toggle", function() {
        var button = $(this);
        var status = button.hasClass('active') ? 1 : 0;
        var lead_status_id = button.data('id');
        
        $.ajax({
            type: "GET",
            dataType: "json",
            url: '/changeLeadStatus/' + lead_status_id + '/' + status,
            success: function(data) {
                if (data.status == 'true') {
                    $('#loading').show();
                    console.log(data.success);
                    window.location.reload(1);
                } else {
                    // Handle the case when the status change is not successful
                }
            }
        });
    });
});

  </script>
	<script>
    $(document).ready(function ()
    {

      $("#tickets1").on("click", ".view", function () {
                // $('#loading').show();
                var view_on_lead = $(this).data('view');
                if(view_on_lead == 1)
                    view_on_lead=0;
                else
                    view_on_lead=1;
                var label_id = $(this).data('id');

              

                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: '/changeViewOnLeadStatus/' + label_id + '/' + view_on_lead,
                    success: function (data) {
                        if (data.status == 'true') {
                            $('#loading').show();
                            console.log(data.success);
                            window.location.reload(1);
                        } else {

                        }

                    }
                });
            })
    });
  </script>

  <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.0/sweetalert.min.js"></script>
  <script type="text/javascript">
    $('.show_confirm').click(function(event)
    {
		$('#delete').modal('show');
		var delete_id = $(this).data('id');
  console.log(delete_id);
   $("#delete").modal('show');
   $("#deleteStatus").val(delete_id);
  
    });


	$(document).on("click", ".deleteLead" , function()
{
   var delete_id = $("#deleteStatus").val();
   var el = this;
   $.ajax
   ({
       url: 'lead-status/'+delete_id,
       type: 'get',
       success: function(response)
       {
           window.location.reload(1);
       }
   });
});
    $(".row_position").sortable({
            delay: 150,
            stop: function() {
                var selectedData = new Array();
                $('.row_position>tr').each(function() {
                    selectedData.push($(this).attr("id"));
                });
                updateOrder(selectedData);
            }
        });

    function updateOrder(data) {

            $.ajaxSetup({
            headers: 
            {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }});
            $.ajax({
                url: "{{ url('/update-lead-status/displayorder') }}",
                type:'post',
                data:{display_order:data},
                success:function(data){
                   toastr.success('Display Order is changed Successfully.');
                }
            })
        }

    $('.edit').click(function ()
    {
      var id = $(this).data('id');
      var title = $(this).data('title');
      var color = $(this).data('color');
      var webhook_url = $(this).data('url');
      var webhook_status = $(this).data('enabled');
      var webhook_method = $(this).data('method');


      var webhook_token = $(this).data('token');




      $('#ajaxModel').modal('show');
      $('#id').val(id);
      $('#title').val(title);
      $('#color_code').val(color);
      $('#webhook_url').val(webhook_url);
      $('#webhook_status').val(webhook_status);
      $('#webhook_token').val(webhook_token);
      $('#webhook_method').val(webhook_method);
      




    });

  </script>



<script>
  $(document).ready(function()
  {
    $('#addLeadStatus,#updateLeadStatus').submit(function()
    {
      $("#ajaxModel").hide();
      $('#loading').show();
    });
  })
</script>


@endsection
