@extends('layouts.app')
@section('title', 'Add Lender')
@section('content')
<section class="content">
  <div class="row">       
    <div class="col-lg-12 col-12">
      <div class="box">
                              <form method="post">

                                @csrf
          <div class="box-body"><!--bg-lightest-->
            <h4 class="box-title text-info mb-0"><i class="fa fa-plus"></i> Add Lender Info</h4>
            <a href="{{url('/lenders')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i> Lenders</a>

            <hr class="my-15">
            <div class="row">


              <div class="row">
  <!-- API Status -->
  <div class="col-md-3">
    <div class="form-group">
      <label class="form-label">API Status <span style="color: red;">*</span></label>
      <select id="api_status" name="api_status" class="form-control" required>
        <option value="">Select Status</option>
        <option value="1">Yes</option>
        <option value="0">No</option>
      </select>
    </div>
  </div>
  <div class="col-md-3" id="api_type_field" style="display: none;">
    <div class="form-group">
      <label class="form-label">API Type <span style="color: red;">*</span></label>
      <select id="lender_api_type" name="lender_api_type" class="form-control" >
        <option value="">Select</option>
        <option value="ondeck">Ondeck</option>
        <option value="credibly">Credibly</option>
        <option value="bitty_advance">Bitty Advance</option>
        <option value="fox_partner">Fox Partner</option>
        <option value="lendini">Lendini</option>
        <option value="specialty">Specialty</option>
        <option value="forward_financing">Forward Financing </option>
        <option value="cancapital">CanCapital </option>




      </select>
    </div>
  </div>
  <!-- Username -->
  <div class="col-md-3" id="username_field" style="display: none;">
    <div class="form-group">
      <label class="form-label">Username <span style="color: red;">*</span></label>
      <input
        type="text"
        name="username"
        value="{{ old('username') }}"
        class="form-control"
        placeholder="Enter Username"
      />
    </div>
  </div>

  <!-- Password -->
  <div class="col-md-3" id="password_field" style="display: none;">
    <div class="form-group">
      <label class="form-label">Password <span style="color: red;">*</span></label>
      <input
        type="password"
        name="password"
        value="{{ old('password') }}"
        class="form-control"
        placeholder="Enter Password"
      />
    </div>
  </div>

  <!-- API Key -->
  <div class="col-md-3" id="api_key_field" style="display: none;">
    <div class="form-group">
      <label class="form-label">API Key <span style="color: red;">*</span></label>
      <input
        type="text"
        name="api_key"
        value="{{ old('api_key') }}"
        class="form-control"
        placeholder="Enter API Key"
      />
    </div>
  </div>

  <!-- URL -->
  <div class="col-md-3" id="url_field" style="display: none;">
    <div class="form-group">
      <label class="form-label">URL <span style="color: red;">*</span></label>
      <input
        type="url"
        name="url"
        value="{{ old('url') }}"
        class="form-control"
        placeholder="Enter URL"
      />
    </div>
  </div>

 <!-- email -->
 <div class="col-md-3" id="email_field" style="display: none;">
    <div class="form-group">
      <label class="form-label">Sales Rep Email Address <span style="color: red;">*</span></label>
      <input
        type="email"
        name="salesRepEmailAddress"
        value="{{ old('salesRepEmailAddress') }}"
        class="form-control"
        placeholder="Enter Email"
      />
    </div>
  </div>
 <!-- partner API Key -->
 <div class="col-md-3" id="partner_api_key_field" style="display: none;">
    <div class="form-group">
      <label class="form-label">Partner API Key <span style="color: red;">*</span></label>
      <input
        type="text"
        name="partner_api_key"
        value="{{ old('partner_api_key') }}"
        class="form-control"
        placeholder="Enter Partner API Key"
      />
    </div>
  </div>
     <!--Auth URL -->
     <div class="col-md-3" id="client_id" style="display: none;">
    <div class="form-group">
      <label class="form-label">Client id <span style="color: red;">*</span></label>
      <input
        type="text"
        name="client_id"
        value="{{ old('client_id') }}"
        class="form-control"
        placeholder="Enter Client Id"
      />
    </div>
  </div>
    <!--Auth URL -->
    <div class="col-md-3" id="auth_url_field" style="display: none;">
    <div class="form-group">
      <label class="form-label">Auth URL <span style="color: red;">*</span></label>
      <input
        type="url"
        name="auth_url"
        value="{{ old('auth_url') }}"
        class="form-control"
        placeholder="Enter  Auth URL"
      />
    </div>
  </div>
   <div class="col-md-3">
                <div class="form-group @error('first_name') has-error @enderror">
                  <label class="form-label">Lender Name <span style="color: red;">*</span></label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('first_name') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    

                    <input type="text" name="lender_name" value="{{old('lender_name')}}" class="form-control" id="lender_name" required placeholder="Enter Lender Name" />
                  </div>
                </div>
              </div>
</div>














         
            
              <div class="col-md-3"style="display:none;">
                <div class="form-group @error('lender_type') has-error @enderror">
                  <label class="form-label">Lender Type</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('lender_type') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="lender_type">
                    <option value="email"Selected>Email</option>

                  </select>

                  </div>
                </div>
              </div>

              <div class="" id="hiddenField" style="display: none;">
                <div class="row">
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Lender Email</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                    <input type="email" name="email" value="{{old('email')}}" class="form-control" id="email" placeholder="Enter Lender Email" />
                  </div>
                </div>
              </div>

              <div class="col-md-3">
                <div class="form-group @error('secondary_email') has-error @enderror">
                  <label class="form-label">Optional Email 1(CC) </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                    <input type="email" name="secondary_email" value="{{old('secondary_email')}}" class="form-control" id="secondary_email" placeholder="Enter Optional Email 1" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('secondary_email2') has-error @enderror">
                  <label class="form-label">Optional Email 2</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                    <input type="email" name="secondary_email2" value="{{old('secondary_email2')}}" class="form-control" id="secondary_email2" placeholder="Enter Optional Email 2" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('secondary_email3') has-error @enderror">
                  <label class="form-label">Optional Email 3</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                    <input type="email" name="secondary_email3" value="{{old('secondary_email3')}}" class="form-control" id="secondary_email3" placeholder="Enter Optional Email 3" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('secondary_email3') has-error @enderror">
                  <label class="form-label">Optional Email 4</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                    <input type="email" name="secondary_email4" value="{{old('secondary_email4')}}" class="form-control" id="secondary_email4" placeholder="Enter Optional Email 4" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Phone </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="fa fa-phone"></i></span>
                    <input name="phone" id="phone" value="{{ old('mobile') }}" type="text" class="form-control" data-inputmask="'mask': '(999) 999-9999'" data-mask="" />
                  </div>
                </div>
              </div>

              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Contact </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <input type="text" name="contact_person" value="{{old('contact_person')}}" class="form-control" id="contact_person"  placeholder="Enter Contact" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('min_credit_score') has-error @enderror">
                  <label class="form-label">FICO </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('min_credit_score') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <input type="text" name="min_credit_score" value="{{old('min_credit_score')}}" class="form-control" id="min_credit_score"  placeholder="Enter Min Credit score" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('max_Negative_days') has-error @enderror">
                  <label class="form-label">Max Negative Days </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('max_negative_days') text-danger border-danger @enderror"><i class="fa fa-calendar"></i></span>
                    <input type="text" name="max_negative_days" value="{{old('max_negative_days')}}" class="form-control" id="max_negative_days"  placeholder="Enter Max Negative days" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('max_advance') has-error @enderror">
                  <label class="form-label">Max Loan Amount </label> 
                  <div class="controls">
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('max_adv') text-danger border-danger @enderror">$</span>
                    <input type="text" name="max_advance "value="{{old('max_advance')}}" class="form-control"  data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers"placeholder="Enter Max Advance" > 
              
                  </div>
                  </div>
                </div>
              </div>

              <div class="col-md-3">
                <div class="form-group @error('nsfs') has-error @enderror">
                  <label class="form-label">NSFs</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('max_adv') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <input type="text" name="nsfs" value="{{old('nsfs')}}" class="form-control" id="nsfs"  placeholder="Enter NSFs" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('min_time_business') has-error @enderror">
                  <label class="form-label"> Time In Business(Months)</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('min_time_business') text-danger border-danger @enderror"><i class="fa fa-calendar"></i></span>
                    <input type="text" name="min_time_business" value="{{old('min_time_business')}}" class="form-control" id="min_time_business"  placeholder="Enter  Business Time" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('min_amount') has-error @enderror">
                  <label class="form-label">Min Loan Amount</label> 
                  <div class="controls">
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('min_amount') text-danger border-danger @enderror">$</span>
                    <input type="text" name="min_amount" value="{{old('min_amount')}}" class="form-control" id="min_amount"  placeholder="Enter Min Amount" data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers"placeholder="Enter Min Amount"/>
                  </div>
                </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('min_deposits') has-error @enderror">
                  <label class="form-label">Minimum no of Deposits</label> 
                  <div class="controls">
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('min_amt') text-danger border-danger @enderror"><i class="fa fa-user"></i></span>
                    <input type="text" name="min_deposits" value="{{old('min_deposits')}}" class="form-control" id="min_deposits"  placeholder="Enter Deposits"  data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers"/>
                  </div>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('min_amount') has-error @enderror">
                  <label class="form-label">Min Monthly Deposit</label> 
                  <div class="controls">
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('min_amount') text-danger border-danger @enderror">$</span>
                    <input type="text" name="min_monthly_deposit" value="" class="form-control" id="min_monthly_deposit"  placeholder="Enter Min Amount"data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers" //>
                  </div>
                </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('min_amount') has-error @enderror">
                  <label class="form-label">Min Average Revenue</label> 
                  <div class="controls">
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('min_amount') text-danger border-danger @enderror">$</span>
                    <input type="text" name="min_avg_revenue" value="" class="form-control" id="min_avg_revenue"  placeholder="Enter Min Average"data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers" />
                  </div>
                </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('max_position') has-error @enderror">
                  <label class="form-label">Positions Offered</label> 
                  <div class="controls">
                  <div class="input-group mb-3">
                    <!-- <input type="text" name="max_position" value="{{old('max_position')}}" class="form-control" id="max_position"  placeholder="Enter Max Position" data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers"/> -->
                    <select class="select2 form-control" multiple="multiple" name="max_position[]" autocomplete="off" data-placeholder="Select position"style="width:100%;">
                    <option value="">--Select--</option>
                    <option value="1">1</option>
                    <option value="2">2</option>
                    <option value="3">3</option>
                    <option value="4">4</option>
                    <option value="5">5</option>
                    <option value="6">6</option>
                    <option value="7">7</option>
                    <option value="8">8</option>
                    <option value="9">9</option>
                    <option value="10">10</option>
                    </select>
                  </div>
                </div>
              </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('max_term') has-error @enderror">
                  <label class="form-label">Max Term(months)</label> 
                  <div class="controls">
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('max_term') text-danger border-danger @enderror"><i class="fa fa-calendar"></i></span>
                    <input type="text" name="max_term" value="{{old('max_term')}}" class="form-control" id="max_term"  placeholder="Enter Max Term" data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers"/>
                  </div>
                </div>
              </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('daily_balance') has-error @enderror">
                  <label class="form-label"> Average Daily Balance</label> 
                  <div class="controls">
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('daily_balance') text-danger border-danger @enderror">$</span>
                    <input type="text" name="daily_balance" value="{{old('daily_balance')}}" class="form-control" id="daily_balance"  placeholder="Enter Avg Daily Balance" data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers"/>
                  </div>
                </div>
              </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('max_term') has-error @enderror">
                  <label class="form-label">White Label</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('white_label') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="white_label">
                    <option value="Yes">Yes</option>
                    <option value="No">No</option>

                  </select>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('consolidation') has-error @enderror">
                  <label class="form-label">Consolidation</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('consolidation') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="consolidation"id="consolidation">
                    <option value="Yes">Yes</option>
                    <option value="No">No</option>

                  </select>
                  </div>
                </div>
              </div>
              <div class="col-md-3"id="max_mca_div" style="display: none;">
                <div class="form-group @error('max_mca_payoff_amount') has-error @enderror">
                  <label class="form-label">Max MCA Payoff Amount</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('max_mca_payoff_amount') text-danger border-danger @enderror">$</span>
                    <input type="text" name="max_mca_payoff_amount" value="{{old('max_mca_payoff_amount')}}" class="form-control" id="max_mca_payoff_amount"  placeholder="" data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers"/>

                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('reverse_consolidation') has-error @enderror">
                  <label class="form-label">Reverse Consolidation</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('consolidation') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="reverse_consolidation">
                    <option value="1">Yes</option>
                    <option value="0">No</option>

                  </select>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('sole_prop') has-error @enderror">
                  <label class="form-label">Sole Prop</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('sole_prop') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="sole_prop">
                    <option value="Yes">Yes</option>
                    <option value="No">No</option>

                  </select>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('home_business') has-error @enderror">
                  <label class="form-label">Home based </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('home_business') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="home_business">
                    <option value="Yes">Yes</option>
                    <option value="No">No</option>

                  </select>                 
                </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('non_profit') has-error @enderror">
                  <label class="form-label">Non Profit</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('non_profit') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="non_profit">
                    <option value="Yes">Yes</option>
                    <option value="No"Selected>No</option>

                  </select>                    
                </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('non_profit') has-error @enderror">
                  <label class="form-label">Payment Schedule(Daily/Weekly)</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('daily') text-danger border-danger @enderror"><i class="fa fa-calendar"></i></span>
                    <select class="form-select" name="daily">
                    <option value="daily">Daily</option>
                    <option value="weekly">Weekly</option>
                    <option value="all">Both</option>

                  </select> 
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('coj_request') has-error @enderror">
                  <label class="form-label">COJ Request</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('coj_request') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="coj_request">
                    <option value="Yes">Yes</option>
                    <option value="No">No</option>

                  </select>                    
                </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('bank_verify') has-error @enderror">
                  <label class="form-label">Bank Verification Process</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('bank_verify') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="bank_verify">
                    <option value="team">Team Viewer</option>
                    <option value="manual">MANUAL LOGIN</option>

                  </select>                    
                </div>
                </div>
              </div>
         
              <!-- <div class="col-md-3">
                <div class="form-group @error('not_business_type') has-error @enderror">
                  <label class="form-label">Does Not Do Business Type</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('not_business_type') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <input type="text" name="not_business_type" value="{{old('not_business_type')}}" class="form-control" id="not_business_type"  placeholder="Enter Max Term" />
                  </div>
                </div>
              </div> -->
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Address </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="ti-world"></i></span>
                    <input type="text" name="address" value="{{old('address')}}" class="form-control" id="address"  placeholder="Enter Address" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('country') has-error @enderror">
                  <label class="form-label">Country </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('country') text-danger border-danger @enderror"><i class="ti-world"></i></span>
                    <select  class="form-select" name="country" id="country">
                                                        <option  value="USA" Selected>USA</option>
                                                        
                            </select>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">State </label> 
                  <div class="input-group mb-3">
                  <span class="input-group-text @error('country') text-danger border-danger @enderror"><i class="ti-world"></i></span>
                    <select class="form-select" name="state" id="state">
                                                                    <option value="AL">Alabama</option>
                                                                        <option value="AK">Alaska</option>
                                                                        <option value="AS">American Samoa</option>
                                                                        <option value="AZ">Arizona</option>
                                                                        <option value="AR">Arkansas</option>
                                                                        <option value="AE-A">Armed Forces Africa</option>
                                                                        <option value="AA">Armed Forces Americas</option>
                                                                        <option value="AE-C">Armed Forces Canada</option>
                                                                        <option value="AE-E">Armed Forces Europe</option>
                                                                        <option value="AE-M">Armed Forces Middle East</option>
                                                                        <option value="AP">Armed Forces Pacific</option>
                                                                        <option value="CA">California</option>
                                                                        <option value="CO">Colorado</option>
                                                                        <option value="CT">Connecticut</option>
                                                                        <option value="DE">Delaware</option>
                                                                        <option value="DC">District of Columbia</option>
                                                                        <option value="FM">Federated States of Micronesia</option>
                                                                        <option value="FL">Florida</option>
                                                                        <option value="GA">Georgia</option>
                                                                        <option value="GU">Guam</option>
                                                                        <option value="HI">Hawaii</option>
                                                                        <option value="ID">Idaho</option>
                                                                        <option value="IL">Illinois</option>
                                                                        <option value="IN">Indiana</option>
                                                                        <option value="IA">Iowa</option>
                                                                        <option value="KS">Kansas</option>
                                                                        <option value="KY">Kentucky</option>
                                                                        <option value="LA">Louisiana</option>
                                                                        <option value="ME">Maine</option>
                                                                        <option value="MD">Maryland</option>
                                                                        <option value="MA">Massachusetts</option>
                                                                        <option value="MI">Michigan</option>
                                                                        <option value="MN">Minnesota</option>
                                                                        <option value="MS">Mississippi</option>
                                                                        <option value="MO">Missouri</option>
                                                                        <option value="MT">Montana</option>
                                                                        <option value="NE">Nebraska</option>
                                                                        <option value="NV">Nevada</option>
                                                                        <option value="NH">New Hampshire</option>
                                                                        <option value="NJ">New Jersey</option>
                                                                        <option value="NM">New Mexico</option>
                                                                        <option value="NY">New York</option>
                                                                        <option value="NC">North Carolina</option>
                                                                        <option value="ND">North Dakota</option>
                                                                        <option value="MP">Northern Mariana Islands</option>
                                                                        <option value="OH">Ohio</option>
                                                                        <option value="OK">Oklahoma</option>
                                                                        <option value="OR">Oregon</option>
                                                                        <option value="PA">Pennsylvania</option>
                                                                        <option value="PR">Puerto Rico</option>
                                                                        <option value="MH">Republic of Marshall Islands</option>
                                                                        <option value="RI">Rhode Island</option>
                                                                        <option value="SC">South Carolina</option>
                                                                        <option value="SD">South Dakota</option>
                                                                        <option value="TN">Tennessee</option>
                                                                        <option value="TX">Texas</option>
                                                                        <option value="UT">Utah</option>
                                                                        <option value="VT">Vermont</option>
                                                                        <option value="VI">Virgin Islands of the U.S.</option>
                                                                        <option value="VA">Virginia</option>
                                                                        <option value="WA">Washington</option>
                                                                        <option value="WV">West Virginia</option>
                                                                        <option value="WI">Wisconsin</option>
                                                                        <option value="WY">Wyoming</option>
                                                                </select>
                  </div>
                </div>
              </div>

              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">City </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="ti-world"></i></span>
                    <input type="text" name="city" value="{{old('city')}}" class="form-control" id="city"  placeholder="Enter City" />
                  </div>
                </div>
              </div>
           
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Factor Rates</label>
                  <div class="input-group mb-3">
                  <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="fa fa-user"></i></span>
                  <input type="text" name="factor_rate" class="form-control" id="factor_rate" placeholder=""value="{{old('factor_rate')}}" >
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">LOC</label>
                  <div class="input-group mb-3">
                  <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="fa fa-user"></i></span>
                    <select class="form-select"name="loc">
                      <option  value="yes">Yes</option>
                      <option  value="no">No</option>

</select>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Ownership Percentage</label>
                  <div class="input-group mb-3">
                  <span class="input-group-text @error('ownership_percentage') text-danger border-danger @enderror"><i class="fa fa-user"></i></span>
                  <input type="text" name="ownership_percentage" class="form-control" id="" placeholder=""value="{{old('ownership_percentage')}}" data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers">
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Restricted Industry </label> 
                  <div class="input-group mb-3">
                    <select class="select2 form-control"  multiple="multiple" name="industry[]" autocomplete="off" data-placeholder="Select industry"id="industry"style="width:100%;" >
                    <option value="construction">Construction</option>
                <option value="trucking">Trucking</option>
                <option value="auto sales">Auto Sales</option>
                  </select>    
                  </div>
                </div>
              </div>
          
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Restricted industry Notes </label>
                  <div class="input-group mb-3">
                  <textarea type="text" name="restricted_industry_note" class="form-control" id="notes" placeholder="Write Notes" ></textarea>
                  </div>
                </div>
              </div>
              <!-- <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Prohibited Industry </label>
                  <div class="input-group mb-3">
                  <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="fa fa-user"></i></span>
                  <input type="text" name="prohibited_industry" class="form-control" id="prohibited_industry" placeholder=""value="{{old('prohibited_industry')}}" >
                  </div>
                </div>
              </div> -->
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Restricted State </label>
                  <div class="input-group mb-3">
                    <select class="select2 form-control"  multiple="multiple" name="guideline_state[]" autocomplete="off" data-placeholder="Select state"id="guideline_state"style="width:100%;" >
                    <option value="AL">Alabama</option>
                                                                        <option value="AK">Alaska</option>
                                                                        <option value="AS">American Samoa</option>
                                                                        <option value="AZ">Arizona</option>
                                                                        <option value="AR">Arkansas</option>
                                                                        <option value="AE-A">Armed Forces Africa</option>
                                                                        <option value="AA">Armed Forces Americas</option>
                                                                        <option value="AE-C">Armed Forces Canada</option>
                                                                        <option value="AE-E">Armed Forces Europe</option>
                                                                        <option value="AE-M">Armed Forces Middle East</option>
                                                                        <option value="AP">Armed Forces Pacific</option>
                                                                        <option value="CA">California</option>
                                                                        <option value="CO">Colorado</option>
                                                                        <option value="CT">Connecticut</option>
                                                                        <option value="DE">Delaware</option>
                                                                        <option value="DC">District of Columbia</option>
                                                                        <option value="FM">Federated States of Micronesia</option>
                                                                        <option value="FL">Florida</option>
                                                                        <option value="GA">Georgia</option>
                                                                        <option value="GU">Guam</option>
                                                                        <option value="HI">Hawaii</option>
                                                                        <option value="ID">Idaho</option>
                                                                        <option value="IL">Illinois</option>
                                                                        <option value="IN">Indiana</option>
                                                                        <option value="IA">Iowa</option>
                                                                        <option value="KS">Kansas</option>
                                                                        <option value="KY">Kentucky</option>
                                                                        <option value="LA">Louisiana</option>
                                                                        <option value="ME">Maine</option>
                                                                        <option value="MD">Maryland</option>
                                                                        <option value="MA">Massachusetts</option>
                                                                        <option value="MI">Michigan</option>
                                                                        <option value="MN">Minnesota</option>
                                                                        <option value="MS">Mississippi</option>
                                                                        <option value="MO">Missouri</option>
                                                                        <option value="MT">Montana</option>
                                                                        <option value="NE">Nebraska</option>
                                                                        <option value="NV">Nevada</option>
                                                                        <option value="NH">New Hampshire</option>
                                                                        <option value="NJ">New Jersey</option>
                                                                        <option value="NM">New Mexico</option>
                                                                        <option value="NY">New York</option>
                                                                        <option value="NC">North Carolina</option>
                                                                        <option value="ND">North Dakota</option>
                                                                        <option value="MP">Northern Mariana Islands</option>
                                                                        <option value="OH">Ohio</option>
                                                                        <option value="OK">Oklahoma</option>
                                                                        <option value="OR">Oregon</option>
                                                                        <option value="PA">Pennsylvania</option>
                                                                        <option value="PR">Puerto Rico</option>
                                                                        <option value="MH">Republic of Marshall Islands</option>
                                                                        <option value="RI">Rhode Island</option>
                                                                        <option value="SC">South Carolina</option>
                                                                        <option value="SD">South Dakota</option>
                                                                        <option value="TN">Tennessee</option>
                                                                        <option value="TX">Texas</option>
                                                                        <option value="UT">Utah</option>
                                                                        <option value="VT">Vermont</option>
                                                                        <option value="VI">Virgin Islands of the U.S.</option>
                                                                        <option value="VA">Virginia</option>
                                                                        <option value="WA">Washington</option>
                                                                        <option value="WV">West Virginia</option>
                                                                        <option value="WI">Wisconsin</option>
                                                                        <option value="WY">Wyoming</option>

                  </select>                   
                </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Restriced state Notes </label>
                  <div class="input-group mb-3">
                  <textarea type="text" name="restricted_state_note" class="form-control" id="notes" placeholder="Write Notes" ></textarea>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Lender Notes </label>
                  <div class="input-group mb-3">
                  <textarea type="text" name="notes" class="form-control" id="notes" placeholder="Write Notes" >{{ $lender['notes'] ?? '' }}</textarea>
                  </div>
                </div>
              </div>
              <div class="form-group col-md-6">
    
                <label for="exampleInputEmail1">Upload Guidelines:</label> {{ $lender['guideline_file'] ?? '' }}
                <div class="input-group">
                <span class="input-group-text @error('logo') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                <!-- <input type="file"  class="form-select logo" name="logo" id="logo"> -->
                <input type="file" class="form-select" name="guideline" id="guideline" accept="application/pdf">
                </div>
              </div>
              
  <div class="form-group col-md-3">
                            <img id="previewImage" src="#" alt="File Preview" style="display:none; max-width: 80%; max-height: 100px;">  
                            <embed id="previewPDF" src="#" type="application/pdf" style="display:none; max-width: 70%; max-height: 100px;">                           
  </div>
            </div>
            </div>
            </div>


            <div class="box-footer text-end"style="padding-right:0.1rem;">
             <a href="/lenders"  ><button type="button" class="btn btn-warning">
                  <i class="ti-trash"></i> Cancel
                </button></a>

                <a onclick="window.location.reload();"  <button type="button" class="btn btn-danger">
                  <i class="ti-reload"></i> Reset
                </button></a>

                <button  type="submit" name="submit" value="add" class="btn btn-primary">
                  <i class="ti-save-alt"></i> Submit
                </button>
              </div>  
            </form>
                       </div>
                
              </div>
              <!-- /.box-body -->
          
            <!-- /.box -->      
        </div>  
       
      </div>

      <script src="{{asset('assets/js/pages/validation.js')}}"></script>
    <script src="{{asset('assets/js/pages/form-validation.js')}}"></script>

      <script src="https://cdn.jsdelivr.net/npm/imask"></script>
        <script>
    //   var phoneInput = document.getElementById('phone');
    // var phoneMask = new IMask(phoneInput, {
    //     mask: '(000) 000-0000'
    // }); 
     
 
     var phoneInput = document.getElementById('min_credit_score');
    var phoneMask = new IMask(phoneInput, {
        mask: '000'
    });
    var phoneInput = document.getElementById('max_negative_days');
    var phoneMask = new IMask(phoneInput, {
        mask: '00'
    });
    var phoneInput = document.getElementById('nsfs');
    var phoneMask = new IMask(phoneInput, {
        mask: '0000'
    });
    var phoneInput = document.getElementById('min_time_business');
    var phoneMask = new IMask(phoneInput, {
        mask: '00'
    });
    var phoneInput = document.getElementById('max_term');
    var phoneMask = new IMask(phoneInput, {
        mask: '00'
    });
    
    </script>
       <script>
 $(document).ready(function () {
    // Preview image or PDF when a file is selected
    $('#guideline').change(function () {
        var file = this.files[0];
        
        // Check if the file is a PDF
        if (file && file.type !== 'application/pdf') {
            toastr.error('Only PDF files are allowed!');
            this.value = '';  // Clear the input
            return;  // Stop further execution
        }

        readURL(this);
    });

    function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();

            reader.onload = function (e) {
                if (input.files[0].type === 'application/pdf') {
                    // Display PDF preview
                    $('#previewPDF').attr('src', e.target.result).show();
                    $('#previewImage').hide();
                } else {
                    console.log('Unsupported file type');
                }
            };

            reader.readAsDataURL(input.files[0]);
        }
    }
});

</script>
<script>
  // Function to toggle the display of Max MCA Payoff Amount
  function toggleMaxMcaPayoff() {
    var consolidation = document.getElementById('consolidation').value;
    var maxMcaDiv = document.getElementById('max_mca_div');
    
    if (consolidation === 'Yes') {
      maxMcaDiv.style.display = 'block';
    } else {
      maxMcaDiv.style.display = 'none';
    }
  }

  // On page load
  document.addEventListener('DOMContentLoaded', function() {
    toggleMaxMcaPayoff(); // Ensure the correct state on load
  });

  // On change of consolidation select dropdown
  document.getElementById('consolidation').addEventListener('change', function() {
    toggleMaxMcaPayoff();
  });
</script>


<script>
  document.addEventListener("DOMContentLoaded", function () {
    const apiStatus = document.getElementById("api_status");
    const hiddenField = document.getElementById("hiddenField");

    const usernameField = document.getElementById("username_field");
    const passwordField = document.getElementById("password_field");
    const apiKeyField = document.getElementById("api_key_field");
    const urlField = document.getElementById("url_field");
    const api_type_field = document.getElementById("api_type_field");
    const emailField = document.getElementById("email_field");


    apiStatus.addEventListener("change", function () {
      if (this.value === "1") {
        usernameField.style.display = "none";
        passwordField.style.display = "none";
        apiKeyField.style.display = "none";
        urlField.style.display = "none";
        api_type_field.style.display = "block";

        hiddenField.style.display = "none";


      } else {
        usernameField.style.display = "none";
        passwordField.style.display = "none";
        apiKeyField.style.display = "none";
        urlField.style.display = "none";
        api_type_field.style.display = "none";
        emailField.style.display = "none";

        hiddenField.style.display = "block";

      }
    });
  
  });
</script>



<script>
  document.addEventListener("DOMContentLoaded", function () {
    const apiStatus = document.getElementById("lender_api_field");
    const lender_api_type=document.getElementById("lender_api_type");
    const hiddenField = document.getElementById("hiddenField");

    const usernameField = document.getElementById("username_field");
    const passwordField = document.getElementById("password_field");
    const apiKeyField = document.getElementById("api_key_field");
    const urlField = document.getElementById("url_field");
    const api_type_field = document.getElementById("api_type_field");

    const emailField = document.getElementById("email_field");
    const partner_api_key_field=document.getElementById("partner_api_key_field");   
    const client_id=document.getElementById("client_id");
    const auth_url_field=document.getElementById("auth_url_field");
    lender_api_type.addEventListener("change", function () {
      if (this.value === "ondeck") {
        usernameField.style.display = "block";
        passwordField.style.display = "block";
        apiKeyField.style.display = "block";
        urlField.style.display = "block";
        api_type_field.style.display = "block";
        emailField.style.display = "none";

        hiddenField.style.display = "none";


      } 

      else
         if (this.value === "cancapital") {
        usernameField.style.display = "block";
        passwordField.style.display = "block";
        apiKeyField.style.display = "block";
        urlField.style.display = "block";
        api_type_field.style.display = "block";
        emailField.style.display = "block";
        partner_api_key_field.style.display="block";
        client_id.style.display="block";
        auth_url_field.style.display="block";
        hiddenField.style.display = "none";


      }

      else if(this.value === "credibly" || this.value === "specialty" || this.value === "forward_financing") {
        usernameField.style.display = "none";
        passwordField.style.display = "none";
        apiKeyField.style.display = "block";
        urlField.style.display = "block";
        api_type_field.style.display = "block";
        emailField.style.display = "none";

        hiddenField.style.display = "none";

      }
      else if(this.value === "bitty_advance") {
        usernameField.style.display = "none";
        passwordField.style.display = "none";
        apiKeyField.style.display = "block";
        urlField.style.display = "block";
        api_type_field.style.display = "block";
        emailField.style.display = "none";

        hiddenField.style.display = "none";

      }
      else if(this.value === "fox_partner") {
        usernameField.style.display = "block";
        passwordField.style.display = "block";
        apiKeyField.style.display = "none";
        urlField.style.display = "block";
        api_type_field.style.display = "block";
        emailField.style.display = "block";

        hiddenField.style.display = "none";

      }
      else if(this.value === "lendini") {
        usernameField.style.display = "none";
        passwordField.style.display = "none";
        apiKeyField.style.display = "block";
        urlField.style.display = "block";
        api_type_field.style.display = "block";
        emailField.style.display = "none";

        hiddenField.style.display = "none";

      }
    });
  
  });
</script>
@endsection
