@extends('layouts.app')
@section('title', 'Edit Lender')
@section('content')
<section class="content">
<div id="logoErrorAlert" class="alert alert-danger" style="display: none;"></div>
  <div class="row">       
    <div class="col-lg-12 col-12">
      <div class="box">
                              <form method="post">

                                @csrf
          <div class="box-body"><!--bg-lightest-->
            <h4 class="box-title text-info mb-0"><i class="fa fa-edit"></i> Edit Lender Info</h4>
            <a href="{{url('/lenders')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i> Lenders</a>

            <hr class="my-15">
            <div class="row">
              <!-- API Status -->
  <div class="col-md-3"style="display: none;">
    <div class="form-group">
      <label class="form-label">API Status <span style="color: red;">*</span></label>
      <select id="api_status" name="api_status" class="form-control" required>
        <option value="">Select Status</option>
        <option value="1" @if($lender['api_status'] == 1) selected @endif>Yes</option>
        <option value="0" @if($lender['api_status'] == 0) selected @endif>No</option>
      </select>
    </div>
  </div>
  <div class="col-md-3" id="api_type_field" style="display: none;">
    <div class="form-group">
      <label class="form-label">API Type <span style="color: red;">*</span></label>
      <select id="lender_api_type" name="lender_api_type" class="form-control" >
        <option value="">Select</option>
        <option value="ondeck" @if($lender['lender_api_type'] == "ondeck") selected @endif>Ondeck</option>
        <option value="credibly"@if($lender['lender_api_type'] == "credibly") selected @endif>Credibly</option>
        <option value="bitty_advance"@if($lender['lender_api_type'] == "bitty_advance") selected @endif>Bitty Advance</option>
        <option value="fox_partner"@if($lender['lender_api_type'] == "fox_partner") selected @endif>Fox Partner</option>
        <option value="lendini"@if($lender['lender_api_type'] == "lendini") selected @endif>Lendini</option>
         <option value="specialty"@if($lender['lender_api_type'] == "specialty") selected @endif>Specialty</option>
        <option value="forward_financing"@if($lender['lender_api_type'] == "forward_financing") selected @endif>Forward Financing</option>
        <option value="cancapital"@if($lender['lender_api_type'] == "cancapital") selected @endif>CanCapital</option>

      </select>
    </div>
  </div>
  <!-- Username -->
  <div class="col-md-3" id="username_field" style="display: none;">
    <div class="form-group">
      <label class="form-label">Username <span style="color: red;">*</span></label>
      <input
        type="text"
        name="username"
        value="{{ $crm_lender_api['username'] ?? '' }}"
        class="form-control"
        placeholder="Enter Username"
      />
    </div>
  </div>

  <!-- Password -->
  <div class="col-md-3" id="password_field" style="display: none;">
    <div class="form-group">
      <label class="form-label">Password <span style="color: red;">*</span></label>
      <input
        type="password"
        name="password"
        value="{{ $crm_lender_api['password'] ?? '' }}"
        class="form-control"
        placeholder="Enter Password"
      />
    </div>
  </div>

  <!-- API Key -->
  <div class="col-md-3" id="api_key_field" style="display: none;">
    <div class="form-group">
      <label class="form-label">API Key <span style="color: red;">*</span></label>
      <input
        type="text"
        name="api_key"
        value="{{$crm_lender_api['api_key'] ?? '' }}"
        class="form-control"
        placeholder="Enter API Key"
      />
    </div>
  </div>

  <!-- URL -->
  <div class="col-md-3" id="url_field" style="display: none;">
    <div class="form-group">
      <label class="form-label">URL <span style="color: red;">*</span></label>
      <input
        type="url"
        name="url"
        value="{{$crm_lender_api['url'] ?? ''}}"
        class="form-control"
        placeholder="Enter URL"
      />
    </div>
  </div>

 <!-- email -->
 <div class="col-md-3" id="email_field" style="display: none;">
    <div class="form-group">
      <label class="form-label">Sales Rep Email Address <span style="color: red;">*</span></label>
      <input
        type="email"
        name="salesRepEmailAddress"
        value="{{$crm_lender_api['sales_rep_email']  ?? ''}}"
        class="form-control"
        placeholder="Enter Email"
      />
    </div>
  </div>
 <!-- partner API Key -->
 <div class="col-md-3" id="partner_api_key_field" style="display: none;">
    <div class="form-group">
      <label class="form-label">Partner API Key <span style="color: red;">*</span></label>
      <input
        type="text"
        name="partner_api_key"
        value="{{$crm_lender_api['partner_api_key']  ?? ''}}"
        class="form-control"
        placeholder="Enter Partner API Key"
      />
    </div>
  </div>
     <!--Auth URL -->
     <div class="col-md-3" id="client_id" style="display: none;">
    <div class="form-group">
      <label class="form-label">Client id <span style="color: red;">*</span></label>
      <input
        type="text"
        name="client_id"
        value="{{$crm_lender_api['client_id']  ?? ''}}"
        class="form-control"
        placeholder="Enter Client Id"
      />
    </div>
  </div>
    <!--Auth URL -->
    <div class="col-md-3" id="auth_url_field" style="display: none;">
    <div class="form-group">
      <label class="form-label">Auth URL <span style="color: red;">*</span></label>
      <input
        type="url"
        name="auth_url"
        value="{{$crm_lender_api['auth_url']  ?? ''}}"
        class="form-control"
        placeholder="Enter  Auth URL"
      />
    </div>
  </div>


              <div class="col-md-3">
                <div class="form-group @error('lender_name') has-error @enderror">
                  <label class="form-label">Lender Name <span style="color: red;">*</span></label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('first_name') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    

                    <input type="text" name="lender_name" value="{{old('lender_name', $lender['lender_name'])}}" class="form-control" id="lender_name" required placeholder="Enter Lender Name" />
                  </div>
                </div>
              </div>
              <div class="col-md-3"style="display:none;">
                <div class="form-group @error('lender_type') has-error @enderror">
                  <label class="form-label">Lender Type</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('lender_type') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="lender_type">
                    <option value="email"Selected>Email</option>

                  </select>

                  </div>
                </div>
              </div>
              <div class="" id="hiddenField" style="display: none;">
              <div class="row">
              <div class="col-md-3">
                <div class="form-group @error('email') has-error @enderror">
                  <label class="form-label">Lender Email </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                    <input type="email" name="email" value="{{old('email', $lender['email'])}}" class="form-control" id="email" placeholder="Enter Email" />
                  </div>
                </div>
              </div>

              <div class="col-md-3">
                <div class="form-group @error('secondary_email') has-error @enderror">
                  <label class="form-label">Optional Email 1(CC) </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                    <input type="email" name="secondary_email" value="{{old('secondary_email', $lender['secondary_email'])}}"   class="form-control" id="secondary_email" placeholder="Enter Secondary Email" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('secondary_email2') has-error @enderror">
                  <label class="form-label">Optional Email 2</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                    <input type="email" name="secondary_email2" value="{{old('secondary_email2', $lender['secondary_email2'])}}" class="form-control" id="secondary_email2" placeholder="Enter Optional Email 2" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('secondary_email3') has-error @enderror">
                  <label class="form-label">Optional Email 3</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                    <input type="email" name="secondary_email3" value="{{old('secondary_email3',$lender['secondary_email3'])}}" class="form-control" id="secondary_email3" placeholder="Enter Optional Email 3" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('secondary_email3') has-error @enderror">
                  <label class="form-label">Optional Email 4</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                    <input type="email" name="secondary_email4" value="{{old('secondary_email4',$lender['secondary_email4'])}}" class="form-control" id="secondary_email4" placeholder="Enter Optional Email 4" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('phone') has-error @enderror">
                  <label class="form-label">Phone </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('phone') text-danger border-danger @enderror"><i class="fa fa-phone"></i></span>
                    <input name="phone" id="phone" value="{{old('phone', $lender['phone'])}}" type="text" class="form-control" data-inputmask="'mask': '(999) 999-9999'" data-mask="" />
                  </div>
                </div>
              </div>

              <div class="col-md-3">
                <div class="form-group @error('contact_person') has-error @enderror">
                  <label class="form-label">Contact</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('contact_person') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <input type="text" name="contact_person" value="{{old('contact_person', $lender['contact_person'])}}" class="form-control" id="contact_person"  placeholder="Enter Contact" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('min_score') has-error @enderror">
                  <label class="form-label">FICO </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('min_credit_score') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <input type="text" name="min_credit_score" value="{{old('min_credit_score', $lender['min_credit_score'])}}" class="form-control" id="min_credit_score"  placeholder="Enter Credit score" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('max_Negative_days') has-error @enderror">
                  <label class="form-label">Max Negative Days </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('max_negative_days') text-danger border-danger @enderror"><i class="fa fa-calendar"></i></span>
                    <input type="text" name="max_negative_days" value="{{old('max_negative_days', $lender['max_negative_days'])}}" class="form-control" id="max_negative_days"  placeholder="Enter Max Negative days" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('max_advance') has-error @enderror">
                  <label class="form-label">Max Loan Amount </label> 
                  <div class="controls">
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('max_adv') text-danger border-danger @enderror">$</span>
                    <input type="text" name="max_advance"value="{{old('max_advance', $lender['max_advance'])}}" class="form-control"  data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers"placeholder="Enter Max Advance" > 
              
                  </div>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('nsfs') has-error @enderror">
                  <label class="form-label">NSFs</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('max_adv') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <input type="text" name="nsfs" value="{{old('nsfs', $lender['nsfs'])}}" class="form-control" id="nsfs"  placeholder="Enter NSFs" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('min_time_business') has-error @enderror">
                  <label class="form-label"> Time In Business(Months)</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('min_time_business') text-danger border-danger @enderror"><i class="fa fa-calendar"></i></span>
                    <input type="text" name="min_time_business" value="{{old('min_time_business', $lender['min_time_business'])}}" class="form-control" id="min_time_business"  placeholder="Enter  Business Time" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('min_amount') has-error @enderror">
                  <label class="form-label">Min Loan Amount</label> 
                  <div class="controls">
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('min_amount') text-danger border-danger @enderror">$</span>
                    <input type="text" name="min_amount" value="{{old('min_amount', $lender['min_amount'])}}" class="form-control" id="min_amount"  placeholder="Enter Min Amount" data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers"/>
                  </div>
                </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('min_deposits') has-error @enderror">
                  <label class="form-label"> Minimum no of Deposits</label> 
                  <div class="controls">
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('min_amt') text-danger border-danger @enderror"><i class="fa fa-user"></i></span>
                    <input type="text" name="min_deposits" value="{{old('min_deposits', $lender['min_deposits'])}}" class="form-control" id="min_deposits"  placeholder="Enter  Deposits"data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers" />
                  </div>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('min_amount') has-error @enderror">
                  <label class="form-label">Min Monthly Deposit</label> 
                  <div class="controls">
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('min_amount') text-danger border-danger @enderror">$</span>
                    <input type="text" name="min_monthly_deposit" value="{{old('min_monthly_deposit', $lender['min_monthly_deposit'])}}" class="form-control" id="min_monthly_deposit"  placeholder="Enter Min Amount"data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers" //>
                  </div>
                </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('min_amount') has-error @enderror">
                  <label class="form-label">Min Average Revenue</label> 
                  <div class="controls">
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('min_amount') text-danger border-danger @enderror">$</span>
                    <input type="text" name="min_avg_revenue" value="{{old('min_avg_revenue', $lender['min_avg_revenue'])}}" class="form-control" id="min_avg_revenue"  placeholder="Enter Min Average"data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers" />
                  </div>
                </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('max_position') has-error @enderror">
                  <label class="form-label">Positions Offerred</label> 
                  <div class="controls">
                  <div class="input-group mb-3">
                    <!-- <span class="input-group-text @error('max_position') text-danger border-danger @enderror"><i class="ti-user"></i></span> -->
                    <!-- <input type="text" name="max_position" value="{{old('max_position', $lender['max_position'])}}" class="form-control" id="max_position"  placeholder="Enter  Position"data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers" /> -->
                    <!-- <select class="form-select" name="max_position">
                    <option @if($lender['max_position'] == 'minimum')  @endif value="minimum">Minimum Position</option>
                    <option @if($lender['max_position'] == 'maximum')  @endif value="maximum">Maximum Position</option>
                    </select> -->
                    <!-- <select class="form-select select2" name="max_position"> -->
                    <select class="select2 form-control" multiple="multiple" name="max_position[]" autocomplete="off" data-placeholder="Select position">
    <option value="">--Select--</option>
    @php
        $selectedPositions = json_decode($lender['max_position'] ?? '[]', true) ?: [];

    @endphp
    
    @for($i = 1; $i <= 10; $i++)
        <option @if(in_array($i, $selectedPositions)) selected @endif value="{{ $i }}">{{ $i }}</option>
    @endfor
</select>
                  </div>
                </div>
              </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('max_term') has-error @enderror">
                  <label class="form-label">Max Term(months)</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('max_term') text-danger border-danger @enderror"><i class="fa fa-calendar"></i></span>
                    <input type="text" name="max_term" value="{{old('max_term', $lender['max_term'])}}" class="form-control" id="max_term"  placeholder="Enter Max Term" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('daily_balance') has-error @enderror">
                  <label class="form-label"> Average Daily Balance</label> 
                  <div class="controls">
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('daily_balance') text-danger border-danger @enderror">$</span>
                    <input type="text" name="daily_balance" value="{{old('daily_balance', $lender['daily_balance'])}}" class="form-control" id="daily_balance"  placeholder="Enter  Avg Daily Balance"data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers" />
                  </div>
                </div>
              </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('white_label') has-error @enderror">
                  <label class="form-label">White Label</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('white_label') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="white_label">
                    <option  @if($lender['white_label'] == 'Yes')  @endif value="Yes">Yes</option>
                    <option @if($lender['white_label'] == 'No')   @endif value="No">No</option>

                  </select>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('consolidation') has-error @enderror">
                  <label class="form-label">Consolidation</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('consolidation') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="consolidation"id="consolidation">
                    <option @if($lender['consolidation'] == 'Yes')  @endif value="Yes">Yes</option>
                    <option @if($lender['consolidation'] == 'No')  @endif value="No">No</option>

                  </select>
                  </div>
                </div>
              </div>
              <div class="col-md-3"id="max_mca_div" style="display: none;">
                <div class="form-group @error('max_mca_payoff_amount') has-error @enderror">
                  <label class="form-label">Max MCA Payoff Amount</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('max_mca_payoff_amount') text-danger border-danger @enderror">$</span>
                    <input type="text" name="max_mca_payoff_amount" value="{{old('max_mca_payoff_amount', $lender['max_mca_payoff_amount'])}}" class="form-control" id="max_mca_payoff_amount"  placeholder="" data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers"/>

                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('consolidation') has-error @enderror">
                  <label class="form-label">Reverse Consolidation</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('consolidation') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="reverse_consolidation">
                    <option @if($lender['reverse_consolidation'] == '1')  @endif value="1">Yes</option>
                    <option @if($lender['reverse_consolidation'] == '0')  @endif value="0">No</option>

                  </select>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('sole_prop') has-error @enderror">
                  <label class="form-label">Sole Prop</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('sole_prop') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="sole_prop">
                    <option @if($lender['sole_prop'] == 'Yes')  @endif value="Yes">Yes</option>
                    <option  @if($lender['sole_prop'] == 'No')  @endif value="No">No</option>

                  </select>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('home_business') has-error @enderror">
                  <label class="form-label">Home based</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('home_business') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="home_business">
                    <option @if($lender['home_business'] == 'Yes')  @endif value="Yes">Yes</option>
                    <option @if($lender['home_business'] == 'No')  @endif value="No">No</option>

                  </select>                 
                </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('non_profit') has-error @enderror">
                  <label class="form-label">Non Profit</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('non_profit') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="non_profit">
                    <option @if($lender['non_profit'] == 'Yes')  @endif value="Yes">Yes</option>
                    <option @if($lender['non_profit'] == 'No')  @endif value="No">No</option>

                  </select>                    
                </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('non_profit') has-error @enderror">
                  <label class="form-label">Payment Schedule(Daily/Weekly)</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('daily') text-danger border-danger @enderror"><i class="fa fa-calendar"></i></span>
                    <select class="form-select" name="daily">
                    <option @if($lender['daily'] == 'daily')  @endif value="daily">Daily</option>
                    <option  @if($lender['daily'] == 'weekly')  @endif value="weekly">Weekly</option>
                    <option  @if($lender['daily'] == 'all')  @endif value="all">Both</option>

                  </select> 
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('coj_req') has-error @enderror">
                  <label class="form-label">COJ Request</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('coj_req') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="coj_req">
                    <option @if($lender['coj_req'] == 'Yes')  @endif value="Yes">Yes</option>
                    <option @if($lender['coj_req'] == 'No')  @endif value="No">No</option>

                  </select>                    
                </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('bank_verify') has-error @enderror">
                  <label class="form-label">Bank Verification Process</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('bank_verify') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select class="form-select" name="bank_verify">
                    <option @if($lender['bank_verify'] == 'team')  @endif value="team">Team Viewer</option>
                    <option @if($lender['bank_verify'] == 'manual')  @endif value="manual">MANUAL LOGIN</option>

                  </select>                    
                </div>
                </div>
              </div>
        
         
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Address </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="ti-world"></i></span>
                    <input type="text" name="address" value="{{old('address', $lender['address'])}}" class="form-control" id="address" placeholder="Enter Address" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('country') has-error @enderror">
                  <label class="form-label">Country </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('country') text-danger border-danger @enderror"><i class="ti-world"></i></span>
                    <select  class="form-select " name="country" id="country">
                                            <option @if($lender['country']== 'USA') selected @endif  value="USA">USA</option>
                                   
                                                    </select>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">State </label> 
                  <div class="input-group mb-3">
                  <span class="input-group-text @error('country') text-danger border-danger @enderror"><i class="ti-world"></i></span>
                    <select class="form-select" name="state" id="state">
                                                                    <option @if($lender['state'] == 'AL') selected @endif   value="AL">Alabama</option>
                                                                        <option @if($lender['state'] == 'AK') selected @endif   value="AK">Alaska</option>
                                                                        <option @if($lender['state'] == 'AS') selected @endif   value="AS">American Samoa</option>
                                                                        <option @if($lender['state'] == 'AZ') selected @endif   value="AZ">Arizona</option>
                                                                        <option @if($lender['state'] == 'AR') selected @endif   value="AR">Arkansas</option>
                                                                        <option @if($lender['state'] == 'AE-A') selected @endif   value="AE-A">Armed Forces Africa</option>
                                                                        <option @if($lender['state'] == 'AA') selected @endif   value="AA">Armed Forces Americas</option>
                                                                        <option @if($lender['state'] == 'AE-C') selected @endif   value="AE-C">Armed Forces Canada</option>
                                                                        <option @if($lender['state'] == 'AE-E') selected @endif   value="AE-E">Armed Forces Europe</option>
                                                                        <option @if($lender['state'] == 'AE-M') selected @endif   value="AE-M">Armed Forces Middle East</option>
                                                                        <option @if($lender['state'] == 'AP') selected @endif   value="AP">Armed Forces Pacific</option>
                                                                        <option @if($lender['state'] == 'CA') selected @endif   value="CA">California</option>
                                                                        <option @if($lender['state'] == 'CO') selected @endif   value="CO">Colorado</option>
                                                                        <option @if($lender['state'] == 'CT') selected @endif   value="CT">Connecticut</option>
                                                                        <option @if($lender['state'] == 'DE') selected @endif   value="DE">Delaware</option>
                                                                        <option @if($lender['state'] == 'DC') selected @endif   value="DC">District of Columbia</option>
                                                                        <option @if($lender['state'] == 'FM') selected @endif   value="FM">Federated States of Micronesia</option>
                                                                        <option @if($lender['state'] == 'FL') selected @endif   value="FL">Florida</option>
                                                                        <option @if($lender['state'] == 'GA') selected @endif   value="GA">Georgia</option>
                                                                        <option @if($lender['state'] == 'GU') selected @endif   value="GU">Guam</option>
                                                                        <option @if($lender['state'] == 'HI') selected @endif   value="HI">Hawaii</option>
                                                                        <option @if($lender['state'] == 'ID') selected @endif   value="ID">Idaho</option>
                                                                        <option @if($lender['state'] == 'IL') selected @endif   value="IL">Illinois</option>
                                                                        <option @if($lender['state'] == 'IN') selected @endif   value="IN">Indiana</option>
                                                                        <option @if($lender['state'] == 'IA') selected @endif   value="IA">Iowa</option>
                                                                        <option @if($lender['state'] == 'KS') selected @endif   value="KS">Kansas</option>
                                                                        <option @if($lender['state'] == 'KY') selected @endif   value="KY">Kentucky</option>
                                                                        <option @if($lender['state'] == 'LA') selected @endif   value="LA">Louisiana</option>
                                                                        <option @if($lender['state'] == 'ME') selected @endif   value="ME">Maine</option>
                                                                        <option @if($lender['state'] == 'MD') selected @endif   value="MD">Maryland</option>
                                                                        <option @if($lender['state'] == 'MA') selected @endif   value="MA">Massachusetts</option>
                                                                        <option @if($lender['state'] == 'MI') selected @endif   value="MI">Michigan</option>
                                                                        <option @if($lender['state'] == 'MN') selected @endif   value="MN">Minnesota</option>
                                                                        <option @if($lender['state'] == 'MS') selected @endif   value="MS">Mississippi</option>
                                                                        <option @if($lender['state'] == 'MO') selected @endif   value="MO">Missouri</option>
                                                                        <option @if($lender['state'] == 'MT') selected @endif   value="MT">Montana</option>
                                                                        <option @if($lender['state'] == 'NE') selected @endif   value="NE">Nebraska</option>
                                                                        <option @if($lender['state'] == 'NV') selected @endif   value="NV">Nevada</option>
                                                                        <option @if($lender['state'] == 'NH') selected @endif   value="NH">New Hampshire</option>
                                                                        <option @if($lender['state'] == 'NJ') selected @endif   value="NJ">New Jersey</option>
                                                                        <option @if($lender['state'] == 'NM') selected @endif   value="NM">New Mexico</option>
                                                                        <option @if($lender['state'] == 'NY') selected @endif   value="NY">New York</option>
                                                                        <option @if($lender['state'] == 'NC') selected @endif   value="NC">North Carolina</option>
                                                                        <option @if($lender['state'] == 'ND') selected @endif   value="ND">North Dakota</option>
                                                                        <option @if($lender['state'] == 'MP') selected @endif   value="MP">Northern Mariana Islands</option>
                                                                        <option @if($lender['state'] == 'OH') selected @endif   value="OH">Ohio</option>
                                                                        <option @if($lender['state'] == 'OK') selected @endif   value="OK">Oklahoma</option>
                                                                        <option @if($lender['state'] == 'OR') selected @endif   value="OR">Oregon</option>
                                                                        <option @if($lender['state'] == 'PA') selected @endif   value="PA">Pennsylvania</option>
                                                                        <option @if($lender['state'] == 'PR') selected @endif   value="PR">Puerto Rico</option>
                                                                        <option @if($lender['state'] == 'MH') selected @endif   value="MH">Republic of Marshall Islands</option>
                                                                        <option @if($lender['state'] == 'RI') selected @endif   value="RI">Rhode Island</option>
                                                                        <option @if($lender['state'] == 'SC') selected @endif   value="SC">South Carolina</option>
                                                                        <option @if($lender['state'] == 'SD') selected @endif   value="SD">South Dakota</option>
                                                                        <option @if($lender['state'] == 'TN') selected @endif   value="TN">Tennessee</option>
                                                                        <option @if($lender['state'] == 'TX') selected @endif   value="TX">Texas</option>
                                                                        <option @if($lender['state'] == 'UT') selected @endif   value="UT">Utah</option>
                                                                        <option @if($lender['state'] == 'VT') selected @endif   value="VT">Vermont</option>
                                                                        <option @if($lender['state'] == 'VI') selected @endif   value="VI">Virgin Islands of the U.S.</option>
                                                                        <option @if($lender['state'] == 'VA') selected @endif   value="VA">Virginia</option>
                                                                        <option @if($lender['state'] == 'WA') selected @endif   value="WA">Washington</option>
                                                                        <option @if($lender['state'] == 'WV') selected @endif   value="WV">West Virginia</option>
                                                                        <option @if($lender['state'] == 'WI') selected @endif   value="WI">Wisconsin</option>
                                                                        <option @if($lender['state'] == 'WY') selected @endif   value="WY">Wyoming</option>
                                                                </select>
                  </div>
                </div>
              </div>

              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">City </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="ti-world"></i></span>
                    <input type="text" name="city" value="{{old('city', $lender['city'])}}" class="form-control" id="city"  placeholder="Enter City" />
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Factor Rates</label>
                  <div class="input-group mb-3">
                  <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="fa fa-user"></i></span>
                  <input type="text" name="factor_rate" class="form-control" id="factor_rate" placeholder=""value="{{old('factor_rate', $lender['factor_rate'])}}" >
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">LOC</label>
                  <div class="input-group mb-3">
                  <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="fa fa-user"></i></span>
                    <select class="form-select"name="loc">
                      <option @if($lender['loc'] == 'yes') selected @endif value="yes">Yes</option>
                      <option @if($lender['loc'] == 'no') selected @endif value="no">No</option>

</select>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Ownership Percentage</label>
                  <div class="input-group mb-3">
                  <span class="input-group-text @error('ownership_percentage') text-danger border-danger @enderror"><i class="fa fa-user"></i></span>
                  <input type="text" name="ownership_percentage" class="form-control" id="" placeholder=""value="{{old('ownership_percentage', $lender['ownership_percentage'])}}" data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers">
                  </div>
                </div>
              </div>
              @php
    // Decode the JSON string into an array
    $industries = json_decode($lender['industry'] ?? '[]', true) ?: [];
@endphp
    <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Restricted Industry </label> 
                  <div class="input-group mb-3">
                    <select class="select2 form-control"  multiple="multiple" name="industry[]" autocomplete="off" data-placeholder="Select industry"id="industry" >
                    <option value="construction" {{ in_array('construction', $industries) ? 'selected' : '' }}>Construction</option>
                <option value="trucking" {{ in_array('trucking', $industries) ? 'selected' : '' }}>Trucking</option>
                <option value="auto sales" {{ in_array('auto sales', $industries) ? 'selected' : '' }}>Auto Sales</option>
                  </select>    
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Restricted industry Notes </label>
                  <div class="input-group mb-3">
                  <textarea type="text" name="restricted_industry_note" class="form-control" id="notes" placeholder="Write Notes" >{{ $lender['restricted_industry_note'] ?? '' }}</textarea>
                  </div>
                </div>
              </div>
              <!-- <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Prohibited Industry </label>
                  <div class="input-group mb-3">
                  <span class="input-group-text @error('last_name') text-danger border-danger @enderror"><i class="fa fa-user"></i></span>
                  <input type="text" name="prohibited_industry" class="form-control" id="prohibited_industry" placeholder=""value="{{old('prohibited_industry', $lender['prohibited_industry'])}}" >
                  </div>
                </div>
              </div> -->
              @php
    // Decode the JSON string into an array for guideline state
    $state = json_decode($lender['guideline_state'] ?? '[]', true) ?: [];
@endphp
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Restricted State </label>
                  <div class="input-group mb-3">
                    <select class="select2 form-control"  multiple="multiple" name="guideline_state[]" autocomplete="off" data-placeholder="Select state"id="guideline_state" >
                    <option {{ in_array('AL', $state) ? 'selected' : '' }} value="AL">Alabama</option>
<option {{ in_array('AK', $state) ? 'selected' : '' }} value="AK">Alaska</option>
<option {{ in_array('AS', $state) ? 'selected' : '' }} value="AS">American Samoa</option>
<option {{ in_array('AZ', $state) ? 'selected' : '' }} value="AZ">Arizona</option>
<option {{ in_array('AR', $state) ? 'selected' : '' }} value="AR">Arkansas</option>
<option {{ in_array('AE-A', $state) ? 'selected' : '' }} value="AE-A">Armed Forces Africa</option>
<option {{ in_array('AA', $state) ? 'selected' : '' }} value="AA">Armed Forces Americas</option>
<option {{ in_array('AE-C', $state) ? 'selected' : '' }} value="AE-C">Armed Forces Canada</option>
<option {{ in_array('AE-E', $state) ? 'selected' : '' }} value="AE-E">Armed Forces Europe</option>
<option {{ in_array('AE-M', $state) ? 'selected' : '' }} value="AE-M">Armed Forces Middle East</option>
<option {{ in_array('AP', $state) ? 'selected' : '' }} value="AP">Armed Forces Pacific</option>
<option {{ in_array('CA', $state) ? 'selected' : '' }} value="CA">California</option>
<option {{ in_array('CO', $state) ? 'selected' : '' }} value="CO">Colorado</option>
<option {{ in_array('CT', $state) ? 'selected' : '' }} value="CT">Connecticut</option>
<option {{ in_array('DE', $state) ? 'selected' : '' }} value="DE">Delaware</option>
<option {{ in_array('DC', $state) ? 'selected' : '' }} value="DC">District of Columbia</option>
<option {{ in_array('FM', $state) ? 'selected' : '' }} value="FM">Federated States of Micronesia</option>
<option {{ in_array('FL', $state) ? 'selected' : '' }} value="FL">Florida</option>
<option {{ in_array('GA', $state) ? 'selected' : '' }} value="GA">Georgia</option>
<option {{ in_array('GU', $state) ? 'selected' : '' }} value="GU">Guam</option>
<option {{ in_array('HI', $state) ? 'selected' : '' }} value="HI">Hawaii</option>
<option {{ in_array('ID', $state) ? 'selected' : '' }} value="ID">Idaho</option>
<option {{ in_array('IL', $state) ? 'selected' : '' }} value="IL">Illinois</option>
<option {{ in_array('IN', $state) ? 'selected' : '' }} value="IN">Indiana</option>
<option {{ in_array('IA', $state) ? 'selected' : '' }} value="IA">Iowa</option>
<option {{ in_array('KS', $state) ? 'selected' : '' }} value="KS">Kansas</option>
<option {{ in_array('KY', $state) ? 'selected' : '' }} value="KY">Kentucky</option>
<option {{ in_array('LA', $state) ? 'selected' : '' }} value="LA">Louisiana</option>
<option {{ in_array('ME', $state) ? 'selected' : '' }} value="ME">Maine</option>
<option {{ in_array('MD', $state) ? 'selected' : '' }} value="MD">Maryland</option>
<option {{ in_array('MA', $state) ? 'selected' : '' }} value="MA">Massachusetts</option>
<option {{ in_array('MI', $state) ? 'selected' : '' }} value="MI">Michigan</option>
<option {{ in_array('MN', $state) ? 'selected' : '' }} value="MN">Minnesota</option>
<option {{ in_array('MS', $state) ? 'selected' : '' }} value="MS">Mississippi</option>
<option {{ in_array('MO', $state) ? 'selected' : '' }} value="MO">Missouri</option>
<option {{ in_array('MT', $state) ? 'selected' : '' }} value="MT">Montana</option>
<option {{ in_array('NE', $state) ? 'selected' : '' }} value="NE">Nebraska</option>
<option {{ in_array('NV', $state) ? 'selected' : '' }} value="NV">Nevada</option>
<option {{ in_array('NH', $state) ? 'selected' : '' }} value="NH">New Hampshire</option>
<option {{ in_array('NJ', $state) ? 'selected' : '' }} value="NJ">New Jersey</option>
<option {{ in_array('NM', $state) ? 'selected' : '' }} value="NM">New Mexico</option>
<option {{ in_array('NY', $state) ? 'selected' : '' }} value="NY">New York</option>
<option {{ in_array('NC', $state) ? 'selected' : '' }} value="NC">North Carolina</option>
<option {{ in_array('ND', $state) ? 'selected' : '' }} value="ND">North Dakota</option>
<option {{ in_array('MP', $state) ? 'selected' : '' }} value="MP">Northern Mariana Islands</option>
<option {{ in_array('OH', $state) ? 'selected' : '' }} value="OH">Ohio</option>
<option {{ in_array('OK', $state) ? 'selected' : '' }} value="OK">Oklahoma</option>
<option {{ in_array('OR', $state) ? 'selected' : '' }} value="OR">Oregon</option>
<option {{ in_array('PA', $state) ? 'selected' : '' }} value="PA">Pennsylvania</option>
<option {{ in_array('PR', $state) ? 'selected' : '' }} value="PR">Puerto Rico</option>
<option {{ in_array('MH', $state) ? 'selected' : '' }} value="MH">Republic of Marshall Islands</option>
<option {{ in_array('RI', $state) ? 'selected' : '' }} value="RI">Rhode Island</option>
<option {{ in_array('SC', $state) ? 'selected' : '' }} value="SC">South Carolina</option>
<option {{ in_array('SD', $state) ? 'selected' : '' }} value="SD">South Dakota</option>
<option {{ in_array('TN', $state) ? 'selected' : '' }} value="TN">Tennessee</option>
<option {{ in_array('TX', $state) ? 'selected' : '' }} value="TX">Texas</option>
<option {{ in_array('UT', $state) ? 'selected' : '' }} value="UT">Utah</option>
<option {{ in_array('VT', $state) ? 'selected' : '' }} value="VT">Vermont</option>
<option {{ in_array('VI', $state) ? 'selected' : '' }} value="VI">Virgin Islands of the U.S.</option>
<option {{ in_array('VA', $state) ? 'selected' : '' }} value="VA">Virginia</option>
<option {{ in_array('WA', $state) ? 'selected' : '' }} value="WA">Washington</option>
<option {{ in_array('WV', $state) ? 'selected' : '' }} value="WV">West Virginia</option>
<option {{ in_array('WI', $state) ? 'selected' : '' }} value="WI">Wisconsin</option>
<option {{ in_array('WY', $state) ? 'selected' : '' }} value="WY">Wyoming</option>

                  </select>                   
                </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Restriced state Notes </label>
                  <div class="input-group mb-3">
                  <textarea type="text" name="restricted_state_note" class="form-control" id="notes" placeholder="Write Notes" >{{ $lender['restricted_state_note'] ?? '' }}</textarea>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('last_name') has-error @enderror">
                  <label class="form-label">Lender Notes </label>
                  <div class="input-group mb-3">
                  <textarea type="text" name="notes" class="form-control" id="notes" placeholder="Write Notes" >{{ $lender['notes'] ?? '' }}</textarea>
                  </div>
                </div>
              </div>
              <div class="form-group col-md-6">
    <label for="exampleInputEmail1">Upload Guidelines:</label> {{ $lender['guideline_file'] ?? '' }}
    <div class="input-group">
    <span class="input-group-text @error('logo') text-danger border-danger @enderror"><i class="ti-user"></i></span>
    <!-- <input type="file"  class="form-select logo" name="logo" id="logo"> -->
    <input type="file" class="form-select" name="guideline" id="guideline" accept="application/pdf">
    </div>
    </div>
   
  <div class="form-group col-md-3">
                            <img id="previewImage" src="#" alt="File Preview" style="display:none; max-width: 80%; max-height: 100px;">  
                            <embed id="previewPDF" src="#" type="application/pdf" style="display:none; max-width: 70%; max-height: 100px;">                           
  </div>
             <!-- Display existing PDF if available -->
<!-- @if(isset($lender['guideline_file']) && pathinfo($lender['guideline_file'], PATHINFO_EXTENSION) === 'pdf')
    <div class="form-group col-md-3">
        <embed src="{{ asset($lender['guideline_file']) }}" type="application/pdf" style="max-width: 70%; max-height: 100px;">
    </div>
@endif -->
</div>
</div>
              <div class="box-footer text-end"style="padding-right:0.1rem;">
                  <a href="/lenders"  ><button type="button" class="btn btn-warning">
                      <i class="ti-trash"></i> Cancel
                    </button></a>

                    <a onclick="window.location.reload();"> <button type="button" class="btn btn-danger">
                      <i class="ti-reload"></i> Reset
                    </button></a>

                    <button  type="submit" name="submit" value="add" class="btn btn-primary">
                      <i class="ti-save-alt"></i> Submit
                    </button>
                  </div>  
                </form>
              </div>
           
              </div>
              <!-- /.box-body -->
          
            <!-- /.box -->      
            </div>  
       
          </div>
          </div>
</section>
<script src="{{asset('assets/js/pages/validation.js')}}"></script>
    <script src="{{asset('assets/js/pages/form-validation.js')}}"></script>
        <script src="https://cdn.jsdelivr.net/npm/imask"></script>
        <script>
    //   var phoneInput = document.getElementById('phone');
    // var phoneMask = new IMask(phoneInput, {
    //     mask: '(000) 000-0000'
    // }); 
     
 
     var phoneInput = document.getElementById('min_credit_score');
    var phoneMask = new IMask(phoneInput, {
        mask: '000'
    });
    var phoneInput = document.getElementById('max_negative_days');
    var phoneMask = new IMask(phoneInput, {
        mask: '00'
    });
    var phoneInput = document.getElementById('nsfs');
    var phoneMask = new IMask(phoneInput, {
        mask: '0000'
    });
    var phoneInput = document.getElementById('min_time_business');
    var phoneMask = new IMask(phoneInput, {
        mask: '00'
    });
    var phoneInput = document.getElementById('max_term');
    var phoneMask = new IMask(phoneInput, {
        mask: '000'
    });
    
    </script>
    <script>
 $(document).ready(function () {
    // Preview image or PDF when a file is selected
    $('#guideline').change(function () {
        var file = this.files[0];
        
        // Check if the file is a PDF
        if (file && file.type !== 'application/pdf') {
            toastr.error('Only PDF files are allowed!');
            this.value = '';  // Clear the input
            return;  // Stop further execution
        }

        readURL(this);
    });

    function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();

            reader.onload = function (e) {
                if (input.files[0].type === 'application/pdf') {
                    // Display PDF preview
                    $('#previewPDF').attr('src', e.target.result).show();
                    $('#previewImage').hide();
                } else {
                    console.log('Unsupported file type');
                }
            };

            reader.readAsDataURL(input.files[0]);
        }
    }
});

</script>
<script>
  // Function to toggle the display of Max MCA Payoff Amount
  function toggleMaxMcaPayoff() {
    var consolidation = document.getElementById('consolidation').value;
    var maxMcaDiv = document.getElementById('max_mca_div');
    
    if (consolidation === 'Yes') {
      maxMcaDiv.style.display = 'block';
    } else {
      maxMcaDiv.style.display = 'none';
    }
  }

  // On page load
  document.addEventListener('DOMContentLoaded', function() {
    toggleMaxMcaPayoff(); // Ensure the correct state on load
  });

  // On change of consolidation select dropdown
  document.getElementById('consolidation').addEventListener('change', function() {
    toggleMaxMcaPayoff();
  });
</script>
<script>
 document.addEventListener("DOMContentLoaded", function () {
  const apiStatus = document.getElementById("api_status");
  const hiddenField = document.getElementById("hiddenField");

  const usernameField = document.getElementById("username_field");
  const passwordField = document.getElementById("password_field");
  const apiKeyField = document.getElementById("api_key_field");
  const urlField = document.getElementById("url_field");
  const apiTypeField = document.getElementById("api_type_field");
  const emailField = document.getElementById("email_field");

  // Function to update the visibility of fields
  function updateFieldVisibility() {
    if (apiStatus.value === "1") {
      usernameField.style.display = "none";
      passwordField.style.display = "none";
      apiKeyField.style.display = "none";
      urlField.style.display = "none";
      apiTypeField.style.display = "none";

      hiddenField.style.display = "none";
    } else {
      usernameField.style.display = "none";
      passwordField.style.display = "none";
      apiKeyField.style.display = "none";
      urlField.style.display = "none";
      apiTypeField.style.display = "none";
      emailField.style.display = "none";

      hiddenField.style.display = "block";
    }
  }

  // Initial check to apply visibility rules on page load
  updateFieldVisibility();

  // Update visibility on change event
  apiStatus.addEventListener("change", updateFieldVisibility);
});

</script>



<script>
document.addEventListener("DOMContentLoaded", function () {
  const apiStatus = document.getElementById("api_status");
  const lenderApiType = document.getElementById("lender_api_type");
  const hiddenField = document.getElementById("hiddenField");

  const usernameField = document.getElementById("username_field");
  const passwordField = document.getElementById("password_field");
  const apiKeyField = document.getElementById("api_key_field");
  const urlField = document.getElementById("url_field");
  const apiTypeField = document.getElementById("api_type_field");

  const emailField = document.getElementById("email_field");
  const partner_api_key_field=document.getElementById("partner_api_key_field");   
    const client_id=document.getElementById("client_id");
    const auth_url_field=document.getElementById("auth_url_field");

  // Function to update visibility based on lender API type
  function updateFieldVisibility1() {
    const value = lenderApiType.value;
// alert(value);
    if (value === "ondeck") {
      usernameField.style.display = "block";
      passwordField.style.display = "block";
      apiKeyField.style.display = "block";
      urlField.style.display = "block";
      apiTypeField.style.display = "none";
      emailField.style.display = "none";

      hiddenField.style.display = "none";
    } else if (value === "credibly" || value === "specialty"  || value === "forward_financing") {
      usernameField.style.display = "none";
      passwordField.style.display = "none";
      apiKeyField.style.display = "block";
      urlField.style.display = "block";
      apiTypeField.style.display = "none";
      emailField.style.display = "none";

      hiddenField.style.display = "none";
    } else if (value === "bitty_advance") {
      usernameField.style.display = "none";
      passwordField.style.display = "none";
      apiKeyField.style.display = "block";
      urlField.style.display = "block";
      apiTypeField.style.display = "none";
      emailField.style.display = "none";

      hiddenField.style.display = "none";
    } else if (value === "fox_partner") {
      usernameField.style.display = "block";
      passwordField.style.display = "block";
      apiKeyField.style.display = "none";
      urlField.style.display = "block";
      apiTypeField.style.display = "none";
      emailField.style.display = "block";

      hiddenField.style.display = "none";
    } else if (value === "lendini") {
      usernameField.style.display = "none";
      passwordField.style.display = "none";
      apiKeyField.style.display = "block";
      urlField.style.display = "block";
      apiTypeField.style.display = "none";
      emailField.style.display = "none";

      hiddenField.style.display = "none";
    }
    else if (value === "cancapital") {
      usernameField.style.display = "block";
        passwordField.style.display = "block";
        apiKeyField.style.display = "block";
        urlField.style.display = "block";
        api_type_field.style.display = "block";
        emailField.style.display = "block";
        partner_api_key_field.style.display = "block";
        client_id.style.display = "block";
        auth_url_field.style.display = "block";
        hiddenField.style.display = "none";

    }
  }

  // Apply visibility logic on page load
  updateFieldVisibility1();

  // Update visibility on dropdown change
  lenderApiType.addEventListener("change", updateFieldVisibility1);
});

</script>
@endsection
