<div class="row g-3">
    @php
        $fields = [
            ['Lender Name', $list['lender_name'], 'ti-user', 'primary'],
            ['Lender Email', $list['email'], 'ti-email', 'primary'],
            ['Optional Email', $list['secondary_email'], 'ti-email', 'primary'],
            ['Phone', $list['phone'], 'ti-mobile', 'primary'],
            ['Contact Person', $list['contact_person'], 'ti-user', 'primary'],
            ['Min Credit Score', $list['min_credit_score'], 'ti-bar-chart', 'primary'],
            ['Max Negative Days', $list['max_negative_days'], 'ti-timer', 'primary'],
            ['Max Advance', $list['max_advance'], 'ti-wallet', 'primary'],
            ['NSFs', $list['nsfs'], 'ti-reload', 'primary'],
            ['CoJ Request', $list['coj_req'], 'ti-check-box', 'primary'],
            ['Bank Verification Process', $list['bank_verify'], 'ti-lock', $list['bank_verify'] == 'manual' ? 'danger' : 'success'],
            ['Address', $list['address'], 'ti-location-pin', 'primary'],
            ['Min Time In Business(Months)', $list['min_time_business'], 'ti-briefcase', 'primary'],
            ['Min Amount', $list['min_amount'], 'ti-money', 'primary'],
            ['Min Deposits', $list['min_deposits'], 'ti-import', 'primary'],
            ['Max Position', $list['max_position'], 'ti-layers', 'primary'],
            ['Max Term(Months)', $list['max_term'], 'ti-timer', 'primary'],
            ['Min Average Daily Balance', $list['daily_balance'], 'ti-stats-up', 'primary'],
            ['White Label', $list['white_label'], 'ti-bookmark-alt', 'primary'],
            ['Consolidation', $list['consolidation'], 'ti-layout-grid2', 'primary'],
            ['Sole Prop', $list['sole_prop'], 'ti-user', 'primary'],
            ['Home based Business', $list['home_business'], 'ti-home', 'primary'],
            ['Non Profit', $list['non_profit'], 'ti-face-smile', 'primary'],
            ['Payment Schedule', $list['daily'], 'ti-calendar',
                $list['daily'] == 'daily' ? 'danger' : ($list['daily'] == 'weekly' ? 'success' : 'secondary')],
        ];
    @endphp

    @foreach ($fields as [$label, $value, $icon, $badgeColor])
        <div class="col-md-4 col-sm-6">
            <div class="d-flex align-items-start gap-2 mb-2">
                <i class="{{ $icon }} fs-5" style="color: black;"></i>
                <div>
                    <label class="form-label mb-1" style="color: black; font-weight: normal;">{{ $label }}</label>
                    <p class="mb-0"><span class="badge badge-sm badge-{{ $badgeColor }}">{{ ucfirst($value) ?: 'NA' }}</span></p>
                </div>
            </div>
        </div>
    @endforeach
</div>
