@extends('layouts.app')
@section('title', 'Lenders List')

@section('content')
   <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<style>
  .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
  </style>
<style>
       .extension-item {
        display: inline-block;
        margin-right: 5px; /* Adjust the margin as needed */
    }
    * {
  user-select: none;
  -webkit-tap-highlight-color: transparent;
}

.switch {
  transform: scale(0.5); /* Adjust the scale value as needed to reduce the size */
}
/* Style for the active state */
.btn-toggle.active {
    background-color: #2196f3; /* Set to the desired green color */
    color: white; /* Set to the desired text color */
    border-color: green; /* Set to the desired border color */
}

/* Style for the inactive state */
.btn-toggle:not(.active) {
    background-color: red; /* Set to the desired red color */
    color: white; /* Set to the desired text color */
    border-color: red; /* Set to the desired border color */
}

.button-row {
  display: flex;
  flex-wrap: wrap;   /* mobile pe line break ho sake */
  gap: 10px;         /* buttons ke beech ka gap */
  justify-content: flex-end; /* right side pe aligned */
}

.button-row a {
  white-space: nowrap; /* text break na ho */
}


    </style>
<!-- Main content -->
        <section class="content">

      <div class="row">

       
        
        <div class="col-12">
          <div class="box">
            <div class="box-body">   
              <div class="d-flex flex-wrap justify-content-between align-items-center">
    <!-- Left Side Title -->
    <h4 class="box-title text-info mb-0">
        <i class="icon-Add-user"><span class="path1"></span><span class="path2"></span></i> 
        Lenders
    </h4>

    <!-- Right Side Buttons -->
    <div class="button-row">
        @if(Session::get('level') > 5)
            <a href="{{url('/lender')}}/add" 
               class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-2">
               <i class="fa fa-plus"></i> Add Lender
            </a>
        @endif

        @if(Session::get('role') === 'admin' || Session::get('role') === 'super_admin' || Session::get('role') === 'system_administrator')
            <a href="{{ url('lenders?download=excel') }}" 
               class="waves-effect waves-light btn btn-rounded btn-warning btn-bitbucket btn-sm mb-2">
               <i class="fa fa-file-text"></i> Excel
            </a>
        @endif

        <a href="{{url('lender/master-sheet')}}" 
           class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-2">
           <i class="fa fa-eye"></i> Master Lender Sheet
        </a>
    </div>
</div>

         
    <!-- <div class="d-flex justify-content-between align-items-center">
        <h4 class="box-title text-info mb-0"><i class="icon-Add-user"><span class="path1"></span><span class="path2"></span></i> Lenders</h4>

  <div>
        @if(Session::get('level') > 5)
         
                <a href="{{url('/lender')}}/add" type="button"style="margin-right:10px;" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-plus"></i> Add Lender</a>
              
         
        @endif
        @if(Session::get('role') === 'admin' || Session::get('role') === 'super_admin' || Session::get('role') === 'system_administrator')
              <a href="{{ url('lenders?download=excel') }}" type="button"style="float:right;"  class="waves-effect waves-light btn btn-rounded btn-warning btn-bitbucket btn-sm mb-5"><i class="fa fa-file-text"></i> Excel</a>
              @endif
              <a href="{{url('lender/master-sheet')}}" type="button"style="margin-right:10px;" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye"></i> Master Lender Sheet</a>

    </div>
    
    </div> -->
<hr class="my-15">
              <div class="table-responsive">
                <table id="tickets1" class="table mt-0 table-hover no-wrap" data-page-size="10">
                  <thead>
                            <tr>
                              <th>#</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Secondary Email</th>

                    <th>Contact Person</th>
                    <th>Status</th>
                    <th>Action</th>

                            </tr>
                  </thead>
                 <tbody>

   </tbody>
                </table>
              </div>
<style>
.modal-dialog.modal-fit {
  display: inline-block;
  width: auto;         
  max-width: 50vw;    
}

.modal-content {
  display: inline-block;
}

</style>
          <!-- Replace id="myModal" with this -->
<div class="modal fade" id="lenderModal"  tabindex="-1"  aria-labelledby="lenderModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title fw-semibold" id="myModalLabel"><i class="icon-Add-user"><span class="path1"></span><span class="path2"></span></i> Lender Details</h4>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
  <div class="modal-body mb-2" id="lenderModalBody">
    <!-- We'll load the form here dynamically -->
  </div>
</div>
  </div>
</div>    

<script>
$(document).on('click', '.view-lender', function () {
    var lenderId = $(this).data('id');
      //alert(extensionId);
            $("#lenderModal").modal('show');

    $.ajax({
        url: '/lender/' + lenderId + '/modal',
        type: 'GET',
        success: function (response) {
                $('#lenderModalBody').html(response);


        },
        error: function () {
            alert('Could not load lender details.');
        }
    });
});
</script>

<style>
  /* .modal-dialog.modal-lg {
    max-width: 700px;
  } */

  .modal-content {
    border-radius: 1rem !important;
    box-shadow: 0 6px 18px rgba(0, 0, 0, 0.15);
    border: none;
    background-color: #ffffff;
  }

  .modal-body {
    padding: 2rem;
  }

  .text-muted {
    font-size: 0.85rem;
  }

  .fw-bold {
    font-size: 1rem;
  }

  .ti {
    font-size: 1.2rem;
  }

  @media (max-width: 768px) {
    .col-md-4 {
      flex: 0 0 100%;
      max-width: 100%;
    }
  }
</style>






            
             
            </div>
          </div>
        </div>
      </div>

    </section>

  <script>
$(document).ready(function(){
    $('#tickets1').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ url('lenders') }}", // replace with your route
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex' },
            { data: 'name', name: 'name' },
            { data: 'email', name: 'email' },
             { data: 'secondary_email', name: 'secondary_email' },

            { data: 'contact_person', name: 'contact_person' },
            { data: 'status', name: 'status' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ],
language: {
    processing: `
        <span style="display:flex; align-items:center; justify-content:center; gap:8px;">
            <img src="https://i.gifer.com/ZZ5H.gif"
                 alt="Loading..." style="width:20px; height:20px;">
            Processing...
        </span>
    `
}
    });
});
</script>

<script>
$(function()
{
    $("#tickets1").on("click", ".btn-toggle", function ()
    {
       console.log('hi');
      var status = $(this).hasClass('active') ? 1 : 0;
        var lender_id = $(this).data('id');    



                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: '/changeLenderStatus/' + lender_id + '/' + status,
                    success: function (data) {
                        if (data.status == 'true') {
                            $('#loading').show();
                            console.log(data.success);
                            window.location.reload(1);
                        } else {

                        }

                    }
                });
    })
})
</script>

   


@endsection
