@extends('layouts.app')
@section('title', 'Add Recycle Rule')
@section('content')


<section class="content">
  <div class="row">       
    <div class="col-lg-12 col-12">
      <div class="box">
      <form method="post" action="">
        @csrf
          <div class="box-body"><!--bg-lightest-->
          
         
            <h4 class="box-title text-info mb-0"><i class="ti-user me-15"></i> Add Recycle Rule</h4>
            <a href="{{url('/recycle-rule')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i> Show Recycle Rule</a>

            <hr class="my-15">
            <div class="row">
              <div class="col-md-6">
                <div class="form-group @error('name') has-error @enderror">
                  <label class="form-label">Campaign</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('name') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select name="campaign_id" class="form-select" id="campaign" required="">                                
                                <?php foreach ($campaign_list as $key=>$value){
                                    if(!empty($value->title) & ($value->status==1)){?>
                                    <option value="<?php echo $value->id;?>"><?php echo $value->title;?></option>

                                <?php } }?>
                    </select>                  
                </div>
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">List</label> 
                  <div class="input-group mb-3">
                  <select name="list_id" class="form-select" id="list-rule" required="">
                                <option value="">Select Lists</option>
                                <?php foreach ($list_details as $key=>$value){?>
                                                        <option value="<?php echo $value->list_id;?>"><?php echo $value->list;?></option>
                                                    <?php }?>

                            </select>
                  </div>
                </div>
              </div>
            </div>

            <div class="row"> 
              <div class="col-md-6">
                <div class="form-group @error('dial_mode') has-error @enderror">
                  <label class="form-label">Disposition</label>
                  <div class="input-group mb-3">
                    <select class="select2 form-select" multiple="multiple" name="disposition_id[]" autocomplete="off" data-placeholder="Select Disposition" style="width: 100%;">
                           
                           <option value="">select disposition</option>
                                               <?php foreach ($disposition_list as $key=>$value){?>
                                                   <option value="<?php echo $value->id;?>"><?php echo $value->title;?></option>
                                               <?php }?>
                       </select>
                  </div>
                </div>
              </div>
              <div class="col-md-6"id="show_predictive">
                <div class="form-group @error('dial_mode') has-error @enderror">
                  <label class="form-label">Time</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('dial_mode') text-danger border-danger @enderror"><i class="fa fa-clock"></i></span>
                    <input type="time" class="form-control" value="09:30" name="time" id="timepicker">

                  </div>
                </div>
              </div>
               
              <div class="col-md-6">
                <div class="form-group @error('status') has-error @enderror">
                  <label class="form-label">Day</label>
                  <div class="input-group mb-3 ">
                  <select class="select2 form-select" multiple="multiple" name="days[]" autocomplete="off" data-placeholder="Select Days" style="width: 100%;">
                                                
                                                <option value="sunday">Sunday</option>
                                                <option value="monday">Monday</option>
                                                <option value="tuesday">Tuesday</option>
                                                <option value="wednesday">Wednesday</option>
                                                <option value="thursday">Thursday</option>
                                                <option value="friday">Friday</option>
                                                <option value="saturday">Saturday</option>
                                            </select>
                  </div>
                </div>
              </div>
            

           
              <div class="col-md-6">
                <div class="form-group @error('duration') has-error @enderror">
                  <label class="form-label">Call Time</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('duration') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                    <select name="call_time" class="form-select" id="calltime-rule" required="">
                            <option value="1">1</option>
                            <option value="2"> less than or equal to 2</option>
                            <option value="3"> less than or equal to 3</option>
                            <option value="4">less than or equal to 4</option>
                            <option value="5">less than or equal to 5</option>
                            <option value="6">less than or equal to 6</option>
                            <option value="7">less than or equal to 7</option>
                            <option value="8">less than or equal to 8</option>
                            <option value="9">less than or equal to 9</option>
                            <option value="10">less than or equal to 10</option>
                            <option value="11">less than or equal to 11</option>
                            <option value="12">less than or equal to 12</option>
                            <option value="13">less than or equal to 13</option>
                            <option value="14">less than or equal to 14</option>
                            <option value="15">less than or equal to 15</option>
                        </select>
                  </div>
                </div>
              </div>


      <!-- /.row -->
     <!-- /.box-body -->
     
     <div class="box-footer text-end">

              
                <button type="submit" name ="submit" value="add" class="btn btn-primary">
                  <i class="ti-save-alt"></i> Save
                </button>
              </div>  
            </form>
            </div>
            <!-- /.box -->      
        </div>  
                                               </div>
    </section>


 


@endsection
