@extends('layouts.app')
@section('title', 'List')

@section('content')


<style>
        .wrap
        {
            white-space: pre-wrap;      /* CSS3 */   
            white-space: -moz-pre-wrap; /* Firefox */    
            white-space: -pre-wrap;     /* Opera <7 */   
            white-space: -o-pre-wrap;   /* Opera 7 */    
            word-wrap: break-word;      /* IE */
        }
    </style>
<section class="content">
  <div class="row">       
    <div class="col-12">
      <div class="box">
                 
        <div class="box-body"><!--bg-lightest-->
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Configure List</h4>
              <a href="{{ url('/list') }}" type="submit" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye"></i>Show List</a>
         <hr class="my-15">    
           
      <form id="formSubmit"class="form-inline" method="post" action="">
          @csrf
          <input type="hidden" name="list_id" value="{{$lists->list_id}}" />
          <input type="hidden" name="campaign_id" value="{{$lists->campaign_id}}" />


          


          
            <div class="row">
              <div class="col-md-3">
                <div class="form-group @error('name') has-error @enderror">
                  <label class="form-label">Title</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('name') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <input type="" class="form-control"  value="{{$lists->list}}" id="name"  name="title" >
                </div>
                </div>
              </div>

           
              <div class="col-md-3">
                <div class="form-group @error('list_id') has-error @enderror">
                  <label class="form-label">Campaign</label>
                  <div class="input-group mb-3">
                    <select class="form-select select2"  name="new_campaign_id" autocomplete="off" data-placeholder="Select Campaign">
                            @foreach($campaign_list as $key => $campaign)
                            @if($campaign->status == 1)
                                <option @if($lists->campaign_id == $campaign->id) selected @endif value="{{$campaign->id}}">{{$campaign->title}}</option>
                            @endif
                            @endforeach;
                            </select>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('list_id') has-error @enderror">
                  <label class="form-label"></label>
                  <div class="input-group mb-3">
                    <button type="submit" name="submit" value="edit" class="btn btn-primary btn-sm"style="margin-top:10px;">
                  <i class="ti-save-alt"></i> Save
                </button>
                  </div>
                </div>
              </div> 
    
      </div>
      <!-- /.row -->
     <!-- /.box-body -->
   
            <!-- /.box -->      
        </div>  

  

      <div class="row">    
        <div class="col-12">
          <div class="box">
           <div class="box-body">           
              <div class="table-responsive">
                <table  class="table mt-0 table-hover no-wrap">
                  <thead>
                    <tr>
                              <th>#</th>
                              <th>File Header</th>
                              <th>Search Filter</th>
                              <th>Dialing Column</th>
                              <th>Visible</th>
                              <th>Editable</th>                             
                              <th>Label</th>

                            </tr>
                  </thead>
                  <tbody>
                                    @php
                                    $i=0;
                                    @endphp
                                    @foreach ($lists->list_header as $key => $value)
                                <tr>
                                  <th scope="row">{{$i}}</th>
                                    <td>
                                      <input type="hidden" name="id[]" value="<?php echo $value->id; ?>"/><?php echo $value->header; ?>
                                                    <input type="hidden" name="column_name[{{$i}}]" value="<?php echo $value->column_name; ?>"/>
                                    </td>
                                  <td>

                                    
                                    <input type="checkbox"class="filled-in" id="basic_checkbox1_{{$i}}"name="is_search[{{$i}}]" value="1" @if($value->is_search == '1') checked  @endif />
						                        <label for="basic_checkbox1_{{$i}}"></label>
                                    
                                 </td>
                                                            
                                     <td>  <input style="opacity: unset;position: unset;width: 18px;height: 18px;" type="radio" id="radio_{{$i}}" required  title="Please select an option" @if($value->is_dialing == '1')  checked  @endif name="is_dialing"  value="{{$value->id}}"/>
                                    <!-- <label for="radio_{{$i}}"></label> -->
                                    </td>
                                    <td><input class="filled-in"type="checkbox" id="basic_checkbox2_{{$i}}" name="is_visible[{{$i}}]"value="1"  @if($value->is_visible == '1')  checked  @endif  />
                                    <label for="basic_checkbox2_{{$i}}"></label></td>                                 
                                    <td><input  class="filled-in"type="checkbox" id="basic_checkbox3_{{$i}}" name="is_editable[{{$i}}]" value="1" @if($value->is_editable == '1')  checked  @endif  />
                                    <label for="basic_checkbox3_{{$i}}"></label>
                                   </td>
                                   <!-- <?php var_dump($value->is_editable); ?> -->
                                    <td>               <select name="label_id[]"
                                                            class="form-select" >
                                                        <option value="">Select Label</option>

                                                        <?php foreach ($label as $listKey => $listValue) { ?>
                                                            <option @if($value->label_id == $listValue->id) selected @endif  value="<?php echo $listValue->id; ?>"><?php echo $listValue->title; ?></option>
                                                        <?php } ?>

                                                    </select></td>
                                
                                  
                             
                                </tr>
                                @php
                                    $i++;
                                @endphp
  
                            @endforeach

                         
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
 
</div>
      </div>
      <!-- /.row -->
      </form>
    </section>
        <!-- /.content -->

        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

 

       

@endsection
