@extends('layouts.app')
@section('title', 'lead Activity')
@section('content')

@php
    $email="";
    if(!empty($smtp->from_email))
    {
        $from_email = $smtp->from_email;
    }
    else
    {
        $from_email = "";
    }
@endphp
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">

<style>
    .callLeadHide {
  cursor:no-drop;
}
#myTab {
    position: sticky;
    top: 0;
    left: 0;
    width: 100%;
    z-index: 1000; /* Adjust the z-index as needed */
    background-color: #fff; /* Add a background color if desired */
    box-shadow: 0px 2px 5px rgba(0, 0, 0, 0.1); /* Add a box shadow for styling */
}
</style>
<style>
.spacing {
    padding-top: 7px;
    padding-bottom: 7px;
}

#count_word{
    margin-right: 6px;
    color: blue;
    font-weight: bold;
}
.count_sms_len{
    float: left;
    width: 164px;
    height: 25px;
    text-align: center;
    font-weight: bold;
    font-size: 15px;
    }

    #heading_sms{
        width: 100%;
    background-color: #3c8dbc;
    height: 31px;
    line-height: 28px;
    text-align: center;
    font-weight: bold;
    color: #ffffff;
    }
    .close{
        display:none;
    }

    .sms_popup_send{
    display: none;
    visibility: hidden;
    height: 30px;
    margin-bottom: 10px;
    text-align: center;
    line-height: 27px;
    font-weight: bold;
    }
    .err_sms{
         width: 100%;
    text-align: center;
    font-size: 17px;
    font-weight: bold;
    color: red;
    }
</style>

<section class="content"style="min-height:80px;">
  <div class="row">       
    <div class="col-12">
        <div class="box"style="margin-bottom:10px;">
            <div class="box-body"style="padding-bottom:1px;"><!--bg-lightest-->          
                       
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Lead Activity</h4>            
          <hr class="my-15">
            <form class="form-inline" method="post">
             @csrf                   
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group @error('name') has-error @enderror">                 
                                <div class="input-group">
                                <input type="" id="phone_number" name="phone_number" value="{{(isset($_GET['phone_number']) ? $_GET['phone_number'] : '' )}}" class="form-control"  placeholder="(___) ___-____" required/>
                                </div>
                            </div>
                        </div>       
                        <div class="col-md-3">
                                                <div class="form-group">
                                                    <div class="row text-danger text-center" id="form_error">
                                                        @if(!empty($message))
                                                        {{ $message }}
                                                        @endif
                                                    </div>
                                                    <button type="button" id="search_lead" class="btn btn-success btn-sm" value="Search">Search</button>

                                                </div>
                        </div> 
                
                    </div>                
                </div>  
            </form>
        </div>
    </div>
  </div>
@if(!empty($updateData))

    <div class="row">
    <div class="col-xl-5 col-lg-6 col-12"style="padding-right:1px;">
              <div class="box box-widget widget-user-2">
                <div class="widget-user-header bg-primary d-flex align-items-center"style="padding:5px 10px 5px 20px;">
                
                  <i class='fas fa-user-plus'style="font-size:20px;"></i> <h6 class="widget-user-username"style="margin-left:10px;padding:0px;font-size:20px;">@foreach($leadDataArr as $lead)
                                            @if($lead['title'] == 'First Name')
                                                {{$lead['value']}}
                                            @endif
                                            @if($lead['title'] == 'Last Name')
                                                &nbsp;{{$lead['value']}}
                                            @endif
                                        @endforeach </h6>
                                        @if(!empty($leadDataArr))
                                        @foreach($leadDataArr as $lead)
                                        @if(stristr($lead['title'], 'mail') && $lead['value'] != '')
                                        @php
                                        @$email = $lead['value'];
                                        @endphp
                                            <span style="font-size:15px;display:none;"id="userEmail"><i class='fa fa-envelope'></i> {{$lead['value']}}</span>
                                        @endif
                                    @endforeach
                                <div style="margin-left:30px;">

                                    <a class="btn btn-primary btn-sm"  href='{{url('/lead-data')}}/{{$leadId}}/{{Request::get('phone_number')}}'><i class='fa fa-edit'></i> Edit</a>
                                </div>
                            @endif
                                    
                </div>
        
            <!-- Add the bg color to the header using any of the bg-* classes -->
    
           
       
            
            <div class="box">
                <div class="box-body box-profile"style="padding-top:0.5rem;">            
                    <div class="row">
                        <div >
                        <div class="table-responsive ">
                                <table id="tickets" class="table table-hover no-padding">
                                <tbody>
                                @if(!empty($leadDataArr))
                                    @foreach($leadDataArr as $lead)
                                            <tr>
                                            <th style="white-space: nowrap;padding:0.5rem;">{{$lead['title']}}</th>
                                            <td style="padding:0.5rem;"> @if(isset($lead['is_dialing']) && $lead['is_dialing'] == '1')
                                                                            <i class='fa fa-phone'></i>
                                                                            @if($lead['value'] != '')
                                                                                {{$lead['value']}}
                                                                            @else
                                                                                {{Request::get('phone_number')}}
                                                                            @endif
                                                                        @else
                                                                            {{$lead['value']}}
                                                                        @endif</td>
                                            </tr>
                                            @endforeach
                                            @else
                                            <tr><td><b>No Lead Data Found</b></td></tr>
                                            @endif
                                            </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                
                
                    </div>
                </div>
            <!-- /.box-body -->
            </div>
     

        </div>
        
    <div class="col-12 col-lg-6 col-xl-7">
        
        <div class="nav-tabs-custom"style=" max-height:1020px;
        overflow-y: auto;">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item"> <a class="nav-link active"  data-bs-toggle="tab" href="#usertimeline" role="tab" aria-controls="home5" aria-expanded="true"><span class="hidden-sm-up"><i class="ion-home"></i></span> <span class="hidden-xs-down">Activity</span></a> </li>
                        <input type="hidden" name="lead-detail-class-box" class="lead-detail-class-box" value="{{$leadId}}">
                        <li class="nav-item"> <a class="nav-link"  data-bs-toggle="tab" href="#activity" role="tab" aria-controls="profile" id="btn_send_sms" data-contact="{{Request::get('phone_number')}}" ><span class="hidden-sm-up"><i class="ion-person"></i></span> <span class="hidden-xs-down">Send Text</span></a></li>
                        <li class="nav-item"> <a class="nav-link"  data-bs-toggle="tab" href="#settings" role="tab" aria-controls="profile"id="btn_send_email" data-emailid="{{$email}}" data-leadid="{{$leadId}}" data-listid="39"><span class="hidden-sm-up"><i class="ion-person"></i></span> <span class="hidden-xs-down">Send Email</span></a></li>
                        <li class="nav-item"> <a class="nav-link"  data-bs-toggle="tab" href="#fax" role="tab" aria-controls="profile"id="btn_send_fax" ><span class="hidden-sm-up"><i class="ion-person"></i></span> <span class="hidden-xs-down">Send Fax</span></a></li>

                        <!-- <li class="nav-item"> <a class="nav-link" target="_blank" href="{{url('/send-fax')}}" role="tab" aria-controls="profile"><span class="hidden-sm-up"><i class="ion-person"></i></span> <span class="hidden-xs-down">Send Fax</span></a></li> -->
                        <li class="nav-item"> <a class="nav-link send-to-crm"  href="#crm" ><span class="hidden-sm-up"><i class="ion-person"></i></span> <span class="hidden-xs-down">Export Lead</span></a></li>

                    </ul>
  

        <div class="tab-content ">

        <div class=" active tab-pane" id="usertimeline">
           


        <div class="box no-shadow">             
                    <!-- Post -->
                    <div class="post">
                    @foreach($updateData as $upd)
                                @if(isset($arrUser[$upd->extension]) || (isset($arrUserIdExtMap[$upd->extension]) && isset($arrUser[$arrUserIdExtMap[$upd->extension]])))
                      <div class="user-block">
                        
                        
                        <img class="img-bordered-sm rounded-circle" src="assets/images/avatar-simple.webp" alt="user image">
                            <span class="username">
                              <a href="#">     @if($upd->platform == 'sms')
                                                    {{$arrUser[$arrUserIdExtMap[$upd->extension]]['first_name']}} {{$arrUser[$arrUserIdExtMap[$upd->extension]]['last_name']}} ({{$arrUser[$arrUserIdExtMap[$upd->extension]]['extension']}})
                                                @elseif($upd->platform == 'comment')

                                                {{$arrUser[$upd->extension]['first_name']}} {{$arrUser[$upd->extension]['last_name']}} ({{$arrUser[$upd->extension]['extension']}})

                                                @else
                                                    {{$arrUser[$upd->extension]['first_name']}} {{$arrUser[$upd->extension]['last_name']}} ({{$arrUser[$upd->extension]['extension']}})
                                                @endif
                                                   @if($upd->platform == 'comment')
                                            Comments : {{$upd->comment}}
                                            @endif
                                            @if($upd->platform == 'cdr')
                                                @if($upd->route == 'IN')
                                                    received a call from
                                                @else
                                                    made a
                                                    @if($upd->type == 'manual')
                                                       manual
                                                    @endif
                                                    call to
                                                @endif    {{$upd->number}}  
                                                @if($upd->type == 'manual')
                                                @if(empty($upd->disposition_id))
                                                <span id="stop_{{$upd->id}}">
                                                <input type="hidden" class="cdr_id" value="{{$upd->id}}" />
                                                <select class="check_dispo" onchange="clicktochange('{{$upd->id}}')" id="check_dispo_{{$upd->id}}" name="check_dispo">
                                                    <option value="">select disposition</option>
                                                    @foreach($disposition_list as $dispo)
                                                    <option value="{{$dispo->id}}_{{$dispo->title}}">{{$dispo->title}}</option>
                                                    @endforeach
                                                </select> 
                                                </span> 
                                                @endif
                                                @endif      
                                                @foreach($disposition_list as $dispo)
                                                    @if($dispo->id  == $upd->disposition_id)
                                                         (<b>{{$dispo->title}}</b>)
                                                    @endif
                                                @endforeach  
                                                <span  style="display: none;"id="hide_{{$upd->id}}">( <b id="dis_{{$upd->id}}"></b>)</span>
                                                @elseif($upd->platform == 'sms')
                                                    sent a text to {{$upd->number}} <a onclick="open_msg_fax_detail_popup('{{$upd->message}}');" title="View Details" href="javascript:void(0);"><i class="fa fa-info-circle"></i></a>
                                                @elseif($upd->platform == 'fax')
                                                    sent a fax to {{$upd->dialednumber}} <a onclick="open_msg_fax_detail_popup('{{$upd->faxurl}}');" title="View Details" href="javascript:void(0);"><i class="fa fa-info-circle"></i></a>
                                                @endif
                                </a>
                              
                            </span>
                        <span class="description">{{$upd->start_time}}   <span class="product-description"style="margin-left:20px">
                                                @if($upd->platform == 'cdr')
                                                    {{$upd->duration_in_time_format}}
                                                    @if(Session::get('role') !== null && in_array(Session::get('role'), ['admin', 'manager', 'super_admin']))
                                                        <a title="Play Recording" target="_blank" href="{{$upd->call_recording}}"><i class="fa fa-play"></i></a>
                                                    @endif
                                                @endif
                                            </span></span>
                                          
                          
                      </div>
                      <!-- /.user-block -->
                      <div class="activitytimeline">
                          <p>
                         
                       
                                               
                                               
                                                </p>
                                              
                                               
                                            
                                                
                                            
                      </div>

                      @else
                      <div> <div class="user-block">
                        
                        
                        <img class="img-bordered-sm rounded-circle" src="assets/images/avatar-simple.webp" alt="user image">
                            <span class="username">
                              <a href="#">    
                                            @if($upd->platform == 'cdr')
                                                @if($upd->route == 'IN')
                                                    received a call from
                                                @else
                                                    made a

                                                    @if($upd->type == 'outbound_ai')
                                                       Outbound AI
                                                    @endif
                                                    @if($upd->type == 'manual')
                                                       manual
                                                    @endif
                                                    call to
                                                @endif    {{$upd->number}}  
                                                @if($upd->type == 'manual')
                                                @if(empty($upd->disposition_id))
                                                <span id="stop_{{$upd->id}}">
                                                <input type="hidden" class="cdr_id" value="{{$upd->id}}" />
                                                <select class="check_dispo" onchange="clicktochange('{{$upd->id}}')" id="check_dispo_{{$upd->id}}" name="check_dispo">
                                                    <option value="">select disposition</option>
                                                    @foreach($disposition_list as $dispo)
                                                    <option value="{{$dispo->id}}_{{$dispo->title}}">{{$dispo->title}}</option>
                                                    @endforeach
                                                </select> 
                                                </span> 
                                                @endif
                                                @endif      
                                                @foreach($disposition_list as $dispo)
                                                    @if($dispo->id  == $upd->disposition_id)
                                                         (<b>{{$dispo->title}}</b>)
                                                    @endif
                                                @endforeach  
                                                <span  style="display: none;"id="hide_{{$upd->id}}">( <b id="dis_{{$upd->id}}"></b>)</span>
                                                @elseif($upd->platform == 'sms')
                                                    sent a text to {{$upd->number}} <a onclick="open_msg_fax_detail_popup('{{$upd->message}}');" title="View Details" href="javascript:void(0);"><i class="fa fa-info-circle"></i></a>
                                                @elseif($upd->platform == 'fax')
                                                    sent a fax to {{$upd->dialednumber}} <a onclick="open_msg_fax_detail_popup('{{$upd->faxurl}}');" title="View Details" href="javascript:void(0);"><i class="fa fa-info-circle"></i></a>
                                                @endif
                                </a>
                              
                            </span>
                        <span class="description">{{$upd->start_time}}   <span class="product-description"style="margin-left:20px">
                                                @if($upd->platform == 'cdr')
                                                    {{$upd->duration_in_time_format}}
                                                    @if(Session::get('role') !== null && in_array(Session::get('role'), ['admin', 'manager', 'super_admin']))
                                                        <a title="Play Recording" target="_blank" href="{{$upd->call_recording}}"><i class="fa fa-play"></i></a>
                                                    @endif
                                                @endif
                                            </span>
                        </span>
                                          
                          
                      </div></div>
                    @endif
                    @endforeach
                    </div>
                    <!-- /.post -->

                
                
                    <!-- /.post -->
                   </div>
            </div>    
            <!-- /.tab-pane -->

            <div class=" tab-pane" id="activity">           

            <div class="box no-shadow">             
            <!-- Post -->
            <div class="box">
                <div class="box-header with-border">
                    <h4><i class="icon-Chat"><span class="path1"></span><span class="path2"></span></i> SMS</h4>
                </div>

                <div class="sms_popup_send" role="alert"></div>

                <div class="row" id="sms_box_1">

                    <form class="form">
                        @csrf
                        <div class="box-body">
                            <div class="row">
                                <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Lead Contact No.</label>
                                <div class="input-group mb-3">
                                    <span class="input-group-text"><i class="ti-mobile"></i></span>
                                    <input  type="text" class="form-control" name="send_phone" id="send_phone" readonly="true" value=""placeholder="Enter sender contact number">
                                </div>
                            </div>
                            </div>
                            <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Agent Contact No.</label>
                                <div class="input-group mb-3">
                                    <span class="input-group-text"><i class="ti-mobile"></i></span>
                                    <Select id="agent_phone" class="form-select" name="agent_phone">
                                        <option value="">--SELECT NUMBER--</option>
                                    </Select>
                                </div>
                                </div>
                            </div>
                            </div>
                            <div class="form-group">
                                <label class="form-label">Template</label>
                                <div class="input-group mb-3">
                                    <span class="input-group-text"><i class="ti-lock"></i></span>
                                    <Select id="sms_template_list" class="form-select"
                                                            name="sms_template_list">
                                                            <option value="">--SELECT SMS TEMPLATE--</option>
                                                        </Select>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="form-label">Message</label>
                                <div class="input-group mb-3">
                                    <textarea name="preview_sms_id" maxlength="190" id="preview_sms_id" style="width:740px;height: 94px;"></textarea>
                                </div>
                            </div>
                            <div class="count_sms_len" style=""><i id="count_word">192</i>Characters left </div>
                        </div>
                    </form>
                </div>

                <div class="row" id="sms_box_2" style="display:none">
                    <div class="err_sms" style="margin: 60px;font-size: 16px;">You don't have any DID associated with your extension.</div>
                </div>

                <div class="box-footer text-end">
                    <button id="singlebutton" type="button" class="btn btn-primary">
                        <i class="ti-save-alt"></i> Send SMS
                    </button>

                </div>  
            </div>
            <!-- /.post -->
            </div>

            </div>
            <!-- /.tab-pane -->

            <div class="tab-pane" id="settings">        

            <div class="box no-shadow"> 
            <span id="responseMessage"></span>

            <form method="post" id="emailSend">
                            @csrf   
                                       <input type="hidden" name="lead_id" id="lead_id" value=""/>
                                        <input type="hidden" name="list_id" id="list_id" value=""/>                                        

                                    <div class="row">
                                        <div class="col-md-6">
                                            <label class="form-label">To</label>
                                            <div class=" input-group ">
                                            <span class="input-group-text"><i class="ti-user"></i></span>

                                                <input type="text" value="{{$email}}" class="form-control" name="to" id="toEmailId" @if(empty($email)) disabled @endif>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <label class="form-label">From</label>
                                            <div class=" input-group ">
                                            <span class="input-group-text"><i class="ti-user"></i></span>
                                                <input type="text" class="form-control" name="from" value="{{$from_email}}" id="fromEmail" disabled>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <label class="form-label">Templates</label>
                                            <div class=" input-group ">
                                            <span class="input-group-text"><i class="ti-user"></i></span>

                                                <select id="templates" class="form-select" autocomplete="off" >
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <span id="setBoxValue" style="display: none;"></span>
                                            <label class="form-label">Lead Placeholders</label>
                                            <div class=" input-group ">
                                                <span class="input-group-text"><i class="ti-user"></i></span>
                                                <select id="multiple_labels" class="form-select" autocomplete="off"  @if(empty($email)) disabled @endif>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <label class="form-label">Sender Placeholders</label>
                                            <div class=" input-group">
                                            <span class="input-group-text"><i class="ti-user"></i></span>
                                                <select id="multiple_names" class="form-select" autocomplete="off"  @if(empty($email)) disabled @endif>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                        <div class="col-md-12">
                                            <label class="form-label">Subject</label>
                                            <div class=" input-group ">
                                                <input type="text" class="form-control" name="subject" id="subject">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <label class="form-label">Templete Preview</label>
                                            <div class=" input-group ">
                                                <textarea type="text" class="form-control" name="body" value="" id="editor1"></textarea>
                                            </div>
                                        </div>
                                        <div class="text-end">
                                        <a id="checkResponce" style="display: none;"> <img style="width:30px;" src="{{ asset('assets/images/loader.gif') }}"/></a>
                                    <button type="button" id="send-email" class="btn btn-info"style="margin-top:10px;">Send</button>
                                       </div>
            </form>
            </div>            
            </div>
            <div class="tab-pane" id="fax">     

<div class="box no-shadow"> 
     <form method="post" id="myform" action="{{url('save-fax')}}" enctype="multipart/form-data">
                    @csrf
                        <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group" style="width:322px;">
                                        <label class="form-label">Select the phone number you wish to send fax from</label>
                                        <select name="from_id" class="form-select" id="from_id" required="">
                                            <option value="">Select Any</option>
                                             @if (is_array($group))
                                                @foreach($group as $did)
                                                <option value="{{$did->did}}">{{$did->did}}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6"style="margin-top:20px;">
                                    <div class="form-group" >
                                    <label class="form-label">Recipient Fax Number</label>
                                        <input placeholder="Recipient Fax Number" type="text" class="form-control" name="to_id" id="to_id" required="" data-inputmask="'mask': '(999) 999-9999'" data-mask="" />
                                    </div>
                                </div>
                            </div>
                            <div class="form-group"></div>
                            <div class="form-group">
                                <input type="file" name="pdf_file" id="pdf_file">
                                <p class="help-block">Max. 10MB (Only pdf files are allowed)</p>
                            </div>
                            <div class="box-footer text-end">
                            <button type="submit" name="submit" value="add"  class="btn btn-primary btn-md"><i class="fa fa-envelope-o"></i> Send</button>
                            <button type="reset" class="btn btn-default btn-md"><a href="{{ url('/fax-list') }}"><i class="fa fa-times"></i> Discard</a></button>

                        </div>
                        </form>
</div>            
</div>
            <!-- /.tab-pane -->
        </div>
        <!-- /.tab-content -->
        </div>
        <!-- /.nav-tabs-custom -->
    </div>
    <!-- /.col -->      
      
   
    <div class="modal fade" id="msg_fax_detail_popup"  tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true"style="display: none;">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="msg_fax_detail_title">Details</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
     
            <div class="modal-body">
            <p id="msg_fax_detail_text"></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            </div>
    </div>
</div>
    </div>
    <!-- /.row -->
    
    <div class="modal fade" id="sendtocrmselection" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="add-edit">Click Url to Send to CRM</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
     
            <div class="modal-body">
            <p>Please click to url which u want to send to crm<b><i class="title"></i></b></p>
                               <div id="showUrls" style="color:white;"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            </div>
    </div>
</div>

@endif


</section>


        <!-- /.content -->




        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/npm/imask"></script>
        <script>
    var phoneInput = document.getElementById('send_phone');
    var phoneMask = new IMask(phoneInput, {
        mask: '(000) 000-0000'
    });

    $('#btn_send_sms').on('click', function () {
        $('#preview_sms_id').val("");
        $("#sms_template_list").prop('selectedIndex', '');
        let cont_number_sms = $(this).attr('data-contact');

        // Get the unformatted value and set it to the input field
        phoneMask.unmaskedValue = cont_number_sms;
    });
</script>
    <script>
              $(document).ready(function() {
    var lead_detail_class_box = $('.lead-detail-class-box').attr('value');
    $.ajax({
        url: '/messaging_modal_box_data',
        type: 'POST', // http method
        dataType: "json",
        data: {"_token": $('meta[name="csrf-token"]').attr('content') , 'lead_id': lead_detail_class_box }, // data to submit
        success: function (data) {
            var sms_var = data['sms_data'];
            var c_num = data['c_number'];
            let dropdown = $('#sms_template_list');
            dropdown.empty();
            dropdown.append('<option value="">--SELECT SMS TEMPLATE--</option>');
            dropdown.prop('selectedIndex', 0);
            $.each(sms_var.sms, function (key, entry) {
                dropdown.append($('<option></option>').attr('value', entry.templete_id).text(entry.templete_name));
            })
    
    
            if(c_num.length==0){
                $('#sms_box_1').hide();
                $('#sms_box_2').show();
                $('#singlebutton').hide();
    
            }
    
            let agent_phone = $('#agent_phone');
            agent_phone.empty();
            // console.log(sms_var, c_num);
            $.each(c_num, function (key1, entry1) {
    // Format the phone number as (999) 999-9999
    var formattedPhoneNumber = formatPhoneNumber(entry1.cli);

    // Append an option with the formatted number as both value and text
    agent_phone.append($('<option></option>').attr('value', entry1.cli).text(formattedPhoneNumber));
});

// Function to format the phone number as (999) 999-9999
function formatPhoneNumber(phoneNumber) {
    // Extract the last 10 digits from the phone number
    var last10Digits = phoneNumber.slice(-10);

    // Apply the desired formatting logic to the last 10 digits
    var formattedNumber = last10Digits.replace(/(\d{3})(\d{3})(\d{4})/, '($1) $2-$3');

    // Concatenate the front digits (if any)
    if (phoneNumber.length > 10) {
        formattedNumber = phoneNumber.slice(0, -10) + formattedNumber;
    }

    // Return the formatted number
    return formattedNumber;
}
        },
        error: function (jqXhr, textStatus, errorMessage) {
            console.log('Error' + errorMessage);
        }
    });
    
    
    $('#sms_template_list').on('change', function () {
        let sms_val = $(this).val();
        let lead_id = $('.lead-detail-class-box').attr('value');
        $.ajax({
            url: '/messaging_modal_sms_template_review',
            type: 'POST', // http method
            dataType: "json",
            data: {"_token": $('meta[name="csrf-token"]').attr('content'), 'sms_tpl_id': sms_val, 'lead_id': lead_id}, // data to submit
            success: function (data) {
                $('#preview_sms_id').val(data);
                //$('#preview_sms_id').html(data);
                var n = data.length;
                var remaning_word = 190 - n;
                $('#count_word').html(remaning_word);
                if(remaning_word>=0){
                    $('#singlebutton').prop('disabled', false);
                }else{
                    $('#singlebutton').prop('disabled', true);
                }
            },
            error: function (jqXhr, textStatus, errorMessage) {
                console.log('Error' + errorMessage);
            }
        });
    })
    
    $("#preview_sms_id").keyup(function () {
        // Getting the current value of textarea
        var currentText = $(this).val();
        var n = currentText.length;
        var remaning_word = 190 - n;
        $('#count_word').html(remaning_word);
        $('#preview_id').html(currentText);
        if(remaning_word>=0){
            $('#singlebutton').prop('disabled', false);
        }else{
            $('#singlebutton').prop('disabled', true);
        }
    });
    
    
    /// Send sms
    
    $('#singlebutton').on('click',function(){
       // $(this).prop('disabled', true);
      var to_phone = $('#send_phone').val();
      var agent_phone = $('#agent_phone').val();
      var sms_txt = $('#preview_sms_id').val();
      var sms_template_list = $('#sms_template_list').val();
    
      if(to_phone==''){
          $('#send_phone').focus();
          return false;
      }
      if(agent_phone==''){
          $('#agent_phone').focus();
          return false;
      }
      if(sms_template_list=='' ){
        //  $('#sms_template_list').focus();
        //  return false;
      }
      if(sms_txt==''){
          $('#preview_sms_id').focus();
          return false;
      }
    
      // 1 added before lead no
      $('#singlebutton').prop('disabled', true);
      var created_date = moment.utc().format('YYYY-MM-DD HH:mm:ss');
        $.ajax({
           // url: 'send_sms_dialer/' + agent_phone + '/' + to_phone + '/' + preview_sms_id,
            url: 'send_sms_dialer',
            method:'post',
            data : { 'from' : agent_phone , 'to' : "1"+to_phone , 'message': sms_txt , 'created_date':created_date},
            type: 'get',
            beforeSend: function (xhr) {
        // Retrieve the CSRF token from the meta tag
        var csrfToken = $('meta[name="csrf-token"]').attr('content');
        xhr.setRequestHeader('X-CSRF-Token', csrfToken);
    },
            success: function (response) {
              //let userObj = $.getJSON(response);
    
              var returnedData = JSON.parse(response);
              if(returnedData.success==="false"){
                  $('.sms_popup_send').addClass('alert-danger');
                  $('.sms_popup_send').html(returnedData.message);
                  $('.sms_popup_send').css( "visibility", "visible" );
                  $('.sms_popup_send').show();
    
              } else{
                  $('.sms_popup_send').addClass('alert-success');
                  $('.sms_popup_send').html(returnedData.message);
                  $('.sms_popup_send').css( "visibility", "visible" );
                  $('.sms_popup_send').show();
              }
              $('.sms_popup_send').fadeOut(6000);
              $('#singlebutton').prop('disabled', false);
            },
            error: function(errors) {
               $('#sms_popup_send').addClass('alert-success');
                  $('#sms_popup_send').html('Error Message');
                 $('#singlebutton').prop('disabled', false);
            }
    
        });
    });
     //$(this).prop('disabled', false);
 
    
    });
</script>
    @if(Request::get('phone_number') != '')
<script>
@if(!empty($duration_time))
countUpFromTime('{{$duration_time}}', 'countup');
    $(".call").addClass("callLeadHide");
    @else
    $(".call").removeClass("callLeadHide");

@endif
</script>
@endif
<script>
    @if(Request::get('phone_number') != '' && empty($arrUser))
        toastr.error("No lead data found.");
    @endif

    $(function () {
     
        var phoneInput = document.getElementById('phone_number');
    var phoneMask = new IMask(phoneInput, {
        mask: '(000) 000-0000',
        placeholder: "(___) ___-____",
            showMaskOnHover: false, // Optional: Hide the mask on hover
    }); 
        $("#search_lead").click(function () {
            var rawPhoneNumber = $("#phone_number").val().replace(/\D/g, ''); // Remove non-numeric characters
            if (rawPhoneNumber.length < 10 || rawPhoneNumber.length > 12) {
                toastr.error('Phone number must be more than 10 and less than 13 digits');
                return;
            } else {
                var redirectUrl = "{{ url('/lead-activity') }}";
                window.location.href = redirectUrl + "?phone_number=" + rawPhoneNumber;
            }
        });
    });


    function open_msg_fax_detail_popup(text) {
        $("#msg_fax_detail_text").text(text);
        $("#msg_fax_detail_popup").modal('show');
    }

</script>
<script>
$(document).ready(function() {
    // Get the email address from the user profile box and set it in the "To" field
    var userEmail = $("#toEmailId").text();
    $("#userEmail").val(userEmail);
});
</script>
<script src="https://cdn.ckeditor.com/4.22.1/standard/ckeditor.js"></script>
    <script language="javascript">
        $(function () {
            CKEDITOR.config.autoParagraph = false;
            CKEDITOR.config.versionCheck = false;
            CKEDITOR.config.enterMode = CKEDITOR.ENTER_BR;
            CKEDITOR.config.shiftEnterMode = CKEDITOR.ENTER_P;
            CKEDITOR.replace('editor1', {
                width: '100%', 
                enterMode: CKEDITOR.ENTER_BR,
                filebrowserUploadUrl: "{{route('start-dialing.upload', ['_token' => csrf_token() ])}}",
                filebrowserUploadMethod: 'form',
                allowedContent: true
                
            });

            CKEDITOR.instances['editor1'].on('contentDom', function () {
                this.document.on('click', function (event) {
                    console.log('abh');
                    $('#setBoxValue').html('');
                });
            });

            $("#multiple_labels").on('change', function () {
                //console.log($(this).val());
                var label_name = $(this).val();
                var lead_id = $("#lead_id").val();
                var list_id = $("#list_id").val();


                $.ajax({
                    url: 'getLabelValue/' + label_name + '/' + list_id + '/' + lead_id,
                    type: 'get',
                    success: function (response) {

                        //console.log($(this).val());
                        var hidden_box = $('#setBoxValue').html();
                        if (hidden_box == 'subject_box')
                        {
                            var cursorPos = $('#subject').prop('selectionStart');
                            var v = $('#subject').val();
                            console.log(v);

                            var textBefore = v.substring(0, cursorPos);
                            var textAfter = v.substring(cursorPos, v.length);
                            $('#subject').val(textBefore + response + textAfter);
                        }
                        else
                        {
                            for (var i in CKEDITOR.instances) {

                                console.log(response);
                                CKEDITOR.instances[i].insertHtml(response);
                            }
                        }
                    }
                });
            });

            $("#multiple_names").on('change', function () {
                console.log($(this).val());
                var sender_id = $(this).val();
                $.ajax({
                    url: 'getSenderValue/' + sender_id,
                    type: 'get',
                    success: function (response) {
                        var hidden_box = $('#setBoxValue').html();
                        if (hidden_box == 'subject_box')
                        {
                            var cursorPos = $('#subject').prop('selectionStart');
                            var v = $('#subject').val();
                            console.log(v);

                            var textBefore = v.substring(0, cursorPos);
                            var textAfter = v.substring(cursorPos, v.length);
                            $('#subject').val(textBefore + response + textAfter);
                        }
                        else
                        {
                            for (var i in CKEDITOR.instances) {
                                CKEDITOR.instances[i].insertHtml(response);
                            }
                        }
                    }
                });
            });

            $("#templates").on('change', function () {
                console.log("Template change called");
                var output = '';
                CKEDITOR.instances['editor1'].setData(output);

                var template_id = this.value;
                var lead_id = $("#lead_id").val();
                var list_id = $("#list_id").val();

                $.ajax({
                    url: 'getTemplate/' + template_id + '/' + list_id + '/' + lead_id,
                    type: 'get',
                    success: function(response){
                        $("#subject").val(response['subject']);
                        for (var i in CKEDITOR.instances) {
                            CKEDITOR.instances[i].insertHtml(response['template_html']);
                            var editor = CKEDITOR.instances[i];
                            editor.on('contentDom', function () {
                                var editable = editor.editable();
                                editable.attachListener(editable, 'click', function () {
                                    console.log("click event");
                                    $('#setBoxValue').html('');
                                });
                            });
                        }
                    }
                });
            });

            $('#subject').on('click', function () {
                $('#setBoxValue').html('subject_box');
            });
        });


    /*send email code */
    $('#btn_send_email').click(function () {
        var lead_id = $(this).attr('data-leadid');
        var list_id = $(this).attr('data-listid');
        var toEmailId = $("#toEmailId").val();

            $("#lead_id").val(lead_id);
            $("#list_id").val(list_id);
            $("#responseMessage").html('');

            //Rest the template selection
            $('#templates option[value=""]').attr('selected','selected');
            $('#subject').val('');
            $('#multiple_labels').val('');
            $('#multiple_names').val('');
            CKEDITOR.instances['editor1'].setData('');

            console.log("btn_send_email: " + toEmailId);
            $.ajax({
                url: '/openMailModal',
                type: 'post',
                data: {
                    lead_id: lead_id,
                    smtpType: '1',
                    campaign_id: {{$campaignId}},
                    list_id: list_id,
                    toEmailId: toEmailId,
                    "_token": "{{ csrf_token() }}"
                },
                success: function (response) {

                    templates_line = "<option value=''>Compose New</option>";
                    for (var i = 0; i < response['email_templates'].length; i++) {
                        var email_template = response['email_templates'][i];
                        //alert(email_template);
                        templates_line += "<option value='" + response['email_templates'][i]['id'] + "'>";
                        templates_line += response['email_templates'][i]['template_name'];
                        templates_line += "</option>";
                    }



                    $('#templates').html(templates_line);
                    label_line = "<option value=''>Select to Insert</option>";
                    for (var i = 0; i < response['labels'].length; i++) {
                        var labels = response['labels'][i];
                        label_line += "<option value='" + response['labels'][i]['id'] + "'>";
                        //label_line += "<option value='[["+response['labels'][i]['title']+"]]'>";
                        label_line += response['labels'][i]['title'];
                        label_line += "</option>";
                    }

                    $('#multiple_labels').html(label_line);
                    user_line = "<option value=''>Select to Insert</option>";
                    for (var i = 0; i < response['user_column'].length; i++) {
                        var user_column = response['user_column'][i];
                        //alert(user_column);
                        user_line += "<option value='[[" + user_column + "]]'>";
                        user_line += user_column;
                        user_line += "</option>";
                    }
                    $('#multiple_names').html(user_line);
                    //window.location.reload(1);
                },
                error: function (xhr, status, error) {
                    $("#responseMessage").html('<div class="alert alert-danger" id="alert-errors">'+xhr.responseText+'</div>');
                }
            });
    });


  

    function clicktochange(val)
    {
        check_dispo = $("#check_dispo_"+val).val();
        disposition_id = check_dispo.split("_");
        //alert(myArray[0]);
        //alert(myArray[1]);

        cdr_id = val;

         $.ajax({
                url: '/change-disposition',
                type: 'post',
                data: {
                    disposition_id: disposition_id[0],
                    cdr_id: cdr_id,
                    "_token": "{{ csrf_token() }}"
                },
                success: function (response)
                {   
                    $("#stop_"+cdr_id).hide();
                    $("#dis_"+cdr_id).text(disposition_id[1]);
                    $("#hide_"+cdr_id).show();
                },
                error: function (xhr, status, error) {
                    //$("#responseMessage").html('<div class="alert alert-danger" id="alert-errors">'+xhr.responseText+'</div>');
                }
            });


    }



    $('#send-email').bind('click', function (event) {

            event.preventDefault();
            from = $("#fromEmail").val();
            if (from == '' || from == undefined) {
                $('#from').css('border', '1px solid red');
                $("#from").focus();
                return false;
            }
            to = $("#toEmailId").val();
            if (to == '' || to == undefined) {
                $('#to').css('border', '1px solid red');
                $("#to").focus();
                return false;
            }
            subject = $("#subject").val();
            if (subject == '' || subject == undefined) {
                $('#subject').css('border', '1px solid red');
                $("#subject").focus();
                return false;
            }
            message = CKEDITOR.instances['editor1'].getData();

            if (message == '' || message == undefined) {
                $('#message').css('border', '1px solid red');
                $("#message").focus();
                return false;
            }

            $("#checkResponce").show();

            $.ajax({
                type: 'POST',
                url: 'send-email/generic',
                dataType: "json",
                data: {
                    from: from,
                    to: to,
                    subject: subject,
                    message: message,
                    smtpType: '1',
                    campaign_id: {{$campaignId}}
                },

                success: function (response) {
                    console.log(response);
                    $("#responseMessage").show();
                    $("#checkResponce").hide();
                    if (response.success) {
                        $("#responseMessage").html("<div class='alert alert-success alert-block'>Mail Send Successfully</div>");
                    } else {
                        $("#responseMessage").html("<div class='alert alert-danger alert-block'>" + response.message + "</div>");
                    }
                    setTimeout(function () {
                        $("#responseMessage").hide();
                    }, 3000);
                }
            });
        });
    /* close*/

    /* send to crm  code */

    $('.send-to-crm').click(function ()
    {
        var num = $('#lead-detail').attr('data-number');
        var lead_id_1 = $('.lead-detail-class-box').attr('value');

        lead_id_1 = {{$leadId}};
        campaign_id = {{$campaignId}};
        num = {{Request::get('phone_number')}};

        $.ajax({
            type: 'POST',
            url: '/sendToCrm',
            data:
            {
                campaign: campaign_id,
                lead: lead_id_1,
                number: num,
                "_token": "{{ csrf_token() }}"
            },

            success: function (data)
            {
                var res = $.parseJSON(data);
                if (res.status == "false")
                {
                    alert(res.message);
                }
                count = Object.keys(res.url).length;
                if (res.status == "success")
                {
                    if(count == 1)
                    {
                        window.open(res.url, '_blank');
                    }
                    else
                    {
                        $("#sendtocrmselection").modal('show');
                        var html='';
                        for(i=0;i<count;i++)
                        {
                            html+='<p><a target="_blank" style="color:white;background: yellowgreen;" href="'+res.url[i]+'">'+res.main_url[i]+'</a></p>';
                        }

                        $("#showUrls").html(html);
                    }
                }

                else
                {
                    $("#detail-message").addClass('text-success').removeClass('text-danger').html(res.message);
                }
            }
        });
    });

</script>
@endsection
