@extends('layouts.app')
@section('title', 'List')

@section('content')


<style>
        .wrap
        {
            white-space: pre-wrap;      /* CSS3 */   
            white-space: -moz-pre-wrap; /* Firefox */    
            white-space: -pre-wrap;     /* Opera <7 */   
            white-space: -o-pre-wrap;   /* Opera 7 */    
            word-wrap: break-word;      /* IE */
        }
    </style>
    
<section class="content">
  <div class="row">   
  <div class="alert alert-danger" id="errorMsg" style="display: none;">
<strong id="mes"></strong>
<ul>
</ul>
</div>
    <div class=" col-12">
      <div class="box">
        <div class="box-body"><!--bg-lightest-->
       
       <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Manage Leads</h4>
             <hr class="my-15">
           
            <form class="form-inline" method="post">
             @csrf          
         
          


            <div class="row">
              <div class="col-md-3">
                <div class="form-group @error('name') has-error @enderror">
                  <label class="form-label">List</label> 
                  <div class="input-group mb-3">
                    <select class="form-select select2" required="required" multiple="multiple" name="list_id[]" id="list_id" autocomplete="off" data-placeholder="Select List" style="width: 100%;">

                                                         <option value="0">All</option>                    
                                                       @foreach($list_details as $key => $lists)
                                                            <option value="{{$lists->list_id}}" >{{$lists->list}}</option>
                                                        @endforeach

                  </select>
                </div>
                </div>
              </div>

           
              <div class="col-md-3"id="hiddenHeader" style="display: none;">
                <div class="form-group @error('list_id') has-error @enderror">
                  <label class="form-label">Search By</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('list_id') text-danger border-danger @enderror"><i class="ti-list"></i></span>
                    <select  required="required" name="header_column" class="form-select" id="header_column">                                                                                                                    
                    </select>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('list_id') has-error @enderror">
                  <label class="form-label">Value</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('list_id') text-danger border-danger @enderror"><i class="ti-list"></i></span>
                    <input type="text" required="required" name="header_value" class="form-control" id="header_value"value="{{ old('header_value') }}">

                  </div>
                </div>
              </div>
              <div class="col-md-3"style="margin-top:10px;">
                <div class="form-group @error('list_id') has-error @enderror">
                  <label class="form-label"></label>
                  <div class="input-group mb-3">
                    <button type="submit" value="Search"id="submit_search" class="btn btn-primary btn-sm">
                  <i class="ti-save-alt"></i> Search
                </button>
                  </div>
                </div>
              </div> 
    
            </div>
      <!-- /.row -->
     <!-- /.box-body -->
   
            <!-- /.box -->      
        </div>  



    


    @isset($leads)


      <div class="row">    
        <div class="col-12">
          <div class="box">
           <div class="box-body">           
              <div class="table-responsive">
                <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
                  <thead>
                    <tr>
                              <th>#</th>
                              <th>Lead Id</th>
                              <?php 
                                $in_array_heaader = array();
                                $in_array =array('Email','First Name','Last Name','Mobile','State','Legal Company Name');?>
                                <?php foreach($lists_header_array as $header){
                                if(in_array($header->title,$in_array)) { 

                                    $in_array_heaader[] = $header->column_name;
                                    ?>
                              <th>{{$header->title}}</th>
                              <?php } }?>                             
                              <th>Action</th>

                            </tr>
                  </thead>
                  <tbody>
    <?php foreach ($leads as $key => $lead) { ?>
        <tr>
            <th scope="row"><?php echo ++$key; ?></th>
            <td>
                <a target="_blank" style="cursor:pointer;" href="call-report/{{$lead->id}}" class='editEG'>
                    {{$lead->id}}
                </a>
            </td>
            <?php
            // Initialize $view_report outside the loop
            $view_report=null;

            foreach ($lists_header_array as $key1 => $header) {
                $variableName = $header->column_name;
                if (in_array($variableName, $in_array_heaader)) {
                    if ($header->title == 'Mobile') {
                        $option = $header->column_name;
                        $view_report = $lead->$option;
                    }
                    ?>
                    <td><?php echo $lead->$variableName; ?></td>
                <?php } } ?>
            <td>
                <a target="_blank" style="cursor:pointer;" href="report/{{$view_report}}" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5 editEG">
                    <i class="fa fa-eye"></i> View Call Record
                </a>
            </td>
        </tr>
    <?php } ?>
</tbody>

                </table>
              </div>
            </div>
          </div>
        </div>
 
</div>
      </div>
      @endisset
      <!-- /.row -->
      </form>
    </section>
        <!-- /.content -->




        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

     <script>
      $(document).ready(function() {
    $("#list_id").change(function () {
        var data_list = $("#list_id").val();

        $.ajax({
            url: 'searchListHeader/' + data_list,
            type: 'get',
            success: function (response) {
                if (response == '0') {
                    $("#errorMsg").show();
                    $("#mes").html('Whoops! List Header not created.');
                } else {
                    $("#hiddenHeader").show();
                    $("#header_column").html("");

                    //header_column
                    var elem = document.getElementById('header_column');

                    for (var i = 0; i < response.length; i++) {
                        var obj = response[i];
                        elem.innerHTML = elem.innerHTML + '<option value="' + obj.column_name + '">' + obj.title + '</option>';
                    }
                }
            },
            error: function (xhr, status, error) {
                console.error(xhr.responseText);
            }
        });
    });
});

     </script>   

        <script>

$(document).ready(function(){
  $("#submit_search").click(function(){
    var list_id = $("#list_id").val();
    var header_column = $("#header_column").val();
    var header_value  = $("#header_value").val();
if(header_column == null){
header_column=0
}
     $.ajax({
            url: 'searchLeadColumn/'+list_id+'/'+header_column+'/'+header_value,
            type: 'get',
            success: function(response){
            }
        });



  });
});


</script>
@endsection
