@extends('layouts.app')
@section('title', 'List Data Value')

@section('content')
<style>
    /* Custom style for pagination links */
    .pagination {
        margin: 0; /* Remove default margin */
        padding: 0; /* Remove default padding */
        list-style: none; /* Remove list bullet points */
        display: flex; /* Use flex layout for horizontal alignment */
    }

    .pagination li a {
        padding:6px;
    }

    .pagination a {
        display: inline-block;
        padding: 0; /* Adjust the padding as needed */
        text-decoration: none;
        background-color: #f0f0f0;
        border: 1px solid #ccc;
        color: #333;
        transition: background-color 0.3s ease, color 0.3s ease;
    }

    .pagination a:hover {
        background-color: #ccc;
        color: #fff;
    }

    .pagination .active a {
        background-color: #007bff;
        color: #fff;
    }
</style>
<!-- Main content -->
        <section class="content">

      <div class="row">

      <?php
        
        if (!empty($list_details->list_data)) {
      
          $url = request()->url(); 
        if($page == 1)
        {
            $currentPage = 1;
        }

        else
        {
            $currentPage = isset($_GET['page']) ? (int) $_GET['page'] : 1;
        }

        $perPage = $show;
        $paginator = new Illuminate\Pagination\LengthAwarePaginator($list_details->list_data, $record_count, $perPage, $currentPage, ['path' => url($url)]);
    ?>

@if (session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
@endif

        <div class="col-12">
          <div class="box">
           <div class="box-body">   
         
      
                 
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> List Data for {{$list_name}}</h4>   
              <a href="/list" id="openListForm"  style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye"></i>View List</a>
              <form method="GET" action=" "style="display: inline;">
    <input type="hidden" name="submit_download" value="excel">
    <input type="hidden" name="search" value="{{ $searchTerm }}">
    <input type="hidden" name="show" value="{{ $show }}">
    <button type="submit" id="submit" style="float:right;margin-right:10px;" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5">
        <i class="fa fa-download"></i> Download
    </button>
</form>

           <hr class="my-15">
           <div style="display:flex; justify-content:space-between; align-items:center;">
           <form action="{{ url()->current() }}" method="get" id="listForm">
    <input type="hidden" name="search" value="{{ $searchTerm }}">
              <label class="label-class" for="show">Show:
              <select id="show" class="form-select form-control-sm" name="show"style="width:75px;display:inline-block;">
                  <option value="10" {{ request('show') == 10 ? 'selected' : '' }}>10</option>
                  <option value="25" {{ request('show') == 25 ? 'selected' : '' }}>25</option>
                  <option value="50" {{ request('show') == 50 ? 'selected' : '' }}>50</option>
                  <option value="100" {{ request('show') == 100 ? 'selected' : '' }}>100</option>
              </select>
              </label>
              <label for="show">entries</label>
          </form>
          
                    <form action="{{ url()->current() }}" method="get" style="margin:0; display:flex; align-items:center;">
                     <label class="form-label" style="margin:0 10px 0 0;">Search:</label>
                     <input type="text" value="{{$searchTerm}}" class="form-control form-control-sm" name="search" id="search" placeholder="" style="width:auto; padding:5px 30px 5px 15px;">
                    <input type="hidden" name="show" value="{{ request('show', 10) }}">
             
                    </form>
                    </div>
                
                    <b>Total Rows :<?= $record_count ?></b>

              <div class="table-responsive">
                <table  class="table mt-0 table-hover no-wrap">
                  <thead>
                    <tr>
                                    <th>#</th>
                                     @foreach($list_details->list_header as $key => $header)
                                    <th>{{$header}}</th>
                                                                   @endforeach


                            </tr>
                  </thead>
                  @if(!empty($list_details))
                            <tbody>

                                @foreach($list_details->list_data as $key => $live)
                                <tr>
                                    <td>{{ ($paginator->currentPage() - 1) * $paginator->perPage() + $key + 1 }}</td>
                                  @foreach($list_details->list_header as $header)
                                    @php
                                        $fieldName = 'option_' . ($loop->index + 1); // Assuming headers start from 1
                                    @endphp

                                    <td>
                                        @if(isset($live->$fieldName) && !empty($live->$fieldName))
                                            {{ $live->$fieldName }}
                                        @else
                                            <!-- Show empty cell if no data is available -->
                                        @endif
                                    </td>
                                  @endforeach


                                </tr>

                                @endforeach
                            </tbody>
                            @endif
                            <?php } ?>
                </table>
                <div style="float:right;">
                
                        <!-- {{$paginator->appends(Request::all())->links()}} -->

<!-- Pagination links with search parameter -->
<!-- {{$paginator->appends(['show' => $paginator->perPage(), 'search' => $searchTerm])->links()}} -->
 {{$paginator->appends(Request::all())->links('pagination::bootstrap-5')}}
 


                                                            </div>
              </div>
            </div>
          </div>
        </div>
 
      </div>
      <!-- /.row -->

    </section>
        <!-- /.content -->

<script>
  document.addEventListener('DOMContentLoaded', function() {
    var selectElement = document.getElementById('show');
    var searchInput = document.getElementById('search');
    var listForm = document.getElementById('listForm');

    selectElement.addEventListener('change', function() {
        listForm.action = updateActionWithSearch(listForm.action, searchInput.value);
        listForm.submit();
    });

    function updateActionWithSearch(action, searchTerm) {
        var url = new URL(action);
        url.searchParams.set('search', searchTerm);
        return url.toString();
    }
});

  </script>

<script>
  document.addEventListener('DOMContentLoaded', function() {
    var selectElement = document.getElementById('submit');

    selectElement.addEventListener('click', function() {
        this.form.submit();
    });
});

  </script>

@endsection
