@extends('layouts.app')
@section('title', 'List')

@section('content')

    <style>
        .wrap {
            white-space: pre-wrap;
            /* CSS3 */
            white-space: -moz-pre-wrap;
            /* Firefox */
            white-space: -pre-wrap;
            /* Opera <7 */
            white-space: -o-pre-wrap;
            /* Opera 7 */
            word-wrap: break-word;
            /* IE */
        }

        .input-group input[type="time"] {
            vertical-align: middle;
            /* Adjust vertical alignment */
        }
    </style>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css"
    integrity="sha384-wvfXpqpZZVQGK6TAh5aJSK8r/jFaMM8DO" crossorigin="anonymous">
    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="box">
                    <div class="box-body"><!--bg-lightest-->

                        <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Recyle Rules</h4>
                        <a href="add-recycle" type="submit" style="float:right"
                            class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i
                                class="fa fa-plus"></i>Add Recycle Rule</a>

                        <hr class="my-15">
                        <form class="form-inline" method="post">
                            @csrf





                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group @error('name') has-error @enderror">
                                        <label class="form-label">Campaign</label>
                                        <div class="input-group mb-3">
                                            <!-- <span
                                                class="input-group-text @error('name') text-danger border-danger @enderror"><i
                                                    class="ti-list"></i></span> -->
                                            <select name="campaign_id" class="js-example-basic-single select2" id="search-campaign-rule"
                                                required>
                                                <option value="">Select</option>
                                                <?php foreach ($campaign_list as $key=>$value){
                                                        if(!empty($value->title) & ($value->status==1)){?>
                                                <option @if ($value->id == request()->input('campaign_id')) selected @endif
                                                    value="{{ $value->id }}">{{ $value->title }}</option>


                                                <?php } }?>
                                            </select>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-md-3">
                                    <div class="form-group @error('list_id') has-error @enderror">
                                        <label class="form-label">List </label>
                                        <div class="input-group mb-3">
                                            <!-- <span
                                                class="input-group-text @error('list_id') text-danger border-danger @enderror"><i
                                                    class="ti-list"></i></span> -->
                                            <select name="list_id" class="form-select" id="search-list-rule">
                                                <option value="">Select List</option>
                                                <?php foreach ($list_details as $key=>$value){?>
                                                <option @if ($value->list_id == request()->input('list_id')) selected @endif
                                                    value="{{ $value->list_id }}">{{ $value->list }}</option>
                                                <?php }?>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="form-group @error('list_id') has-error @enderror">
                                        <label class="form-label">Disposition </label>
                                        <div class="input-group mb-3">
                                            <select name="disposition_id" class="form-select" id="search-disposition-rule">
                                                <option value="">Select Disposition</option>
                                                <?php foreach ($disposition_list as $key=>$value){?>
                                                <option @if ($value->id == request()->input('disposition_id')) selected @endif
                                                    value="{{ $value->id }}">{{ $value->title }}</option>
                                                <?php }?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group @error('list_id') has-error @enderror">
                                        <label class="col-form-label ">Day </label>
                                        <div class="input-group mb-3"id="date-range1">
                                            <span
                                                class="input-group-text @error('list_id') text-danger border-danger @enderror"><i
                                                    class="ti-list"></i></span>
                                            <select name="days" class="form-select" id="search-days-rule">
                                                <option value="">Select Day</option>

                                                <option @if (request()->input('days') == 'sunday') selected @endif value="sunday">
                                                    Sunday</option>
                                                <option @if (request()->input('days') == 'monday') selected @endif value="monday">
                                                    Monday</option>
                                                <option @if (request()->input('days') == 'tuesday') selected @endif value="tuesday">
                                                    Tuesday</option>
                                                <option @if (request()->input('days') == 'wednesday') selected @endif
                                                    value="wednesday">Wednesday</option>
                                                <option @if (request()->input('days') == 'thursday') selected @endif value="thursday">
                                                    Thursday</option>
                                                <option @if (request()->input('days') == 'friday') selected @endif value="friday">
                                                    Friday</option>
                                                <option @if (request()->input('days') == 'saturday') selected @endif value="saturday">
                                                    Saturday</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group @error('list_id') has-error @enderror">
                                        <label class="col-form-label ">Call Time </label>
                                        <div class="input-group mb-3"id="date-range1">
                                            <span
                                                class="input-group-text @error('list_id') text-danger border-danger @enderror"><i
                                                    class="ti-list"></i></span>
                                            <select name="call_time" class="form-select" id="search-calltime-rule">
                                                <option value="">Select Call Time</option>

                                                <option @if (request()->input('call_time') == '1') selected @endif value='1'>1
                                                </option>
                                                <option @if (request()->input('call_time') == '2') selected @endif value='2'>
                                                    less than or equal to 2</option>
                                                <option @if (request()->input('call_time') == '3') selected @endif value='3'>
                                                    less than or equal to 3</option>
                                                <option @if (request()->input('call_time') == '4') selected @endif value='4'>
                                                    less than or equal to 4</option>
                                                <option @if (request()->input('call_time') == '5') selected @endif value='5'>
                                                    less than or equal to 5</option>
                                                <option @if (request()->input('call_time') == '6') selected @endif value='6'>
                                                    less than or equal to 6</option>
                                                <option @if (request()->input('call_time') == '7') selected @endif value='7'>
                                                    less than or equal to 7</option>
                                                <option @if (request()->input('call_time') == '8') selected @endif value='8'>
                                                    less than or equal to 8</option>
                                                <option @if (request()->input('call_time') == '9') selected @endif value='9'>
                                                    less than or equal to 9</option>
                                                <option @if (request()->input('call_time') == '10') selected @endif value='10'>
                                                    less than or equal to 10</option>
                                                <option @if (request()->input('call_time') == '11') selected @endif value='11'>
                                                    less than or equal to 11</option>
                                                <option @if (request()->input('call_time') == '12') selected @endif value='12'>
                                                    less than or equal to 12</option>
                                                <option @if (request()->input('call_time') == '13') selected @endif value='13'>
                                                    less than or equal to 13</option>
                                                <option @if (request()->input('call_time') == '14') selected @endif value='14'>
                                                    less than or equal to 14</option>
                                                <option @if (request()->input('call_time') == '15') selected @endif value='15'>
                                                    less than or equal to 15</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group @error('list_id') has-error @enderror">

                                        <label class="col-form-label ">Time </label>
                                        <div class="input-group mb-3"id="date-range1">
                                            <input class="form-control" type="time" value="09:30" name="time"
                                                id="timepicker6">

                                            <span class="input-group-addon bg-primary text-white b-0">to</span>
                                            <input type="time" class="form-control" value="09:30" name="time"
                                                id="timepicker9">
                                        </div>
                                    </div>
                                </div>


                            </div>
                    </div>
                    <div class="box-footer text-end">

                        <button type="button"id="searchRecycle" name="submit" value="Search"
                            class="btn btn-primary btn-sm mb-5 mr-5">
                            <i class="ti-search-alt"></i> Search
                        </button>
                    </div>

                    <!-- /.row -->
                    <!-- /.box-body -->

                    <!-- /.box -->
                </div>
            </form>



                <div class="row">
                    <div class="col-12">
                        <div class="box">
                            <div class="box-body">
                                <div class="table-responsive">
                                    <table id="recycle" class="table mt-0 table-hover no-wrap" data-page-size="10">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Campaign</th>
                                                <th>List</th>
                                                <th>Disposition</th>
                                                <th>Day</th>
                                                <th>Time</th>
                                                <th>Call Time</th>
                                                <th>Recycle Status</th>
                                                <th>Action</th>

                                            </tr>
                                        </thead>
                                        <tbody>
                                            
                                                <tr>
                                                    <th scope="row"></th>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                    <td>
                                                     
                                                    </td>


                                                </tr>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>
                       
                                <div class="modal-body">
                                    <p>You are about to delete <b><i class="title"></i></b>recycle.</p>
                                    <p>Do you want to proceed?</p>
                                    <input type="hidden" class="form-control" name="recycle_id" value=""
                                        id ="recycle_id">

                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary btn-sm"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="submit"name="submit"
                                        class="btn btn-danger btn-sm deleteRecycleRule">Delete</button>
                                </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.row -->
    </section>
    <!-- /.content -->




    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM="
        crossorigin="anonymous"></script>
<script>// Open delete modal
$(document).on("click", ".deleteRecycle", function() {
    var delete_id = $(this).data('id');
    $("#delete").modal('show');
    $("#recycle_id").val(delete_id);
});

// Confirm delete
$(document).on("click", ".deleteRecycleRule", function() {
    var recycle_id = $('#recycle_id').val();

    $.ajax({
        url: 'deleteRecycleRule/' + recycle_id,
        type: 'get',
        success: function(response) {
            if (response.success) {
                toastr.success('Recycle rule deleted successfully');
                $("#delete").modal('hide');
                $('#recycle').DataTable().ajax.reload(null, false);
            } else {
                toastr.error(response.message);
            }
        },
        error: function(xhr) {
            toastr.error('Something went wrong while deleting');
            console.error(xhr.responseText);
        }
    });
});

</script>
    <script>
  

        // $(document).ready(function() {
        //     var table = $('#recycle').DataTable({
        //         processing: true,
        //         serverSide: true,
        //         ajax: '{{ url('recycle-rule') }}', // or your actual route
        //         columns: [{
        //                 data: 'DT_RowIndex',
        //                 name: 'DT_RowIndex',
        //                 orderable: false,
        //                 searchable: false
        //             },
        //             {
        //                 data: 'campaign',
        //                 name: 'campaign'
        //             },
        //             {
        //                 data: 'list',
        //                 name: 'list'
        //             },
        //             {
        //                 data: 'disposition',
        //                 name: 'disposition'
        //             },
        //             {
        //                 data: 'day',
        //                 name: 'day'
        //             },
        //             {
        //                 data: 'time',
        //                 name: 'time'
        //             },
        //             {
        //                 data: 'call_time',
        //                 name: 'call_time'
        //             },
        //             {
        //                 data: 'status',
        //                 name: 'status',
        //                 orderable: false,
        //                 searchable: false
        //             },
        //             {
        //                 data: 'action',
        //                 name: 'action',
        //                 orderable: false,
        //                 searchable: false
        //             },
        //         ]
        //     });

        //     // Search button reloads the DataTable using POST with filters

        //     $('#searchRecycle').on('click', function() {
        //         let formData = {
        //             _token: $('input[name="_token"]').val(),
        //             campaign_id: $('#search-campaign-rule').val(),
        //             list_id: $('#search-list-rule').val(),
        //             disposition_id: $('#search-disposition-rule').val(),
        //             call_time: $('#search-calltime-rule').val(),
        //             days: $('#search-days-rule').val(),
        //         };

        //         $.ajax({
        //             url: '{{ url('recycle-rule') }}',
        //             type: 'POST',
        //             data: formData,
        //             success: function(response) {
        //                 // clear existing data
        //                 table.clear();

        //                 // add new data from response
        //                 table.rows.add(response.data);
        //                 //alert(JSON.stringify(response.data));
        //                 // redraw table
        //                 table.draw();
        //             },
        //             error: function() {
        //                 alert('Error loading data');
        //             }
        //         });
        //     });
        // });
        $(document).ready(function() {
            var table = $('#recycle').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '{{ url('recycle-rule') }}',
                    type: 'POST', // Use POST always for consistent behavior
                    data: function(d) {
                        d._token = $('input[name="_token"]').val();
                        d.campaign_id = $('#search-campaign-rule').val();
                        d.list_id = $('#search-list-rule').val();
                        d.disposition_id = $('#search-disposition-rule').val();
                        d.call_time = $('#search-calltime-rule').val();
                        d.days = $('#search-days-rule').val();
                    }
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'campaign',
                        name: 'campaign'
                    },
                    {
                        data: 'list',
                        name: 'list'
                    },
                    {
                        data: 'disposition',
                        name: 'disposition'
                    },
                    {
                        data: 'day',
                        name: 'day'
                    },
                    {
                        data: 'time',
                        name: 'time'
                    },
                    {
                        data: 'call_time',
                        name: 'call_time'
                    },
                    {
                        data: 'status',
                        name: 'status',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
language: {
    processing: `
        <span style="display:flex; align-items:center; justify-content:center; gap:8px;">
            <img src="https://i.gifer.com/ZZ5H.gif"
                 alt="Loading..." style="width:20px; height:20px;">
            Processing...
        </span>
    `
}

            });

            // Filter/search: simply trigger redraw
            $('#searchRecycle').on('click', function() {
                table.ajax.reload(); // triggers DataTable's internal POST using the data function above
            });
        });
    </script>


<script>
$(document).ready(function() {
    function initializeSelect2() {
        $('.js-example-basic-single.select2').select2({
            dropdownParent: $('#listModal')
        });

       
        $('.select2-container').css({
            'width': '100%',
            'display': 'block'
        });
        $('.select2-selection').css({
            'height': '38px',
            'border': '1px solid #ced4da',
            'border-radius': '4px'
        });
    }

    $('#listModal').on('shown.bs.modal', function() {
        initializeSelect2(); 
    });

    if ($('#listModal').hasClass('show')) {
        initializeSelect2();
    }
});
</script>

<style>
.select2-container {
    width: 100% !important;
}
.select2-selection--single {
    height: 38px !important; 
    display: flex;
    align-items: center;
}
.select2-selection__rendered {
    line-height: 36px !important;
}
.select2-selection__arrow {
    height: 36px !important;
}
</style>


@endsection
