

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Smart Phone Platform For Businesses | 2FA</title>

  <!-- Font Awesome for icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: 'Segoe UI', sans-serif;
    }

    body {
      background: url('bg.png') no-repeat center center/cover;
      height: 100vh;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      position: relative;
    }
      .logo {
      width: 140px;
      margin-bottom: 30px;
    }
.otp-input {
  width: 50px;
  height: 55px;
  font-size: 22px;
  font-weight: bold;
  text-align: center;
  border: 2px solid #ddd;
  border-radius: 8px;
  transition: border-color 0.2s ease;
}

.otp-input:focus {
  border-color: #007bff;
  outline: none;
  box-shadow: 0 0 5px rgba(0,123,255,0.5);
}
    .login-card {
      background-color: white;
      padding: 40px;
      border-radius: 25px;
      width: 100%;
      max-width: 420px; 
      box-shadow: 0 25px 60px rgba(0, 0, 0, 0.25);
      text-align: center;
    }
 .login-card h2 {
      color: #1b1b4f;
      margin-bottom: 10px;
      font-size: 24px;
    }

    .login-card p {
      font-size: 14px;
      color: #555;
      margin-bottom: 25px;
    }

    .input-box {
      position: relative;
      margin-bottom: 20px;
    }

    .input-box input {
      width: 100%;
      padding: 12px 15px 12px 40px;
      border-radius: 10px;
      border: 1px solid #ccc;
      font-size: 15px;
      outline: none;
    }

    .input-box i {
      position: absolute;
      top: 50%;
      left: 12px;
      transform: translateY(-50%);
      color: #999;
      font-size: 14px;
    }
  .login-btn {
      width: 100%;
      padding: 12px;
      background: linear-gradient(to right, #00294d, #0b3a6f);
      color: white;
      font-weight: bold;
      font-size: 14px;
      border: none;
      border-radius: 8px;
      margin-top: 10px;
      cursor: pointer;
      transition: background 0.3s ease;
    }

    .login-btn:hover {
      background: linear-gradient(to right, #001f3a, #082d54);
    }
       .alert {
            margin-bottom:15px;
            padding:10px;
            border-radius:8px;
            font-size:14px;
        }
        .alert-success{background:#d4edda;color:#155724;}
        .alert-danger{background:#f8d7da;color:#721c24;}
    </style>


    <style>
        .scrollable-container {
            height: 100vh;
            overflow-y: auto;
            scrollbar-width: none;
            -ms-overflow-style: none;
        }

        .scrollable-container::-webkit-scrollbar {
            display: none;
        }
        
    </style>
<style>/* Apply blur effect to body when submitting */
body.blurred {
    filter: blur(5px);
    pointer-events: none;
    user-select: none;
}

/* Overlay background during blur */
#blur-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    backdrop-filter: blur(8px);
    background-color: rgba(255, 255, 255, 0.6);
    display: none;
    align-items: center;
    justify-content: center;
    z-index: 9999;
}

/* Loading text or spinner */
.loading-text {
    font-size: 1.5rem;
    font-weight: bold;
    color: #333;
}
</style>
    <div class="account-content login-card">
        <div class="d-flex flex-wrap w-100">
            <div class="d-flex align-items-center justify-content-center flex-fill flex-wrap vh-100">
             
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-md-5">
                            <div class="login-content user-login">


                                <div class="mx-auto mw-600 mb-2">
                                
<div class="card border p-sm-3">
    <div class="card-body p-4">

    <div class="col-md-12">
    <div class="alert alert-danger"  style="display: none"></div>
    <div class="alert alert-success"  style="display: none"></div>
    @if(session()->has('message'))
        <div class="alert alert-danger">
            {{ session()->get('message') }}
            {{ session()->forget('message') }}
            {{ session()->save() }}
        </div>
    @endif
    @if(session()->has('success'))
        <div class="alert alert-success">
            {{ session()->get('success') }}
            {{ session()->forget('success') }}
            {{ session()->save() }}
        </div>
    @endif
    @if (count($errors) > 0 or session()->has('error-title'))
        <div class="alert alert-danger">
            @if(session()->has('error-title'))
                {{ session()->get('error-title') }}
                {{ session()->forget('error-title') }}
                {{ session()->save() }}
            @endif
            @if (count($errors) > 0)
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            @endif
        </div>
    @endif
</div>

                                    <div class="card border p-sm-3">
                                        <div class="card-body p-4" >
                                           
                                                <div class="mb-4">
                                                    <h4 class="mb-2 fs-20">Login With Your Email</h4><br>
                                                    <!-- <p>Scan the QR code below with your Google Authenticator app.</p><br> -->
                                                    <div class="my-3 d-flex justify-content-center">
                                                        <div class="p-3 bg-white border rounded shadow"
                                                            style=" display: flex; align-items: center; justify-content: center;">
                                                        @if (session('qrCode'))
                                                            <div>{!! session('qrCode') !!}</div>
                                                          @endif
                                                        </div>
                                                    </div>



                                                    {{-- <p class="my-4 d-flex justify-content-center">Secret Key:
                                                <strong>{{ session('secret') }}</strong></p> --}}
                                                </div>
                                          
                                            <form method="POST">
                                                @csrf
                                                <div class="mb-3">
                                                    <label for="code"
                                                        class="col-form-label text-md-end text-start">Enter
                                                        the 6-digit Google Authenticator
                                                        code </label>

                                                    <input type="hidden" id="code" name="code" maxlength="6"
                                                        class="form-control @error('code') is-invalid @enderror">
                                                    @if ($errors->has('code'))
                                                        <span class="text-danger">{{ $errors->first('code') }}</span>
                                                    @endif

                                                </div>

                                                <div id="otp_status"></div>

                                                <input type="hidden"id=email value="">
                                                <div class="d-flex align-items-center mb-4">


                                                    <input class="otp-input border rounded w-100 py-sm-3 py-2 text-center fs-26
                                                        hw-bold" type="hidden" name="otp" required>


                                                </div>

                                                <input type="hidden"id=email value="">
                                                <div class="d-flex align-items-center mb-4">
                                                    <input type="text"
                                                        class="otp-input border rounded w-100 py-sm-3 py-2 text-center fs-26 hw-bold me-3"
                                                        id="digit-1" name="digit1" data-next="digit-2" required
                                                        maxlength="1">
                                                    <input type="text"
                                                        class="otp-input border rounded w-100 py-sm-3 py-2 text-center fs-26 hw-bold me-3"
                                                        id="digit-2" name="digit2" data-next="digit-3" required
                                                        data-previous="digit-1" maxlength="1">
                                                    <input type="text"
                                                        class="otp-input border rounded w-100 py-sm-3 py-2 text-center fs-26 hw-bold me-3"
                                                        id="digit-3" name="digit3" data-next="digit-4" required
                                                        data-previous="digit-2" maxlength="1">
                                                    <input type="text"
                                                        class="otp-input border rounded w-100 py-sm-3 py-2 text-center fs-26 hw-bold me-3"
                                                        id="digit-4" name="digit4" data-next="digit-5" required
                                                        data-previous="digit-3" maxlength="1">
                                                    <input type="text"
                                                        class="otp-input border rounded w-100 py-sm-3 py-2 text-center fs-26 hw-bold me-3"
                                                        id="digit-5" name="digit5" data-next="digit-6" required
                                                        data-previous="digit-4" maxlength="1">
                                                    <input type="text"
                                                        class="otp-input border rounded w-100 py-sm-3 py-2 text-center fs-26 hw-bold me-3"
                                                        id="digit-6" name="digit6" data-next="digit-7" required
                                                        data-previous="digit-5" maxlength="1">
                                                </div>

                                                <div class="mb-3">

                                                    <button type="submit" class="btn btn-primary w-100 login-btn ">Verify</button>

                                                </div>

                                            </form>
                                        </div>
                                    </div>

                                </div>
                            </div>

                         

                        </div>
                    </div>
                </div>
            </div>

<script>
document.addEventListener("DOMContentLoaded", function() {
    const inputs = document.querySelectorAll(".otp-input[type='text']");
    const form = document.querySelector("form");
    const hiddenOtpInput = document.querySelector("input[name='otp']");

    // Create blur overlay dynamically
    const blurOverlay = document.createElement('div');
    blurOverlay.id = 'blur-overlay';
    blurOverlay.innerHTML = `<div class="loading-text">Verifying...</div>`;
    document.body.appendChild(blurOverlay);
    blurOverlay.style.display = "none";

    // Focus on first input when page loads
    if (inputs.length > 0) inputs[0].focus();

    inputs.forEach((input, index) => {
        // ✅ Restrict to digits only
        input.addEventListener("input", function(e) {
            this.value = this.value.replace(/[^0-9]/g, ''); // remove non-digit chars

            if (this.value.length === 1 && index < inputs.length - 1) {
                inputs[index + 1].focus();
            }

            const otp = Array.from(inputs).map(i => i.value).join('');
            if (otp.length === 6) {
                hiddenOtpInput.value = otp;
                blurOverlay.style.display = "flex"; // show blur overlay
                document.body.classList.add('blurred');
                setTimeout(() => form.submit(), 300);
            }
        });

        // ✅ Allow backspace navigation
        input.addEventListener("keydown", function(e) {
            if (e.key === "Backspace" && this.value === '' && index > 0) {
                inputs[index - 1].focus();
            }
        });

        // ✅ Block any non-digit key presses
        input.addEventListener("keypress", function(e) {
            if (!/[0-9]/.test(e.key)) {
                e.preventDefault();
            }
        });
    });
});
</script>



            <!-- <script>
                document.addEventListener('DOMContentLoaded', function() {
                    const inputs = document.querySelectorAll('.otp-input');

                    inputs.forEach((input) => {
                        input.addEventListener('input', (e) => {
                            if (e.target.value.length === 1) {
                                const nextInput = document.getElementById(input.dataset.next);
                                if (nextInput) {
                                    nextInput.focus();
                                }
                            }
                        });

                        input.addEventListener('keydown', (e) => {
                            if (e.key === "Backspace") {
                                const currentInput = e.target;
                                const previousInput = document.getElementById(currentInput.dataset
                                    .previous);

                                if (currentInput.value !== '') {
                                    currentInput.value = '';
                                    if (previousInput) {
                                        previousInput.focus();
                                    }
                                    e.preventDefault();
                                } else if (previousInput) {
                                    previousInput.focus();
                                    previousInput.select();
                                    e.preventDefault();
                                }
                            }
                        });

                        input.addEventListener('focus', (e) => {
                            e.target.select();
                        });
                    });
                });
            </script> -->





      
</body>
</html>
