<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.site') }} OTP Login | Access Your AI Call Management Dashboard</title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1" name="viewport">

    <link rel="stylesheet" href="{{asset('assets/css/vendors_css.css')}}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

    <style>
       <style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
        font-family: 'Segoe UI', sans-serif;
    }

    body {
        background: url('bg.png') no-repeat center center/cover;
        height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .login-card {
        background: #fff;
        padding: 40px;
        border-radius: 25px;
        width: 100%;
        max-width: 420px;
        box-shadow: 0 25px 60px rgba(0, 0, 0, 0.25);
        text-align: center;
    }

    .login-card h2 {
        color: #1b1b4f;
        margin-bottom: 10px;
        font-size: 24px;
    }

    .login-card p {
        font-size: 14px;
        color: #555;
        margin-bottom: 25px;
    }

    .input-box {
        position: relative;
        margin-bottom: 20px;
    }

    .input-box input {
        width: 100%;
        padding: 12px 15px 12px 40px;
        border-radius: 10px;
        border: 1px solid #ccc;
        font-size: 15px;
        outline: none;
    }

    .input-box i {
        position: absolute;
        top: 50%;
        left: 12px;
        transform: translateY(-50%);
        color: #999;
        font-size: 14px;
    }

    .alert-danger {
        display: flex;
        align-items: center;
        gap: 8px;
        background-color: #ff5252 !important;
        color: #fff !important;
        border: none;
        border-radius: 12px;
        padding: 8px 14px;
        font-size: 14px;
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
        width: 100%;
        min-width: unset;
    }

    .alert-danger .close {
        order: -1;
        font-size: 20px;
        line-height: 1;
        margin-right: 6px;
        color: #000 !important;
        opacity: 0.9;
    }

    .alert-danger .close:hover {
        opacity: 1;
    }


    .card .alert-danger {
        position: absolute;
        top: -20px;
        left: 0;
        right: 0;
    }



    .login-btn {
        width: 100%;
        padding: 12px;
        background: linear-gradient(to right, #00294d, #0b3a6f);
        color: white;
        font-weight: bold;
        font-size: 14px;
        border: none;
        border-radius: 8px;
        margin-top: 10px;
        cursor: pointer;
        transition: background .3s ease;
    }

    .login-btn:hover {
        background: linear-gradient(to right, #001f3a, #082d54);
    }
.forgot-password{text-align:right;font-size:13px;margin-top:-15px;margin-bottom:15px;}
        .forgot-password a{color:#0b3a6f;text-decoration:none;}
        .forgot-password a:hover{text-decoration:underline;}
    </style>
</head>
<body>

    <div class="login-card">
        @include("layouts.messaging")

              <div class="text-center mb-1" style="margin-top:-25px">
                <img src="{{ url('/') }}{{ config('app.logo') }}?v={{ time() }}" alt="Logo"
                    class="img-fluid" style="max-width: 320px;">
            </div>

       <h2>Verify Your Email</h2>
        <p id="sign">A verification code has been sent to your Email- {{$email}} . Please enter the code
             below.</p>
          


        <form method="POST" action="{{url('verify-google-otp')}}">
            @csrf
            <div class="d-flex align-items-center mb-4">
                    <input type="text"
                        class="otp-input border rounded w-100 py-sm-3 py-2 text-center fs-26 hw-bold me-3" id="digit-1"
                        name="digit1" data-next="digit-2"  maxlength="1">
                    <input type="text"
                        class="otp-input border rounded w-100 py-sm-3 py-2 text-center fs-26 hw-bold me-3" id="digit-2"
                        name="digit2" data-next="digit-3"  data-previous="digit-1" maxlength="1">
                    <input type="text"
                        class="otp-input border rounded w-100 py-sm-3 py-2 text-center fs-26 hw-bold me-3" id="digit-3"
                        name="digit3" data-next="digit-4"  data-previous="digit-2" maxlength="1">
                    <input type="text"
                        class="otp-input border rounded w-100 py-sm-3 py-2 text-center fs-26 hw-bold me-3" id="digit-4"
                        name="digit4" data-next="digit-5"  data-previous="digit-3" maxlength="1">
                    <input type="text"
                        class="otp-input border rounded w-100 py-sm-3 py-2 text-center fs-26 hw-bold me-3" id="digit-5"
                        name="digit5" data-next="digit-6"  data-previous="digit-4" maxlength="1">
                    <input type="text"
                        class="otp-input border rounded w-100 py-sm-3 py-2 text-center fs-26 hw-bold me-3" id="digit-6"
                        name="digit6" data-next="digit-7"  data-previous="digit-5" maxlength="1">
                </div>

        <div class="forgot-password">
    <button type="submit" name="action" value="resend" id="resend-btn" style="display:none;">
        Resend
    </button>
    <span id="timer" style="margin-left:10px; font-weight:600; color:red;"></span>
</div>
  
            <a id="login" href=""> <button type="submit"  name="action" value="verify" class="btn btn-primary w-100">Verify</button></a>
        </form>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const inputs = document.querySelectorAll('.otp-input');
            inputs.forEach(input => {
                input.addEventListener('input', e => {
                    if (e.target.value.length === 1) {
                        const nextInput = document.getElementById(input.dataset.next);
                        if (nextInput) nextInput.focus();
                    }
                });
                input.addEventListener('keydown', e => {
                    if (e.key === "Backspace" && !e.target.value) {
                        const prevInput = document.getElementById(input.dataset.previous);
                        if (prevInput) prevInput.focus();
                    }
                });
            });
        });
    </script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        let countdown = 120; // 2 minutes in seconds
        let timerEl = document.getElementById("timer");
        let resendBtn = document.getElementById("resend-btn");

        let interval = setInterval(function () {
            let minutes = Math.floor(countdown / 60);
            let seconds = countdown % 60;

            // Format 2-digit seconds
            seconds = seconds < 10 ? "0" + seconds : seconds;

            timerEl.textContent = minutes + ":" + seconds;

            countdown--;

            if (countdown < 0) {
                clearInterval(interval);
                timerEl.textContent = ""; // remove timer text
                resendBtn.style.display = "inline-block"; // show button
            }
        }, 1000);
    });
</script>
</body>
</html>
