<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Smart Phone Platform For Businesses | Login</title>

  <!-- Font Awesome for icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: 'Segoe UI', sans-serif;
    }

    body {
      background: url('bg.png') no-repeat center center/cover;
      height: 100vh;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      position: relative;
    }

    .logo {
      width: 140px;
      margin-bottom: 30px;
    }

    .login-card {
      background-color: white;
      padding: 40px;
      border-radius: 25px;
      width: 100%;
      max-width: 420px; 
      box-shadow: 0 25px 60px rgba(0, 0, 0, 0.25);
      text-align: center;
    }

    .login-card h2 {
      color: #1b1b4f;
      margin-bottom: 10px;
      font-size: 24px;
    }

    .login-card p {
      font-size: 14px;
      color: #555;
      margin-bottom: 25px;
    }

    .input-box {
      position: relative;
      margin-bottom: 20px;
    }

    .input-box input {
      width: 100%;
      padding: 12px 15px 12px 40px;
      border-radius: 10px;
      border: 1px solid #ccc;
      font-size: 15px;
      outline: none;
    }

    .input-box i {
      position: absolute;
      top: 50%;
      left: 12px;
      transform: translateY(-50%);
      color: #999;
      font-size: 14px;
    }

    .forgot-password {
      text-align: right;
      font-size: 13px;
      margin-top: -15px;
      margin-bottom: 15px;
    }

    .forgot-password a {
      color: #0b3a6f;
      text-decoration: none;
    }

    .forgot-password a:hover {
      text-decoration: underline;
    }

    .login-btn {
      width: 100%;
      padding: 12px;
      background: linear-gradient(to right, #00294d, #0b3a6f);
      color: white;
      font-weight: bold;
      font-size: 14px;
      border: none;
      border-radius: 8px;
      margin-top: 10px;
      cursor: pointer;
      transition: background 0.3s ease;
    }

    .login-btn:hover {
      background: linear-gradient(to right, #001f3a, #082d54);
    }

    .social-login {
      margin-top: 25px;
    }

    .social-login p {
      font-size: 14px;
      color: #666;
      margin-bottom: 12px;
    }

    .social-icons {
      display: flex;
      justify-content: center;
      gap: 18px;
    }

    .social-icons a {
      width: 42px;
      height: 42px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 18px;
      color: white;
      text-decoration: none;
    }

    .facebook { background: #3b5998; }
    .google   { background: #dd4b39; }
    .twitter  { background: #1da1f2; }

    @media (max-width: 500px) {
      .logo {
        width: 100px;
      }

      .login-card {
        padding: 30px 20px;
        border-radius: 20px;
      }
    }
  </style>
</head>
<body>


  <div class="login-card">
    <h2>Portal Login</h2>
    <p>Sign in to start your session.</p>

    <form>
      <div class="input-box">
        <i class="fas fa-user"></i>
        <input type="text" placeholder="Username" required>
      </div>
      <div class="input-box">
        <i class="fas fa-lock"></i>
        <input type="password" placeholder="Password" required>
      </div>

      <!-- Forgot Password -->
      <div class="forgot-password">
        <a href="#">Forgot Password?</a>
      </div>

      <button type="submit" class="login-btn">SIGN IN</button>
    </form>

    <div class="social-login">
      <p>Or sign in with</p>
      <div class="social-icons">
        <a href="#" class="facebook"><i class="fab fa-facebook-f"></i></a>
        <a href="#" class="google"><i class="fab fa-google"></i></a>
        <a href="#" class="twitter"><i class="fab fa-x-twitter"></i></a>

      </div>
    </div>
  </div>

</body>
</html>
