<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
<title>{{ config('app.site') }} Recover Password | Access Your AI Call Management Dashboard</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1"><!DOCTYPE html>

	<link rel="stylesheet" href="{{asset('assets/css/vendors_css.css')}}">
	  
	<!-- Style-->  
	<link rel="stylesheet" href="{{asset('assets/css/style.css')}}">
	<link rel="stylesheet" href="{{asset('assets/css/skin_color.css')}}">	
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <style>

       * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', sans-serif;
        }

        body {
            background: url('bg.png') no-repeat center center/cover;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .login-card {
            background: #fff;
            padding: 40px;
            border-radius: 25px;
            width: 100%;
            max-width: 420px;
            box-shadow: 0 25px 60px rgba(0, 0, 0, 0.25);
            text-align: center;
            position: relative;
        }

        .login-card h2 {
            color: #1b1b4f;
            margin-bottom: 10px;
            font-size: 24px;
        }

        .login-card p {
            font-size: 14px;
            color: #555;
            margin-bottom: 25px;
        }

        .input-box {
            position: relative;
            margin-bottom: 20px;
        }

        .input-box input {
            width: 100%;
            padding: 12px 15px 12px 40px;
            border-radius: 10px;
            border: 1px solid #ccc;
            font-size: 15px;
            outline: none;
        }

        .input-box i {
            position: absolute;
            top: 50%;
            left: 12px;
            transform: translateY(-50%);
            color: #999;
            font-size: 14px;
        }

        .alert-danger {
            display: flex;
            align-items: center;
            gap: 8px;
            background-color: #ff5252 !important;
            color: #fff !important;
            border: none;
            border-radius: 12px;
            padding: 8px 14px;
            font-size: 14px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
            width: 100%;
            min-width: unset;
            margin-bottom: 15px;
        }

        .alert-danger .close {
            order: -1;
            font-size: 20px;
            line-height: 1;
            margin-right: 6px;
            color: #000 !important;
            opacity: 0.9;
        }

        .login-btn {
            width: 100%;
            padding: 12px;
            background: linear-gradient(to right, #00294d, #0b3a6f);
            color: white;
            font-weight: bold;
            font-size: 14px;
            border: none;
            border-radius: 8px;
            margin-top: 10px;
            cursor: pointer;
            transition: background .3s ease;
        }

        .login-btn:hover {
            background: linear-gradient(to right, #001f3a, #082d54);
        }

        .loading {
            position: absolute;
            color: White;
            top: 50%;
            left: 45%;
        }
</style>
</head>
<body class="hold-transition theme-primary bg-img"style="background-image: url('{{ asset('assets/images/auth-bg/bg-2.jpg') }}');" >
<div class="container h-p70 ">
		<div class="row align-items-center justify-content-md-center h-p100">
        @include("layouts.messaging")
        <div id="errorMessage"></div>
	
            <div class="login-card">

                       <div class="text-center mb-1" style="margin-top:-25px">
                <img src="{{ url('/') }}{{ config('app.logo') }}?v={{ time() }}" alt="Logo"
                    class="img-fluid" style="max-width: 320px;">
            </div>

        @include("layouts.messaging")
        <div id="errorMessage"></div>

        <h2>Recover Password</h2>
        <p>Please enter your new password below to reset your account password.</p>

        <div class="form-group hidediv">
            <p class="loading" style="display: none;">
                <img style="width:50px;" src="{{ asset('asset/img/loader.gif') }}"/>
            </p>
        </div>

        <form method="POST" action="{{url('resetPasswordUserMobile')}}">
            @csrf
            <div class="input-box hidediv">
                <i class="fas fa-lock"></i>
                <input type="password" id="newpassword" name="password" placeholder="New Password" required pattern="(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{6,}"
               title="Password must be at least 6 characters, include uppercase, lowercase, number and special character">
            </div>

            <div class="input-box hidediv">
                <i class="fas fa-lock"></i>
                <input type="password" id="confirmpassword" name="password_confirmation" placeholder="Confirm Password" required pattern="(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{6,}"
               title="Password must be at least 6 characters, include uppercase, lowercase, number and special character">
            </div>

            <button type="submit" class="login-btn">Update</button>
        </form>
    </div>
		</div>
	</div>	


<script src="{{asset('assets/js/vendors.min.js')}}"></script>
	<script src="{{asset('assets/js/pages/chat-popup.js')}}"></script>
    <script src="{{asset('assets/icons/feather-icons/feather.min.js')}}"></script>	
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(function () {
        $('input').iCheck({
            checkboxClass: 'icheckbox_square-blue',
            radioClass: 'iradio_square-blue',
            increaseArea: '20%' // optional
        });
    });
</script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $('form').submit(function(event) {
                var newPassword = $('#newpassword').val();
                var confirmPassword = $('#confirmpassword').val();

                if (newPassword !== confirmPassword) {
                    event.preventDefault();
                    $('#errorMessage').html('<div class="alert alert-danger">New Password and Confirm Password must match</div>');
                }
            });
            $('#newpassword, #confirmpassword').on('input', function() {
            $('#errorMessage').empty();
        });
        });
      


 


  
    // Removing sipML credentials & settings
    localStorage.removeItem("org.doubango.identity.display_name");
    localStorage.removeItem("org.doubango.identity.impi");
    localStorage.removeItem("org.doubango.identity.impu");
    localStorage.removeItem("org.doubango.identity.password");
    localStorage.removeItem("org.doubango.identity.realm");
    localStorage.removeItem("org.doubango.expert.websocket_server_url");
    localStorage.removeItem("org.doubango.expert.disable_video");
    localStorage.removeItem("org.doubango.expert.enable_rtcweb_breaker");
    localStorage.removeItem("org.doubango.expert.sip_outboundproxy_url");
    localStorage.removeItem("org.doubango.expert.ice_servers");
    localStorage.removeItem("org.doubango.expert.bandwidth");
    localStorage.removeItem("org.doubango.expert.video_size");
    localStorage.removeItem("org.doubango.expert.disable_early_ims");
    localStorage.removeItem("org.doubango.expert.disable_debug");
    localStorage.removeItem("org.doubango.expert.enable_media_caching");
    localStorage.removeItem("org.doubango.expert.disable_callbtn_options");

</script>

<script>
    function disableSubmitButton() {
        document.getElementById("submitButton").disabled = true;
    }
</script>
</body>
</html>

	