<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
     <title>Register on {{ config('app.site') }} | Sign Up for AI Call & Workflow Automation</title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

    <link rel="stylesheet" href="{{asset('assets/css/vendors_css.css')}}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">


<style>
body {
    display: flex;
    align-items: center;
    justify-content: center;
    min-height: 100vh;
    margin: 0;
    background: #f6f7fb;
    /* background: url('bg.png') no-repeat center center/cover; */
}



/* Shapes fixed position */
.login-shapes .login-left-shape,
.login-shapes .login-right-shape {
    position: fixed;
    z-index: -1;
}

.login-shapes .login-left-shape {
    top: 0;
    left: 0;
}

.login-shapes .login-right-shape {
    bottom: 0;
    right: 0;
}

/* Card */
.login-card {
    background: #fff;
    padding: 30px 40px;
    border-radius: 20px;
    width: 100%;
    max-width: 510px;   
    box-shadow: 0 12px 28px rgba(0,0,0,0.15);
    text-align: center;
    margin: 20px;
    position: relative;
    z-index: 10;
}


.input-box i:first-child {
    position: absolute;
    top: 50%;
    left: 12px;
    transform: translateY(-50%);
    color: #777;
    font-size: 15px;
}


.input-box {
    position: relative;
    margin-bottom: 18px;
}

.input-box input {
    width: 100%;
    padding: 12px 40px 12px 38px;
    border-radius: 8px;
    border: 1px solid #ccc;
    font-size: 15px;
    outline: none;
}

.input-box .toggle-eye {
    position: absolute;
    top: 50%;
    right: 12px;    
    transform: translateY(-50%);
    cursor: pointer;
    color: #555;
    font-size: 16px;
}


/* Checkbox */
.login-card .terms {
    display: flex;
    align-items: center;
    font-size: 12px;
    margin-bottom: 10px;
    justify-content: flex-start;
}
.login-card .terms input {
    margin-right: 6px;
}

/* Buttons */
.login-btn {
    width: 100%;
    padding: 12px;
    background: #E41F07 !important;
    color: #fff;
    font-weight: 600;
    font-size: 15px;
    border: none;
    border-radius: 6px;
    cursor: pointer;
    transition: background .3s ease;
}
.login-btn:hover {
    background: #c62828;
}

/* Social Section */
.social-login {
    margin-top: 8px;
}
.social-login p {
    font-size: 12px;
    margin-bottom: 4px;
}


/* Login link */
.login-card .alt-login {
    margin-top: 8px;
    font-size: 12px;
}
.login-card .alt-login a {
    color: #e63946;
    font-weight: bold;
    text-decoration: none;
}


/* Social login */
.social-login {
    margin-top: 20px;
}
.social-login p {
    font-size: 14px;
    margin-bottom: 10px;
}
.social-icons {
    display: flex;
    justify-content: center;
    gap: 12px;
}
.social-icons a {
    flex: 1;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    height: 42px;
    border-radius: 6px;
    font-size: 14px;
    font-weight: 500;
    text-decoration: none;
}
.social-icons a.facebook {
    background: #3b5998;
    color: #fff;
}
.social-icons a.google {
    background: #fff;
    color: #000;
    border: 1px solid #ddd;
}
.social-icons a.google img {
    width: 20px;
    height: 20px;
}
.social-icons a.twitter {
    background: #000;
    color: #fff;
}



        /* .login-card h2{color:#1b1b4f;margin-bottom:10px;font-size:24px;}
        .login-card p{font-size:14px;color:#555;margin-bottom:25px;}
        .input-box{position:relative;margin-bottom:20px;}
        .input-box input{
            width:100%;
            padding:12px 15px 12px 40px;
            border-radius:10px;
            border:1px solid #ccc;
            font-size:15px;
            outline:none;
        }
        .input-box i{
            position:absolute;
            top:50%;
            left:12px;
            transform:translateY(-50%);
            color:#999;
            font-size:14px;
        }
        .login-btn{
            width:100%;
            padding:12px;
            background:linear-gradient(to right,#00294d,#0b3a6f);
            color:white;
            font-weight:bold;
            font-size:14px;
            border:none;
            border-radius:8px;
            margin-top:10px;
            cursor:pointer;
            transition:background .3s ease;
        }
        .login-btn:hover{background:linear-gradient(to right,#001f3a,#082d54);} */
        .forgot-password{text-align:right;font-size:13px;margin-top:-15px;margin-bottom:15px;}
        .forgot-password a{color:#0b3a6f;text-decoration:none;}
        .forgot-password a:hover{text-decoration:underline;}
        @media(max-width:500px){
            .login-card{padding:30px 20px;border-radius:20px;}
        }

        /* Loader */
        #loader {
            display:none;
            position:absolute;
            top:0;left:0;right:0;bottom:0;
            background:rgba(255,255,255,0.85);
            border-radius:25px;
            z-index:99;
            align-items:center;
            justify-content:center;
        }
        .spinner {
            width:40px;
            height:40px;
            border:4px solid #ddd;
            border-top:4px solid #00294d;
            border-radius:50%;
            animation:spin 0.8s linear infinite;
        }
        @keyframes spin {100%{transform:rotate(360deg);}}
        .alert {
            margin-bottom:15px;
            padding:10px;
            border-radius:8px;
            font-size:14px;
        }
        .alert-success{background:#d4edda;color:#155724;}
        .alert-danger{background:#f8d7da;color:#721c24;}

        /* OTP input */
        .otp-box{
            display:flex;
            justify-content:space-between;
            gap:8px;
            margin-bottom:20px;
        }
        .otp-input{
            width:45px;
            height:50px;
            border:1px solid #ccc;
            border-radius:8px;
            font-size:20px;
            font-weight:bold;
            text-align:center;
        }
           .login-card-mobile{
            background:#fff;
            padding:40px;
            border-radius:25px;
            width:100%;
            max-width:420px;
            box-shadow:0 25px 60px rgba(0,0,0,0.25);
            text-align:center;
            position:relative;
        }
        .login-card-mobile h2{color:#1b1b4f;margin-bottom:10px;font-size:24px;}
        .login-card-mobile p{font-size:14px;color:#555;margin-bottom:25px;}


        .social-login{margin-top:25px;}
        .social-login p{font-size:14px;color:#666;margin-bottom:12px;}
        /* .social-icons{display:flex;justify-content:center;gap:18px;}
        .social-icons a{
            width:42px;height:42px;border-radius:50%;
            display:flex;align-items:center;justify-content:center;
            font-size:18px;color:#fff;text-decoration:none;
        }
        .facebook{background:#3b5998;}
        .google{background:#dd4b39;}
        .twitter{background:#1da1f2;} */


        #resendOtpBtn {
    background:#ccc !important;
    color: #fff !important;
    cursor: not-allowed;
    padding: 8px 16px;
    border-radius: 8px;
    border: none;
    transition: background 0.3s ease;
}

#resendOtpBtn:enabled {
    background: #28a745 !important;
    cursor: pointer;
}



@media (max-width: 1024px) {
    .login-shapes .login-left-shape,
    .login-shapes .login-right-shape {
        display: none;
    }
}

@media (max-width: 768px) {
    .login-shapes .login-left-shape,
    .login-shapes .login-right-shape {
        display: none;
    }

    body, .login-page {
        height: auto;
        display: block;
        padding: 20px 15px;
        overflow: auto;
    }

    .login-card {
        margin: 20px auto;
    }

}



    </style>

</head>
<body>

    <div id="loader"><div class="spinner"></div></div>
<div class="login-card" id="registerCard">

<div class="login-shapes">
    <!-- Left Purple Shape -->
    <div class="login-left-shape">
        <img src="assets/images/auth-bg/shape-01.png" alt="Shape Left">
    </div>
    <!-- Right Orange Shape -->
    <div class="login-right-shape">
        <img src="assets/images/auth-bg/shape-02.png" alt="Shape Right">
    </div>
</div>
   <div class="text-center mb-1" style="margin-top:-31px">
            <img src="{{ url('/') }}{{ config('app.logo') }}?v={{ time() }}" alt="Logo" class="img-fluid"
                style="max-width: 340px;">
        </div>


     <div id="registerHeader">
      <h2 id="formTitle" style="margin-top: 10px; margin-bottom: 3px; font-weight: 700; font-size: 1.5rem;">Register</h2>
      <p id="formSubtitle" style="margin-top: 0;">Create your account</p>
  </div>

   <div id="responseMessage">
</div>







    <!-- Register Form -->
    <form id="registerForm">
        @csrf
        <div class="input-box">
            <i class="fas fa-user"></i>
            <input id="name" type="text" name="name" placeholder="Name" required>
        </div>


        <div class="input-box">
            <i class="fas fa-envelope"></i>
            <input id="email" type="email" name="email" placeholder="Email" required>
        </div>
        <div class="input-box">
            <i class="fas fa-building"></i>
            <input id="company_name" type="text" name="company_name" placeholder="Company Name" required>

        </div>
          <div class="input-box">
            <i class="fas fa-lock"></i>
            <input id="password" type="password" name="password" placeholder="Password" style="cursor: text !important;" required>
              <i class="fas fa-eye-slash toggle-eye" onclick="togglePassword('password', this)"></i>

        </div>
         <div class="input-box">
            <i class="fas fa-lock"></i>
            <input id="confirm_password" type="password" name="password_confirmation" placeholder="Confirm Password" style="cursor: text !important;" required>
             <i class="fas fa-eye-slash toggle-eye" onclick="togglePassword('confirm_password', this)"></i>

        </div>


        <div class="d-flex justify-content-between align-items-end mb-3">
            {{-- reCAPTCHA Widget --}}
            <div class="captcha-wrapper">
                {!! NoCaptcha::display() !!}
                @if ($errors->has('g-recaptcha-response'))
                    <span class="text-danger">{{ $errors->first('g-recaptcha-response') }}</span>
                @endif
            </div>

            <!-- {{-- Login Link --}}
            <div class="forgot-password ms-3">
                <a href="{{ url('/') }}">Login</a>
            </div> -->
        </div>

<style>
.terms-check {
    display: flex !important;
    align-items: center !important;
    gap: 4px !important;
    margin: 0 !important;
    padding: 0 !important;
}

.terms-check .form-check-input {
    cursor: pointer !important;
    margin: 0 !important;
    width: 16px !important;
    height: 16px !important;
}

.terms-check .form-check-label {
    cursor: pointer !important;
    margin: 0 !important;
    font-size: 16px !important;
}

</style>

<!-- Terms & Conditions Checkbox -->
<div class="form-check mb-3 terms-check">
    <input class="form-check-input" type="checkbox" id="terms" required>
    <label class="form-check-label" for="terms">
        I agree to the <a href="{{ url('/terms-services') }}" target="_blank">Terms & Conditions</a>
    </label>
</div>


        <button type="submit" class="login-btn">SIGN UP</button>

  <div class="mt-2">
    {{-- Login Link --}}
    <p style="margin: 0; text-align: left; font-weight: 600; font-size: 14px; color: #444;">
        Already have an account?
        <a href="{{ url('/login') }}"
           class="link-hover forgot-password"
           style="margin-left: 4px; font-weight: 700; color: #5A2EFF; text-decoration: none;">
           Login Instead
        </a>
    </p>
</div>


           <div class="social-login mb-3">
                <p>Or sign in with</p>
        <div class="social-icons">
        <a href="#" class="facebook"><i class="fab fa-facebook-f"></i></a>
        <a href="{{url('auth/google/redirect')}}" class="google">
            <img src="https://developers.google.com/identity/images/g-logo.png" alt="Google">
        </a>
        <a href="#" class="twitter"><i class="fab fa-x-twitter"></i></a>
    </div>
            </div>

        <div class="text-center text-muted large mt-3">
           Copyright &copy; 2025 - {{ config('app.site') }}
        </div>
    </form>

</div>

    <!-- OTP Verify Form (hidden initially) -->
<style>
   .otp-input {
    width: 48px;
    height: 52px;
    border: 1px solid #ccc;
    border-radius: 10px;
    font-size: 20px;
    font-weight: bold;
    text-align: center;
    outline: none;
    transition: border-color .3s ease;
}
.otp-input:focus {
    border-color: #0b3a6f;
    box-shadow: 0 0 6px rgba(11,58,111,0.3);
}


.login-btn {
    width: 100%;
    padding: 12px;
    background: linear-gradient(to right,#00294d,#0b3a6f);
    color: white;
    font-weight: bold;
    font-size: 15px;
    border: none;
    border-radius: 8px;
    margin-top: 10px;
    cursor: pointer;
}



.login-btn {
    width: 100%;
    padding: 12px;
    background: linear-gradient(to right,#00294d,#0b3a6f);
    color: white;
    font-weight: bold;
    font-size: 15px;
    border: none;
    border-radius: 8px;
    margin-top: 10px;
    cursor: pointer;
}


</style>

<!-- OTP Verify Form -->
<form id="otpForm" style="display:none;">
    <div class="login-shapes">
    <!-- Left Purple Shape -->
    <div class="login-left-shape">
        <img src="assets/images/auth-bg/shape-01.png" alt="Shape Left">
    </div>
    <!-- Right Orange Shape -->
    <div class="login-right-shape">
        <img src="assets/images/auth-bg/shape-02.png" alt="Shape Right">
    </div>
</div>

    @csrf
    <!-- Centered Card -->
    <div class="login-card" style="max-width: 400px; margin: 40px auto; padding:30px 25px;">

     <div class="text-center mb-1" style="margin-top:-25px">
                <img src="{{ url('/') }}{{ config('app.logo') }}?v={{ time() }}" alt="Logo"
                    class="img-fluid" style="max-width: 320px;">
            </div>

        <!-- Emoji Avatar -->
        <div class="text-center mb-3" style="font-size:60px;">
            👤
        </div>
        <div id="responseMessageOtpForm"></div>

        <!-- Title -->
        <h2 style="color:#1b1b4f;margin-bottom:10px;text-align:center;">Verification</h2>
        <p style="font-size:14px;color:#555;margin-bottom:20px;text-align:center;">
            Enter the verification code we just sent you on your email address.
        </p>

        <!-- OTP Inputs -->
        <div class="otp-box" style="display:flex;gap:12px;justify-content:center;margin-bottom:20px;">
            <input type="text" class="otp-input" maxlength="1" inputmode="numeric">
            <input type="text" class="otp-input" maxlength="1" inputmode="numeric">
            <input type="text" class="otp-input" maxlength="1" inputmode="numeric">
            <input type="text" class="otp-input" maxlength="1" inputmode="numeric">
            <input type="text" class="otp-input" maxlength="1" inputmode="numeric">
            <input type="text" class="otp-input" maxlength="1" inputmode="numeric">
        </div>

        <!-- Verify Button -->
        <button type="submit" class="login-btn">VERIFY</button>

        <!-- Resend OTP -->
        <div id="resendSection" style="margin-top:16px;text-align:center;font-size:14px;">
            <span>If you didn’t receive a code?</span><br>
            <button type="button" id="resendOtpBtn" disabled
                style="margin-top:6px;padding:6px 14px;background:#ccc;border:none;
                       border-radius:6px;color:#666;font-weight:500;cursor:not-allowed;">
                Resend OTP (<span id="timer">120</span>s)
            </button>
        </div>

           <div class="text-center text-muted large mt-4">
                Copyright &copy; 2025 - {{ config('app.site') }}
            </div>

    </div>

   
</form>



<style>
#resendOtpBtnMobile:disabled {
  background: #ccc !important;
  cursor: not-allowed;
}


#resendOtpBtnMobile {
  background: green !important;
  color: white;
  cursor: pointer;
  padding: 8px 16px;
  border-radius: 8px;
  border: none;
}
</style>


<div class="login-shapes">
    <!-- Left Purple Shape -->
    <div class="login-left-shape">
        <img src="assets/images/auth-bg/shape-01.png" alt="Shape Left">
    </div>
    <!-- Right Orange Shape -->
    <div class="login-right-shape">
        <img src="assets/images/auth-bg/shape-02.png" alt="Shape Right">
    </div>
</div>




<div class="login-card-mobile" style="display:none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background:#fff; padding:32px; border-radius:16px; box-shadow:0 4px 12px rgba(0,0,0,0.2); text-align:center; width:90%; max-width:400px;">



     <div class="text-center mb-1" style="margin-top:-25px">
                <img src="{{ url('/') }}{{ config('app.logo') }}?v={{ time() }}" alt="Logo"
                    class="img-fluid" style="max-width: 320px;">
            </div>

       <h2 id="formTitleMoble"></h2>
    <p id="formSubtitleMobile"></p>


<!-- Mobile + SMS Avatar (SMS on top-right inside circle) -->
<div class="text-center mb-3">
    <div style="
        width: 70px;
        height: 70px;
        border: 2px solid #333;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
        margin: 0 auto;
    ">
        <i class="fas fa-mobile-alt" style="font-size:28px; color:#333;"></i>
        <i class="fas fa-comment" style="
            position: absolute;
            top: 8px;   /* thoda upar */
            right: 10px; /* thoda aur right */
            font-size:14px;
            color:#1e88e5;
        "></i>
    </div>
</div>








    <div id="responseMessageMobile"></div>
 <form id="otpFormMobile"style="display:none;">
    @csrf
    <p>Please enter the 6-digit OTP sent to your phone.</p>
    <div class="otp-box" style="display:flex;gap:8px;justify-content:center;margin-bottom:16px;">
        <input type="text" class="otp-input" id="digit-1-mobile" maxlength="1" inputmode="numeric" autocomplete="one-time-code">
        <input type="text" class="otp-input" id="digit-2-mobile" maxlength="1" inputmode="numeric">
        <input type="text" class="otp-input" id="digit-3-mobile" maxlength="1" inputmode="numeric">
        <input type="text" class="otp-input" id="digit-4-mobile" maxlength="1" inputmode="numeric">
        <input type="text" class="otp-input" id="digit-5-mobile" maxlength="1" inputmode="numeric">
        <input type="text" class="otp-input" id="digit-6-mobile" maxlength="1" inputmode="numeric">
    </div>


    <button type="submit" class="login-btn">VERIFY OTP</button>


    <!-- Resend OTP Section -->
<div id="resendSectionMobile" style="margin-top:16px;text-align:center;">
     <span>If you didn’t receive a code?</span><br>
    <button type="button" id="resendOtpBtnMobile" disabled
    style="background:#ccc;cursor:not-allowed;padding:8px 16px;border-radius:8px;border:none;"> Resend OTP (<span id="timerMobile">120</span>s) </button>
    </div>
      <div class="text-center text-muted large mt-4">
                Copyright &copy; 2025 - {{ config('app.site') }}
            </div>
    </div>
</form>





<style>
.phone-input-wrapper {
    display: flex;
    align-items: center;
    border: 1px solid #ccc;
    border-radius: 6px;
    overflow: hidden;
    max-width: 600px;
    margin: 0 auto;
}

.phone-input-wrapper select {
    border: none;
    outline: none;
    background: #f8f9fa;
    font-size: 14px;
    height: 38px;
    padding: 0 28px 0 8px;
    border-right: 1px solid #ccc;
    appearance: none;
    cursor: pointer;

    background-image: url("data:image/svg+xml;utf8,<svg fill='black' height='10' viewBox='0 0 24 24' width='10' xmlns='http://www.w3.org/2000/svg'><path d='M7 10l5 5 5-5z'/></svg>");
    background-repeat: no-repeat;
    background-position: right 8px center;
    background-size: 12px;
}



.phone-input-wrapper input {
    flex: 1;
    border: none;
    outline: none;
    font-size: 14px;
    padding: 0 8px;
    height: 38px;
    background: white;
}

.email-avatar {
    width: 48px;
    height: 48px;
    border-radius: 50%;
    background: #e3f2fd;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #2196f3;
    font-size: 22px;
    margin: 0 auto 8px;
}

</style>

<!-- Thank You Page (Initially Hidden) -->
<div id="thankYouPage" style="display:none; text-align:center; padding:40px; font-family: Arial, sans-serif;">

    <div style="max-width:500px; margin:0 auto; background:#fff; border-radius:16px; padding:32px; box-shadow:0 4px 12px rgba(0,0,0,0.1);">

        <!-- Logo -->
       <div class="text-center mb-1" style="margin-top:-25px">
                <img src="{{ url('/') }}{{ config('app.logo') }}?v={{ time() }}" alt="Logo"
                    class="img-fluid" style="max-width: 320px;">
            </div>

        <!-- Success Icon -->
        <!-- <div style="background:#4caf50; width:60px; height:60px; border-radius:50%; margin:20px auto; display:flex; align-items:center; justify-content:center;">
            <span style="font-size:32px; color:#fff;">✔</span>
        </div> -->

        <div class="email-avatar">
  <i class="fa fa-envelope"></i>
</div>


        <!-- Heading -->
        <h3 style="color:#333; margin-bottom:12px;">Email Verified Successfully!</h3>

        <!-- Message -->
        <!-- <p style="color:#666; font-size:15px; line-height:1.5; margin-bottom:20px;">
            Thank you for verifying your email address. Please enter phone number below for further processing.
        </p> -->

        <!-- Phone Form -->
    <div id="responseMessageMobileError"></div>

        <form id="phonesubmit" method="post" style="margin-bottom:20px;">
            @csrf
            <div class="phone-input-wrapper">
                <select id="countryCode" name="countryCode" required>                 
                                <option value="+1" selected>US +1</option>
                                    <option value="+91">IN +91</option>
                                    <option value="+44">GB +44</option>
                                    <option value="+61">AU +61</option>
                                    <option value="+49">DE +49</option>
                                    <option value="+33">FR +33</option>
                                    <option value="+81">JP +81</option>
                                    <option value="+82">KR +82</option>
                                    <option value="+39">IT +39</option>
                                    <option value="+55">BR +55</option>
                                    <option value="+7">RU +7</option>
                                    <option value="+86">CN +86</option>
                                    <option value="+27">ZA +27</option>
                                    <option value="+34">ES +34</option>
                                    <option value="+46">SE +46</option>
                </select>
                <input id="phone" type="text" name="phone" placeholder="Phone" required
                       style="flex:1; border:none; outline:none; font-size:14px; height:36px;">
            </div>
            <button type="submit" class="login-btn" id="phone_submit" style="margin-top:20px; width:100%;">
                Submit
            </button>
        </form>

        <!-- Back to Login Button -->
    <button onclick="window.location.href='{{ url('/') }}'"
        style="background:#4CAF50; color:#fff; border:none; padding:10px 20px; border-radius:6px; font-size:15px; cursor:pointer; transition:background 0.3s ease;">
    Login
</button>

<div class="text-center text-muted large mt-4">
                Copyright &copy; 2025 - {{ config('app.site') }}
            </div>


    </div>

      
</div>

<!-- Thank You Page (Initially Hidden) -->
<div id="thankYouPageMobile" style="display:none; text-align:center; padding:40px; font-family: Arial, sans-serif;">

    <div style="max-width:500px; margin:0 auto; background:#fff; border-radius:16px; padding:32px; box-shadow:0 4px 12px rgba(0,0,0,0.1);">

     <div class="text-center mb-1" style="margin-top:-25px">
                <img src="{{ url('/') }}{{ config('app.logo') }}?v={{ time() }}" alt="Logo"
                    class="img-fluid" style="max-width: 320px;">
            </div>

        <!-- Celebration Emoji -->
        <div class="text-center mb-3" style="font-size:60px;">
            🎉
        </div>

        <!-- Heading -->
        <h2 style="color:#333; margin-bottom:12px;">
            Welcome, <span id="welcomeNameMobile" style="color:#4caf50;"></span>!
        </h2>

        <!-- Highlighted Success Line -->
        <p style="color:#2e7d32; font-size:18px; font-weight:bold; margin-bottom:12px;">
            ✅ You are Successfully registered with us!
        </p>

        <p style="color:#666; font-size:15px; line-height:1.5; margin-bottom:20px;">
            We’ve also sent <strong>Confirmation</strong> on your registered email.<br>
            Please check your inbox and start exploring!
        </p>

        <!-- Hidden Login Form -->
        <form id="autoLoginForm" action="{{ url('/') }}" method="POST" style="display:none;">
            @csrf
            <input type="hidden" name="email" value="{{ session('email', 'No email') }}">
            <input type="hidden" name="password" value="{{ Session::get( 'plainPassword' ,'123456789') }}">
            <input type="hidden" name="auto_login" value="true">
        </form>

        <!-- Go to Dashboard Button -->
        <button id="goToDashboardBtn"
            style="display:inline-block; padding:12px 24px; background:#4caf50; color:#fff; border:none;
                border-radius:8px; font-weight:bold; transition:0.3s; cursor:pointer;"
            onmouseover="this.style.background='#43a047'"
            onmouseout="this.style.background='#4caf50'">
            Go to Dashboard
        </button>

         <div class="text-center text-muted large mt-4">
                Copyright &copy; 2025 - {{ config('app.site') }}
            </div>
    </div>

     
</div>

<script>
    document.getElementById('goToDashboardBtn').addEventListener('click', function () {
        this.innerText = "Redirecting...";
        this.disabled = true;
        document.getElementById('autoLoginForm').submit();
    });
</script>


<script>
    document.addEventListener("DOMContentLoaded", function () {
        @if(Session::has('google_id'))
            //  Auto-trigger flow for Google signup
            (function () {
                // Simulating the "res.success" condition
                let res = { success: true, message: "Google signup detected." };

                if (res.success) {
                    $("#registerCard").hide();
                    // Show thank you page section
                    if (typeof showThankYouPage === "function") {
                        showThankYouPage();
                    }

                    // Success message for mobile OTP step
                    $("#responseMessageMobileError").html(`
                    <div class="alert alert-success">
                        Now, please enter your phone number to receive a 6-digit OTP via SMS.
                    </div>
                `);
                    // Hide email OTP form
                    $("#otpForm").hide();
                    $("#formTitle").text("Verify Mobile Number");
                    $("#formSubtitle").text("Enter your phone number to receive OTP.");
                    $("#phoneForm").show(); // <- show phone form next
                } else {
                    $("#responseMessageOtpForm").html(
                        `<div class="alert alert-danger">${res.message}</div>`
                    );
                }
            })();
        @endif
});
</script>
{{-- Clear google_id session after JS trigger --}}
@php
    Session::forget('google_id');
@endphp

<script>
function togglePassword(fieldId, icon) {
    const field = document.getElementById(fieldId);
    if (field.type === "password") {
        field.type = "text";
        icon.classList.remove("fa-eye-slash");
        icon.classList.add("fa-eye");
    } else {
        field.type = "password";
        icon.classList.remove("fa-eye");
        icon.classList.add("fa-eye-slash");
    }
}
</script>

<script>
document.querySelectorAll('.input-box').forEach(box => {
    const input = box.querySelector('input');
    const eye = box.querySelector('.toggle-eye');

    eye.addEventListener('click', function(e) {
        e.stopPropagation();
        togglePassword(input.id, this);
    });


    input.addEventListener('click', function(e) {
        if (e.target === input) {
            e.stopPropagation();
        }
    });
});
</script>




<!-- Font Awesome (for icons) -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
<script>


document.addEventListener('DOMContentLoaded', function() {
    const otpInputs = document.querySelectorAll('.otp-input');
    otpInputs.forEach((input, index) => {
        input.addEventListener('input', (e) => {
            if (e.target.value.length === 1 && index < otpInputs.length - 1) {
                otpInputs[index + 1].focus();
            }
        });
    });



    // Resend OTP Timer
    let timer = 120;
    const resendBtn = document.getElementById('resendOtpBtn');
    const timerSpan = document.getElementById('timer');

    function startTimer() {
        timer = 120;
        resendBtn.disabled = true;
        resendBtn.style.background = "#ccc";
        resendBtn.style.cursor = "not-allowed";
        timerSpan.textContent = timer;

        const countdown = setInterval(() => {
            timer--;
            timerSpan.textContent = timer;
            if (timer <= 0) {
                clearInterval(countdown);
                resendBtn.disabled = false;
                resendBtn.style.background = "green";
                resendBtn.style.cursor = "pointer";
                resendBtn.textContent = "Resend OTP";
            }
        }, 1000);
    }

    startTimer(); // start countdown when form opens
    resendBtn.addEventListener('click', function() {
    // Show loader
    $("#loader").css("display", "flex");

    fetch("{{ url('verify-google-otp') }}", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
            "X-CSRF-TOKEN": document.querySelector('[name=_token]').value
        },
           body: JSON.stringify({
        action: "resend" ,  // 👈 important,
         email: document.getElementById('email').value // send directly
    })
    })
    .then(response => response.json())
    .then(data => {
        // Hide loader after getting response
        $("#loader").hide();

        if (data.success) {
            // Show success message
            $("#responseMessage").html(
                `<div class="alert alert-success">${data.message ?? '📩 OTP resent to your email.'}</div>`
            );

            resendBtn.innerHTML = `Resend OTP (<span id="timer">120</span>s)`;
            startTimer();
        } else {
            $("#responseMessage").html(
                `<div class="alert alert-danger">⚠️ Failed to resend OTP.</div>`
            );
        }
    })
    .catch(err => {
        $("#loader").hide();
        console.error(err);
        $("#responseMessage").html(
            `<div class="alert alert-danger">⚠️ Something went wrong. Please try again.</div>`
        );
    });
});

});
</script>
<script>
    // Example: Show Thank You Page after OTP success
    function showThankYouPage() {
        $(".login-card").hide();
        document.getElementById("otpForm").style.display = "none";
        document.getElementById("thankYouPage").style.display = "block";
    }
    function showThankYouPageMobile() {
        $(".login-card").hide();
        $(".login-card-mobile").hide();

        document.getElementById("otpForm").style.display = "none";
        document.getElementById("otpFormMobile").style.display = "none";

        document.getElementById("thankYouPage").style.display = "none";
        document.getElementById("thankYouPageMobile").style.display = "block";
        // Get first name from input field
        let firstName = $("#name").val(); // Assuming your name input has id="name"
        $("#welcomeNameMobile").text(firstName);
    }
</script>


{!! NoCaptcha::renderJs() !!}

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="{{ asset('asset/plugins/input-mask/jquery.inputmask.js')}}"></script>
<script src="{{ asset('assets/vendor_plugins/input-mask/jquery.inputmask.date.extensions.js')}}"></script>

<script>
  $(document).ready(function ()
  {
    $('#phone').inputmask("(999) 999-9999");
  });

</script>
<script>
$(function () {
    // Register form submit
    $("#registerForm").on("submit", function (e) {
    e.preventDefault();
    $("#loader").css("display", "flex");
    $("#responseMessage").html("");

    // ✅ clear old errors
    $(".text-danger").text("");

    $.ajax({
        url: "{{ url('/store') }}",
        type: "POST",
        data: $(this).serialize(),
        success: function (res) {
            $("#loader").hide();

            // ✅ Updated success message
            // $("#responseMessage").html(
            //     `<div class="alert alert-success">
            //         Registration successful!<br>
            //         We’ve sent a 6-digit verification code to your email address.<br>
            //         Please enter the code below to verify your email and continue.<br><br>
            //         <small>(Didn’t receive the code? Check your spam folder or click <b>Resend OTP</b>.)</small>
            //     </div>`
            // );

            // hide register, show OTP
            $("#registerCard").hide();
            // $("#formTitle").text("Verify Email");
            //$("#formSubtitle").text("Enter the 6-digit OTP sent to your email.");
            $("#otpForm").show();
            $("#registerHeader").hide();
            $("#registerLogo").hide();

        },
        error: function (xhr) {
            $("#loader").hide();

            if (xhr.status === 422) {
                let errors = xhr.responseJSON.errors;

                // ✅ show field-specific errors
                $.each(errors, function (field, messages) {
                    $("#" + field + "_error").text(messages[0]);
                });

                // ✅ also show a general error box
                let errorMsg = Object.values(errors).map(msg => msg[0]).join("<br>");
                $("#responseMessage").html(`<div class="alert alert-danger">${errorMsg}</div>`);
            } else {
                $("#responseMessage").html(
                    `<div class="alert alert-danger">Something went wrong. Please try again.</div>`
                );
            }
        }
    });
});



    // OTP navigation
    $(document).on("keyup", ".otp-input", function(e){
        if(e.key >= 0 && e.key <= 9){
            let next = $(this).data("next");
            if(next) $("#" + next).focus();
        } else if(e.key === "Backspace"){
            let prev = $(this).data("previous");
            if(prev) $("#" + prev).focus();
        }
    });

    // OTP verify form
    $("#otpForm").on("submit", function(e){
    e.preventDefault();

    let otp = "";
    $(".otp-input").each(function(){ otp += $(this).val(); });

    if(otp.length !== 6){
        $("#responseMessageOtpForm").html(
            `<div class="alert alert-danger">Please enter complete 6-digit OTP.</div>`
        );
        return;
    }

    $("#loader").css("display","flex");

    $.ajax({
        url: "{{ url('/verify-google-otp') }}",
        type: "POST",
        data: {
            _token: "{{ csrf_token() }}",
            action: "verify",
            otp: otp,
            email: $("#email").val(),
            password: $("#password").val()
        },
        success: function(res){
            $("#loader").hide();
            if(res.success){

                showThankYouPage();


                $("#responseMessageMobileError").html(
                    `<div class="alert alert-success">

                        Now, please enter your phone number to receive a 6-digit OTP via SMS.
                    </div>`
                );

                // hide email OTP form
                $("#otpForm").hide();
                $("#formTitle").text("Verify Mobile Number");
                $("#formSubtitle").text("Enter your phone number to receive OTP.");
                $("#phoneForm").show(); // <- show phone form next
            } else {
                $("#responseMessageOtpForm").html(
                    `<div class="alert alert-danger">${res.message}</div>`
                );
            }
        },
        error: function(xhr){
            $("#loader").hide();
            $("#responseMessageOtpForm").html(
                `<div class="alert alert-danger">${xhr.responseJSON?.message ?? 'Invalid OTP. Try again.'}</div>`
            );
        }
    });
});



});
</script>

<style>
/* keep your existing styles; just ensure otp inputs look consistent */
.otp-input{
    width:48px;height:52px;border:1px solid #ccc;border-radius:8px;
    text-align:center;font-size:20px;font-weight:600;
}
.otp-input:focus{outline:none;border-color:#0b3a6f;box-shadow:0 0 0 3px rgba(11,58,111,.15);}
</style>

<script>
(function(){
  const inputs = Array.from(document.querySelectorAll('#otpForm .otp-input'));
  const form   = document.getElementById('otpForm');

  // helper: focus first empty box
  function focusFirstEmpty(){
    const el = inputs.find(i => !i.value);
    if(el) el.focus();
  }
  // helper: get OTP
  function getOTP(){ return inputs.map(i => i.value).join(''); }

  // sanitize & move
  inputs.forEach((input, idx) => {
    input.addEventListener('focus', () => input.select());

    input.addEventListener('keydown', (e) => {
      // only digits, arrows, backspace, tab allowed
      if (
        e.key.length === 1 && !/[0-9]/.test(e.key) &&
        !e.ctrlKey && !e.metaKey
      ){
        e.preventDefault();
        return;
      }
      if (e.key === 'ArrowLeft' && idx > 0) { inputs[idx-1].focus(); e.preventDefault(); }
      if (e.key === 'ArrowRight' && idx < inputs.length-1) { inputs[idx+1].focus(); e.preventDefault(); }
      if (e.key === 'Backspace' && input.value === '' && idx > 0) {
        inputs[idx-1].value = '';
        inputs[idx-1].focus();
        e.preventDefault();
      }
    });

    input.addEventListener('input', (e) => {
      // keep only first digit
      const val = e.target.value.replace(/\D/g,'').slice(0,1);
      e.target.value = val;

      if (val && idx < inputs.length - 1) {
        inputs[idx+1].focus();
      }
      // auto-submit when all filled
      const otp = getOTP();
      if (otp.length === inputs.length) {
        $('#otpForm').trigger('submit');
      }
    });
  });

  // paste support (paste full OTP)
  form.addEventListener('paste', (e) => {
    const text = (e.clipboardData || window.clipboardData).getData('text')
                  .replace(/\D/g,'').slice(0, inputs.length);
    if(!text) return;
    e.preventDefault();
    inputs.forEach((inp, i) => { inp.value = text[i] || ''; });
    if (text.length < inputs.length) {
      inputs[text.length].focus();
    } else {
      $('#otpForm').trigger('submit');
    }
  });



  // when you reveal OTP form after registration success, call this:
  window.showOtpForm = function(){
    $('#registerForm').hide();
    $('#otpForm').show();
    setTimeout(focusFirstEmpty, 50);
  };
})();
</script>
<script>
$(document).ready(function () {

    /** ==========================
     *  1) Register Form Submit
     *  ========================== */
    $("#phonesubmit").on("submit", function (e) {
    e.preventDefault();
    $("#loader").css("display", "flex");
    $("#responseMessageMobileError").html("");
    $(".text-danger").text(""); // clear old errors

    // ✅ Validate phone length before AJAX
    let phone = $("#phone").val().replace(/\D/g, '');
     let last4 = phone.slice(-4);
    let masked = "XXXXXX" + last4;
    //alert(phone);
    if (phone.length !== 10) {

        $("#loader").hide();
        $("#responseMessageMobileError").show();
        $("#responseMessageMobileError").html(
            `<div class="alert alert-danger">Phone number must be 10 digits.</div>`
        );
        return false;
    }

    $.ajax({
        url: "{{ url('/send-mobile-otp') }}",
        type: "POST",
        data: $(this).serialize(),
        success: function (res) {
            $("#loader").hide();

            if (res.success) {

            // ✅ Updated success message
            $("#responseMessageMobile").html(
               `<div class="alert alert-success">
            Registration successful!<br>
            Please enter the 6-digit OTP sent to your phone ending in ${masked}
        </div>`
            );

                // hide register, show OTP
                $("#registerForm").hide();
                $('#thankYouPage').hide();
                $("#formTitleMobile").text("Verify OTP");
                // $("#formSubtitleMobile").text("Enter the OTP sent to your phone.");
                $(".login-card-mobile").show();
                $("#otpFormMobile").show();

                // focus first empty input
                focusFirstEmptyMobile();
                startTimerMobile();
            } else {
                $("#responseMessageMobileError").html(
                    `<div class="alert alert-danger">${res.message ?? 'OTP sending failed.'}</div>`
                );
            }
        },
        error: function (xhr) {
            $("#loader").hide();
            if (xhr.status === 422) {
                let errors = xhr.responseJSON.errors;
                $.each(errors, function (field, messages) {
                    $("#" + field + "_error").text(messages[0]);
                });
                let errorMsg = Object.values(errors).map(msg => msg[0]).join("<br>");
                $("#responseMessageMobileError").html(`<div class="alert alert-danger">${errorMsg}</div>`);
            } else {
                $("#responseMessageMobileError").html(
                    `<div class="alert alert-danger">${xhr.responseJSON?.message ?? 'Something went wrong. Please try again.'}</div>`
                );
            }
        }
    });
});



    /** ==========================
     *  2) OTP Form Submit
     *  ========================== */
    // Function to get the full OTP as a single string
function getMobileOtp() {
    let otp = "";
    for (let i = 1; i <= 6; i++) {
        otp += document.getElementById(`digit-${i}-mobile`).value.trim();
    }
    return otp;
}

// Example usage
let otp = getMobileOtp();
console.log("Full OTP:", otp);

    $("#otpFormMobile").on("submit", function(e){
        //alert('hlo');
        e.preventDefault();
    //     let otp = "";
    //     $(".otp-input").each(function(){ otp += $(this).val(); });

    //     if(otp.length !== 6){
    //         $("#responseMessage").html(`<div class="alert alert-danger">Please enter complete 6-digit OTP.</div>`);
    //         return;
    //     }
    //  alert(otp);
     let otp = getMobileOtp();
        $("#loader").css("display","flex");
        $.ajax({
            url: "{{ url('/verify-mobile-otp') }}",
            type: "POST",
            data: {
                _token: "{{ csrf_token() }}",
                action: "verify",
                otp: otp,
                phone: document.getElementById('phone').value,
                password: document.getElementById('password').value,
                email: document.getElementById('email').value

            },
            success: function(res){
                $("#loader").hide();
                if(res.success){
                    $("#autoLoginForm input[name='email']").val(res.email ?? "{{ session('email') }}");
                    $("#autoLoginForm input[name='password']").val(res.password ?? "{{ Session::get('plainPassword', '123456789') }}");
                    showThankYouPageMobile();
                    $('#registerForm').hide();
                    $('#otpForm').hide();
                    $("#formTitleMobile").hide();
                    $("#formSubtitleMobile").hide();
                } else {
                    $("#responseMessageMobile").html(`<div class="alert alert-danger">${res.message}</div>`);
                }
            },
            error: function(xhr){
                $("#loader").hide();
                $("#responseMessageMobile").html(`<div class="alert alert-danger">${xhr.responseJSON?.message ?? 'Invalid OTP. Try again.'}</div>`);
            }
        });
    });




    /** ==========================
     *  3) OTP Input Handling
     *  ========================== */
    const inputs = Array.from(document.querySelectorAll('#otpFormMobile .otp-input'));
    const form   = document.getElementById('otpFormMobile');

    function focusFirstEmptyMobile(){
        const el = inputs.find(i => !i.value);
        if(el) el.focus();
    }
    function getOTPMobile(){ return inputs.map(i => i.value).join(''); }

    inputs.forEach((input, idx) => {
        input.addEventListener('focus', () => input.select());

        input.addEventListener('keydown', (e) => {
            if (e.key.length === 1 && !/[0-9]/.test(e.key) && !e.ctrlKey && !e.metaKey){
                e.preventDefault();
                return;
            }
            if (e.key === 'ArrowLeft' && idx > 0) { inputs[idx-1].focus(); e.preventDefault(); }
            if (e.key === 'ArrowRight' && idx < inputs.length-1) { inputs[idx+1].focus(); e.preventDefault(); }
            if (e.key === 'Backspace' && input.value === '' && idx > 0) {
                inputs[idx-1].value = '';
                inputs[idx-1].focus();
                e.preventDefault();
            }
        });

        input.addEventListener('input', (e) => {
            const val = e.target.value.replace(/\D/g,'').slice(0,1);
            e.target.value = val;
            if (val && idx < inputs.length - 1) {
                inputs[idx+1].focus();
            }
            const otp = getOTPMobile();
            if (otp.length === inputs.length) {
                 //form.submit(); // ✅ directly submit form
    $('#otpFormMobile').triggerHandler('submit'); // ✅ only Ajax handler runs
            }
        });
    });

    form.addEventListener('paste', (e) => {
        const text = (e.clipboardData || window.clipboardData).getData('text')
                      .replace(/\D/g,'').slice(0, inputs.length);
        if(!text) return;
        e.preventDefault();
        inputs.forEach((inp, i) => { inp.value = text[i] || ''; });
        if (text.length < inputs.length) {
            inputs[text.length].focus();
        } else {
    $('#otpFormMobile').triggerHandler('submit'); // ✅ only Ajax handler runs
        }
    });


    /** ==========================
     *  4) Resend OTP Handling
     *  ========================== */
    let timer = 120;
    const resendBtn = document.getElementById('resendOtpBtnMobile');
    const timerSpan = document.getElementById('timerMobile');

    function startTimerMobile() {
        timer = 120;
        resendBtn.disabled = true;
        resendBtn.style.background = "#ccc";
        resendBtn.style.cursor = "not-allowed";
        timerSpan.textContent = timer;

        const countdown = setInterval(() => {
            timer--;
            timerSpan.textContent = timer;
            if (timer <= 0) {
                clearInterval(countdown);
                resendBtn.disabled = false;
                resendBtn.style.background = "#007bff";
                resendBtn.style.cursor = "pointer";
                resendBtn.textContent = "Resend OTP";
            }
        }, 1000);
    }

    resendBtn.addEventListener('click', function() {
        $("#loader").css("display", "flex");
        fetch("{{ url('verify-mobile-otp') }}", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "X-CSRF-TOKEN": document.querySelector('[name=_token]').value
            },
            body: JSON.stringify({
                action: "resend",
                email: document.getElementById('email').value
            })
        })
        .then(response => response.json())
        .then(data => {
            $("#loader").hide();
            if (data.success) {
                $("#responseMessage").html(
                    `<div class="alert alert-success">${data.message ?? '📩 OTP resent to your phone number.'}</div>`
                );
                resendBtn.innerHTML = `Resend OTP (<span id="timerMobile">120</span>s)`;
                startTimerMobile();
            } else {
                $("#responseMessage").html(
                    `<div class="alert alert-danger">⚠️ Failed to resend OTP.</div>`
                );
            }
        })
        .catch(err => {
            $("#loader").hide();
            console.error(err);
            $("#responseMessage").html(
                `<div class="alert alert-danger">⚠️ Something went wrong. Please try again.</div>`
            );
        });
    });

});
</script>



</body>
</html>
