<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Smart Phone Platform For Businesses | Setting Up Dashboard</title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

    <link rel="stylesheet" href="{{asset('assets/css/vendors_css.css')}}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        .alert {
            margin-bottom: 15px;
            padding: 10px;
            border-radius: 8px;
            font-size: 14px;
        }

        .alert-success {
            background: #d4edda;
            color: #155724;
        }

        .alert-danger {
            background: #f8d7da;
            color: #721c24;
        }

        /* Progress Bar */
        .progress-container {
            width: 100%;
            background: #f0f0f0;
            border-radius: 8px;
            margin: 20px 0;
            overflow: hidden;
            position: relative;
        }

        .progress-bar {
            width: 0;
            height: 10px;
            background: linear-gradient(to right, #00294d, #0b3a6f);
            transition: width 0.6s linear;
        }

        .progress-text {
            position: absolute;
            top: -30px;
            left: 0;
            width: 100%;
            text-align: center;
            font-size: 16px;
            color: #1b1b4f;
            font-weight: 600;
            animation: pulse 2s ease-in-out infinite;
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        }

        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
    </style>
    <style>
        /* ===== Background ===== */
        body {
            background: #f6f7fb;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Reset */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', sans-serif;
        }

        /* Page */
        .login-page {
            position: relative;
            height: 100vh;
            background: #f6f7fb;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }

        .login-shapes .login-left-shape {
            position: absolute;
            top: 0;
            left: 0;
        }

        .login-shapes .login-left-shape img {
            max-width: 100%;
            height: auto;
        }

        .login-shapes .login-right-shape {
            position: absolute;
            bottom: 0;
            right: 0;
        }

        .login-shapes .login-right-shape img {
            max-width: 100%;
            height: auto;
        }

        .login-card {
            background: #fff;
            padding: 40px;
            border-radius: 14px;
            width: 100%;
            max-width: 480px;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
            text-align: center;
            z-index: 1;
            max-height: none;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .login-card.login-form-card {
            height: auto;
            max-height: none;
            padding: 30px 25px;
            display: flex;
            flex-direction: column;
            justify-content: flex-start;
        }

        /* Headings */
        .login-card h2 {
            color: #1b1b4f;
            margin-top: 0;
            margin-bottom: 5px;
            font-size: 26px;
            font-weight: bold;
        }

        .login-card p {
            font-size: 14px;
            color: #555;
            margin-top: 0;
            margin-bottom: 15px;
        }

        .new-user {
            margin-top: 6px;
            margin-bottom: 1px;
        }

        .forgot-password {
            margin-top: 5px;
            margin-bottom: 10px;
        }

        /* Inputs */
        .input-box {
            position: relative;
            margin-bottom: 18px;
        }

        .input-box input {
            width: 100%;
            padding: 12px 15px 12px 40px;
            border-radius: 8px;
            border: 1px solid #ccc;
            font-size: 15px;
            outline: none;
        }

        .input-box i {
            position: absolute;
            top: 50%;
            left: 12px;
            transform: translateY(-50%);
            color: #888;
            font-size: 14px;
        }

        /* Buttons */
        .login-btn {
            width: 100%;
            padding: 12px;
            background: #E41F07 !important;
            color: #fff;
            font-weight: 600;
            font-size: 15px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            transition: background .3s ease;
        }

        .login-btn:hover {
            background: #c62828;
        }

        /* Forgot password */
        .forgot-password {
            font-size: 13px;
            color: #0b3a6f;
            text-decoration: none;
        }

        .forgot-password:hover {
            text-decoration: underline;
        }

        /* Social login */
        .social-login {
            margin-top: 20px;
        }

        .social-login p {
            font-size: 14px;
            margin-bottom: 10px;
        }

        .social-icons {
            display: flex;
            justify-content: center;
            gap: 12px;
        }

        .social-icons a {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            height: 42px;
            border-radius: 6px;
            font-size: 14px;
            font-weight: 500;
            text-decoration: none;
        }

        .social-icons a.facebook {
            background: #3b5998;
            color: #fff;
        }

        .social-icons a.google {
            background: #fff;
            color: #000;
            border: 1px solid #ddd;
        }

        .social-icons a.google img {
            width: 20px;
            height: 20px;
        }

        .social-icons a.twitter {
            background: #000;
            color: #fff;
        }

        .alert-danger {
            display: flex;
            align-items: center;
            gap: 8px;
            background-color: #ff5252 !important;
            color: #fff !important;
            border: none;
            border-radius: 8px;
            padding: 6px 10px;
            font-size: 13px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
            width: 100%;
            margin: 2px 0 10px 0;
        }

        .alert-danger .close {
            order: -1;
            font-size: 20px;
            line-height: 1;
            margin-right: 6px;
            color: #000 !important;
            opacity: 0.9;
        }

        .alert-danger .close:hover {
            opacity: 1;
        }

        .card .alert-danger {
            position: relative !important;
            top: auto !important;
            margin-top: 0 !important;
            margin-bottom: 12px !important;
        }

        #mobileHint {
            color: #888;
            font-size: 12px;
        }

        #country_code,
        #mobile {
            padding: 10px 14px;
            border: 1px solid #ccc;
            border-radius: 6px;
            font-size: 14px;
            outline: none;
            transition: border-color 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
        }

        #country_code {
            flex: 0.3;
            background-color: white;
            appearance: none;
            -webkit-appearance: none;
            -moz-appearance: none;
            background-image: url("data:image/svg+xml;utf8,<svg fill='black' height='20' viewBox='0 0 24 24' width='20' xmlns='http://www.w3.org/2000/svg'><path d='M7 10l5 5 5-5z'/></svg>");
            background-repeat: no-repeat;
            background-position: right 10px center;
            background-size: 14px;
        }

        #mobile {
            flex: 0.7;
        }

        #country_code:focus,
        #mobile:focus {
            border-color: #007bff;
            box-shadow: 0 0 4px rgba(0, 123, 255, 0.4);
        }

        .login-btn {
            margin-top: 10px;
            margin-bottom: 10px;
        }

        .mb-3.mt-3 {
            margin-top: 10px !important;
            margin-bottom: 10px !important;
        }

        .form-check-input {
            transform: scale(1.3);
            margin-right: 5px;
        }

        .login-form-card {
            height: 650px;
        }

        .forgot-password-card {
            height: 340px !important;
        }

        .login-btn {
            width: 100%;
            padding: 12px;
            background: linear-gradient(to right, #00294d, #0b3a6f);
            color: white;
            font-weight: bold;
            font-size: 14px;
            border: none;
            border-radius: 8px;
            margin-top: 10px;
            cursor: pointer;
            transition: background .3s ease;
        }

        .login-btn:hover {
            background: linear-gradient(to right, #001f3a, #082d54);
        }

        .social-login {
            margin-top: 25px;
        }

        .social-login p {
            font-size: 14px;
            color: #666;
            margin-bottom: 12px;
        }

        .forgot-password {
            text-align: right;
            font-size: 13px;
            margin-top: -15px;
            margin-bottom: 15px;
        }

        .forgot-password a {
            color: #0b3a6f;
            text-decoration: none;
        }

        .forgot-password a:hover {
            text-decoration: underline;
        }

        @media(max-width:500px) {
            .login-card {
                padding: 30px 20px;
                border-radius: 20px;
            }
        }

        .input-box .toggle-eye {
            position: absolute !important;
            top: 50% !important;
            right: -340px !important;
            transform: translateY(-50%) !important;
            cursor: pointer !important;
            color: #333 !important;
            font-size: 14px !important;
            background: none !important;
            padding: 0 !important;
            margin: 0 !important;
            height: auto !important;
            width: auto !important;
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
        }

        @media (max-width: 991px) {
            .input-box .toggle-eye {
                right: -300px !important;
                font-size: 15px !important;
            }
        }

        @media (max-width: 480px) {
            .input-box .toggle-eye {
                right: -900px !important;
                font-size: 14px !important;
            }
        }

        @media (max-width: 360px) {
            .input-box .toggle-eye {
                right: -900px !important;
                font-size: 13px !important;
            }
        }

        @media (max-width: 991px) {
            body {
                padding: 20px;
            }

            .login-card {
                max-width: 500px;
                padding: 30px 25px;
            }

            .login-card h2 {
                font-size: 22px;
            }

            .login-card p {
                font-size: 13px;
            }

            .input-box input {
                font-size: 14px !important;
                padding: 10px 40px 10px 35px !important;
            }

            .login-btn {
                font-size: 13px;
                padding: 10px;
            }

            .social-icons a {
                width: 38px;
                height: 38px;
                font-size: 16px;
            }
        }

        @media (max-width: 575px) {
            body {
                background: #f5f6fa;
                padding: 15px;
            }

            .login-card {
                width: 100%;
                max-width: 100%;
                border-radius: 18px;
                padding: 25px 18px;
                box-shadow: 0 12px 25px rgba(0, 0, 0, 0.15);
            }

            .login-card h2 {
                font-size: 20px;
            }

            .login-card p {
                font-size: 12px;
            }

            .input-box {
                max-width: 100% !important;
            }

            .input-box input {
                font-size: 14px !important;
                padding: 10px 40px 10px 32px !important;
            }

            .input-box .toggle-eye {
                right: 12px !important;
            }

            .login-btn {
                font-size: 14px;
                padding: 10px;
            }

            .social-login p {
                font-size: 12px;
            }

            .social-icons {
                gap: 12px;
            }

            .social-icons a {
                width: 34px;
                height: 34px;
                font-size: 14px;
            }
        }

        @media (max-width: 360px) {
            .login-card {
                padding: 20px 15px;
            }

            .login-card h2 {
                font-size: 18px;
            }

            .input-box input {
                font-size: 13px !important;
                padding: 9px 35px 9px 30px !important;
            }

            .login-btn {
                font-size: 13px;
                padding: 9px;
            }
        }

        @media (max-width: 1024px) {
            .login-shapes .login-left-shape,
            .login-shapes .login-right-shape {
                display: none;
            }
        }

        @media (max-width: 768px) {
            .login-shapes .login-left-shape,
            .login-shapes .login-right-shape {
                display: none;
            }

            body,
            .login-page {
                height: auto;
                display: block;
                padding: 20px 15px;
                overflow: auto;
            }

            .login-card {
                margin: 20px auto;
            }
        }

        @media (min-width: 768px) and (max-width: 1024px) {
            .input-box .toggle-eye {
                right: -340px !important;
            }
        }

        @media (max-width: 767px) {
            .input-box .toggle-eye {
                right: -270px !important;
            }
        }

        #icon-container {
            transition: opacity 0.5s;
            text-align: center;
            margin: 20px 0;
        }
    </style>
</head>

<body class="hold-transition theme-primary bg-img">
    <div class="login-card login-form-card">
        <!-- Background Shapes -->
        <div class="login-shapes">
            <div class="login-left-shape">
                <img src="assets/images/auth-bg/shape-01.png" alt="Shape Left">
            </div>
            <div class="login-right-shape">
                <img src="assets/images/auth-bg/shape-02.png" alt="Shape Right">
            </div>
        </div>
        <h2 id="setup-title">Setting up your dashboard...</h2>
        <p id="setup-description">Please wait while we prepare everything for you.</p>
        <div id="icon-container">
            <i class="fas fa-cog fa-spin fa-3x"></i>
        </div>
        <div class="progress-container">
            <span id="progress-text" class="progress-text z-0">Hold on, we're firing things up!</span>
            <div class="progress-bar" id="progress-bar"></div>
        </div>
    </div>

    <script>
        let count = 0;
        const messages = [
            "Setting up header...",
            "Configuring sidebar...",
            "Initializing dashboard...",
            "Loading modules...",
            "Syncing data...",
            "Optimizing performance...",
            "Securing access...",
            "Customizing layout...",
            "Integrating features...",
            "Finalizing setup...",
            "Building widgets...",
            "Preparing analytics...",
            "Setting up notifications...",
            "Configuring user settings..."
        ];
        const descriptions = [
            "Please wait while we prepare everything for you.",
            "Crafting a seamless navigation experience...",
            "Getting your dashboard ready...",
            "Loading essential components...",
            "Synchronizing your data securely...",
            "Boosting system efficiency...",
            "Ensuring your account is secure...",
            "Tailoring the interface to your needs...",
            "Adding powerful tools for you...",
            "Almost ready to go!",
            "Creating interactive widgets...",
            "Gathering insights for you...",
            "Setting up your alerts...",
            "Personalizing your experience..."
        ];
        const icons = [
            'cog',
            'database',
            'chart-bar',
            'lock',
            'user-cog',
            'sitemap',
            'sliders-h',
            'palette',
            'plug',
            'check-circle',
            'th-large',
            'chart-line',
            'bell',
            'user'
        ];
        const progressMessages = [
            { range: [0, 25], text: "Hold on, we're firing things up!" },
            { range: [25, 50], text: "Right there, building your awesome dashboard!" },
            { range: [50, 75], text: "Just finishing, almost ready to rock!" },
            { range: [75, 100], text: "Almost done, your experience is set!" }
        ];
        let index = 0;
        const iconContainer = document.getElementById('icon-container');
        const progressBar = document.getElementById('progress-bar');
        const progressText = document.getElementById('progress-text');

        // Progress bar animation (0 to 100% over 60 seconds)
        let progress = 0;
        const progressInterval = setInterval(() => {
            progress += 100 / (60 * 1000 / 100); // Increment to reach 100% in 60 seconds
            if (progress >= 100) {
                progress = 100;
                clearInterval(progressInterval);
            }
            progressBar.style.width = `${progress}%`;

            // Update progress text based on progress percentage
            for (const msg of progressMessages) {
                if (progress >= msg.range[0] && progress < msg.range[1]) {
                    progressText.textContent = msg.text;
                    break;
                }
            }
        }, 100);

        // Message, description, and icon change every 7 seconds
        const messageInterval = setInterval(() => {
            // Change title and description
            document.getElementById('setup-title').textContent = messages[index];
            document.getElementById('setup-description').textContent = descriptions[index];

            // Animate icon: fade out, change, fade in
            iconContainer.style.opacity = 0;
            setTimeout(() => {
                iconContainer.innerHTML = `<i class="fas fa-${icons[index]} fa-spin fa-3x"></i>`;
                iconContainer.style.opacity = 1;
            }, 500);

            index = (index + 1) % messages.length;

            // Check setup status
            fetch('/setting-up-dashboard/check-email', {
                method: 'GET',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                    'Accept': 'application/json'
                }
            }).then(response => response.json())
              .then(data => {
                  if (data === true || (data.status && data.status === true)) {
                      clearInterval(messageInterval);
                      clearInterval(progressInterval);
                      window.location.href = '/setting-up-dashboard/redirecting';
                  }
              }).catch(error => console.error('Error checking setup:', error));

            count++;
            if (count >= 20) {
                clearInterval(messageInterval);
                clearInterval(progressInterval);
                document.getElementById('setup-title').textContent = 'Taking longer than expected...';
                document.getElementById('setup-description').textContent = 'Please wait a moment longer.';
                progressText.textContent = 'Still crafting your experience...';
            }
        }, 7000);
    </script>
</body>

</html>
