<!DOCTYPE html>
<html>

<head>

    <link rel="stylesheet" href="{{asset('assets/css/vendors_css.css')}}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

    <style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
        font-family: 'Segoe UI', sans-serif;
    }

    body {
        background: url('bg.png') no-repeat center center/cover;
        height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .login-card {
        background: #fff;
        padding: 40px;
        border-radius: 25px;
        width: 100%;
        max-width: 420px;
        box-shadow: 0 25px 60px rgba(0, 0, 0, 0.25);
        text-align: center;
    }

    .login-card h2 {
        color: #1b1b4f;
        margin-bottom: 10px;
        font-size: 24px;
    }

    .login-card p {
        font-size: 14px;
        color: #555;
        margin-bottom: 25px;
    }

    .input-box {
        position: relative;
        margin-bottom: 20px;
    }

    .input-box input {
        width: 100%;
        padding: 12px 15px 12px 40px;
        border-radius: 10px;
        border: 1px solid #ccc;
        font-size: 15px;
        outline: none;
    }

    .input-box i {
        position: absolute;
        top: 50%;
        left: 12px;
        transform: translateY(-50%);
        color: #999;
        font-size: 14px;
    }

    .alert-danger {
        display: flex;
        align-items: center;
        gap: 8px;
        background-color: #ff5252 !important;
        color: #fff !important;
        border: none;
        border-radius: 12px;
        padding: 8px 14px;
        font-size: 14px;
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
        width: 100%;
        min-width: unset;
    }

    .alert-danger .close {
        order: -1;
        font-size: 20px;
        line-height: 1;
        margin-right: 6px;
        color: #000 !important;
        opacity: 0.9;
    }

    .alert-danger .close:hover {
        opacity: 1;
    }


    .card .alert-danger {
        position: absolute;
        top: -20px;
        left: 0;
        right: 0;
    }



    .login-btn {
        width: 100%;
        padding: 12px;
        background: linear-gradient(to right, #00294d, #0b3a6f);
        color: white;
        font-weight: bold;
        font-size: 14px;
        border: none;
        border-radius: 8px;
        margin-top: 10px;
        cursor: pointer;
        transition: background .3s ease;
    }

    .login-btn:hover {
        background: linear-gradient(to right, #001f3a, #082d54);
    }

    </style>
</head>

<body class="hold-transition theme-primary bg-img">
    <div class="login-card">
        
          <div class="text-center mb-1" style="margin-top:-25px">
                <img src="{{ url('/') }}{{ config('app.logo') }}?v={{ time() }}" alt="Logo"
                    class="img-fluid" style="max-width: 320px;">
            </div>

       @include("layouts.messaging")
        <span id="mobileError"></span>
        <div id="mobileOtpContainer"></div>
        <div id="errorMessage"></div>
        <span id="mobileError1" style="color:red;"></span>
        <span id="email_status" style="color:red;"></span>
         <input id="mobile" type="hidden" class="form-control" name="mobile" placeholder="mobile" value="{{$mobile}}" required>
                                @php
                                if(!empty($mobile))
                                {
                                    $mobile = substr($mobile,-4);
                                }
                                else
                                {
                                    $mobile='';
                                }
                                @endphp
        <h2>Login With Your SMS</h2>
        <p id="sign">A verification code has been sent to your phone ending in {{$mobile}} . Please enter the code
            received via SMS below.</p>
        <p id="forgot" style="display:none;">Forgot Password</p>


        <div class="showdiv">
            <!-- <form action="{{url('/otp')}}" method="POST"> -->
                                                <form method="POST" action="{{url('/verify-token-mobile/' . $otp_id ?? '')}}"> 

                @csrf
                <div class="mb-3">
                    <label for="code" class="col-form-label text-md-end text-start">Enter the 6-digit
                        code</label>

                    <input type="hidden" id="code" name="code" maxlength="4"
                        class="form-control @error('code') is-invalid @enderror">
                    @if ($errors->has('code'))
                    <span class="text-danger">{{ $errors->first('code') }}</span>
                    @endif

                </div>

                <div id="otp_status"></div>

                <input type="hidden" id=email value="">
                <div class="d-flex align-items-center mb-4">
                    <input type="text"
                        class="otp-input border rounded w-100 py-sm-3 py-2 text-center fs-26 hw-bold me-3" id="digit-1"
                        name="digit1" data-next="digit-2" required maxlength="1">
                    <input type="text"
                        class="otp-input border rounded w-100 py-sm-3 py-2 text-center fs-26 hw-bold me-3" id="digit-2"
                        name="digit2" data-next="digit-3" required data-previous="digit-1" maxlength="1">
                    <input type="text"
                        class="otp-input border rounded w-100 py-sm-3 py-2 text-center fs-26 hw-bold me-3" id="digit-3"
                        name="digit3" data-next="digit-4" required data-previous="digit-2" maxlength="1">
                    <input type="text"
                        class="otp-input border rounded w-100 py-sm-3 py-2 text-center fs-26 hw-bold me-3" id="digit-4"
                        name="digit4" data-next="digit-5" required data-previous="digit-3" maxlength="1">
                    <input type="text"
                        class="otp-input border rounded w-100 py-sm-3 py-2 text-center fs-26 hw-bold me-3" id="digit-5"
                        name="digit5" data-next="digit-6" required data-previous="digit-4" maxlength="1">
                    <input type="text"
                        class="otp-input border rounded w-100 py-sm-3 py-2 text-center fs-26 hw-bold me-3" id="digit-6"
                        name="digit6" data-next="digit-7" required data-previous="digit-5" maxlength="1">
                </div>

                 <a id="login" href=""> <button type="submit" class="btn btn-primary w-100">Verify</button></a>


            </form>
              <!-- Login link for going back -->
    <div style="margin-top: 12px; text-align: center;">
        <h6>Return to<a id="login" href="{{ url('/') }}" class="hover-warning text-bold">
            <i class="ion ion-log-in"></i> Login
</a></h6>
    </div>
        </div>






    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="{{asset('assets/js/vendors.min.js')}}"></script>
    <script src="{{asset('assets/js/pages/chat-popup.js')}}"></script>
    <script src="{{asset('assets/icons/feather-icons/feather.min.js')}}"></script>
    <script src="https://cdn.jsdelivr.net/npm/imask"></script>


            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    const inputs = document.querySelectorAll('.otp-input');

                    inputs.forEach((input) => {
                        input.addEventListener('input', (e) => {
                            if (e.target.value.length === 1) {
                                const nextInput = document.getElementById(input.dataset.next);
                                if (nextInput) {
                                    nextInput.focus();
                                }
                            }
                        });

                        input.addEventListener('keydown', (e) => {
                            if (e.key === "Backspace") {
                                const currentInput = e.target;
                                const previousInput = document.getElementById(currentInput.dataset
                                    .previous);

                                if (currentInput.value !== '') {
                                    currentInput.value = '';
                                    if (previousInput) {
                                        previousInput.focus();
                                    }
                                    e.preventDefault();
                                } else if (previousInput) {
                                    previousInput.focus();
                                    previousInput.select();
                                    e.preventDefault();
                                }
                            }
                        });

                        input.addEventListener('focus', (e) => {
                            e.target.select();
                        });
                    });
                });
            </script>
<script>var timerStarted = false;

function countdown()
{
    if (timerStarted) {
        return; // If the timer has already started, exit the function
    }

    var seconds = 59;

    function tick() {
        var counter = document.getElementById("timer");
        seconds--;
        counter.innerHTML = "0:" + (seconds < 10 ? "0" : "") + String(seconds);

        if (seconds > 0) {
            setTimeout(tick, 1000);
        } else {
            $("#resendCodeBtn").show();
            counter.innerHTML = "";
        }
    }

    tick();
    timerStarted = true; // Set the flag to indicate that the timer has started
}

$("#resendCodeBtn").click(function (event) {
    event.preventDefault();

    $.ajax({
        url: "{{ url('forgot-password-mobile') }}",
        method: "POST",
        data: {
            _token: $('meta[name="csrf-token"]').attr('content'),
            mobile: $("#mobile").val()
        },
        success: function (response) {
            console.log(response); // Add this line to log the response data
            var messageElement = $("#resendMessage");

            // Clear any previous messages
            messageElement.empty();

            // Show success message
            var successMessage = '<div class="alert alert-success">OTP has been resent.</div>';
            messageElement.html(successMessage);

            countdown(); // Start the countdown again if needed
            $("#resendCodeBtn").hide();
        },
        error: function (xhr, status, error) {
            console.error(error); // Add this line to log any errors
            var messageElement = $("#resendMessage");

            // Clear any previous messages
            messageElement.empty();

            // Show error message
            var errorMessage = '<div class="alert alert-danger">An error occurred. Please try again later.</div>';
            messageElement.html(errorMessage);
        }
    });
});


countdown();</script>
</body>

</html>
