@extends('layouts.app')
@section('title', 'Profile')
@section('content')
 <style> 
.lookup::before {
    content: "";
    font-family: themify;
    font-size: 1rem;
    position: absolute;
    top: 52%;
    left: 0;
    -webkit-transform: translateY(-50%);
    transform: translateY(-50%);
    color: rgba(0, 0, 0, 0.4);
    width: 36px;
    text-align: center;
    cursor: text;
}
#messageContent1 {
  overflow-x: auto;
}
.text-yellow {
    color: yellow !important;
}
#loader1 {
    display: none;
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    z-index: 9999; /* Ensure it is on top of other elements */
}
</style>


<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-xl-2 col-lg-4 col-12"style="padding-right:5px;padding-left:5px;">
				  <button class="btn btn-danger w-p100 mb-10" type="button" alt="default" data-bs-toggle="modal" data-bs-target=".bs-example-modal-lg">Compose</button>
                  <a href="{{ route('gmail.logout') }}" class="btn btn-danger  w-p100">Sign Out of Gmail</a>
                  <div class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
						<div class="modal-dialog modal-lg">
							<div class="modal-content">
								<div class="modal-header">
									<h4 class="modal-title" id="myLargeModalLabel">Compose New Message</h4>
									<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
								</div>
                          

								<form method="post"action="{{url('user-send-email')}}"enctype="multipart/form-data"id="composeForm">
									@csrf
								<div class="modal-body">
									<div class="form-group">
										<input class="form-control" placeholder="To:"name="to">
									</div>
									<div class="form-group">
										<input class="form-control" placeholder="Subject:"name="subject">
									</div>
									<div class="form-group">
											<textarea id="compose-textarea" class="form-control" style="height: 300px"name="body">
											
											</textarea>
									</div>
									<div class="form-group">
										<div class="btn btn-info btn-file">
										<i class="fa fa-paperclip"></i> Attachment
										<input type="file" name="attachment">
										</div>
										<!-- <p class="help-block">Max. 32MB</p> -->
									</div>
								</div>
								<div class="modal-footer">
									<div class="pull-right">
										<!-- <button type="button" class="btn btn-default"><i class="fa fa-pencil"></i> Draft</button> -->
										<button type="submit" class="btn btn-success"><i class="fa fa-envelope-o"></i> Send</button>
									</div>
									<!-- <button type="reset" class="btn btn-danger"><i class="fa fa-times"></i> Discard</button> -->
									<button type="button" class="btn btn-danger text-start" data-bs-dismiss="modal">Close</button>
								</div>
							</form>
							</div>
							<!-- /.modal-content -->
						</div>
						<!-- /.modal-dialog -->
					</div>
				<!-- /.modal -->

				<div class="box">
						<div class="box-header with-border">
						<h4 class="box-title">Folders</h4>
						<ul class="box-controls pull-right">
							<li><a class="box-btn-slide" href="#"></a></li>	
						</ul>
						</div>
						<div class="box-body no-padding mailbox-nav">
						<ul class="nav nav-pills flex-column">
							<li class="nav-item"><a class="nav-link active" data-bs-toggle="tab" href="#home4" role="tab"><i class="ion ion-ios-email-outline"></i> Inbox
							</a></li>
							<li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#profile4" role="tab"><i class="ion ion-paper-airplane"></i> Sent</a></li>
							<li class="nav-item"> <a class="nav-link" data-bs-toggle="tab" href="#messages4" role="tab"><i class="ion ion-email-unread"></i> Drafts</a></li>
							<li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#starred" role="tab"><i class="ion ion-star"></i>  Starred</a>
							</li>
							<li class="nav-item"><a class="nav-link"data-bs-toggle="tab" href="#trash" role="tab"><i class="ion ion-trash-a"></i> Trash</a></li>
						</ul>
						</div>
						<!-- /.box-body -->
					</div>
			
				</div>
				<!-- /.col -->
				<div class="col-xl-10 col-lg-10 col-12"id="tabContent">
                    <div class="search-loader"id="loader1">
<img style="width:50px;" src="{{ asset('assets/images/lp.gif') }}"/></div>

                <div class="tab-content"style="border: 2px #000;box-shadow: 2px 2px 8px rgba(0, 0, 0, 0.2); ">
				
                    <div class="tab-pane active" id="home4" role="tabpanel">
                        <div class="p-15">
                            <div class="box">
                                <div class="box-header with-border">
                                <h4 class="box-title">Inbox</h4>
                                    <div class="box-controls pull-right">
                                    <div class="box-header-actions">
                                    <div class="lookup lookup-sm lookup-right d-none d-lg-block">
                                    <form action="{{ url('mailbox-data') }}" method="GET" style="display: flex; align-items: center;"id="searchForm">
																			@csrf
																			<input type="text" name="search" placeholder="Search..." value="{{ request('search') }}">
																			<button type="submit" style="background: none; border: none; cursor: pointer; padding: 0;">
																				<i class="fa fa-search"></i>
																			</button>
																		</form>
                                    </div>
                                    </div>
                                </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                <div class="mailbox-controls">
                                    <!-- Check all button -->
                                    <!-- <button type="button" class="btn btn-primary btn-sm checkbox-toggle"><i class="ion ion-android-checkbox-outline-blank"></i>
                                    </button> -->
                                    <div class="btn-group">
                                    <!-- <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-trash-a"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-reply"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-share"></i></button> -->
                                    </div>
                                    <!-- /.btn-group -->
                                    <div class="btn-group">
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-flag margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button> -->
                                        <!-- <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-folder margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button> -->
                                        <!-- <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    </div>
                                    <!-- /.btn-group -->
                                    <button type="button" class="btn btn-primary btn-sm refresh-button"><i class="fa fa-refresh"></i></button>
                                    <div class="pull-right">
                                    {{ $inboxStartMessage }} - {{ $inboxEndMessage }} of {{ $inboxTotal }}
                                    <div class="btn-group">
                                    <a href="{{ route('mailbox.index', ['inboxPageToken' => $inboxPreviousPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm  pagination-button"><i class="fa fa-chevron-left"></i></a>
																
																@if (isset($inboxNextPageToken))
																	<a href="{{ route('mailbox.index', ['inboxPageToken' => $inboxNextPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm pagination-button"><i class="fa fa-chevron-right"></i></a>
																@endif
                                                                

                                    </div>
                                    <!-- /.btn-group -->
                                    </div>
                                    <!-- /.pull-right -->
                                </div>
                                <div class="mailbox-messages inbox-bx">
                                    <div class="table-responsive">
                                        <table class="table table-hover table-striped">
                                        <tbody>
                                        @foreach($inboxMessages as $message)
                                        <tr class="message-row"   data-to="{{ $message['to'] }}"  data-from="{{ $message['from'] }}" 
																			data-subject="{{ $message['subject'] }}" 
																			data-body="{{ htmlspecialchars($message['body']) }}" 
																			data-date="{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}"data-attachment="{{ json_encode($message['attachments']) }}"data-id="{{$message['id']}}">
                                            <td><input type="checkbox"></td>
                                            <td class="mailbox-star"><a class="star-button">    
                                                  @if ($message['is_starred'])
                                                        <i class="fa fa-star text-yellow"></i> <!-- Yellow star for starred emails -->
                                                    @else
                                                        <i class="fa fa-star"></i> <!-- Default star for non-starred emails -->
                                                    @endif</a></td>
                                            <td>
                                                <p class="mailbox-name mb-0 fs-16 fw-600">{{ $message['from'] }}</p>

                                                <a class="mailbox-subject" href="#">{{ $message['subject'] }}</a>
                                            </td>
                                            <td class="mailbox-attachment"></td>
                                            <td class="mailbox-date">{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}</td>
                                        </tr>
                                        @endforeach
                                        </tbody>
                                        </table>
                                    </div>                
                                    <!-- /.table -->
                                </div>
                                <!-- /.mail-box-messages -->
                                </div>
                                <!-- /.box-body -->
                                <div class="box-footer">
                                <div class="mailbox-controls">
                                    <!-- Check all button -->
                                    <!-- <button type="button" class="btn btn-primary btn-sm checkbox-toggle"><i class="ion ion-android-checkbox-outline-blank"></i>
                                    </button> -->
                                    <div class="btn-group">
                                    <!-- <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-trash-a"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-reply"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-share"></i></button> -->
                                    </div>
                                    <!-- /.btn-group -->
                                    <div class="btn-group">
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-flag margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button> -->
                                        <!-- <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-folder margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    </div>
                                    <!-- /.btn-group -->
                                    <!-- <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-refresh"></i></button> -->
                                    <div class="pull-right">
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-left"></i></button>
                                        <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-right"></i></button> -->
                                    </div>
                                    <!-- /.btn-group -->
                                    </div>
                                    <!-- /.pull-right -->
                                </div>
                                </div>
                            </div>
                    <!-- /. box -->
                    </div>
                    </div>
                    <!--close inbox-->
                    <!--start sent-->
                    <div class="tab-pane" id="profile4" role="tabpanel">
                        <div class="p-15">
                            <div class="box">
                                <div class="box-header with-border">
                                <h4 class="box-title">Sent</h4>
                                    <div class="box-controls pull-right">
                                    <div class="box-header-actions">
                                    <div class="lookup lookup-sm lookup-right d-none d-lg-block">
                                    <form action="{{ url('mailbox-data') }}" method="GET" style="display: flex; align-items: center;"id="SentSearchForm">
																			@csrf
																			<input type="text" name="search" placeholder="Search..." value="{{ request('search') }}">
																			<button type="submit" style="background: none; border: none; cursor: pointer; padding: 0;">
																				<i class="fa fa-search"></i>
																			</button>
																		</form>
                                    </div>
                                    </div>
                                </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                <div class="mailbox-controls">
                                    <!-- Check all button -->
                                    <!-- <button type="button" class="btn btn-primary btn-sm checkbox-toggle"><i class="ion ion-android-checkbox-outline-blank"></i>
                                    </button> -->
                                    <div class="btn-group">
                                    <!-- <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-trash-a"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-reply"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-share"></i></button> -->
                                    </div>
                                    <!-- /.btn-group -->
                                    <div class="btn-group">
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-flag margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button> -->
                                        <!-- <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-folder margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button> -->
                                        <!-- <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    </div>
                                    <!-- /.btn-group -->
                                    <button type="button" class="btn btn-primary btn-sm refresh-button"><i class="fa fa-refresh"></i></button>
                                    <div class="pull-right">
                                    {{ $sentStartMessage }} - {{ $sentEndMessage }} of {{ $sentTotal }}
                                    <div class="btn-group">
                                    <a href="{{ route('mailbox.index', ['sentPageToken' => $sentPreviousPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm"><i class="fa fa-chevron-left pagination-button"></i></a>
																
																@if (isset($sentNextPageToken))
																	<a href="{{ route('mailbox.index', ['sentPageToken' => $sentNextPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm"><i class="fa fa-chevron-right pagination-button"></i></a>
																@endif
                                    </div>
                                    <!-- /.btn-group -->
                                    </div>
                                    <!-- /.pull-right -->
                                </div>
                                <div class="mailbox-messages inbox-bx">
                                    <div class="table-responsive">
                                        <table class="table table-hover table-striped">
                                        <tbody>
                                        @foreach($sentMessages as $message)
                                        <tr class="message-row"  data-to="{{ $message['to'] }}"   data-from="{{ $message['from'] }}" 
																			data-subject="{{ $message['subject'] }}" 
																			data-body="{{ htmlspecialchars($message['body']) }}" 
																			data-date="{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}" 
                                                                            data-attachment="{{ htmlspecialchars(json_encode($message['attachments'])) }}" data-id="{{$message['id']}}">
                                            <td><input type="checkbox"></td>
                                            <td class="mailbox-star"><a href="#"class="star-button">
                                            @if ($message['is_starred'])
                <i class="fa fa-star text-yellow"></i> <!-- Yellow star for starred emails -->
            @else
                <i class="fa fa-star"></i> <!-- Default star for non-starred emails -->
            @endif</a></td>
                                            <td>
                                                <p class="mailbox-name mb-0 fs-16 fw-600">{{ $message['from'] }}</p>
                                                <a class="mailbox-subject" href="#">{{ $message['subject'] }}</a>
                                            </td>
                                            <td class="mailbox-attachment"></td>
                                            <td class="mailbox-date">{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}</td>
                                        </tr>
                                        @endforeach
                                        </tbody>
                                        </table>
                                    </div>                
                                    <!-- /.table -->
                                </div>
                                <!-- /.mail-box-messages -->
                                </div>
                                <!-- /.box-body -->
                                <div class="box-footer">
                                <div class="mailbox-controls">
                                    <!-- Check all button -->
                                    <!-- <button type="button" class="btn btn-primary btn-sm checkbox-toggle"><i class="ion ion-android-checkbox-outline-blank"></i>
                                    </button> -->
                                    <div class="btn-group">
                                    <!-- <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-trash-a"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-reply"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-share"></i></button> -->
                                    </div>
                                    <!-- /.btn-group -->
                                    <div class="btn-group">
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-flag margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button> -->
                                        <!-- <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-folder margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    </div>
                                    <!-- /.btn-group -->
                                    <!-- <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-refresh"></i></button> -->
                                    <div class="pull-right">
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-left"></i></button>
                                        <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-right"></i></button> -->
                                    </div>
                                    <!-- /.btn-group -->
                                    </div>
                                    <!-- /.pull-right -->
                                </div>
                                </div>
                            </div>
                    <!-- /. box -->
                    </div>
                    </div>
                    <!--end sent-->
                       <!--start draft-->
                       <div class="tab-pane" id="messages4" role="tabpanel">
                        <div class="p-15">
                            <div class="box">
                                <div class="box-header with-border">
                                <h4 class="box-title">Drafts</h4>
                                    <div class="box-controls pull-right">
                                    <div class="box-header-actions">
                                    <div class="lookup lookup-sm lookup-right d-none d-lg-block">
                                    <form action="{{ url('mailbox-data') }}" method="GET" style="display: flex; align-items: center;"id="DraftSearchForm">
																			@csrf
																			<input type="text" name="search" placeholder="Search..." value="{{ request('search') }}">
																			<button type="submit" style="background: none; border: none; cursor: pointer; padding: 0;">
																				<i class="fa fa-search"></i>
																			</button>
																		</form>
                                    </div>
                                    </div>
                                </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                <div class="mailbox-controls">
                                    <!-- Check all button -->
                                    <!-- <button type="button" class="btn btn-primary btn-sm checkbox-toggle"><i class="ion ion-android-checkbox-outline-blank"></i>
                                    </button> -->
                                    <div class="btn-group">
                                    <!-- <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-trash-a"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-reply"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-share"></i></button> -->
                                    </div>
                                    <!-- /.btn-group -->
                                    <div class="btn-group">
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-flag margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button> -->
                                        <!-- <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-folder margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button> -->
                                        <!-- <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    </div>
                                    <!-- /.btn-group -->
                                    <button type="button" class="btn btn-primary btn-sm refresh-button"><i class="fa fa-refresh"></i></button>
                                    <div class="pull-right">
                                    {{ $draftStartMessage }} - {{ $draftEndMessage }} of {{ $draftTotal }}

                                    <div class="btn-group">
                                    <a href="{{ route('mailbox.index', ['draftPageToken' => $draftPreviousPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm"><i class="fa fa-chevron-left pagination-button"></i></a>
																
																@if (isset($draftNextPageToken))
																	<a href="{{ route('mailbox.index', ['draftPageToken' => $draftNextPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm"><i class="fa fa-chevron-right pagination-button"></i></a>
																@endif
                                    </div>
                                    <!-- /.btn-group -->
                                    </div>
                                    <!-- /.pull-right -->
                                </div>
                                <div class="mailbox-messages inbox-bx">
                                    <div class="table-responsive">
                                        <table class="table table-hover table-striped">
                                        <tbody>
                                        @foreach($draftMessages as $message)
                                        <tr class="message-row" data-to="{{ $message['to'] }}"    data-from="{{ $message['from'] }}" 
																			data-subject="{{ $message['subject'] }}" 
																			data-body="{{ htmlspecialchars($message['body']) }}" 
																			data-date="{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}"data-attachment="{{ json_encode($message['attachments']) }}"data-id="{{$message['id']}}">
                                            <td><input type="checkbox"></td>
                                            <td class="mailbox-star"><a href="#"class="star-button">@if ($message['is_starred'])
                <i class="fa fa-star text-yellow"></i> <!-- Yellow star for starred emails -->
            @else
                <i class="fa fa-star"></i> <!-- Default star for non-starred emails -->
            @endif</a></td>
                                            <td>
                                                <p class="mailbox-name mb-0 fs-16 fw-600">{{ $message['from'] }}</p>
                                                <a class="mailbox-subject" href="#">{{ $message['subject'] }}</a>
                                            </td>
                                            <td class="mailbox-attachment"></td>
                                            <td class="mailbox-date">{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}</td>
                                        </tr>
                                        @endforeach
                                        </tbody>
                                        </table>
                                    </div>                
                                    <!-- /.table -->
                                </div>
                                <!-- /.mail-box-messages -->
                                </div>
                                <!-- /.box-body -->
                                <div class="box-footer">
                                <div class="mailbox-controls">
                                    <!-- Check all button -->
                                    <!-- <button type="button" class="btn btn-primary btn-sm checkbox-toggle"><i class="ion ion-android-checkbox-outline-blank"></i>
                                    </button> -->
                                    <div class="btn-group">
                                    <!-- <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-trash-a"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-reply"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-share"></i></button> -->
                                    </div>
                                    <!-- /.btn-group -->
                                    <div class="btn-group">
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-flag margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button> -->
                                        <!-- <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-folder margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    </div>
                                    <!-- /.btn-group -->
                                    <!-- <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-refresh"></i></button> -->
                                    <div class="pull-right">
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-left"></i></button>
                                        <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-right"></i></button> -->
                                    </div>
                                    <!-- /.btn-group -->
                                    </div>
                                    <!-- /.pull-right -->
                                </div>
                                </div>
                            </div>
                    <!-- /. box -->
                    </div>
                    </div>
                    <!--end draft-->
                        <!--start starred-->
                        <div class="tab-pane" id="starred" role="tabpanel">
                        <div class="p-15">
                            <div class="box">
                                <div class="box-header with-border">
                                <h4 class="box-title">Starred</h4>
                                    <div class="box-controls pull-right">
                                    <div class="box-header-actions">
                                    <div class="lookup lookup-sm lookup-right d-none d-lg-block">
                                    <form action="{{ url('mailbox-data') }}" method="GET" style="display: flex; align-items: center;"id="StarredSearchForm">
																			@csrf
																			<input type="text" name="search" placeholder="Search..." value="{{ request('search') }}">
																			<button type="submit" style="background: none; border: none; cursor: pointer; padding: 0;">
																				<i class="fa fa-search"></i>
																			</button>
																		</form>
                                    </div>
                                    </div>
                                </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                <div class="mailbox-controls">
                                    <!-- Check all button -->
                                    <!-- <button type="button" class="btn btn-primary btn-sm checkbox-toggle"><i class="ion ion-android-checkbox-outline-blank"></i>
                                    </button> -->
                                    <div class="btn-group">
                                    <!-- <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-trash-a"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-reply"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-share"></i></button> -->
                                    </div>
                                    <!-- /.btn-group -->
                                    <div class="btn-group">
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-flag margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button> -->
                                        <!-- <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-folder margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button> -->
                                        <!-- <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    </div>
                                    <!-- /.btn-group -->
                                    <button type="button" class="btn btn-primary btn-sm refresh-button"><i class="fa fa-refresh"></i></button>
                                    <div class="pull-right">
                                    {{ $starredStartMessage }} - {{ $starredEndMessage }} of {{ $starredTotal }}

                                    <div class="btn-group">
                                    <a href="{{ route('mailbox.index', ['starredPageToken' => $starredPreviousPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm pagination-button"><i class="fa fa-chevron-left "></i></a>
																
																
																	<a href="{{ route('mailbox.index', ['starredPageToken' => $starredNextPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm"><i class="fa fa-chevron-right pagination-buttons"></i></a>
																
                                    </div>
                                    <!-- /.btn-group -->
                                    </div>
                                    <!-- /.pull-right -->
                                </div>
                                <div class="mailbox-messages inbox-bx"id="starred">
                                    <div class="table-responsive">
                                        <table class="table table-hover table-striped">
                                        <tbody>
                                        @foreach($starredMessages as $message)
                                        <tr class="message-row" data-to="{{ $message['to'] }}"    data-from="{{ $message['from'] }}" 
																			data-subject="{{ $message['subject'] }}" 
																			data-body="{{ htmlspecialchars($message['body']) }}" 
																			data-date="{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}"data-attachment="{{ json_encode($message['attachments']) }}"data-id="{{$message['id']}}">
                                            <td><input type="checkbox"></td>
                                            <td class="mailbox-star"><a href="#"class="star-button">@if ($message['is_starred'])
                <i class="fa fa-star text-yellow"></i> <!-- Yellow star for starred emails -->
            @else
                <i class="fa fa-star"></i> <!-- Default star for non-starred emails -->
            @endif</a></td>
                                            <td>
                                                <p class="mailbox-name mb-0 fs-16 fw-600">{{ $message['from'] }}</p>
                                                <a class="mailbox-subject" href="#">{{ $message['subject'] }}</a>
                                            </td>
                                            <td class="mailbox-attachment"></td>
                                            <td class="mailbox-date">{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}</td>
                                        </tr>
                                        @endforeach
                                        </tbody>
                                        </table>
                                    </div>                
                                    <!-- /.table -->
                                </div>
                                <!-- /.mail-box-messages -->
                                </div>
                                <!-- /.box-body -->
                                <div class="box-footer">
                                <div class="mailbox-controls">
                                    <!-- Check all button -->
                                    <!-- <button type="button" class="btn btn-primary btn-sm checkbox-toggle"><i class="ion ion-android-checkbox-outline-blank"></i>
                                    </button> -->
                                    <div class="btn-group">
                                    <!-- <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-trash-a"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-reply"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-share"></i></button> -->
                                    </div>
                                    <!-- /.btn-group -->
                                    <div class="btn-group">
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-flag margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button> -->
                                        <!-- <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-folder margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    </div>
                                    <!-- /.btn-group -->
                                    <!-- <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-refresh"></i></button> -->
                                    <div class="pull-right">
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-left"></i></button>
                                        <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-right"></i></button> -->
                                    </div>
                                    <!-- /.btn-group -->
                                    </div>
                                    <!-- /.pull-right -->
                                </div>
                                </div>
                            </div>
                    <!-- /. box -->
                    </div>
                    </div>
                    <!--end starred-->
                      <!--start starred-->
                      <div class="tab-pane" id="trash" role="tabpanel">
                        <div class="p-15">
                            <div class="box">
                                <div class="box-header with-border">
                                <h4 class="box-title">Trash</h4>
                                    <div class="box-controls pull-right">
                                    <div class="box-header-actions">
                                    <div class="lookup lookup-sm lookup-right d-none d-lg-block">
                                    <form action="{{ url('mailbox-data') }}" method="GET" style="display: flex; align-items: center;"id="TrashSearchForm">
																			@csrf
																			<input type="text" name="search" placeholder="Search..." value="{{ request('search') }}">
																			<button type="submit" style="background: none; border: none; cursor: pointer; padding: 0;">
																				<i class="fa fa-search"></i>
																			</button>
																		</form>
                                    </div>
                                    </div>
                                </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                <div class="mailbox-controls">
                                    <!-- Check all button -->
                                    <!-- <button type="button" class="btn btn-primary btn-sm checkbox-toggle"><i class="ion ion-android-checkbox-outline-blank"></i>
                                    </button> -->
                                    <div class="btn-group">
                                    <!-- <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-trash-a"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-reply"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-share"></i></button> -->
                                    </div>
                                    <!-- /.btn-group -->
                                    <div class="btn-group">
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-flag margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button> -->
                                        <!-- <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-folder margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button> -->
                                        <!-- <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    </div>
                                    <!-- /.btn-group -->
                                    <button type="button" class="btn btn-primary btn-sm refresh-button"><i class="fa fa-refresh"></i></button>
                                    <div class="pull-right">
                                    {{ $trashStartMessage }} - {{ $trashEndMessage }} of {{ $trashTotal }}

                                    <div class="btn-group">
                                    <a href="{{ route('mailbox.index', ['trashPageToken' => $trashPreviousPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm pagination-button"><i class="fa fa-chevron-left"></i></a>
																
																
																	<a href="{{ route('mailbox.index', ['trashPageToken' => $trashNextPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm pagination-button"><i class="fa fa-chevron-right"></i></a>
																
                                    </div>
                                    <!-- /.btn-group -->
                                    </div>
                                    <!-- /.pull-right -->
                                </div>
                                <div class="mailbox-messages inbox-bx">
                                    <div class="table-responsive">
                                        <table class="table table-hover table-striped">
                                        <tbody>
                                        @foreach($trashMessages as $message)
                                        <tr class="message-row" data-to="{{$message['to']}}"   data-from="{{ $message['from'] }}" 
																			data-subject="{{ $message['subject'] }}" 
																			data-body="{{ htmlspecialchars($message['body']) }}" 
																			data-date="{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}"data-attachment="{{ json_encode($message['attachments']) }}"data-id="{{$message['id']}}">
                                            <td><input type="checkbox"></td>
                                            <td class="mailbox-star"><a href="#"class="star-button">@if ($message['is_starred'])
                <i class="fa fa-star text-yellow"></i> <!-- Yellow star for starred emails -->
            @else
                <i class="fa fa-star"></i> <!-- Default star for non-starred emails -->
            @endif</a></td>
                                            <td>
                                                <p class="mailbox-name mb-0 fs-16 fw-600">{{ $message['from'] }}</p>
                                                <a class="mailbox-subject" href="#">{{ $message['subject'] }}</a>
                                            </td>
                                            <td class="mailbox-attachment"></td>
                                            <td class="mailbox-date">{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}</td>
                                        </tr>
                                        @endforeach
                                        </tbody>
                                        </table>
                                    </div>                
                                    <!-- /.table -->
                                </div>
                                <!-- /.mail-box-messages -->
                                </div>
                                <!-- /.box-body -->
                                <div class="box-footer">
                                <div class="mailbox-controls">
                                    <!-- Check all button -->
                                    <!-- <button type="button" class="btn btn-primary btn-sm checkbox-toggle"><i class="ion ion-android-checkbox-outline-blank"></i>
                                    </button> -->
                                    <div class="btn-group">
                                    <!-- <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-trash-a"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-reply"></i></button>
                                    <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-share"></i></button> -->
                                    </div>
                                    <!-- /.btn-group -->
                                    <div class="btn-group">
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-flag margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button> -->
                                        <!-- <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ion ion-folder margin-r-5"></i>
                                        <span class="caret"></span>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                        </div> -->
                                    </div>
                                    </div>
                                    <!-- /.btn-group -->
                                    <!-- <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-refresh"></i></button> -->
                                    <div class="pull-right">
                                    <div class="btn-group">
                                        <!-- <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-left"></i></button>
                                        <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-right"></i></button> -->
                                    </div>
                                    <!-- /.btn-group -->
                                    </div>
                                    <!-- /.pull-right -->
                                </div>
                                </div>
                            </div>
                    <!-- /. box -->
                    </div>
                    </div>
                    <!--end trash-->
                </div>
               </div>
				<!-- /.col -->
				<div class="col-xl-10 col-12"id="messageContent"style="display:none;">
				  <div class="box"id="messageContent1"style="border: 2px #000;box-shadow: 2px 2px 8px rgba(0, 0, 0, 0.2); ">
                    <input type="hidden" id="hidden-from-email" value="">

					<div class="box-body pt-10">
					  <div class="mailbox-read-info">
                       <div class="btn-group">
                      <button id="backButton"class="btn btn-primary"style="margin-right:5px;"><i class="fa fa-arrow-left"></i></button>
                      <form action="{{ route('delete.email') }}" method="POST">
                            @csrf
                            <input type="hidden" name="message_id" value=""id="message_id">
                            <button type="submit"class="btn btn-primary"><i class="fa fa-trash-o"></i></button>
                        </form>
</div>
<br>
						<h4></h4>
					  </div>
					  <div class="mailbox-read-info clearfix mb-20">
						<!-- <div class="float-start me-10"><a href="#"><img src="../images/1.jpg" alt="user" width="40" class="rounded-circle"></a></div> -->
						<h5 class="no-margin"id="mail-from"><br>
							 <small></small>
                           
						  <span class="mailbox-read-time pull-right"></span></h5>
					  </div>
					  <!-- /.mailbox-read-info -->
					  <div class="mailbox-controls with-border clearfix">                
						<div class="float-start">
						  <!-- <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="tooltip" title="Print">
						  <i class="fa fa-print"></i></button> -->
						</div>
						<div class="float-end">
						<div class="btn-group">
    
						   <!-- <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="tooltip" data-container="body" title="Delete">
							<i class="fa fa-trash-o"></i></button> -->
						<!--  <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="tooltip" data-container="body" title="Reply">
							<i class="fa fa-reply"></i></button>
						  <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="tooltip" data-container="body" title="Forward">
							<i class="fa fa-share"></i></button> -->
						</div>
						</div>
						<!-- /.btn-group -->

					  </div>
					  <!-- /.mailbox-controls -->
					  <div class="mailbox-read-message read-mail-bx">
						<!-- <p>Dear USer,</p>

						<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem.Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi.</p>

						<p>enean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus. Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum. Nam quam nunc, blandit vel, luctus pulvinar.</p>

						<p>Thanks,<br>Jane</p> -->
					  </div>
					  <!-- /.mailbox-read-message -->
					</div>
					<!-- /.box-body -->
					<div class="box-footer">
						<h5><i class="fa fa-paperclip m-r-10 m-b-10"></i> Attachments <span></span></h5>
					  <ul class="mailbox-attachments clearfix">
						<li>
						<div class="mailbox-attachments"></div>
						</li>
					
					  </ul>
                     
                      <div class="form-group"id="user-forward"style="display:none;">
                      <input type="text" id="hidden-forward-body" value="">

                      <form method="post"action="{{url('user-send-email')}}"enctype="multipart/form-data">
									@csrf
                     <label class="form-label">To </label>
                     <input type="text" name="to" id="" placeholder="">

                   
											<textarea id="compose-textarea-forward" class="form-control" style="height: 100px"name="body">
											
											</textarea><br>
                                        
                                            <button type="submit"class="btn btn-primary">Send</button>

                                           
									
                       </form>   
                       <button type="button"style="float:right;"class="btn btn-primary"id="delete-button-forward"><i class="fa fa-trash-o"></i><button>

									</div>
                                    <div class="form-group"id="user-reply"style="display:none;">
                      <form method="post"action="{{url('user-send-email')}}"enctype="multipart/form-data">
									@csrf
                     <div id="to"></div>
                     <input type="hidden" name="to" id="email_to">
                   
											<textarea id="compose-textarea-reply" class="form-control" style="height: 100px"name="body">
											
											</textarea><br>
                                            <div class="btn btn-info btn-file">
										<i class="fa fa-paperclip"></i> Attachment
										<input type="file" name="attachment">
									
										<!-- <p class="help-block">Max. 32MB</p> -->
									</div>
                                            <button type="submit"class="btn btn-primary">Send</button>

                                           
									
                       </form>   
                       <button type="button"style="float:right;"class="btn btn-primary"id="delete-button"><i class="fa fa-trash-o"></i><button>

									</div>
					</div>
					<!-- /.box-footer -->
					<div class="box-footer">
					  <div class="pull-right">
						<button type="button" class="btn btn-success"id="reply-button"><i class="fa fa-reply"></i> Reply</button>
						<!-- <button type="button" class="btn btn-info"id="forward-button"><i class="fa fa-share"></i> Forward</button> -->
					  </div>
					  <!-- <button type="button" class="btn btn-danger"><i class="fa fa-trash-o"></i></button>
					  <button type="button" class="btn btn-warning"><i class="fa fa-print"></i></button> -->
					</div>
					<!-- /.box-footer -->
				  </div>
				  <!-- /. box -->
				</div>
				<!-- /.col -->
			  </div>
		</section>
		<!-- /.content -->
	
  <!-- /.content-wrapper -->
  <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
   <!-- Include Bootstrap CSS -->
   <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" rel="stylesheet">
    <!-- Include jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Include Bootstrap JS -->
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
  <script>
    // Replace 'compose-textarea-reply' and 'compose-textarea-forward' with the IDs of your CKEditor instances
    CKEDITOR.replace('compose-textarea', {
        enterMode: CKEDITOR.ENTER_BR,  // Use <br> for line breaks
        shiftEnterMode: CKEDITOR.ENTER_P  // Use <p> for new paragraphs
    });

    
</script>
  <script>
    $(document).ready(function() {
        $('.toggle-body').on('click', function() {
            // Toggle the visibility of full message body
            $(this).closest('td').find('.full-body').toggle();
            // Change button text based on visibility
            var buttonText = $(this).text() === 'Show More' ? 'Show Less' : 'Show More';
            $(this).text(buttonText);
        });
    });
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.message-row').forEach(function(row) {
        row.addEventListener('click', function(event) {
            if (!event.target.closest('.star-button')) {
                document.getElementById('messageContent').style.display = 'block';
                document.getElementById('tabContent').style.display = 'none';

                const fromEmail = this.getAttribute('data-from');
                const subject = this.getAttribute('data-subject');
                const body = this.getAttribute('data-body');
                const decodedBody = $('<div/>').html(body).text();
                const date = this.getAttribute('data-date');
                const attachment = this.getAttribute('data-attachment');
                const id = this.getAttribute('data-id');
                const to = this.getAttribute('data-to');

                console.log('From:', fromEmail);
                console.log('Subject:', subject);
                console.log('Body:', body);
                console.log('id:', id);
                console.log('Attachment:', attachment);
                console.log('To:', to);

                document.querySelector('#messageContent .mailbox-read-info h4').textContent = subject;
                document.querySelector('#messageContent .mailbox-read-info h5').innerHTML = `${fromEmail}<br><small>From: ${fromEmail}</small><span class="mailbox-read-time pull-right">${date}</span><br><small>To: ${to}</small>`;
                document.querySelector('#messageContent .mailbox-read-message').innerHTML = `<p>${decodedBody}</p>`;
                document.querySelector('#messageContent #message_id').value = id;

                const attachmentContainer = document.querySelector('#messageContent .mailbox-attachments');
                attachmentContainer.innerHTML = '';

                if (attachment) {
                    try {
                        const decodedAttachment = decodeEntities(attachment);
                        const attachmentData = JSON.parse(decodedAttachment);
                        console.log('Parsed Attachment Data:', attachmentData);

                        if (attachmentData.length > 0) {
                            attachmentData.forEach(att => {
                                const attachmentElement = document.createElement('div');
                                attachmentElement.className = 'attachment-item';
                                attachmentElement.innerHTML = `<span class="mailbox-attachment-name">${att.filename}</span>`;
                                attachmentContainer.appendChild(attachmentElement);
                            });
                        } else {
                            const noAttachmentElement = document.createElement('div');
                            noAttachmentElement.className = 'attachment-item';
                            noAttachmentElement.textContent = 'No attachment';
                            attachmentContainer.appendChild(noAttachmentElement);
                        }
                    } catch (e) {
                        console.error('Failed to parse attachment JSON:', e);
                        const errorElement = document.createElement('div');
                        errorElement.className = 'attachment-item';
                        errorElement.textContent = 'Invalid attachment data';
                        attachmentContainer.appendChild(errorElement);
                    }
                } else {
                    const noAttachmentElement = document.createElement('div');
                    noAttachmentElement.className = 'attachment-item';
                    noAttachmentElement.textContent = 'No attachment';
                    attachmentContainer.appendChild(noAttachmentElement);
                }

                document.getElementById('hidden-from-email').value = fromEmail;
            }
        });
    });


function decodeEntities(encodedString) {
    const textArea = document.createElement('textarea');
    textArea.innerHTML = encodedString;
    return textArea.value;
}

// document.addEventListener('DOMContentLoaded', function() {
//     document.querySelectorAll('.message-row').forEach(function(row) {
//         row.addEventListener('click', function(event) {
//             if (!event.target.closest('.star-button')) {
//                 document.getElementById('messageContent').style.display = 'block';
//                 document.getElementById('tabContent').style.display = 'none';

//                 const fromEmail = this.getAttribute('data-from');
//                 const subject = this.getAttribute('data-subject');
//                 const body = this.getAttribute('data-body');
//                 const decodedBody = $('<div/>').html(body).text();
//                 const date = this.getAttribute('data-date');
//                 const attachment = this.getAttribute('data-attachment');
//                 const id = this.getAttribute('data-id');
//                 const to = this.getAttribute('data-to');

//                 console.log('From:', fromEmail);
//                 console.log('Subject:', subject);
//                 console.log('Body:', body);
//                 console.log('id:', id);
//                 console.log('Attachment:', attachment);
//                 console.log('To:', to);

//                 document.querySelector('#messageContent .mailbox-read-info h4').textContent = subject;
//                 document.querySelector('#messageContent .mailbox-read-info h5').innerHTML = `${fromEmail}<br><small>From: ${fromEmail}</small><span class="mailbox-read-time pull-right">${date}</span><br><small>To: ${to}</small>`;
//                 document.querySelector('#messageContent .mailbox-read-message').innerHTML = `<p>${decodedBody}</p>`;
//                 document.querySelector('#messageContent #message_id').value = id;

//                 const attachmentContainer = document.querySelector('#messageContent .mailbox-attachments');
//                 attachmentContainer.innerHTML = '';

//                 if (attachment) {
//                     try {
//                         const attachmentData = attachment;
//                         if (attachmentData.length > 0) {
//                             attachmentData.forEach(att => {
//                                 const attachmentElement = document.createElement('div');
//                                 attachmentElement.className = 'attachment-item';
//                                 attachmentElement.innerHTML = `<span class="mailbox-attachment-name">${att.filename}</span>`;
//                                 attachmentContainer.appendChild(attachmentElement);
//                             });
//                         } else {
//                             const noAttachmentElement = document.createElement('div');
//                             noAttachmentElement.className = 'attachment-item';
//                             noAttachmentElement.textContent = 'No attachment';
//                             attachmentContainer.appendChild(noAttachmentElement);
//                         }
//                     } catch (e) {
//                         console.error('Failed to parse attachment JSON:', e);
//                         const errorElement = document.createElement('div');
//                         errorElement.className = 'attachment-item';
//                         errorElement.textContent = 'Invalid attachment data';
//                         attachmentContainer.appendChild(errorElement);
//                     }
//                 } else {
//                     const noAttachmentElement = document.createElement('div');
//                     noAttachmentElement.className = 'attachment-item';
//                     noAttachmentElement.textContent = 'No attachment';
//                     attachmentContainer.appendChild(noAttachmentElement);
//                 }

//                 document.getElementById('hidden-from-email').value = fromEmail;
//             }
//         });
//     });



  
    document.getElementById('reply-button').addEventListener('click', function() {
    // Get the stored from email from the hidden input field
    const fromEmail = document.getElementById('hidden-from-email').value;

    // Alert to ensure the fromEmail value is correct
    //  alert(fromEmail);

    // Check if the element with id 'to' exists
    const toElement = document.getElementById('to');
    if (toElement) {
        // Set the "from email" content in the To div
        toElement.textContent = `To: ${fromEmail}`;

        // Append the fromEmail value to the email_to input field
        document.getElementById('email_to').value = fromEmail;

        // Show the user-reply div
        document.getElementById('user-reply').style.display = 'block';

        // Hide the reply button
        this.style.display = 'none';

        // Hide the forward button
        document.getElementById('forward-button').style.display = 'none';
    } else {
        console.error('Element with id "to" not found');
    }
});


    // Handle back button
    document.getElementById('backButton').addEventListener('click', function() {
        document.getElementById('messageContent').style.display = 'none'; // Hide the message content div
        document.getElementById('tabContent').style.display = 'block'; // Show the tab content div
    });
});

</script>


<script>
   document.querySelectorAll('.refresh-button').forEach(button => {
        button.addEventListener('click', function() {
            location.reload();
        });
    });
   

</script>
<script>
        $(document).ready(function() {
            $('.nav-link').on('click', function() {
                $('#tabContent').show();
                $('#messageContent').hide();
            });
        });
    </script>
<script>
    $(document).ready(function() {
        $('.star-button').on('click', function(event) {
            event.preventDefault();
            var $row = $(this).closest('.message-row');
            var emailId = $row.data('id');
            var $starIcon = $(this).find('.fa-star');

            if ($starIcon.hasClass('text-yellow')) {
                // Star is currently filled (yellow), so unstar (remove yellow color)
                $starIcon.removeClass('text-yellow');

                // Send AJAX request to unstar the email
                $.ajax({
                    url: '/unstar-email',
                    method: 'POST',
                    data: {
                        emailId: emailId,
                        _token: '{{ csrf_token() }}'  // If using Laravel
                    },
                    success: function(response) {
                        if (response.success) {
                            window.location.reload();
                            console.log('Email unstarred successfully');
                            // Remove from starred section
                            $('#starred tbody .message-row[data-id="' + emailId + '"]').fadeOut(function() {
                                $(this).remove();
                            });
                        } else {
                            console.log('Failed to unstar email');
                        }
                    },
                    error: function() {
                        console.log('Error unstarring email');
                    }
                });
            } else {
                // Star is currently unfilled, so star (add yellow color)
                $starIcon.addClass('text-yellow');

                // Send AJAX request to star the email
                $.ajax({
                    url: '/star-email',
                    method: 'POST',
                    data: {
                        emailId: emailId,
                        _token: '{{ csrf_token() }}'  // If using Laravel
                    },
                    success: function(response) {
                        if (response.success) {
                            window.location.reload();
                            console.log('Email starred successfully');
                            // Clone the email row and append to the starred section
                            var $clonedRow = $row.clone(true);
                            $('#starred tbody').append($clonedRow);
                        } else {
                            console.log('Failed to star email');
                        }
                    },
                    error: function() {
                        console.log('Error starring email');
                    }
                });
            }
        });
    });
</script>


<script>
     // Replace 'compose-textarea-reply' and 'compose-textarea-forward' with the IDs of your CKEditor instances
     CKEDITOR.replace('compose-textarea-reply', {
        enterMode: CKEDITOR.ENTER_BR,  // Use <br> for line breaks
        shiftEnterMode: CKEDITOR.ENTER_P  // Use <p> for new paragraphs
    });
</script>
<script>
    CKEDITOR.replace('compose-textarea-forward');
</script>
<script>
  document.getElementById('delete-button').addEventListener('click', function() {
    // Hide the user-reply div
    document.getElementById('user-reply').style.display = 'none';

    // Show the reply button
    document.getElementById('reply-button').style.display = 'block';

    // Show the forward button
    document.getElementById('forward-button').style.display = 'block';
});

document.addEventListener('DOMContentLoaded', function () {
    const form = document.getElementById('searchForm');
    const loader = document.getElementById('loader');

    form.addEventListener('submit', function (event) {
        // Show the loader
        loader.style.display = 'block';

        // Optionally, you can disable the submit button to prevent multiple submissions
        form.querySelector('button[type="submit"]').disabled = true;
    });

    // Hide the loader when the window loads (after the response is received)
    window.addEventListener('load', function () {
        loader.style.display = 'none';
    });
});
document.addEventListener('DOMContentLoaded', function () {
    const form = document.getElementById('SentSearchForm');
    const loader = document.getElementById('loader');

    form.addEventListener('submit', function (event) {
        // Show the loader
        loader.style.display = 'block';

        // Optionally, you can disable the submit button to prevent multiple submissions
        form.querySelector('button[type="submit"]').disabled = true;
    });

    // Hide the loader when the window loads (after the response is received)
    window.addEventListener('load', function () {
        loader.style.display = 'none';
    });
});
document.addEventListener('DOMContentLoaded', function () {
    const form = document.getElementById('DraftsearchForm');
    const loader = document.getElementById('loader');

    form.addEventListener('submit', function (event) {
        // Show the loader
        loader.style.display = 'block';

        // Optionally, you can disable the submit button to prevent multiple submissions
        form.querySelector('button[type="submit"]').disabled = true;
    });

    // Hide the loader when the window loads (after the response is received)
    window.addEventListener('load', function () {
        loader.style.display = 'none';
    });
});
document.addEventListener('DOMContentLoaded', function () {
    const form = document.getElementById('StarredSearchForm');
    const loader = document.getElementById('loader');

    form.addEventListener('submit', function (event) {
        // Show the loader
        loader.style.display = 'block';

        // Optionally, you can disable the submit button to prevent multiple submissions
        form.querySelector('button[type="submit"]').disabled = true;
    });

    // Hide the loader when the window loads (after the response is received)
    window.addEventListener('load', function () {
        loader.style.display = 'none';
    });
});
document.addEventListener('DOMContentLoaded', function () {
    const form = document.getElementById('TrashSearchForm');
    const loader = document.getElementById('loader');

    form.addEventListener('submit', function (event) {
        // Show the loader
        loader.style.display = 'block';

        // Optionally, you can disable the submit button to prevent multiple submissions
        form.querySelector('button[type="submit"]').disabled = true;
    });

    // Hide the loader when the window loads (after the response is received)
    window.addEventListener('load', function () {
        loader.style.display = 'none';
    });
});
</script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
    const forms = document.querySelectorAll('.searchForm');
    const paginationButtons = document.querySelectorAll('.pagination-button');
    const loader = document.getElementById('loader');

    forms.forEach(function (form) {
        form.addEventListener('submit', function () {
            // Show the loader
            loader.style.display = 'block';

            // Optionally, you can disable the submit button to prevent multiple submissions
            form.querySelector('button[type="submit"]').disabled = true;
        });
    });

    paginationButtons.forEach(function (button) {
        button.addEventListener('click', function () {
            // Show the loader
            loader.style.display = 'block';
        });
    });

    // Hide the loader when the window loads (after the response is received)
    window.addEventListener('load', function () {
        loader.style.display = 'none';
    });
});

    </script>
    
  @endsection
 

