@extends('layouts.app')
@section('title', 'Profile')
@section('content')
 <style> 
.lookup::before {
    content: "";
    font-family: themify;
    font-size: 1rem;
    position: absolute;
    top: 52%;
    left: 0;
    -webkit-transform: translateY(-50%);
    transform: translateY(-50%);
    color: rgba(0, 0, 0, 0.4);
    width: 36px;
    text-align: center;
    cursor: text;
}
</style>
		<!-- Main content -->
		<section class="content">
			<div class="row">
				<div class="col-xl-2 col-lg-4 col-12">
				  <button class="btn btn-danger w-p100 mb-30" type="button" alt="default" data-bs-toggle="modal" data-bs-target=".bs-example-modal-lg">Compose</button>

					<div class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
						<div class="modal-dialog modal-lg">
							<div class="modal-content">
								<div class="modal-header">
									<h4 class="modal-title" id="myLargeModalLabel">Compose New Message</h4>
									<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
								</div>
								<form method="post"action="{{url('user-send-email')}}"enctype="multipart/form-data">
									@csrf
								<div class="modal-body">
									<div class="form-group">
										<input class="form-control" placeholder="To:"name="to">
									</div>
									<div class="form-group">
										<input class="form-control" placeholder="Subject:"name="subject">
									</div>
									<div class="form-group">
											<textarea id="compose-textarea" class="form-control" style="height: 300px"name="body">
											<p>Your Message Here....</p>
											</textarea>
									</div>
									<div class="form-group">
										<div class="btn btn-info btn-file">
										<i class="fa fa-paperclip"></i> Attachment
										<input type="file" name="attachment">
										</div>
										<!-- <p class="help-block">Max. 32MB</p> -->
									</div>
								</div>
								<div class="modal-footer">
									<div class="pull-right">
										<!-- <button type="button" class="btn btn-default"><i class="fa fa-pencil"></i> Draft</button> -->
										<button type="submit" class="btn btn-success"><i class="fa fa-envelope-o"></i> Send</button>
									</div>
									<button type="reset" class="btn btn-danger"><i class="fa fa-times"></i> Discard</button>
									<button type="button" class="btn btn-danger text-start" data-bs-dismiss="modal">Close</button>
								</div>
							</form>
							</div>
							<!-- /.modal-content -->
						</div>
						<!-- /.modal-dialog -->
					</div>
				   <!-- /.modal -->
					<div class="box">
						<div class="box-header with-border">
						<h4 class="box-title">Folders</h4>
						<ul class="box-controls pull-right">
							<li><a class="box-btn-slide" href="#"></a></li>	
						</ul>
						</div>
						<div class="box-body no-padding mailbox-nav">
						<ul class="nav nav-pills flex-column">
							<li class="nav-item"><a class="nav-link active" data-bs-toggle="tab" href="#home4" role="tab"><i class="ion ion-ios-email-outline"></i> Inbox
							</a></li>
							<li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#profile4" role="tab"><i class="ion ion-paper-airplane"></i> Sent</a></li>
							<li class="nav-item"> <a class="nav-link" data-bs-toggle="tab" href="#messages4" role="tab"><i class="ion ion-email-unread"></i> Drafts</a></li>
							<li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#starred" role="tab"><i class="ion ion-star"></i>  Starred</a>
							</li>
							<li class="nav-item"><a class="nav-link"data-bs-toggle="tab" href="#trash" role="tab"><i class="ion ion-trash-a"></i> Trash</a></li>
						</ul>
						</div>
						<!-- /.box-body -->
					</div>
					<!-- /. box -->
				</div>
				<!-- /.col -->
				<div class="col-xl-6 col-lg-8 col-12">			
					<div class="box-body">
						<!-- Nav tabs -->			
								<div class="tab-content">
				
								    <div class="tab-pane active" id="home4" role="tabpanel">
										<div class="p-15">
											<div class="box">
												<div class="box-header with-border">
													<h4 class="box-title">Inbox</h4>
														<div class="box-controls pull-right">
															<div class="box-header-actions">
																<div class="lookup lookup-sm lookup-right d-none d-lg-block">
																		<form action="{{ url('user-mailbox') }}" method="GET" style="display: flex; align-items: center;">
																			@csrf
																			<input type="text" name="search" placeholder="Search..." value="{{ request('search') }}">
																			<button type="submit" style="background: none; border: none; cursor: pointer; padding: 0;">
																				<i class="fa fa-search"></i>
																			</button>
																		</form>
																	
																</div>
															</div>
														</div>
													
												</div>
												<div class="box-body">
													<div class="mailbox-controls">
												
														<div class="btn-group">
															<div class="btn-group">
																<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																<i class="ion ion-flag margin-r-5"></i>
																<span class="caret"></span>
																</button> -->
																<!-- <div class="dropdown-menu">
																	<a class="dropdown-item" href="#">Action</a>
																	<a class="dropdown-item" href="#">Another action</a>
																	<a class="dropdown-item" href="#">Something else here</a>
																</div> -->
															</div>
															<div class="btn-group">
																<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																<i class="ion ion-folder margin-r-5"></i>
																<span class="caret"></span>
																</button> -->
																<!-- <div class="dropdown-menu">
																	<a class="dropdown-item" href="#">Action</a>
																	<a class="dropdown-item" href="#">Another action</a>
																	<a class="dropdown-item" href="#">Something else here</a>
																</div> -->
															</div>
														</div>
														<!-- /.btn-group -->
														<button type="button" class="btn btn-primary btn-sm refresh-button"><i class="fa fa-refresh"></i></button>
														<div class="pull-right">
															<div class="btn-group">
																<a href="{{ route('mailbox.index', ['inboxPageToken' => $inboxPreviousPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm"><i class="fa fa-chevron-left"></i></a>
																
																@if (isset($inboxNextPageToken))
																	<a href="{{ route('mailbox.index', ['inboxPageToken' => $inboxNextPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm"><i class="fa fa-chevron-right"></i></a>
																@endif
															</div>

														</div>
														<!-- /.pull-right -->
													</div>
													<div class="mailbox-messages">
														<div class="table-responsive">
															<table class="table table-hover table-striped">
																<tbody>
																	@foreach($sentMessages as $message)
																	    <tr class="message-row"    data-from="{{ $message['from'] }}" 
																			data-subject="{{ $message['subject'] }}" 
																			data-body="{{ htmlspecialchars($message['body']) }}" 
																			data-date="{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}"data-attachment="{{ json_encode($message['attachments']) }}">
																			<td><input type="checkbox"></td>
																			<td class="mailbox-star"><a href="#"><i class="fa fa-star text-yellow"></i></a></td>
																			<td>
																				<p class="mailbox-name mb-0 fs-16 fw-600">{{ $message['from'] }}</p>
																				<a class="mailbox-subject" href="#"><b>{{ $message['subject'] }}</b></a>
																				<!-- Show part of the message body initially -->
																				<p class="partial-body">{{ substr(strip_tags($message['body']), 0, 50) }}{{ strlen(strip_tags($message['body'])) > 50 ? '...' : '' }} </p>
																				<!-- Hidden div to hold full message body -->
																				<div class="full-body" style="display: none;">{!!$message['body'] !!}</div>
																				<!-- Button to expand/collapse the message body -->
																				<button class="btn btn-link toggle-body" data-toggle="collapse" data-target=".full-body">Show More</button>								
																			</td>
																				<td class="mailbox-attachment"></td>
																				<td class="mailbox-date">{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}</td>
																		</tr>
																
																	@endforeach
																</tbody>
															</table>
														</div>                

													</div>
									
													<div class="box-footer">
														<div class="mailbox-controls">
															<!-- Check all button -->
															<!-- <button type="button" class="btn btn-primary btn-sm checkbox-toggle"><i class="ion ion-android-checkbox-outline-blank"></i>
															</button> -->
															<!-- <div class="btn-group">
															<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-trash-a"></i></button>
															<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-reply"></i></button>
															<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-share"></i></button>
															</div> -->
															<!-- /.btn-group -->
															<div class="btn-group">
																<div class="btn-group">
																	<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																	<i class="ion ion-flag margin-r-5"></i>
																	<span class="caret"></span>
																	</button> -->
																	<!-- <div class="dropdown-menu">
																		<a class="dropdown-item" href="#">Action</a>
																		<a class="dropdown-item" href="#">Another action</a>
																		<a class="dropdown-item" href="#">Something else here</a>
																	</div> -->
																</div>
																<div class="btn-group">
																	<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																	<i class="ion ion-folder margin-r-5"></i>
																	<span class="caret"></span>
																	</button> -->
																	<!-- <div class="dropdown-menu">
																		<a class="dropdown-item" href="#">Action</a>
																		<a class="dropdown-item" href="#">Another action</a>
																		<a class="dropdown-item" href="#">Something else here</a>
																	</div> -->
																</div>
															</div>
															<!-- /.btn-group -->
															<!-- <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-refresh"></i></button> -->
															<div class="pull-right">
															<!-- <div class="btn-group">
																<button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-left"></i></button>
																<button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-right"></i></button>
															</div> -->
															<!-- /.btn-group -->
															</div>
															<!-- /.pull-right -->
														</div>
													</div>

											    </div>
										    </div>
									    </div>
                                    </div>
									<div class="tab-pane" id="profile4" role="tabpanel">
										<div class="p-15">
											<div class="box">
												<div class="box-header with-border">
													<h4 class="box-title">Sent</h4>
														<div class="box-controls pull-right">
															<div class="box-header-actions">
																<div class="lookup lookup-sm lookup-right d-none d-lg-block">
																		<form action="{{ url('user-mailbox') }}" method="GET" style="display: flex; align-items: center;">
																			@csrf
																			<input type="text" name="search" placeholder="Search..." value="{{ request('search') }}">
																			<button type="submit" style="background: none; border: none; cursor: pointer; padding: 0;">
																				<i class="fa fa-search"></i>
																			</button>
																		</form>
																	
																</div>
															</div>
														</div>
													
												</div>
												<div class="box-body">
													<div class="mailbox-controls">
														<!-- Check all button -->
														<!-- <button type="button" class="btn btn-primary btn-sm checkbox-toggle"><i class="ion ion-android-checkbox-outline-blank"></i>
														</button> -->
														<!-- <div class="btn-group">
														<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-trash-a"></i></button>
														<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-reply"></i></button>
														<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-share"></i></button>
														</div> -->
														<!-- /.btn-group -->
														<div class="btn-group">
															<div class="btn-group">
																<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																<i class="ion ion-flag margin-r-5"></i>
																<span class="caret"></span>
																</button> -->
																<!-- <div class="dropdown-menu">
																	<a class="dropdown-item" href="#">Action</a>
																	<a class="dropdown-item" href="#">Another action</a>
																	<a class="dropdown-item" href="#">Something else here</a>
																</div> -->
															</div>
															<div class="btn-group">
																<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																<i class="ion ion-folder margin-r-5"></i>
																<span class="caret"></span>
																</button> -->
																<!-- <div class="dropdown-menu">
																	<a class="dropdown-item" href="#">Action</a>
																	<a class="dropdown-item" href="#">Another action</a>
																	<a class="dropdown-item" href="#">Something else here</a>
																</div> -->
															</div>
														</div>
														<!-- /.btn-group -->
														<button type="button" class="btn btn-primary btn-sm refresh-button"><i class="fa fa-refresh"></i></button>
														<div class="pull-right">
															<div class="btn-group">
																<a href="{{ route('mailbox.index', ['sentPageToken' => $sentPreviousPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm"><i class="fa fa-chevron-left"></i></a>
																
																@if (isset($sentNextPageToken))
																	<a href="{{ route('mailbox.index', ['sentPageToken' => $sentNextPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm"><i class="fa fa-chevron-right"></i></a>
																@endif
															</div>

														</div>
														<!-- /.pull-right -->
													</div>
													<div class="mailbox-messages inbox-bx">
														<div class="table-responsive">
															<table class="table table-hover table-striped">
																<tbody>
																	@foreach($sentMessages as $message)
																	<tr class="message-row"    data-from="{{ $message['from'] }}" 
																			data-subject="{{ $message['subject'] }}" 
																			data-body="{{ htmlspecialchars($message['body']) }}" 
																			data-date="{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}"data-attachment="{{ json_encode($message['attachments']) }}">
																			<td><input type="checkbox"></td>
																			<td class="mailbox-star"><a href="#"><i class="fa fa-star text-yellow"></i></a></td>
																			<td>
																				<p class="mailbox-name mb-0 fs-16 fw-600">{{ $message['from'] }}</p>
																				<a class="mailbox-subject" href="#"><b>{{ $message['subject'] }}</b></a>
																				<!-- Show part of the message body initially -->
																				<p class="partial-body">{{ substr(strip_tags($message['body']), 0, 50) }}{{ strlen(strip_tags($message['body'])) > 50 ? '...' : '' }} </p>
																				<!-- Hidden div to hold full message body -->
																				<div class="full-body" style="display: none;">{!!$message['body'] !!}</div>
																				<!-- Button to expand/collapse the message body -->
																				<button class="btn btn-link toggle-body" data-toggle="collapse" data-target=".full-body">Show More</button>								</td>
																			<td class="mailbox-attachment"></td>
																			<td class="mailbox-date">{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}
																			</td>
																		</tr>
																
																	@endforeach
																</tbody>
															</table>
														</div>                

													</div>
									
													<div class="box-footer">
														<div class="mailbox-controls">
															<!-- Check all button -->
															<!-- <button type="button" class="btn btn-primary btn-sm checkbox-toggle"><i class="ion ion-android-checkbox-outline-blank"></i>
															</button> -->
															<!-- <div class="btn-group">
															<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-trash-a"></i></button>
															<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-reply"></i></button>
															<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-share"></i></button>
															</div> -->
															<!-- /.btn-group -->
															<div class="btn-group">
																<div class="btn-group">
																	<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																	<i class="ion ion-flag margin-r-5"></i>
																	<span class="caret"></span>
																	</button> -->
																	<!-- <div class="dropdown-menu">
																		<a class="dropdown-item" href="#">Action</a>
																		<a class="dropdown-item" href="#">Another action</a>
																		<a class="dropdown-item" href="#">Something else here</a>
																	</div> -->
																</div>
																<div class="btn-group">
																	<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																	<i class="ion ion-folder margin-r-5"></i>
																	<span class="caret"></span>
																	</button> -->
																	<!-- <div class="dropdown-menu">
																		<a class="dropdown-item" href="#">Action</a>
																		<a class="dropdown-item" href="#">Another action</a>
																		<a class="dropdown-item" href="#">Something else here</a>
																	</div> -->
																</div>
															</div>
															<!-- /.btn-group -->
															<!-- <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-refresh"></i></button> -->
															<div class="pull-right">
															<!-- <div class="btn-group">
																<button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-left"></i></button>
																<button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-right"></i></button>
															</div> -->
															<!-- /.btn-group -->
															</div>
															<!-- /.pull-right -->
														</div>
													</div>

											    </div>
										</div>
									</div>
                                    </div>
									<div class="tab-pane" id="messages4" role="tabpanel">
										<div class="p-15">
											<div class="box">
													<div class="box-header with-border">
														<h4 class="box-title">Draft</h4>
															<div class="box-controls pull-right">
																<div class="box-header-actions">
																	<div class="lookup lookup-sm lookup-right d-none d-lg-block">
																		<form action="{{ url('user-mailbox') }}" method="GET" style="display: flex; align-items: center;">
																			@csrf
																			<input type="text" name="search" placeholder="Search..." value="{{ request('search') }}">
																			<button type="submit" style="background: none; border: none; cursor: pointer; padding: 0;">
																				<i class="fa fa-search"></i>
																			</button>
																		</form>														
																	</div>
																</div>
															</div>
														
													</div>
													<div class="box-body">
														<div class="mailbox-controls">
															<!-- Check all button -->
															<!-- <button type="button" class="btn btn-primary btn-sm checkbox-toggle"><i class="ion ion-android-checkbox-outline-blank"></i> -->
															<!-- </button> -->
															<div class="btn-group">
																<!-- <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-trash-a"></i></button>
																<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-reply"></i></button>
																<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-share"></i></button> -->
															</div>
															<!-- /.btn-group -->
															<div class="btn-group">
																<div class="btn-group">
																	<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																	<i class="ion ion-flag margin-r-5"></i>
																	<span class="caret"></span>
																	</button> -->
																	<!-- <div class="dropdown-menu">
																		<a class="dropdown-item" href="#">Action</a>
																		<a class="dropdown-item" href="#">Another action</a>
																		<a class="dropdown-item" href="#">Something else here</a>
																	</div> -->
																</div>
																<div class="btn-group">
																	<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																	<i class="ion ion-folder margin-r-5"></i>
																	<span class="caret"></span>
																	</button> -->
																	<!-- <div class="dropdown-menu">
																		<a class="dropdown-item" href="#">Action</a>
																		<a class="dropdown-item" href="#">Another action</a>
																		<a class="dropdown-item" href="#">Something else here</a>
																	</div> -->
																</div>
															</div>
															<!-- /.btn-group -->
															<button type="button" class="btn btn-primary btn-sm refresh-button"><i class="fa fa-refresh"></i></button>
															<div class="pull-right">
																<div class="btn-group">
																	<a href="{{ route('mailbox.index', ['draftPageToken' => $draftPreviousPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm"><i class="fa fa-chevron-left"></i></a>
																	
																	@if (isset($draftNextPageToken))
																		<a href="{{ route('mailbox.index', ['draftPageToken' => $draftNextPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm"><i class="fa fa-chevron-right"></i></a>
																	@endif
																</div>

															</div>
															<!-- /.pull-right -->
														</div>
														<div class="mailbox-messages inbox-bx">
															<div class="table-responsive">
																<table class="table table-hover table-striped">
																	<tbody>
																		@foreach($draftMessages as $message)
																		<tr class="message-row"    data-from="{{ $message['from'] }}" 
																				data-subject="{{ $message['subject'] }}" 
																				data-body="{{ htmlspecialchars($message['body']) }}" 
																				data-date="{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}"data-attachment="{{ json_encode($message['attachments']) }}">
																				<td><input type="checkbox"></td>
																				<td class="mailbox-star"><a href="#"><i class="fa fa-star text-yellow"></i></a></td>
																				<td>
																					<p class="mailbox-name mb-0 fs-16 fw-600">{{ $message['from'] }}</p>
																					<a class="mailbox-subject" href="#"><b>{{ $message['subject'] }}</b></a>
																					<!-- Show part of the message body initially -->
																					<p class="partial-body">{{ substr(strip_tags($message['body']), 0, 50) }}{{ strlen(strip_tags($message['body'])) > 50 ? '...' : '' }} </p>
																					<!-- Hidden div to hold full message body -->
																					<div class="full-body" style="display: none;">{!!$message['body'] !!}</div>
																					<!-- Button to expand/collapse the message body -->
																					<button class="btn btn-link toggle-body" data-toggle="collapse" data-target=".full-body">Show More</button>								</td>
																				<td class="mailbox-attachment"></td>
																				<td class="mailbox-date">{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}
																				</td>
																			</tr>
																	
																		@endforeach
																	</tbody>
																</table>
															</div>                
														</div>

													</div>

													<div class="box-footer">
														<div class="mailbox-controls">
															<!-- Check all button -->
															<!-- <button type="button" class="btn btn-primary btn-sm checkbox-toggle"><i class="ion ion-android-checkbox-outline-blank"></i> -->
															<!-- </button> -->
															<div class="btn-group">
																<!-- <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-trash-a"></i></button>
																<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-reply"></i></button>
																<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-share"></i></button> -->
															</div>
															<!-- /.btn-group -->
															<div class="btn-group">
																<div class="btn-group">
																	<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																	<i class="ion ion-flag margin-r-5"></i>
																	<span class="caret"></span>
																	</button> -->
																	<!-- <div class="dropdown-menu">
																		<a class="dropdown-item" href="#">Action</a>
																		<a class="dropdown-item" href="#">Another action</a>
																		<a class="dropdown-item" href="#">Something else here</a>
																	</div> -->
																</div>
																<div class="btn-group">
																	<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																	<i class="ion ion-folder margin-r-5"></i>
																	<span class="caret"></span>
																	</button> -->
																	<!-- <div class="dropdown-menu">
																		<a class="dropdown-item" href="#">Action</a>
																		<a class="dropdown-item" href="#">Another action</a>
																		<a class="dropdown-item" href="#">Something else here</a>
																	</div> -->
																</div>
															</div>
															<!-- /.btn-group -->
															<!-- <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-refresh"></i></button> -->
															<div class="pull-right">
																<div class="btn-group">
																	<!-- <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-left"></i></button>
																	<button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-right"></i></button> -->
																</div>
															</div>
															<!-- /.pull-right -->
															
														</div>
											
													</div>
											
											</div>
										</div>
									</div>
									<div class="tab-pane" id="starred" role="tabpanel">
										<div class="p-15">
												<div class="box">
													<div class="box-header with-border">
														<h4 class="box-title">Starred</h4>
															<div class="box-controls pull-right">
																<div class="box-header-actions">
																	<div class="lookup lookup-sm lookup-right d-none d-lg-block">
																	<form action="{{ url('user-mailbox') }}" method="GET" style="display: flex; align-items: center;">
																		@csrf
																		<input type="text" name="search" placeholder="Search..." value="{{ request('search') }}">
																		<button type="submit" style="background: none; border: none; cursor: pointer; padding: 0;">
																			<i class="fa fa-search"></i>
																		</button>
																	</form>														
																</div>
															</div>
													</div>
													
												
													<div class="box-body">
														<div class="mailbox-controls">
															<!-- Check all button -->
															<!-- <button type="button" class="btn btn-primary btn-sm checkbox-toggle"><i class="ion ion-android-checkbox-outline-blank"></i> -->
															<!-- </button> -->
															<div class="btn-group">
															<!-- <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-trash-a"></i></button>
															<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-reply"></i></button>
															<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-share"></i></button> -->
															</div>
															<!-- /.btn-group -->
															<div class="btn-group">
																<div class="btn-group">
																	<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																	<i class="ion ion-flag margin-r-5"></i>
																	<span class="caret"></span>
																	</button> -->
																	<!-- <div class="dropdown-menu">
																		<a class="dropdown-item" href="#">Action</a>
																		<a class="dropdown-item" href="#">Another action</a>
																		<a class="dropdown-item" href="#">Something else here</a>
																	</div> -->
																</div>
																<div class="btn-group">
																	<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																	<i class="ion ion-folder margin-r-5"></i>
																	<span class="caret"></span>
																	</button> -->
																	<!-- <div class="dropdown-menu">
																		<a class="dropdown-item" href="#">Action</a>
																		<a class="dropdown-item" href="#">Another action</a>
																		<a class="dropdown-item" href="#">Something else here</a>
																	</div> -->
																</div>
															</div>
															<!-- /.btn-group -->
															<button type="button" class="btn btn-primary btn-sm"><i class="fa fa-refresh"></i></button>
															<div class="pull-right">
																<div class="btn-group">
																<a href="{{ route('mailbox.index', ['starredPageToken' => $starredPreviousPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm"><i class="fa fa-chevron-left"></i></a>
																	
																	@if (isset($starredNextPageToken))
																		<a href="{{ route('mailbox.index', ['starredPageToken' => $starredNextPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm"><i class="fa fa-chevron-right"></i></a>
																	@endif
																</div>
															<!-- /.btn-group -->
															</div>
															<!-- /.pull-right -->
														</div>
														<div class="mailbox-messages inbox-bx">
															<div class="table-responsive">
																<table class="table table-hover table-striped">
																	<tbody>
																		@foreach($starredMessages as $message)
																		<tr class="message-row"    data-from="{{ $message['from'] }}" 
																			data-subject="{{ $message['subject'] }}" 
																			data-body="{{ htmlspecialchars($message['body']) }}"
																			data-date="{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}"data-attachment="{{ json_encode($message['attachments']) }}">
																				<td><input type="checkbox"></td>
																				<td class="mailbox-star"><a href="#"><i class="fa fa-star text-yellow"></i></a></td>
																				<td>
																					<p class="mailbox-name mb-0 fs-16 fw-600">{{ $message['from'] }}</p>
																					<a class="mailbox-subject" href="#"><b>{{ $message['subject'] }}</b></a>
																					<!-- Show part of the message body initially -->
																					<p class="partial-body">{{ substr(strip_tags($message['body']), 0, 50) }}{{ strlen(strip_tags($message['body'])) > 50 ? '...' : '' }} </p>
																					<!-- Hidden div to hold full message body -->
																					<div class="full-body" style="display: none;">{!!$message['body'] !!}</div>
																					<!-- Button to expand/collapse the message body -->
																					<button class="btn btn-link toggle-body" data-toggle="collapse" data-target=".full-body">Show More</button>								</td>
																				<td class="mailbox-attachment"></td>
																				<td class="mailbox-date">{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}
																				</td>
																			</tr>
																	
																		@endforeach
																	</tbody>
																</table>
															</div>                
															<!-- /.table -->
														</div>
													<!-- /.mail-box-messages -->
													</div>
													<!-- /.box-body -->
													<div class="box-footer">
														<div class="mailbox-controls">
															<!-- Check all button -->
															<!-- <button type="button" class="btn btn-primary btn-sm checkbox-toggle"><i class="ion ion-android-checkbox-outline-blank"></i> -->
															</button>
															<div class="btn-group">
																<!-- <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-trash-a"></i></button>
																<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-reply"></i></button>
																<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-share"></i></button> -->
															</div>
															<!-- /.btn-group -->
															<div class="btn-group">
																<div class="btn-group">
																	<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																	<i class="ion ion-flag margin-r-5"></i>
																	<span class="caret"></span>
																	</button> -->
																	<!-- <div class="dropdown-menu">
																		<a class="dropdown-item" href="#">Action</a>
																		<a class="dropdown-item" href="#">Another action</a>
																		<a class="dropdown-item" href="#">Something else here</a>
																	</div> -->
																</div>
																<div class="btn-group">
																	<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																	<i class="ion ion-folder margin-r-5"></i>
																	<span class="caret"></span>
																	</button> -->
																	<!-- <div class="dropdown-menu">
																		<a class="dropdown-item" href="#">Action</a>
																		<a class="dropdown-item" href="#">Another action</a>
																		<a class="dropdown-item" href="#">Something else here</a>
																	</div> -->
																</div>
															</div>
															<!-- /.btn-group -->
															<!-- <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-refresh"></i></button> -->
															<div class="pull-right">
																<div class="btn-group">
																	<!-- <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-left"></i></button>
																	<button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-right"></i></button> -->
																</div>
															</div>
															<!-- /.pull-right -->
															
														</div>
											
													</div>
										
												</div>
										</div>
									</div>
                                    </div>
									<div class="tab-pane" id="trash" role="tabpanel">
										<div class="p-15">
											<div class="box">
													<div class="box-header with-border">
														<h4 class="box-title">Trash</h4>
															<div class="box-controls pull-right">
																<div class="box-header-actions">
																	<div class="lookup lookup-sm lookup-right d-none d-lg-block">
																		<form action="{{ url('user-mailbox') }}" method="GET" style="display: flex; align-items: center;">
																			@csrf
																			<input type="text" name="search" placeholder="Search..." value="{{ request('search') }}">
																			<button type="submit" style="background: none; border: none; cursor: pointer; padding: 0;">
																				<i class="fa fa-search"></i>
																			</button>
																		</form>																
																	</div>
																</div>
															</div>
														
													</div>
													<div class="box-body">
														<div class="mailbox-controls">
															<!-- Check all button -->
															<!-- <button type="button" class="btn btn-primary btn-sm checkbox-toggle"><i class="ion ion-android-checkbox-outline-blank"></i> -->
															</button>
															<div class="btn-group">
																<!-- <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-trash-a"></i></button>
																<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-reply"></i></button>
																<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-share"></i></button> -->
															</div>
															<!-- /.btn-group -->
															<div class="btn-group">
																<div class="btn-group">
																	<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																	<i class="ion ion-flag margin-r-5"></i>
																	<span class="caret"></span>
																	</button> -->
																	<!-- <div class="dropdown-menu">
																		<a class="dropdown-item" href="#">Action</a>
																		<a class="dropdown-item" href="#">Another action</a>
																		<a class="dropdown-item" href="#">Something else here</a>
																	</div> -->
																</div>
																<div class="btn-group">
																	<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																	<i class="ion ion-folder margin-r-5"></i>
																	<span class="caret"></span>
																	</button> -->
																	<!-- <div class="dropdown-menu">
																		<a class="dropdown-item" href="#">Action</a>
																		<a class="dropdown-item" href="#">Another action</a>
																		<a class="dropdown-item" href="#">Something else here</a>
																	</div> -->
																</div>
															</div>
															<!-- /.btn-group -->
															<button type="button" class="btn btn-primary btn-sm refresh-button"><i class="fa fa-refresh"></i></button>
															<div class="pull-right">
																<div class="btn-group">
																<a href="{{ route('mailbox.index', ['trashPageToken' => $trashPreviousPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm"><i class="fa fa-chevron-left"></i></a>
																	
																	
																		<a href="{{ route('mailbox.index', ['trashPageToken' => $trashNextPageToken, 'query' => request('search')]) }}"class="btn btn-primary btn-sm"><i class="fa fa-chevron-right"></i></a>
																	
																</div>

															</div>
															<!-- /.pull-right -->
														</div>
														<div class="mailbox-messages inbox-bx">
															<div class="table-responsive">
																<table class="table table-hover table-striped">
																	<tbody>
																		@foreach($trashMessages as $message)
																		<tr class="message-row"    data-from="{{ $message['from'] }}" 
																			data-subject="{{ $message['subject'] }}" 
																			data-body="{{ htmlspecialchars($message['body']) }}" 
																			data-date="{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}"data-attachment="{{ json_encode($message['attachments']) }}">
																				<td><input type="checkbox"></td>
																				<td class="mailbox-star"><a href="#"><i class="fa fa-star text-yellow"></i></a></td>
																				<td>
																					<p class="mailbox-name mb-0 fs-16 fw-600">{{ $message['from'] }}</p>
																					<a class="mailbox-subject" href="#"><b>{{ $message['subject'] }}</b></a>
																					<!-- Show part of the message body initially -->
																					<p class="partial-body">{{ substr(strip_tags($message['body']), 0, 50) }}{{ strlen(strip_tags($message['body'])) > 50 ? '...' : '' }} </p>
																					<!-- Hidden div to hold full message body -->
																					<div class="full-body" style="display: none;">{{(htmlspecialchars($message['body'])) }}</div>
																					<!-- Button to expand/collapse the message body -->
																					<button class="btn btn-link toggle-body" data-toggle="collapse" data-target=".full-body">Show More</button>								</td>
																				<td class="mailbox-attachment"></td>
																				<td class="mailbox-date">{{ date('Y-m-d H:i:s', strtotime($message['date'])) }}
																				</td>
																			</tr>
																	
																		@endforeach
																	</tbody>
																</table>
															</div>                
															<!-- /.table -->
														</div>
													<!-- /.mail-box-messages -->
													</div>
													<!-- /.box-body -->
													<div class="box-footer">
														<div class="mailbox-controls">
															<!-- Check all button -->
															<!-- <button type="button" class="btn btn-primary btn-sm checkbox-toggle"><i class="ion ion-android-checkbox-outline-blank"></i> -->
															</button>
															<div class="btn-group">
																<!-- <button type="button" class="btn btn-primary btn-sm"><i class="ion ion-trash-a"></i></button>
																<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-reply"></i></button>
																<button type="button" class="btn btn-primary btn-sm"><i class="ion ion-share"></i></button> -->
															</div>
															<!-- /.btn-group -->
															<div class="btn-group">
																<div class="btn-group">
																	<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																	<i class="ion ion-flag margin-r-5"></i>
																	<span class="caret"></span>
																	</button> -->
																	<!-- <div class="dropdown-menu">
																		<a class="dropdown-item" href="#">Action</a>
																		<a class="dropdown-item" href="#">Another action</a>
																		<a class="dropdown-item" href="#">Something else here</a>
																	</div> -->
																</div>
																<div class="btn-group">
																	<!-- <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
																	<i class="ion ion-folder margin-r-5"></i>
																	<span class="caret"></span>
																	</button> -->
																	<!-- <div class="dropdown-menu">
																		<a class="dropdown-item" href="#">Action</a>
																		<a class="dropdown-item" href="#">Another action</a>
																		<a class="dropdown-item" href="#">Something else here</a>
																	</div> -->
																</div>
															</div>
															<!-- /.btn-group -->
															<!-- <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-refresh"></i></button> -->
															<div class="pull-right">
																<div class="btn-group">
																	<!-- <button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-left"></i></button>
																	<button type="button" class="btn btn-primary btn-sm"><i class="fa fa-chevron-right"></i></button> -->
																</div>
															</div>
															<!-- /.pull-right -->
															
														</div>
											
													</div>
											
											</div>
										</div>
									</div>
								</div>
							<!-- /.box-body -->
				
					</div>
				</div>
				<!-- /.col -->
				<div class="col-xl-4 col-12" id="messageContent">
					<div class="box">
						<div class="box-body pt-10">
							<div class="mailbox-read-info">
								<h4></h4>
							</div>
							<div class="mailbox-read-info clearfix mb-20">
								<!-- <div class="float-start me-10"><a href="#"><img src="../images/1.jpg" alt="user" width="40" class="rounded-circle"></a></div> -->
								<h5 class="no-margin">
									<small></small>
									<span class="mailbox-read-time pull-right"></span>
								</h5>
							</div>
							<!-- /.mailbox-read-info -->
							<div class="mailbox-controls with-border clearfix">                
								<div class="float-start">
									<!-- <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="tooltip" title="Print">
										<i class="fa fa-print"></i>
									</button> -->
								</div>
								<div class="float-end">
									<div class="btn-group">
										<!-- <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="tooltip" data-container="body" title="Delete">
											<i class="fa fa-trash-o"></i>
										</button>
										<button type="button" class="btn btn-primary btn-sm" data-bs-toggle="tooltip" data-container="body" title="Reply">
											<i class="fa fa-reply"></i>
										</button>
										<button type="button" class="btn btn-primary btn-sm" data-bs-toggle="tooltip" data-container="body" title="Forward">
											<i class="fa fa-share"></i>
										</button> -->
									</div>
								</div>
								<!-- /.btn-group -->
							</div>
							<!-- /.mailbox-controls -->
							<div class="mailbox-read-message read-mail-bx">
								<p></p>
								<p></p>
								<!-- Message body will be updated here -->
							</div>
							<!-- /.mailbox-read-message -->
						</div>
						<!-- /.box-body -->
						<div class="box-footer">
							<h5><i class="fa fa-paperclip m-r-10 m-b-10"></i> Attachments <span></span></h5>
							<ul class="mailbox-attachments clearfix">
								<li>
									<div class="mailbox-attachment-info">
										<a href="#" class="mailbox-attachment-name"><i class="fa fa-paperclip"></i> </a>
										<span class="mailbox-attachment-size">
										
											<a href="#" class="btn btn-primary btn-xs pull-right"><i class="fa fa-cloud-download"></i></a>
										</span>
									</div>
								</li>
								<!-- <li> -->
									<!-- <div class="mailbox-attachment-info">
										<a href="#" class="mailbox-attachment-name"><i class="fa fa-paperclip"></i> Documents.docx</a>
										<span class="mailbox-attachment-size">
											2,145 KB
											<a href="#" class="btn btn-primary btn-xs pull-right"><i class="fa fa-cloud-download"></i></a>
										</span>
									</div> -->
								<!-- </li> -->
							</ul>
						</div>
						<!-- /.box-footer -->
						<div class="box-footer">
							<div class="pull-right">
								<!-- <button type="button" class="btn btn-success"><i class="fa fa-reply"></i> Reply</button>
								<button type="button" class="btn btn-info"><i class="fa fa-share"></i> Forward</button> -->
							</div>
							<!-- <button type="button" class="btn btn-danger"><i class="fa fa-trash-o"></i></button>
							<button type="button" class="btn btn-warning"><i class="fa fa-print"></i></button> -->
						</div>
						<!-- /.box-footer -->
					</div>
					<!-- /. box -->
                </div>

				<!-- /.col -->
			</div>	
        </section>
	
	<!-- Page Content overlay -->
<script>
    $(document).ready(function() {
        $('.toggle-body').on('click', function() {
            // Toggle the visibility of full message body
            $(this).closest('td').find('.full-body').toggle();
            // Change button text based on visibility
            var buttonText = $(this).text() === 'Show More' ? 'Show Less' : 'Show More';
            $(this).text(buttonText);
        });
    });
</script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Add click event listener to all message rows
        document.querySelectorAll('.message-row').forEach(function(row) {
            row.addEventListener('click', function() {
                // Get message details from data attributes
                const from = this.getAttribute('data-from');
                const subject = this.getAttribute('data-subject');
                const body = this.getAttribute('data-body');
				var decodedBody = $('<div/>').html(body).text();
                const date = this.getAttribute('data-date');
				const attachment=this.getAttribute('data-attachment');
                // Log the values to the console for debugging
                console.log('From:', from);
                console.log('Subject:', subject);
                console.log('Body:', body);
                console.log('Date:', date);
console.log('Attachment:',attachment);
                // Update the messageContent div
                document.querySelector('#messageContent .mailbox-read-info h4').textContent = subject;
                document.querySelector('#messageContent .mailbox-read-info h5').innerHTML = `${from}<br><small>From: ${from}</small><span class="mailbox-read-time pull-right">${date}</span>`;
                document.querySelector('#messageContent .mailbox-read-message').innerHTML = `<p>${decodedBody}</p>`;
            });
        });
    });
</script>


<script>
   document.querySelectorAll('.refresh-button').forEach(button => {
        button.addEventListener('click', function() {
            location.reload();
        });
    });
</script>


@endsection