@extends('layouts.app')
@section('title', 'Marketing Campaign')

@section('content')
<section class="content">

      <div class="row">               
        <div class="col-12">
          <div class="box">
                
           <div class="box-body">   
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Marketing schedules for {{$marketing_campaign->title}}</h4>
              <a href="{{ url('/marketing-campaigns') }}" type="submit"  style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye"></i> Marketing Campaigns</a>
             
            <hr class="my-15">
                  
              <div class="table-responsive">
                <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
                  <thead>
                    <tr>
                                    <th>#</th>
                                    <th>List</th>
                                    <!-- <th>Column</th> -->
                                    <th>Template</th>
                                    <th>Account</th>
                                    <th>Type</th>
                                    <th>Scheduled Time</th>
                                    <th>Complete Time</th>
                                    <th>Status</th>
                                    <th>Total</th>
                                    <th>Sent</th>
                                    <th>Failed</th>
                                    <th>Action</th>

                            </tr>
                  </thead>
                  <tbody>

@if(!empty($schedules))
@foreach($schedules as $key => $schedule)
<tr>
    <td>{{$key+1}}</td>
    <td>
        @foreach($list as $key => $lists)
        @if($lists->list_id == $schedule->list_id)
        {{$lists->list}}
        @endif
        @endforeach
    </td>
    {{-- <td>{{ $listHeaders[$schedule->list_id][$schedule->list_column_name]->header}}</td> --}}

    <td>
        @if($schedule->send == 1)
        @foreach($email_templates as $key => $template)
        @if($template->id == $schedule->email_template_id)
        {{$template->template_name}}
        @endif
        @endforeach
        @elseif($schedule->send == 2)
        @foreach($sms_templates as $key => $template)
        @if($template->templete_id == $schedule->sms_template_id)
        {{$template->templete_name}}
        @endif
        @endforeach
        @endif
    </td>



     <td>
        @if($schedule->send == 1)
        @foreach($smtp_setting as $key => $smtp)
        @if($smtp->id == $schedule->email_setting_id)
        {{$smtp->mail_host}}
        @endif
        @endforeach
        @elseif($schedule->send == 2)
        @foreach($did as $key => $dids)
        @if($dids->id == $schedule->sms_setting_id)
        {{$dids->cli}}
        @endif
        @endforeach
        @endif
    </td>

    <td>
        @if($schedule->send == 1)
        Email
        @elseif($schedule->send == 2)
        Text
        @endif
    </td>
    <td class="utc-time" data-utc-time="{{$schedule->run_time}}"></td>
    <td class="utc-time" data-utc-time="{{$schedule->complete_time}}"></td>

    <td>
        @if($schedule->status == 1)
        <span class="badge badge badge-info">Planned</span>
        @elseif($schedule->status == 2)
        <span class="badge badge badge-success">Processing</span>

        @elseif($schedule->status == 3)
        <span class="badge badge badge-danger">Failed</span>

        @elseif($schedule->status == 4)
        <span class="badge badge badge-success">Queued</span>

        @elseif($schedule->status == 5)
        <span class="badge badge badge-success">Executing</span>

        @elseif($schedule->status == 6)
        <span class="badge badge badge-success">Completed</span>

        @elseif($schedule->status == 7)
        <span class="badge badge badge-warning">Aborted</span>

        @endif
    </td>
    <td><a href="{{ url("/marketing-campaign/{$schedule->campaign_id}/schedule/{$schedule->id}/logs") }}">{{$schedule->scheduled_count}}</a></td>
    <td><a href="{{ url("/marketing-campaign/{$schedule->campaign_id}/schedule/{$schedule->id}/logs?run_status=3") }}">{{$schedule->sent_count}}</a></td>
    <td><a href="{{ url("/marketing-campaign/{$schedule->campaign_id}/schedule/{$schedule->id}/logs?run_status=5") }}">{{$schedule->failed_count}}</a></td>
    <td>
        <a style="cursor:pointer;color:blue; margin-right:4px;" title='Edit only when campaign schedule is in PLANNED status'  @if($schedule->status == 1) href="{{url('marketing-campaign-schedule')}}/{{ $schedule->id}}"  @endif class='editEG'><i class="fa fa-edit"></i></a>
         <a style="cursor:pointer;color:red; margin-right:4px;" title='Delete only when campaign schedule is in PLANNED status' @if($schedule->status == 1)  class='deleteSchedule' @endif data-scheduleid={{$schedule->id}} ><i class="fa fa-trash-o"></i></a>
         <a style="cursor:pointer;color:red; margin-right:4px;"  title='Abort only when campaign schedule is not in PLANNED & ABORT status'
         @if($schedule->status != 1 && $schedule->status != 7) class='abortSchedule' @endif data-scheduleid={{$schedule->id}} ><i class="fa fa-stop"></i></a>
     </td>
</tr>
@endforeach
@endif
</tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
        <div class="modal fade" id="abortScheduleModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="add-edit">Abort Marketing Schedule Campaign</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" name="add-ip-form" action="">
                                @csrf
          
                        <div class="modal-body">
                        <p>You are about to <b>ABORT</b> <b><i class="title"></i></b> Schedule Campaign.</p>
                                    <p>Do you want to proceed?</p>
                                    <input type="hidden" readonly class="form-control" minlength="7" placeholder="" name="schedule_id" id="schedule_id">
                                    <div id="schedule-delete"></div>
                                  <div class="modal-footer">
                                  <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                    <button type="submit" name="submit" id="abortSchedule" class="btn btn-danger btn-ok">Update</button>
                                  </div>
</form>
                        </div>
          </div>
        </div>
      </div>
      <!-- /.row -->


<div class="modal fade" id="deleteScheduleModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="add-edit">Confirm Delete</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
             
            <form method="post" name="add-ip-form" action="">
                                @csrf
                        <div class="modal-body">
                        <p>You are about to delete <b><i class="title"></i></b> Campaign.</p>
                            <p>Do you want to proceed?</p>
                            <input type="hidden" readonly class="form-control" minlength="7" placeholder="" name="scheduled_id" id="scheduled_id">
                                    <!-- pattern="^((\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.){3}(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$" -->
                                    <div id="schedule-delete"></div>
                                                                      <div class="modal-footer">
                                      <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                                      <button type="submit"name="submit" class="btn btn-primary btn-sm deleteMarketing">Delete</button>
                                  </div>
                        </div>
          </div>
        </div>
      </div>

    </section>
        <!-- /.content -->


        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
   
        <script language="javascript">
    $(document).ready(function() {

        $(".utc-time").each(function(i, element) {
            var utcTime = $(element).data("utc-time");
            if (utcTime) {
                var localTime = moment.utc(utcTime).local();
                $(element).html(localTime.format('YYYY-MM-DD HH:mm'));
            }
        });

    });
    $(document).on("click", ".abortSchedule", function () {
        $("#abortScheduleModal").modal('show');
        var scheduled_id = $(this).data('scheduleid');
        $("#schedule_id").val(scheduled_id);
    });

    $(document).on("click", "#abortSchedule", function (e) {
        e.preventDefault();
        postData = {
            "_token": $("#user-role-csrf").val(),
            "scheduleId": parseInt($("#schedule_id").val())
        };
        console.log(postData);
        $.ajax({
            type: "POST",
            url: "{{ route('abortSchedule') }}",
            data: postData,
            success: function(data){
                console.log(data);
                $("#schedule-cancel").click();
                location.reload();
            },
            error: function(error){
                console.log(error.responseJSON);
                $("#schedule-delete").html('<i class="glyphicon glyphicon-info-sign"></i> Something went wrong, Please try again...');
                $("#schedule-delete").show();
            }
        });
    });

    $(document).on("click", ".deleteSchedule", function () {
        $("#deleteScheduleModal").modal('show');
        $("#add-edit").html('Schedule Campaign');
        var scheduled_id = $(this).data('scheduleid');
        $("#scheduled_id").val(scheduled_id);
    });

    $(document).on("click", "#deleteSchedule", function (e) {
        e.preventDefault();
        postData = {
            "_token": $("#user-role-csrf").val(),
            "scheduleId": parseInt($("#scheduled_id").val())
        };
        console.log(postData);
        $.ajax({
            type: "POST",
            url: "{{ route('deleteSchedule') }}",
            data: postData,
            success: function(data){
                console.log(data);
                $("#schedule-cancel").click();
                location.reload();
            },
            error: function(error){
                console.log(error.responseJSON);
                $("#schedule-delete").html('<i class="glyphicon glyphicon-info-sign"></i> Something went wrong, Please try again...');
                $("#schedule-delete").show();
            }
        });
    });

</script>





@endsection
