@extends('layouts.app')
@section('title', 'Add Module')
@section('content')
<style>

fieldset.scheduler-border
{
    border: 1px groove #ddd !important;
    padding: 0 1.4em 1.4em 1.4em !important;
    margin: 15px 6px 1.5em 6px !important;
    -webkit-box-shadow:  0px 0px 0px 0px #000;
    box-shadow:  0px 0px 0px 0px #000;
}

legend.scheduler-border
{
    font-size: 1.2em !important;
    font-weight: bold !important;
    text-align: left !important;
    width:auto;
    padding:0 10px;
    /*border-bottom:none;*/
}

</style>
<!-- Content Wrapper. Contains page content -->


    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-lg-12 col-12">
                <div class="box">

             
                    <div class="box-body"><!--bg-lightest-->
                             <h4 class="box-title text-info mb-0"><i class="fa fa-add"></i> Add Module</h4>
                            <a href="{{ url('super/modules') }}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i> Show Modules</a>
                            <hr class="my-15">
                            <form method="post">
                                @csrf
                                <div class="row">
                                    <div class="col-sm-12">
                                        <fieldset class="scheduler-border">
                                            <legend class="scheduler-border">Module Details</legend>
                                            <div class="row">
   
<div class="col-md-3">
                                                <label class="form-label">Name</label>
                                                <div class="input-group" style="margin-bottom: 10px;">
                                                        <input type="text" class="form-control" name="name"
                                                    id="name" value="{{old('name')}}"  placeholder="Enter Name">
                                                </div>
                                            </div>
                                        <div class="col-md-4">
                                                <label class="form-label">Components </label>
                                                        <div class="input-group" style="margin-bottom: 10px;">
                                                            <select name="components[]" id="components" class="form-select select2" multiple="multiple">
                                                                @foreach($components as $key => $comp)
                                                                <option {{ (collect(old('components'))->contains($comp->key)) ? 'selected':'' }} value="{{$comp->key}}">{{$comp->name}}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                            </div>
                                            <div class="col-md-2">
                                                <label class="form-label">Attribute</label>
                                                        <div class="input-group" style="margin-bottom: 10px;">
                                                            <input type="text" class="form-control" name="attributes[]"
                                                            id="attributes" value=" "  placeholder="Enter Attributes">
                                                            <div id="span" ></div>


                                                        </div>
                                            </div>
                                         
                                            <div class="col-md-2">
                                                <label class="form-label">Is Active</label>
                                                <div class="input-group" >
                                                    <select class="form-select"  id="is_active" name="is_active" >
                                                            <option @if(old('is_active') == '1') selected @endif value="1">Yes</option>
                                                            <option @if(old('is_active') == '0') selected @endif value="0">No</option>
                                                        </select>
                                                </div>
                                            </div>
                                            <div class="col-md-1">
                                                <label class="form-label">Order </label>
                                                <div class="input-group">
                                                        <input type="text" maxlength="2" onkeypress="return isNumberKey($(this));" class="form-control" name="display_order" value="{{old('display_order')}}" id="display_order"  placeholder="Order">
                                                    </div>
                                            </div>
                                        </fieldset>
                                    </div>                        
                                </div>

                                        <div class="form-group text-end" style="float:right;padding: 0px 7px;">
                                            <tfoot>
                                                <tr>
                                                    <td>
                                                        <button id="submit" class="btn btn-primary" type="submit">
                                                            <i class="fa fa-check-square-o fa-lg"></i>
                                                                Submit
                                                        </button>
                                                        &nbsp;

                                                        <a type="button" class="btn btn-warning"  onclick="window.location.reload();"><i class="fa fa-refresh fa-lg"></i>
                                                                Reset
                                                        </a>
                                                        &nbsp;

                                                        <a type="button" class="btn btn-danger" style="margin-right: 14px;" href="{{url('super/modules')}}">
                                                            <i class="fa fa-close fa-lg"></i>
                                                                Cancel
                                                        </a>
                                                    </td>
                                                </tr>
                                            </tfoot>
                                        </div>
                                
                            </form>
          
                    </div>

                </div><!-- /.box -->

            </div><!-- /.col -->
        </div><!-- /.row -->
    </section><!-- /.content -->



             

<!-- /.content-wrapper -->

@endsection
