@extends('layouts.app')
@section('title', 'Modules List')

@section('content')
<style>
  .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
    .table > tbody > tr > td, .table > tbody > tr > th {
     padding: 0rem; 
    vertical-align: middle;
}
div.dataTables_wrapper div.dataTables_paginate ul.pagination {
    /* margin: 2px 0; */
    white-space: nowrap;
    justify-content: flex-end;
}  </style>
<!-- Main content -->
        <section class="content">

      <div class="row">
        
        <div class="col-12">
          <div class="box">
           <div class="box-body">   
              <h4 class="box-title text-info mb-0"><i class="fa fa-list fa-sx"></i> Modules List</h4> 
              <a id="openListForms" href="{{url('super/module')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-plus"></i>  Add Module</a>

                  <hr class="my-15">   
              <div class="table-responsive">
                <table id="tickets"  class="table mt-0 table-hover no-wrap" >
                  <thead>
                    <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Components</th>
                                    <th>Attributes</th>
                                    <th>Status</th>
                                    <th>Action</th>

                            </tr>
                  </thead>
                  <tbody>
                  @if(!empty($modules))
                                @foreach(array_reverse($modules) as $key => $module)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>{{$module->name}}</td>
                                    <td>
                                        @php
                                        $components = implode(',',$module->components);
                                        @endphp
                                        {{$components}}

                                    </td>

                                    <td>
                                        @php
                                        $attributes = implode(',',$module->attributes);
                                        @endphp
                                        {{$attributes}}

                                    </td>



                                    <td>
                                        @if($module->is_active == 1)
                                        <span class="badge badge-success">Active</span>
                                        @else
                                        <span class="badge badge-danger">Inactive</span>
                                        @endif
                                    </td>

                                    <td>
                                        <a style="cursor:pointer;color:blue;" href="{{url('super/module')}}/{{$module->key}}" title="Edit Package Details" class=''  ><i class="fa fa-edit fa-lg"></i></a>

                                </tr>
                                @endforeach
                                @endif

                               

                                       
                  </tbody>
                </table>
              
                    </div><!-- /.box-body -->
            

              </div>
     
            </div>
          </div>
        </div>
        
      </div>
      <!-- /.row -->
   
      <!-- Button trigger modal -->



 
        </div>
    </section>
 





@endsection
