@extends('layouts.app')
@section('title', 'LeadMinePro Registrations')

@section('content')

    <style>
        div.dataTables_wrapper div.dataTables_paginate ul.pagination {
            white-space: nowrap;
            justify-content: flex-end;
        }

        .table td {
            vertical-align: middle !important;
        }

        .modal-content {
            border-radius: 12px !important;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.2);
            border: none;
        }

        .modal-header,
        .modal-footer {
            background: #f8f9fa;
        }

        .modal-header {
            border-bottom: 1px solid #dee2e6;
        }

        .modal-footer {
            border-top: 1px solid #dee2e6;
        }
    </style>

    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="box">

                    <div class="box-body">

                        <h4 class="box-title text-info mb-0">
                            <i class="fa fa-users"></i> LeadMinePro Registrations
                        </h4>

                        <hr class="my-15">

                        <div class="table-responsive">
                            <table id="leadTable" class="table table-hover no-wrap">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Company</th>
                                        <th>Phone</th>
                                        <th>Type</th>
                                        <th>Registered</th>
                                        <th>View</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($leads as $key => $lead)
                                        <tr>
                                            <td>{{ $key + 1 }}</td>
                                            <td>{{ $lead->name }}</td>
                                            <td>
                                                {{ $lead->email ?? '' }}
                                                @if (empty($lead->email))
                                                    <i class="fa fa-times-circle text-danger"></i>
                                                @else
                                                    <i
                                                        class="fa fa-{{ $lead->email_verified_at ? 'check-circle text-success' : 'times-circle text-danger' }}"></i>
                                                @endif
                                            </td>
                                            <td>{{ $lead->company_name ?? '-' }}</td>
                                            <td>{{ ($lead->country_code ?? '') . ' ' . ($lead->phone ?? '') }} @if (!$lead->phone)
                                                <i class="fa fa-times-circle text-danger"></i>@else<i
                                                        class="fa fa-{{ $lead->mobile_verified_at ? 'check-circle text-success' : 'times-circle text-danger' }}"></i>
                                                @endif
                                            </td>
                                            <td>
                                                <span
                                                    class="badge bg-{{ $lead->type === 'contactus' ? 'warning' : 'success' }}">
                                                    {{ ucfirst($lead->type) }}
                                                </span>
                                            </td>
                                            <td>{{ \Carbon\Carbon::parse($lead->created_at)->format('d M Y H:i') }}</td>
                                            <td>
                                                <a href="#" class="openDetails"
                                                    data-item='@json($lead)' style="color:blue;">
                                                    <i class="fa fa-eye fa-lg"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div><!-- /.table-responsive -->

                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- View Modal -->
    <div class="modal fade" id="leadModal" tabindex="-1">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 class="modal-title">Lead Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <div id="detailBody">Loading...</div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>

            </div>
        </div>
    </div>

    <!-- JS -->
    <script src="https://code.jquery.com/jquery-3.7.0.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        $(document).ready(function() {

            $('.openDetails').click(function() {
                const data = $(this).data('item');

                const html = `
            <h5 class="text-primary mb-3">${data.name}</h5>
            <p><strong>Email:</strong> ${data.email ?? ''} ${!data.email ? '<i class="fa fa-times-circle text-danger"></i>' : `<i class="fa fa-${data.email_verified_at ? 'check-circle text-success' : 'times-circle text-danger'}"></i>`}</p>
            <p><strong>Company:</strong> ${data.company_name ?? '-'}</p>
            <p><strong>Phone:</strong> ${data.country_code ?? ''} ${data.phone ?? ''} ${!data.phone ? '<i class="fa fa-times-circle text-danger"></i>' : `<i class="fa fa-${data.mobile_verified_at ? 'check-circle text-success' : 'times-circle text-danger'}"></i>`}</p>
            <p><strong>Type:</strong>
                <span class="badge bg-${data.type === 'contactus' ? 'warning':'success'}">
                    ${data.type}
                </span>
            </p>
            ${data.message ? `<div class="border rounded p-3 bg-light"><strong>Message:</strong><br>${data.message}</div>` : ''}
        `;

                $('#detailBody').html(html);
                $('#leadModal').modal('show');
            });
        });
    </script>

@endsection
