<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Register | Smart Phone Platform For Businesses</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <meta name="csrf-token" content="{{ csrf_token() }}">

    <link rel="stylesheet" href="{{ asset('assets/css/vendors_css.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

    <style>
        body {
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            margin: 0;
            background: #f6f7fb;
        }

        .login-shapes .login-left-shape,
        .login-shapes .login-right-shape {
            position: fixed;
            z-index: -1;
        }

        .login-left-shape {
            top: 0;
            left: 0;
        }

        .login-right-shape {
            bottom: 0;
            right: 0;
        }

        .login-card {
            background: #fff;
            padding: 30px 40px;
            border-radius: 20px;
            width: 100%;
            max-width: 510px;
            box-shadow: 0 12px 28px rgba(0, 0, 0, 0.15);
            text-align: center;
            margin: 20px;
            z-index: 10;
        }

.input-box {
    position: relative;
    margin-bottom: 18px;
}


.input-box input {
    width: 100%;
    padding: 12px 40px 12px 38px;
    border-radius: 8px;
    border: 1px solid #ccc;
    font-size: 15px;
    outline: none;
}

.input-box > i:not(.toggle-eye) {
    position: absolute;
    left: 12px;
    top: 50%;
    transform: translateY(-50%);
    font-size: 15px;
    color: #777;
}

.input-box .toggle-eye {
    position: absolute;
    top: 50%;
    right: 12px;
    transform: translateY(-50%);
    cursor: pointer;
    color: #555;
    font-size: 16px;
}

.login-btn {
    width: 100%;
    padding: 12px;
    background: #E41F07 !important;
    color: #fff;
    font-weight: 600;
    border-radius: 6px;
    cursor: pointer;
}

#loader {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(255, 255, 255, 0.7);
    display: none;
    z-index: 999999;
}

#loader .spinner {
    position: absolute;       
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    border: 6px solid #f3f3f3;
    border-top: 6px solid #3498db;
    border-radius: 50%;
    width: 55px;
    height: 55px;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0%   { transform: translate(-50%, -50%) rotate(0deg); }
    100% { transform: translate(-50%, -50%) rotate(360deg); }
}

.alert {
    padding: 10px;
    border-radius: 8px;
    margin-bottom: 15px;
}

.alert-danger {
    background: #f8d7da;
    color: #721c24;
 }

.alert-success {
     background: #d4edda;
     color: #155724;
}

@media(max-width:768px) {
     body {
        padding: 20px;
     }

     .login-shapes img {
         display: none;
     }
 }

#country_code {
    width: auto;
    min-width: 200px;
    background-color: #fff !important;
    cursor: pointer;
    padding-right: 28px !important;
    appearance: none;
    -webkit-appearance: none;
    -moz-appearance: none;
    background-image: url("data:image/svg+xml;utf8,<svg fill='black' height='12' viewBox='0 0 20 20' width='12' xmlns='http://www.w3.org/2000/svg'><path d='M5.516 7.548l4.484 4.485 4.484-4.485L16 8.548l-6 6-6-6z'/></svg>");
    background-repeat: no-repeat;
    background-position: right 8px center;
    background-size: 12px;
    height: 42px;
}

#phone {
    width: 170px;
    height: 42px;
    padding-left: 12px !important;
}

#phone::placeholder {
    margin-left: 0 !important;
    padding-left: 0 !important;
    transform: translateX(0) !important;
    color: #6c757d;
}

#phone::-webkit-input-placeholder {
    padding-left: 0 !important;
}

</style>
</head>

<body>

    <div id="loader">
        <div class="spinner"></div>
    </div>

    <div class="login-shapes">
        <div class="login-left-shape"><img src="/assets/images/auth-bg/shape-01.png"></div>
        <div class="login-right-shape"><img src="/assets/images/auth-bg/shape-02.png"></div>
    </div>

    <div class="login-card">

        <div class="text-center mb-2" style="margin-top:-20px;">
            <img src="{{ url('/') }}{{ config('app.logo') }}?v={{ time() }}" style="max-width: 330px;">
        </div>

        <h2 style="margin-top: 10px; margin-bottom: 3px; font-weight: 700; font-size: 1.5rem;">Register</h2>
        <p style="margin-top: 0;">Create your account</p>

        <div id="responseMessage"></div>

        <form id="registerForm">
            @csrf

            <div class="input-box">
                <i class="fas fa-user"></i>
                <input type="text" id="name" name="name" placeholder="Name" required>
            </div>

            <div class="input-box">
                <i class="fas fa-envelope"></i>
                <input type="email" id="email" name="email" placeholder="Email" required>
            </div>

          <div class="input-box">
    <div class="d-flex gap-2">


   <select name="country_code" id="country_code" class="form-control">
    @foreach ($countries as $c)
        <option 
            value="{{ $c['code'] }}"
            data-code="+{{ $c['code'] }}"
            {{ $c['code'] == 1 ? 'selected' : '' }}>

            {{ $c['name'] }} {{ $c['flag'] }}
        </option>
    @endforeach
    </select>


      <div class="d-flex form-control" style="padding:0; border-radius:0;">
 <span id="selected_code" class="px-2 d-flex align-items-center" style="font-weight:600;">
</span>

    <input type="tel" 
           name="phone" 
           id="phone" 
           class="border-0 flex-grow-1" 
           placeholder="Phone"
           maxlength="14" 
           value="{{ old('phone') }}" 
           required
           style="border-top-left-radius:0; border-bottom-left-radius:0;">
     </div>


    </div>
</div>




            <div class="input-box">
                <i class="fas fa-building"></i>
                <input type="text" id="company_name" name="company_name" placeholder="Company Name" required>
            </div>

            <div class="input-box">
                <i class="fas fa-lock"></i>
                <input type="password" id="password" name="password" placeholder="Password" required>
                <i class="fas fa-eye-slash toggle-eye" onclick="togglePassword('password', this)"></i>
            </div>

            <div class="input-box">
                <i class="fas fa-lock"></i>
                <input type="password" id="confirm_password" name="password_confirmation" placeholder="Confirm Password"
                    required>
                <i class="fas fa-eye-slash toggle-eye" onclick="togglePassword('confirm_password', this)"></i>
            </div>

            <div class="form-check mb-3" style="text-align:left;">
                <input class="form-check-input" type="checkbox" id="terms" style="cursor:pointer;" required>
                <label class="form-check-label" for="terms">
                    I agree to the <a href="/terms-services" target="_blank">Terms & Conditions</a>
                </label>
            </div>

            {!! NoCaptcha::display() !!}
            @if ($errors->has('g-recaptcha-response'))
                <span class="text-danger">{{ $errors->first('g-recaptcha-response') }}</span>
            @endif

            <button type="submit" class="login-btn mt-3">SIGN UP</button>

            <p class="mt-3" style="font-size:14px;">
                Already have an account?
                <a href="/login" style="font-weight:700;color:#5A2EFF;">Login Instead</a>
            </p>

            <p class="text-muted mt-3">Copyright © 2025 - {{ config('app.site') }}</p>
        </form>

    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    {!! NoCaptcha::renderJs() !!}

    <script>
        function togglePassword(id, icon) {
            const field = document.getElementById(id);
            if (field.type === "password") {
                field.type = "text";
                icon.classList.remove("fa-eye-slash");
                icon.classList.add("fa-eye");
            } else {
                field.type = "password";
                icon.classList.remove("fa-eye");
                icon.classList.add("fa-eye-slash");
            }
        }

        $("#registerForm").on("submit", function(e) {
            e.preventDefault();
            $("#loader").show();
            $("#responseMessage").html("");

            $.ajax({
                url: "{{ route('frontend.register.store') }}",
                type: "POST",
                data: $(this).serialize(),
                success: function(res) {
                    $("#loader").hide();

                    // redirect to verify-otp page
                    window.location.href = "/verify-otp?email=" + encodeURIComponent($("#email").val());
                },
                error: function(xhr) {
                    $("#loader").hide();

                    if (xhr.status === 422) {
                        let errors = xhr.responseJSON.errors;
                        let errorMsg = Object.values(errors).map(e => e[0]).join("<br>");
                        $("#responseMessage").html(`<div class="alert alert-danger">${errorMsg}</div>`);
                    } else {
                        $("#responseMessage").html(
                            `<div class="alert alert-danger">Something went wrong.</div>`);
                    }
                }
            });
        });
    </script>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const select = document.getElementById("country_code");
    const code = select.options[select.selectedIndex].getAttribute("data-code");
    document.getElementById("selected_code").textContent = code;
});

document.getElementById("country_code").addEventListener("change", function () {
    let code = this.options[this.selectedIndex].getAttribute("data-code");
    document.getElementById("selected_code").textContent = code;
});
</script>


<script>
document.getElementById('phone').addEventListener('input', function (e) {
    let value = e.target.value.replace(/\D/g, ''); 

  
    if (value.length > 10) {
        value = value.slice(0, 10);
    }

   
    let formatted = value;

    if (value.length > 0) {
        formatted = '(' + value.slice(0, 3);
    }
    if (value.length >= 4) {
        formatted += ') ' + value.slice(3, 6);
    }
    if (value.length >= 7) {
        formatted += '-' + value.slice(6, 10);
    }

    e.target.value = formatted;
});
</script>


</body>

</html>
