<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Thank You | Smart Phone Platform For Businesses</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet" href="{{ asset('assets/css/vendors_css.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

    <style>
        body {
            background:#f6f7fb;
            min-height:100vh;
            margin:0;
            display:flex;
            justify-content:center;
            align-items:center;
        }

        .thank-card {
            background:#fff;
            padding: 35px 40px;
            border-radius:20px;
            max-width:480px;
            width:100%;
            text-align:center;
            box-shadow:0 10px 30px rgba(0,0,0,0.18);
        }

        .email-circle {
            width:70px;
            height:70px;
            border-radius:50%;
            background:#e3f2fd;
            display:flex;
            justify-content:center;
            align-items:center;
            font-size:30px;
            color:#2196f3;
            margin:0 auto 15px auto;
        }

        .btn-home {
            background:#4CAF50;
            color:#fff;
            padding:12px 20px;
            border:none;
            border-radius:8px;
            font-size:15px;
            font-weight:600;
            cursor:pointer;
            margin-top:20px;
            width:100%;
        }

        .btn-home:hover {
            background:#43a047;
        }

        @media(max-width:480px){
            .thank-card { padding:25px; }
        }
    </style>

</head>

<body>

<div class="thank-card">

    <!-- Logo -->
    <img src="{{ url('/') }}{{ config('app.logo') }}?v={{ time() }}"
         style="max-width:300px;margin-bottom:8px;">

    <div class="email-circle">
        <i class="fa fa-envelope"></i>
    </div>

    <h2 style="font-weight:700;margin-bottom:10px;">Thank You!</h2>

    <p style="color:#444;font-size:15px;line-height:1.5;margin-bottom:18px;">
        Your registration request has been received.
        Our team will review your information and contact you within
        <strong>24 hours</strong>.
    </p>


    <button class="btn-home" onclick="window.location.href='/'">
        Go to Home Page
    </button>

    <p class="text-muted" style="margin-top:20px;font-size:13px;">
        © 2025 - {{ config('app.site') }}
    </p>

</div>

</body>
</html>
