@extends('layouts.app')
@section('title', 'Edit Packages')
@section('content')



    
 

    <section class="content">
        <div class="row">
        <div class="box-header with-border">            
              <h4 class="box-title"><i class="fa fa-list fa-sx"></i>Edit Packages</h4> 
              <a id="openListForms" href="{{url('/super/packages')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye"></i>  See Package</a>

            </div>
            <div class="col-md-12">
                <div class="box">
                    <form method="post">
                    @csrf
                        <div class="row">
                            <input type="hidden" name="applicable_for" id="applicable_for" value="1">
                            <input type="hidden" name="key" id="key" value="{{$package['key']}}">

                            <div class="col-sm-7">
                                <fieldset class="scheduler-border">
                                    <legend class="scheduler-border">Package Details</legend>
                                    <div class="form-group m-b-10">
                                        <div class="col-md-12">
                                            <label>Name </label>
                                            <div class="input-group" style="margin-bottom: 10px;">
                                                <input type="text"  class="form-control" name="name"
                                            id="name" required="" placeholder="Enter Name" value="{{$package['name']}}">
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <label>Description </label>
                                        <div class="input-group" style="margin-bottom: 10px;">
                                            <textarea type="text" class="form-control" rows="8" name="description"  id="description" required="" placeholder="Enter Description"style="width=100%;">{{$package['description']}}</textarea>
                                        </div>
                                    </div>
<div class="row">
                                    <div class="col-md-5">
                                        <label>Is Active </label>
                                        <div class="input-group" >
                                            <select class="form-select"  id="is_active" name="is_active" >
                                                <option @if($package['is_active'] == 1) selected @endif value="1">Yes</option>
                                                <option @if($package['is_active'] == 0) selected @endif value="0">No</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-7">
                                        <label>Display Order</label>
                                        <div class="input-group">
                                            <input type="text" maxlength="2" onkeypress="return isNumberKey($(this));" class="form-control" name="display_order"  id="display_order" required="" placeholder="Display order" value="{{$package['display_order']}}">
                                        </div>
                                    </div>
                                </div>
                            </fieldset>
                            </div>

                            <div class="col-sm-5">
                                <div class="col-sm-12">
                                    <fieldset class="scheduler-border">
                                        <legend class="scheduler-border">Module</legend>
                                        <div class="form-group m-b-10">
                                            <div class="row">
                                            <div class="col-md-8">
                                                <label>Show On </label>
                                                <div class="input-group" style="margin-bottom: 10px;">
                                                    <select class="form-select select2" multiple="multiple" id="show_on" name="show_on[]">
                                                        <option @if(in_array('website', $package['show_on']))  selected  @endif value="website">Website</option>
                                                        <option @if(in_array('portal', $package['show_on']))  selected  @endif value="portal">Portal</option>


                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-md-4">
                                                <label>Currency </label>
                                                <div class="input-group">
                                                    <select class="form-select" id="currency_code" name="currency_code">
                                                        <option @if($package['currency_code'] == 'CAD') selected @endif value="CAD">CAD</option>
                                                        <option @if($package['currency_code'] == 'INR') selected @endif value="INR">INR</option>
                                                        <option @if($package['currency_code'] == 'USD') selected @endif  value="USD">USD</option>
                                                    </select>
                                                </div>
                                            </div>
                                            </div>
                                            <div class="col-md-12" >
                                                <label>Module </label>
                                                <div class="input-group" style="margin-bottom: 10px;">
                                                    <select name="modules[]" id="module" class="form-control select2" multiple="multiple">
                                                        @foreach($modules as $key => $mod)
                                                        <option @if(in_array($mod->key, $package['modules']))  selected  @endif value="{{$mod->key}}">{{$mod->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </fieldset>
                                </div>

                                <div class="col-sm-12" style="margin-top:-35px;">
                                    <fieldset class="scheduler-border">
                                        <legend class="scheduler-border">Package Price</legend>
                                        <div class="form-group m-b-10">
                                            <div class="row">
                                            <div class="col-md-6">
                                                <label>Monthly</label>
                                                <div class="input-group" style="margin-bottom: 10px;">
                                                    <input type="text" onkeypress="return isNumberKey($(this));" class="form-control" name="base_rate_monthly_billed"  id="base_rate_monthly_billed" required="" placeholder="Monthly" value="{{$package['base_rate_monthly_billed']}}">
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <label>Quarterly </label>
                                                <div class="input-group" style="margin-bottom: 10px;">
                                                    <input type="text" onkeypress="return isNumberKey($(this));" class="form-control" name="base_rate_quarterly_billed"  id="base_rate_quarterly_billed" required="" placeholder="Quarterly" value="{{$package['base_rate_quarterly_billed']}}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <label>Half Yearly </label>
                                                <div class="input-group" style="margin-bottom: 10px;">


                                                    <input type="text" onkeypress="return isNumberKey($(this));" class="form-control" name="base_rate_half_yearly_billed"  id="base_rate_half_yearly_billed" required=""
                                                        placeholder="Yearly" value="{{$package['base_rate_half_yearly_billed']}}">
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <label>Yearly </label>
                                                    <div class="input-group">
                                                        <input type="text" onkeypress="return isNumberKey($(this));" class="form-control" name="base_rate_yearly_billed"  id="base_rate_yearly_billed" required=""
                                                        placeholder="Yearly" value="{{$package['base_rate_yearly_billed']}}">
                                                    </div>
                                                </div>
                                            </div>
                                        </fieldset>
                                    </div>
                                </div>
                        </div>
                        <div class="row">

                            <div class="col-sm-3">
                                <fieldset class="scheduler-border">
                                    <legend class="scheduler-border">Rate</legend>
                                    <div class="form-group m-b-10">
                                        <div class="col-md-12">
                                            <label>Call Rate Per Minute </label>
                                            <div class="input-group" style="margin-bottom: 10px;">
                                                <input type="text"  onkeypress="return isNumberKey($(this));" class="form-control" name="call_rate_per_minute" value="{{$package['call_rate_per_minute']}}" id="call_rate_per_minute" required="" placeholder="Rate Per SMS">
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <label>Per SMS Send/Received </label>
                                            <div class="input-group" style="margin-bottom: 10px;">
                                                <input type="text" onkeypress="return isNumberKey($(this));" class="form-control" name="rate_per_sms" value="{{$package['rate_per_sms']}}"
                                                id="rate_per_sms" required="" placeholder="Rate Per SMS">
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <label>Per Phone No</label>
                                            <div class="input-group" style="margin-bottom: 10px;">
                                                <input type="text" onkeypress="return isNumberKey($(this));" class="form-control" name="rate_per_did" value="{{$package['rate_per_did']}}" id="rate_per_did" required="" placeholder="Rate Per Phone No">
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <label>Per Fax Send/Received </label>
                                            <div class="input-group" style="margin-bottom: 10px;">
                                                <input type="text" onkeypress="return isNumberKey($(this));" class="form-control" name="rate_per_fax" value="{{$package['rate_per_fax']}}" id="rate_per_fax" required="" placeholder="Rate Per Fax">
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <label>Per Email </label>
                                            <div class="input-group">
                                                <input type="text" onkeypress="return isNumberKey($(this));" class="form-control" name="rate_per_email" value="{{$package['rate_per_email']}}" id="rate_per_email" required="" placeholder="Rate Per Email">
                                            </div>
                                        </div>
                                    </div>
                                </fieldset>
                            </div>

                            <div class="col-sm-3">
                                <fieldset class="scheduler-border">
                                    <legend class="scheduler-border">Free / Month</legend>
                                    <div class="form-group m-b-10">
                                        <div class="col-md-12">
                                            <label>Free Call Minute </label>
                                            <div class="input-group" style="margin-bottom: 10px;">
                                                <input type="text" onkeypress="return isNumberKey($(this));" class="form-control" name="free_call_minute_monthly" value="{{$package['free_call_minute_monthly']}}" id="free_call_minute_monthly"  placeholder="Free Call">
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <label>Free SMS </label>
                                            <div class="input-group" style="margin-bottom: 10px;">
                                                <input type="text" onkeypress="return isNumberKey($(this));" class="form-control" name="free_sms_monthly" value="{{$package['free_sms_monthly']}}"
                                                id="free_sms_monthly"  placeholder="Free SMS">
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <label>Free FAX </label>
                                            <div class="input-group" style="margin-bottom: 10px;">
                                                <input type="text" onkeypress="return isNumberKey($(this));" class="form-control" name="free_fax_monthly" value="{{$package['free_fax_monthly']}}" id="free_fax_monthly"  placeholder="Free Fax">
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <label>Free Emails </label>
                                            <div class="input-group" style="margin-bottom: 10px;">
                                                <input type="text" onkeypress="return isNumberKey($(this));" class="form-control" name="free_emails_monthly" value="{{$package['free_emails_monthly']}}" id="free_emails_monthly"  placeholder="Free Emails">
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <label>Free Did </label>
                                            <div class="input-group">
                                                <input type="text" onkeypress="return isNumberKey($(this));" class="form-control" name="free_did_monthly" value="{{$package['free_did_monthly']}}" id="free_did_monthly"  placeholder="Free DID">
                                            </div>
                                        </div>
                                    </div>
                                </fieldset>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group" style="float:right;padding: 0px 7px;">
                                    <tfoot>
                                        <tr>
                                            <td>
                                                <button id="submit" class="btn btn-primary" type="submit">
                                                    <i class="fa fa-check-square-o fa-lg"></i>
                                                        Update
                                                </button>
                                                &nbsp;

                                                <a type="button" class="btn btn-warning"  onclick="window.location.reload();"><i class="fa fa-refresh fa-lg"></i>
                                                        Reset
                                                </a>
                                                &nbsp;

                                                <a type="button" class="btn btn-danger" style="margin-right: 14px;" href="{{url('/super/packages')}}">
                                                    <i class="fa fa-close fa-lg"></i>
                                                        Cancel
                                                </a>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <style>

    fieldset.scheduler-border
    {
        border: 1px groove #ddd !important;
        padding: 0 1.4em 1.4em 1.4em !important;
        margin: 15px 6px 1.5em 6px !important;
        -webkit-box-shadow:  0px 0px 0px 0px #000;
        box-shadow:  0px 0px 0px 0px #000;
    }

    legend.scheduler-border
    {
        font-size: 1.2em !important;
        font-weight: bold !important;
        text-align: left !important;
        width:auto;
        padding:0 10px;
        /*border-bottom:none;*/
    }

    </style>

@endsection

@push('scripts')
<script src="https://cdn.ckeditor.com/4.22.1/standard/ckeditor.js"></script>
    <script language="javascript">
        $(function () {
            CKEDITOR.config.autoParagraph = false;
            CKEDITOR.config.versionCheck = false;
            CKEDITOR.config.enterMode = CKEDITOR.ENTER_BR;
            CKEDITOR.config.shiftEnterMode = CKEDITOR.ENTER_P;
            CKEDITOR.replace('description', {
                enterMode: CKEDITOR.ENTER_BR,
                filebrowserUploadUrl: "{{route('start-dialing.upload', ['_token' => csrf_token() ])}}",
                filebrowserUploadMethod: 'form'
            });

            CKEDITOR.instances['description'].on('contentDom', function () {
                this.document.on('click', function (event) {
                    $('#setBoxValue').html('');
                });
            });
        });
    </script>
@endpush
