@extends('layouts.app')
@section('title', 'Packages List')

@section('content')
<style>
  .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
    
  </style>
<!-- Main content -->
        <section class="content">

      <div class="row">
        
        <div class="col-12">
          <div class="box">
           <div class="box-body">   
                        
              <h4 class="box-title text-info mb-0"><i class="fa fa-list fa-sx"></i> Packages List</h4> 
              <a id="openListForms" href="{{url('/super/package')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-plus"></i>  Add Package</a>

      <hr class="my-15">
                     
              <div class="table-responsive">
                <table id="tickets"  class="table mt-0 table-hover no-wrap" >
                  <thead>
                    <tr>
                    <th>#</th>
                                    <th>Name</th>
                                    <th>Status</th>
                                    <th>Currency Code</th>
                                    <th>CallRate/Minute</th>
                                    <th>Rate/SMS</th>
                                    <th>Rate/DID</th>
                                    <th>Rate/FAX</th>
                                    <th>Rate/EMAIL</th>
                                    <th>Action</th>

                            </tr>
                  </thead>
                  <tbody>
                  @if(!empty($packages))
                                @foreach(array_reverse($packages) as $key => $plan)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>{{$plan->name}}</td>
                                    <td>
                                        @if($plan->is_active == 1)
                                        <span class="badge badge-success">Active</span>
                                        @else
                                        <span class="badge badge-danger">Inactive</span>
                                        @endif
                                    </td>
                                    <td><span class="badge badge-warning">{{$plan->currency_code}}</span></td>
                                    <td><i class="fa fa-usd" aria-hidden="true"></i> {{$plan->call_rate_per_minute}}</td>
                                    <td><i class="fa fa-usd" aria-hidden="true"></i> {{$plan->rate_per_sms}}</td>
                                    <td><i class="fa fa-usd" aria-hidden="true"></i> {{$plan->rate_per_did}}</td>
                                    <td><i class="fa fa-usd" aria-hidden="true"></i> {{$plan->rate_per_fax}}</td>
                                    <td><i class="fa fa-usd" aria-hidden="true"></i> {{$plan->rate_per_email}}</td>
                                    <td class="text-center">
                                    <div class="list-icons d-inline-flex">
                                    <a style="cursor:pointer;color:blue;margin-right:5px;" href="{{url('/super/package/view')}}/{{$plan->key}}" title="View Package Details" class=''  ><i class="fa fa-eye fa-lg"></i></a>
                                      <div class="list-icons-item dropdown">
                                        <a href="#" class="list-icons-item dropdown-toggle" data-bs-toggle="dropdown"><i class="fa fa-file-text"></i></a>
                                        <div class="dropdown-menu dropdown-menu-end">
                                          <a  class="dropdown-item" style="cursor:pointer;" href="{{url('/super/package')}}/{{$plan->key}}"><i class="fa fa-edit fa-lg"></i> Edit</a>
                                          <div class="dropdown-divider"></div>
                                          <a  class="dropdown-item" style="cursor:pointer;"href="{{url('/super/package/copy')}}/{{$plan->key}}" ><i class="fa fa-copy fa-lg"></i> Copy</a>
                                          <div class="dropdown-divider"></div>
                                          <a  class="dropdown-item " style="cursor:pointer;"href="{{url('/super/package/rate')}}/{{$plan->key}}" ><i class="fa fa-usd fa-lg"></i> USD</a>


                                        </div>
                                      </div>
                                    </div>
                                  </td>
                                   
                                </tr>
                                @endforeach
                                @endif
                               

                                       
                  </tbody>
                </table>
              
                    </div><!-- /.box-body -->
            

              </div>
     
            </div>
          </div>
        </div>
        
      </div>
      <!-- /.row -->
   
      <!-- Button trigger modal -->



 
        </div>
    </section>
 





@endsection
