@extends('layouts.app')
@section('title', 'Packages List')

@section('content')
<style>
  .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
  </style>
<!-- Main content -->
        <section class="content">

      <div class="row">
        
        <div class="col-12">
          <div class="box">
             <div class="box-header with-border">            
              <h4 class="box-title"><i class="fa fa-list fa-sx"></i>Packages Plans ({{$package['key']}})</h4> 
              <a id="openListForms" href="{{url('/super/package/rate/add')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-plus"></i>  Add Rate</a>

            </div>
           <div class="box-body">   
                     
              <div class="table-responsive">
                <table id="tickets"  class="table mt-0 table-hover no-wrap" >
                  <thead>
                  <tr>
                                    <th>#</th>
                                    <th>Package</th>
                                    <th>Country / Code</th>
                                    <th>CallRate/Minute</th>
                                    <th>Six/Six Sec</th>

                                    <th>Rate/SMS</th>
                                    <th>Rate/DID</th>
                                    <th>Rate/FAX</th>
                                    <th>Rate/EMAIL</th>
                                    <th>Action</th>

                                </tr>
                            </thead>
                            <tbody>
                                @if(!empty($country_wise_rate))
                                @foreach(array_reverse($country_wise_rate) as $key => $plan)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>{{$package['name']}}</td>
                                    <td><span>{{$plan['title_name']}} / ({{$plan['phone_code']}})</span></td>
                                    <td><i class="fa fa-usd" aria-hidden="true"></i> {{$plan['call_rate_per_minute']}}</td>
                                    <td><i class="fa fa-usd" aria-hidden="true"></i> {{$plan['rate_six_by_six_sec']}}</td>

                                    <td><i class="fa fa-usd" aria-hidden="true"></i> {{$plan['rate_per_sms']}}</td>
                                    <td><i class="fa fa-usd" aria-hidden="true"></i> {{$plan['rate_per_did']}}</td>
                                    <td><i class="fa fa-usd" aria-hidden="true"></i> {{$plan['rate_per_fax']}}</td>
                                    <td><i class="fa fa-usd" aria-hidden="true"></i> {{$plan['rate_per_email']}}</td>
                                    <td>
                                        <!-- <a style="cursor:pointer;color:blue;" href="{{url('/super/package/view')}}/{{$plan['id']}}" title="View Package Details" class=''  ><i class="fa fa-eye fa-lg"></i></a>
                                        | -->
                                        <a style="cursor:pointer;color:blue;" href="{{url('/super/package/rate/edit')}}/{{$plan['id']}}" title="Edit Package Details" class=''  ><i class="fa fa-edit fa-lg"></i></a>
                                        <!-- | -->
                                        <!-- <a style="cursor:pointer;color:blue;" title="Copy Package Details" href="{{url('/super/package/copy')}}/{{$plan['id']}}" class=''  ><i class="fa fa-copy fa-lg"></i></a>
                                        | -->
                                       <!--  <a style="cursor:pointer;color:blue;" title="Country Wise Rate" href="{{url('/super/package/rate')}}/{{$plan['id']}}" class=''  ><i class="fa fa-usd fa-lg"></i></a> -->
                                </tr>
                                @endforeach
                                @endif
                            </tbody>>
                </table>
              
                    </div><!-- /.box-body -->
            

              </div>
     
            </div>
          </div>
        </div>
        
      </div>
      <!-- /.row -->
   
      <!-- Button trigger modal -->



 
        </div>
    </section>
 





@endsection
