@extends('layouts.app')
@section('title', 'Flash Panel')

@section('content')
<style>
  
    .flash-panel {
        display: flex;
        flex-wrap: wrap;
        padding: 0 10px 50px;
    /* Other styles */
}
    .bg-gradient-warning {
        margin: 1px;
        border: 1px solid #2220;
        padding: 20px 10px;
        min-height: 180px;
        max-height: 180px;
    }
    .bg-gradient-warning:hover {
    }
    .bg-gradient-warning .not-configured{
        float: right;
        padding: 4px 10px;
        font-size: 22px;
        color: #111;
        border-radius: 25px;
        border: unset;
    }
    .bg-gradient-warning .configured{
        float: right;
        padding: 4px 10px;
        font-size: 22px;
        color: #111;
        border-radius: 25px;
        border: unset;
    }
    .bg-gradient-warning .count{
        font-size: 30px;
    }
    .bg-gradient-warning .title{
        font-size: 23px;
        padding-bottom: 30px;
        min-height: 45px;
    }
    .bg-gradient-warning .count,.panel-box .title{
        color: #fff;
    }
    .question-setup label{
        float: right;
    }
    input[type='checkbox'] {
        width:15px;
        height:15px;
        background:white;
        border-radius:5px;
    }
    input[type='checkbox']:checked {
        background: #111;
    }
    .row-gap .col-xs-12.col-md-6.col-sm-6.col-lg-3{
        padding-right:1px!important;
        padding-left:1px!important;
    }
</style>
<!-- Main content -->
        <section class="content">

      <div class="row">

       
        
        <div class="col-12">
          <div class="box">
            <div class="box-header with-border">            
              <h4 class="box-title text-info mb-0 mt-15"><i class="fa fa-user fa-sx"></i> Flash Panel</h4>
              <div class="question-setup">
               
                    <input type="checkbox"  id="enable-opening-questions" @if($openingQuestionsStatus->status == 0) checked @endif>
                    <label for="enable-opening-questions"> Start Questions Alert! </label>
            </div>
             
            </div>
           <div class="box-body">           
            <div class="row row-gap">
                @include('layouts.messaging')
                <div class="flash-panel col-md-12">
                    @foreach($openingQuestionsData as $key => $openingQuestionData)
                       <div class="col-12 col-sm-6 col-md-6 col-lg-3">
    <a href="{{ url($openingQuestionData->path) }}">
        <div class="bg-gradient-warning">
            <div class="count">{{ $openingQuestionData->count }}</div>
            <div class="title">
                {{ $openingQuestionData->title }} <i class="{{ $openingQuestionData->icon }}"></i>
            </div>
            @if($openingQuestionData->count == 0)
                <button class="not-configured">
                    Not Setup Yet <i class="fa fa-arrow-circle-right"></i>
                </button>
            @else
                <button class="configured">
                    Configure <i class="fa fa-arrow-circle-right"></i>
                </button>
            @endif
        </div>
    </a>
</div>

                    @endforeach
                </div>
            </div>
            </div>
          </div>
        </div>
    

      </div>
      <!-- /.row -->

    </section>
        <!-- /.content -->
   

        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
        <script>
    jQuery(document).ready(function () {
        $("#enable-opening-questions").change(function() {
            if(this.checked){
                $.ajax({
                    url: 'opening-questions/show/permanently',
                    type: 'GET',
                    success: function (response){
                        window.location.reload(1);
                    },
                    error: function (response) {
                        console.log(response);
                    }
                });
            } else {
                $.ajax({
                    url: 'opening-questions/hide/permanently',
                    type: 'GET',
                    success: function (response){
                        window.location.reload(1);
                    },
                    error: function (response) {
                        console.log(response);
                    }
                });
            }
        });
    });
</script>






@endsection
