@extends('layouts.app')
@section('title', 'Ring Group List')

@section('content')
<style>
  
    .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;
  margin-top:5px;}
  .modal {
    z-index: 1050; /* Adjust the value as needed */
}

/* Set z-index for the Select2 dropdown */
.select2-container {
    z-index: 1060; /* Adjust the value as needed, make it higher than the modal */
}
.table > tbody > tr > td, .table > tbody > tr > th {
     padding: 0.5rem; 
    vertical-align: middle;
}    </style>
<!-- Main content -->
        <section class="content">

      <div class="row">        
        <div class="col-12">
          <div class="box">
           <div class="box-body">           
            <h4 class="box-title text-info mb-0"><i class="icon-Add-user"><span class="path1"></span><span class="path2"></span></i>  Ring Group List</h4>
      
              <!-- <h4 class="box-title"><i class="fa fa-user fa-sx"></i> Ring Group List</h4> -->
              <a id="openDNCForm" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-plus"></i> Add Ring Group</a>
             <hr class="my-15">
           
              <div class="table-responsive">
                <table id="tickets" class="table mt-0 table-hover" data-page-size="10">
                  <thead>
                    <tr>
                              <th>#</th>
                              <th>Name</th>
                              <th>Description</th>
                              <th>Extension</th>
                              <th>Email</th>
                              <th>Action</th>

                            </tr>
                  </thead>
                  <tbody>
                  @foreach($ring_group as $key => $ring)
                                <tr>
                                  <th scope="row">{{$key+1}}</th>
                                  <td>{{$ring->title}}</td>
                                  <td>{{$ring->description}}</td>
                                  <td ><?php                                             
                                                $country_array = explode(',' , $ring->extension_name);
                                                foreach( $country_array as $key => $country )
                                                {
                                                    echo "<span class='badge badge-sm badge-primary'>{$country}</span>";
                                                    echo ( ( $key < ( count( $country_array ) -1 ) ) ? ' ':'' );
                                                }                                                
                                            ?>
                                            
                                  </td>
                                  <td>{{$ring->emails}}</td>                                 
                                  <td><a style="cursor:pointer;margin-right:5px;" title="Edit" class='editRingGroup' data-receiveon={{$ring->receive_on}} data-ringtype={{$ring->ring_type}} data-number={{$ring->id}} data-ext={{ str_replace("SIP/","",$ring->extensions)}} data-emails={{$ring->emails}}  ><i class="fa fa-edit fa-lg"></i></a> 
                                   <a style="cursor:pointer;" title="Delete" class='openRingDelete' data-number={{$ring->id}}><i class="fa fa-trash-o fa-lg"></i></a></td>

                             
                                </tr>

  
                            @endforeach
                         
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
        <div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="add-edit"></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
                <form method="post" action="" >
                  @csrf
                  <input type="hidden" class="form-control" name="ring_id" value="" id="id">

                          <div class="modal-body">
                            <div class="form-group">									
                                <label for="inputEmail3" class="form-label closed number">Name </label>
                                  <div class="input-group mb-3">
                                    <span class="input-group-text"><i class="ti-user"></i></span>

                                    <input type="text" class="form-control closed" required name="title" id="title" placeholder="Please enter name">
                                  </div>
                            </div>
                                    <div class="form-group">	
                                      <label for="inputEmail3" class="form-label ">Description </label>
                                      <div class="input-group mb-3">
                                        <textarea class="form-control" required name="description" id="description" placeholder="Enter Description"></textarea>
                                      </div>
                                    </div>
                                    <div class="form-group">	
                                      <label for="inputEmail3" class="form-label ">Extension</label>
                                      <div class="input-group mb-3">                                          
                                      <select class="select2" multiple="multiple" required name="extensions[]" id="extensions" autocomplete="off" data-placeholder="Select Extension" style="width: 100%;">


                                    
                                    </select>
                                      </div>
                                      <div class="form-group">	
                                      <label for="inputEmail3" class="form-label ">Email </label>
                                      <div class="input-group mb-3">
                                      <span class="input-group-text"><i class="ti-email"></i></span>

                                      <input type="" class="form-control" name="emails[]" value="" id="emails">
                                      </div>
                                    </div>
                                    <div class="form-group">	
                                      <label for="inputEmail3" class="form-label ">Ring Mode </label>
                                      <div class="input-group mb-3">
                                      <select name="ring_type" class="form-select" id="ring_type">
                                      <option value="1">Ring All</option>
                                      <option value="2">Sequence</option>
                                      <option value="3">Round Robin</option>
                                  </select>                                    
                                </div>
                                    </div>

                                      <div class="form-group">  
                                      <label for="inputEmail3" class="form-label ">Receive On</label>
                                      <div class="input-group mb-3">
                                      <select name="receive_on" class="form-select" id="receive_on">
                                      <option value="desk_phone">Desk Phone</option>
                                      <option value="web_phone">Web Phone</option>

                                      <option value="mobile">Mobile</option>
                                      
                                  </select>                                    
                                </div>
                                    </div>
                                    </div>
                              
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                                        <button type="submit"name="submit" class="btn btn-primary btn-sm">Save</button>
                                    </div>
                          </div>
                </form>
            </div>
          </div>
        </div>
        <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
          
              <div class="modal-body">
              <p>You are about to delete <b><i class="title"></i></b>Ring Group.</p>
                <p>Do you want to proceed?</p>
                <input type="hidden" class="form-control" name="ring_id" value="" id="ring_id">
              
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                <button type="submit"name="submit" class="btn btn-danger btn-sm deleteRing">Delete</button>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- /.row -->

    </section>
        <!-- /.content -->

        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
        <script>


    $(".openRingDelete").click(function() {
        var delete_id = $(this).data('number');
        $("#delete").modal('show');
        $("#ring_id").val(delete_id);

    });


     $("#openExcelForm").click(function() {

        $("#myModalExcel").modal('show');
        $("#name").val('');
        $("#status").val('1');
        $("#id").val('');
        $(".closed").show();
        $("#upload-excel").html('Upload Excel');
    });

    $("#openDNCForm").click(function() {

        $("#myModal").modal('show');
        $("#name").val('');
        $("#status").val('1');
        $("#id").val('');
        $(".closed").show();
    loadExtensionOptions([], null);

        $("#add-edit").html('Add Ring Group');
    });

    $(document).on("click", ".editRingGroup", function() {

        var myarr = [];

        var ring_id = $(this).data('number');

        $("#myModal").modal('show');
        $("#add-edit").html('Edit Ring Group');

        var edit_number = $(this).data('number');
        var sip_list = $(this).data('ext');
        //var sip_list = sip_list.replace("SIP/", "");
         //myarr = sip_list.split("&");
       // alert(sip_list);
        //$('#extensions').val(myarr).trigger('change');
        loadExtensionOptions([], sip_list);


        var email_list = $(this).data('emails');
        var ring_type = $(this).data('ringtype');
        var receive_on = $(this).data('receiveon');


        var myarr_emails = email_list.split(",");
        $('#emails').val(myarr_emails).trigger('change');
        $.ajax({
            url: 'editRingGroup/' + edit_number,
            type: 'get',
            success: function(response) {
                $("#description").val(response[0].description);
                $("#title").val(response[0].title);
                $("#emails").val(response[0].emails);
                $("#ring_type").val(response[0].ring_type);
                $("#receive_on").val(response[0].receive_on);
                $("#id").val(response[0].id);
            }
        });
    });

    $(document).on("click", ".deleteRing", function() {
        var delete_id = $("#ring_id").val();
        var el = this;
        $.ajax({
            url: 'deleteRingGroup/' + delete_id,
            type: 'get',
            success: function(response) {
                window.location.reload(1);
            }
        });

        //}
        /*  else
          {
              return false;
          }*/
    });
    function loadExtensionOptions(selectedExtensions, selectedRingID) {
    $.ajax({
        url: 'mapExtensionRingGroup/',
        type: 'get',
        success: function (response) {
            var options = '';

            if (response.success && response.data && response.data.length > 0) {
                var uniqueExtensions = [];
                response.data.forEach(function (extension) {
                    if (extension.is_deleted === 0 && !uniqueExtensions.includes(extension.extension)) {
                        uniqueExtensions.push(extension.extension);
                        options += '<option value="' + extension.extension + '">' + extension.first_name + ' ' + extension.last_name + '-' + extension.extension + '</option>';
                    }
                });
            }

            $("#extensions").html(options);

            if (selectedRingID) {
                loadSelectedExtensions(selectedRingID, selectedExtensions);
            } else {
                $('#extensions').val(selectedExtensions).trigger('change');
            }
        }
    });
}

function loadSelectedExtensions(sip_list, selectedExtensions) {
    $.ajax({
        url: 'mapExtensionRingGroup/',
        type: 'get',
        success: function (response) {
            var extensions = [];
            var test = sip_list.replaceAll("-", "&");
            //alert(test);

            var myArray = test.split("&");

          //  alert(myArray);

            if (response.success && response.data && response.data.length > 0) {
                response.data.forEach(function (extension) {
//let text = "32003&32002&32001&32004&32005&32006";


//alert(myArray[0]);

var cehck =extension.extension;
//alert(cehck);


let arrayLength = myArray.length;
for(let i = 0 ; i < arrayLength; i++) {
    
  // let val = myArray[i];

  //alert(myArray[i]);




if (cehck == myArray[i]) {
                        extensions.push(extension.extension);
                    }

}



                });
            }



            if (selectedExtensions) {
                selectedExtensions.forEach(function (extension) {
                    if (!extensions.includes(extension)) {
                        extensions.push(extension);
                    }
                });
            }

            $('#extensions').val("");

            $('#extensions').val(extensions).trigger('change');
        }
    });
}

</script>
@endsection
