@extends('layouts.app')
@section('title', 'Add Campaign')
@section('content')
<!-- Content Wrapper. Contains page content -->


    <!-- Main content -->
    <section class="content">
        <div class="row">
        <div class="col-lg-12 col-12">
                <div class="box">

                         <form method="post" action="">
                             @csrf
                             <div class="box-body"><!--bg-lightest-->
                             <h4 class="box-title text-info mb-0"><i class="fa fa-plus"></i> Add Campaign</h4>
            <a href="{{url('ringless-campaigns')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i> Campaigns</a>
            <hr class="my-15">

                    <div class="row col-md-12">
                        <div class="form-group col-md-6">
                            <label class="form-label">Name </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <input type="text" class="form-control" name="title" value="{{ old('title') }}" id="campaign_name" required="">
                            </div>
                        </div>
                        <div class="form-group col-md-6">
                            <label class="form-label">Description </label>
                           <div class="input-group">
                                <textarea type="textarea" class="form-control" name="description" value="{{ old('description') }}" id="campaign_description"></textarea>
                            </div>
                        </div>
                  
                    
                    
                        <div class="form-group col-md-6" id="show_predictive_status">
                            <label class="form-label">Status </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                <select name="status" class="form-select" id="status">
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group col-md-3"  id="call_ratio_div">
                            <label class="form-label"id="label_id">Call Duration</label> 
                            <div class="input-group">
                             <span class="input-group-text @error('call_duration') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                <select name="call_duration" class="form-select" id="call_duration">
                                   <option value="60">1 Min</option>
                                   <option value="120">2 Min</option>
                                   <option value="300">5 Min</option>
                                   <option value="600">10 Min</option>
                                   <option value="1200">20 Min</option>
                                   <option value="1800">30 Min</option>
                                </select>
                            </div>
                        </div>

                        


                        <div class="form-group col-md-3"  id="call_ratio_div">
                            <label class="form-label"id="label_id">Call Ratio</label> 
                            <div class="input-group">
                             <span class="input-group-text @error('call_ratio') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                <select name="call_ratio" class="form-select" id="call_ratio">
                                   @php
                                for($i=1;$i<31;$i++)
                                {
                                    @endphp
             <option value="{{$i}}">{{$i}}</option>';
                                @php

            }
                                    @endphp
                                </select>
                            </div>
                        </div>
                        <div class="form-group col-md-6">
                                    <label class="form-label">Time Zone Rule</label>
                                   <div class="input-group">
                                   <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                        <select name="time_based_calling" class="form-select" id="time_based_calling" required="">
                                            <option value="1">Yes</option>
                                            <option value="0">No</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                            <label class="form-label">Schedule Time </label>
                            <div>
                                <div class="input-group">
                                <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                    <input type="time" class="form-select" value="09:30" name="call_time_start" id="timepicker">
                                    <span class="input-group-addon bg-primary text-white b-0">to</span>
                                    <input type="time" class="form-select" value="21:30" name="call_time_end" id="timepicker3">
                                </div>
                            </div>
                        </div>

               
                        <div class="form-group col-md-6">
                            <label class="form-label">Caller Id </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="caller_id" class="form-select" id="caller_id" required="">
                                    <option value="custom">Custom</option>
                                    <option value="area_code">Area Code</option>
                                    <option value="area_code_random">AreaCode And Randomizer</option>
                                  


                                </select>
                            </div>
                        </div>
                        <div class="form-group col-md-6">
                            <label class="form-label">Custom Caller Id </label>
                            <div class="input-group">
                            <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                            <select required class="form-select" name="custom_caller_id" value="" id="custom-caller-id">
                                <option value="">Select DID</option>
                                @if(count($did_list) > 0)
                                    @foreach(array_reverse($did_list) as $key => $lists)
                                    <?php
                                // Assuming $lists->cli contains the caller ID
                                $callerID = $lists->cli;

                                // Remove any non-digit characters from the caller ID
                                $callerID = preg_replace('/[^0-9]/', '', $callerID);

                                // Check if the caller ID is at least 10 digits long
                                if (strlen($callerID) >= 10) {
                                    // Extract the last 10 digits
                                    $lastTenDigits = substr($callerID, -10);

                                    // Format the last 10 digits as (999) 999-9999
                                    $formattedLastTenDigits = preg_replace('/(\d{3})(\d{3})(\d{4})/', '($1) $2-$3', $lastTenDigits);

                                    // Add a "+" sign in front of the original caller ID
                                    $formattedCallerID = '+' . substr($callerID, 0, -10) . $formattedLastTenDigits;

                                    // Output the formatted caller ID
                                    echo $formattedCallerID;
                                } else {
                                    // Handle cases where the caller ID is too short
                                    echo "Invalid caller ID";
                                }
                                echo $formattedCallerID;
                                ?>
                                    <option data-cnam="{{$lists->cnam}}" value="<?php echo $lists->cli ?>">{{$formattedCallerID}}   @php
                                        $role = Session::get('role');
                                    @endphp

@if(in_array($role, ['system_admin', 'system_administrator']))(<?php echo $lists->voip_provider ?>)
                                    @endif <?php if(!empty($lists->cnam)) echo '-'.$lists->cnam ?>
                                 
                                @if($lists->dest_type > 0)
                                    @if($lists->dest_type == 1)
                                        @foreach($extension_list as $extension)
                                            @if($lists->extension == $extension->id)
                                                -{{$extension->first_name}} {{$extension->last_name}} - {{$extension->extension}} 
                                            @endif
                                        @endforeach
                                       @elseif($lists->dest_type == 4)
                                        {{$lists->forward_number}}
                                         @elseif($lists->dest_type == 11)
                                        Voice AI
                                   
                                    @endif
                                 
                                @endif
                                            </option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                        </div>
                        <div class="form-group col-md-6">
                                        <label class="form-label">Country Code </label>
                                       <div class="input-group">
                                       <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                            <select class="form-select"  name="country_code" id="country_code">
                                                                @if (is_array($phone_country))
                                                                @foreach($phone_country as $code)
                                                                <option  value={{$code->phonecode}}>{{$code->name}} (+{{$code->phonecode}})
                                                                </option>
                                                                @endforeach
                                                                @endif
                                            </select>
                                        </div>
                                    </div>

                                     <div class="form-group col-md-6">
                                        <label class="form-label">Voice Template </label>
                                       <div class="input-group">
                                       <span class="input-group-text @error('voice_template_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                            <select class="form-select" required  name="voice_template_id" id="voice_template_id">
                                                <option value="">Select Voice Template</option>
                                                                @if (is_array($templete_list))
                                                                @foreach($templete_list as $temp)
                                                                <option  value={{$temp->id}}>{{$temp->ivr_desc}}
                                                                </option>
                                                                @endforeach
                                                                @endif
                                            </select>
                                        </div>
                                    </div>

                                      <div class="form-group col-md-6">
                                        <label class="form-label">SIP Gateways </label>
                                       <div class="input-group">
                                       <span class="input-group-text @error('sip_gateway_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                            <select class="form-select" required  name="sip_gateway_id" id="sip_gateway_id">
                                                <option value="">Select SIP Gateway</option>
                                                                @if (is_array($gateway_list))
                                                                @foreach($gateway_list as $temp)
                                                                <option  value={{$temp->id}}>{{$temp->sip_trunk_name}}
                                                                </option>
                                                                @endforeach
                                                                @endif
                                            </select>
                                        </div>
                                    </div>
                </div>

            
                    <div class="box-footer text-end">
                    <input type="hidden" class="form-select" name="username" value="" id ="first-name" required>
                    <button type="submit" name="submit" value="Save" class="btn btn btn-primary waves-effect waves-light">Save</button>
                </div>
            </form>
                    </div>
                <div class="row lead_status">
                </div>
            
                    </div><!-- /.box-body -->
                </div><!-- /.box -->

            </div><!-- /.col -->
        </div><!-- /.row -->
    </section><!-- /.content -->

<!-- /.content-wrapper -->
<script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

<script>
    const callerIdSelect = document.getElementById('caller_id');
    const customCallerIdSelect = document.getElementById('custom-caller-id');

    // Initially, set the disabled property based on the selected option
    customCallerIdSelect.disabled = callerIdSelect.value !== 'custom';

    // Add an event listener to the "Caller Id" select field
    callerIdSelect.addEventListener('change', function () {
        customCallerIdSelect.disabled = this.value !== 'custom';
    });
</script>
@endsection
