@extends('layouts.app')
@section('title', 'SIP Gateways')

@section('content')
<style>
.badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;
  margin-top:5px;}
  /* Style for the active state */
.btn-toggle.active {
    background-color: #2196f3; /* Set to the desired green color */
    color: white; /* Set to the desired text color */
    border-color: green; /* Set to the desired border color */
}

/* Style for the inactive state */
.btn-toggle:not(.active) {
    background-color: red; /* Set to the desired red color */
    color: white; /* Set to the desired text color */
    border-color: red; /* Set to the desired border color */
}
  </style>
<!-- Main content -->
<link href="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/css/bootstrap4-toggle.min.css" rel="stylesheet">

        <section class="content">

      <div class="row">

       
        
        <div class="col-12">
          <div class="box">
           <div class="box-body">           
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i>  SIP Gateways List</h4>
              <a href="{{ url('/sip-gateway') }}" type="submit"  style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-plus"></i>  Add</a>
             <hr class="my-15">
              <div class="table-responsive">
                <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
                  <thead>
                    <tr>
                    <th>#</th>
                                    <th>Client Name</th>
                                    <th>Trunk Name</th>
                                    <th>Status</th>                                    
                                    <th>Action</th>

                            </tr>
                  </thead>
                  <tbody>

                  @if(!empty($sip_gateways))
                                @foreach($sip_gateways as $key => $template)
                                <tr>
                                  <th scope="row">{{$key+1}}</th>
                                  <td>{{$template->client_name}}</td>                                     
                                  <td>{{$template->sip_trunk_name}}</td>
                                  <td></td>

                                                             
                                 <td><a style="cursor:pointer;margin-right:5px;"  href="{{url('sip-gateway')}}/{{ $template->id}}" class='editEG'><i class="fa fa-edit fa-lg"></i></a>
                                    
                                        <a  class="openTemplateDelete" style="cursor:pointer;"data-templateid="{{$template->id}}" ><i class="fa fa-trash-o fa-lg"></i></a>     

                                       </td>

                             
                                </tr>

  
                            @endforeach
                         @endif
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
     
      
    
<div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
   
      <div class="modal-body">
      <p>You are about to delete <b><i class="title"></i></b>Sip Gateway.</p>
         <p>Do you want to proceed?</p>
         <input type="hidden" class="form-control" name="sip_gateway_id" value="" id="sip_gateway_id">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit"name="submit" class="btn btn-danger btn-sm deleteTemplate">Delete</button>
      </div>
    </div>
  </div>
</div>
      </div>
      <!-- /.row -->

    </section>
        <!-- /.content -->

        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/js/bootstrap4-toggle.min.js"></script>

    
<script>

$(".openTemplateDelete").click(function() {
        var delete_id = $(this).data('templateid');

        $("#delete").modal('show');
        $("#sip_gateway_id").val(delete_id);


    });
    $(document).on("click", ".deleteTemplate", function() {
    var temp_id = $('#sip_gateway_id').val();
    var modal = $('#delete');
    $.ajax({
        url: 'sip-gateway-delete/' + temp_id,
        type: 'get',
        dataType: 'json',  // Ensure that data is treated as JSON
        success: function(response) {
            console.log(response);
            if (response.success) {
                toastr.success(response.message);
                window.location.reload(); // Refresh page after success
            } else {
                // Handle the error response
                if (Array.isArray(response.message)) {
                    // If message is an array, join the messages into a single string
                    toastr.error(response.message.join(' '));
                    
                } else {
                    // Handle as a single string message
                    toastr.error(response.message || 'An error occurred while deleting the SIP Gateway');
                }
            }
        },
        error: function(xhr) {
            var errorMsg = 'Failed to delete the SIP Gateway. Please try again later.';
            if (xhr.responseJSON && xhr.responseJSON.message) {
                if (Array.isArray(xhr.responseJSON.message)) {
                    // If message is an array, join the messages into a single string
                    errorMsg = xhr.responseJSON.message.join(' ');
                } else {
                    // Handle as a single string message
                    errorMsg = xhr.responseJSON.message;
                }
            }
            toastr.error(errorMsg);
               // Hide the modal if an error occurs
               modal.modal('hide'); // For Bootstrap modals
        }
    });
});


</script>
@endsection
