@extends('layouts.app')
@section('title', 'Trunking Report')
@section('content')

<?php error_reporting(0); ?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">




    <section class="content">
			<div class="row">			  
				<div class="col-lg-12 col-12">
					  <div class="box">
						
						<!-- /.box-header -->
                        <form class="needs-validation" action="{{url('trunking-call-report')}}" method="post">
                            @csrf
							<div class="box-body">
								<h4 class="box-title text-info mb-0"><i class="fa fa-edit me-15"></i>Trunking Call Report</h4> 

								<hr class="my-15">
								<div class="row">
                   
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">Aggregation Type</label>
                                        <div class="input-group mb-3">
                                            <span class="input-group-text @error('aggregation_type') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                            <select class="form-select" name="aggregation_type">
                                            <option value="">Select</option>

                                                <option value="connection"{{ request()->input('aggregation_type')== 'connection' ? 'selected' : '' }}>Connection</option>
                                                <!-- <option value="no_aggregation" {{ old('aggregation_type') == 'no_aggregation' ? 'selected' : '' }}>NO_Aggregation</option> -->
                                                <!-- <option value="tag"{{ old('aggregation_type') == 'tag' ? 'selected' : '' }}>Tag</option> -->
                                                <option value="billing_group"{{ request()->input('aggregation_type') == 'billing_group' ? 'selected' : '' }}>Billing Group</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

								  <div class="col-md-6"style="display:none;"id="div_connection">
                                  <div class="form-group">
									<label class="form-label"> Connections</label>
                                    <div class="input-group mb-3">
                                            <span class="input-group-text @error('connections') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                            <select class="form-select"name="connections">
                                                <option value="">Select</option>
                                                @foreach($connection_list as $list)
                                                <option value="{{$list->id}}"{{ request('connections') == $list->id ? 'selected' : '' }}>{{$list->connection_name}}</option>
                                                @endforeach

                                            </select>
                                     								
                                        </div>
								</div>
								  </div>
                                  <div class="col-md-6"style="display:none;"id="div_tag">
                                  <div class="form-group">
									<label class="form-label"> Tags</label>
                                    <div class="input-group mb-3">
                                            <span class="input-group-text @error('connections') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                            <select class="form-select"name="tag">
                                                <option value="">Select</option>
                                                @foreach($connection_list as $list)
                                                <option value="{{$list->id}}">{{$list->connection_name}}</option>
                                                @endforeach

                                            </select>
                                     								
                                        </div>
								</div>
								  </div>
                                
                                  <div class="col-md-6"style="display:none;"id="div_billing_group">
                                  <div class="form-group">
									<label class="form-label"> Billing Group</label>
                                    <div class="input-group mb-3">
                                            <span class="input-group-text @error('billing_group') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                            <select class="form-select"name="billing_group">
                                                <option value="">Select</option>
                                                @foreach($billing_group as $list)
                                                <option value="{{$list->id}}"{{ request('billing_group') == $list->id ? 'selected' : '' }}>{{$list->name}}</option>
                                                @endforeach

                                            </select>
                                     								
                                        </div>
								</div>
								  </div>
                                <div class="col-md-6">
                                  <div class="form-group">
									<label class="form-label">Product Breakdown</label>
									<div class="input-group mb-3">
										<span class="input-group-text"><i class="ti-user"></i></span>
                                        <select class="form-select"name="product_breakdown">
                                        <option value="">Select</option>
                                                <option value="no_breakdown"selected>No breakdown</option>
                                                <!-- <option value="did_vs_toll_free">DID_Vs_Toll Free</option>
                                                <option value="country">Country</option>
                                                <option value="did_vs_toll_free_per_country">DID_Vs_Toll Free Per Country</option> -->

                                            </select>
                                	</div>
								</div>
                                </div> 	
                                <div class="col-md-6">
                                  <div class="form-group">
									<label class="form-label">Direction</label>
									<div class="input-group mb-3">
										<span class="input-group-text"><i class="ti-user"></i></span>
                                        <select class="form-select"name="direction">
                                        <option value="">Select</option>
                                                <option value="Inbound"{{ request()->input('direction')== 'Inbound' ? 'selected' : '' }}>Inbound</option>
                                                <option value="Outbound"{{ request()->input('direction')== 'Outbound' ? 'selected' : '' }}>Outbound</option>

                                            </select>
                                	</div>
								</div>
                                </div> 	
                            <div class="col-md-6">
                                  <div class="form-group">
									<label class="form-label">Datetime range</label>
									<div class="input-group mb-3">
                                            <div class="input-group-addon">
                                                <i class="fa fa-calendar"></i>
                                            </div>
                                            <input class="form-control" type="datetime-local" name="start_date" value="{{ request()->input('start_date') }}"required>
                                            <input class="form-control" type="datetime-local" name="end_date" value="{{ request()->input('end_date') }}"required>

                                            <!-- <input type="text" class="form-control pull-right cdr-range" id="reservation">
                                            <input type="hidden" id="start_date" name="start_date" value="{{ $startDate }}">
                                            <input type="hidden" id="end_date" name="end_date" value="{{ $endDate }}"> -->
                                    </div>
                                    </div>
                                    </div>
                       
                           
						
                    
                                </div>
                               
                            </div>        
							<!-- /.box-body -->
							<div class="box-footer text-end"style="margin-right:15px;">
                            <button type="submit" name="submit" value="Search" class="btn btn btn-primary waves-effect waves-light"><i class="fa fa-search" aria-hidden="true"></i> Search</button>
                        
                            <!-- <a class="btn btn-primary"href="{{$download_url}}"><i class="fa fa-download" aria-hidden="true"></i>Download</a>                                 -->
							</div>  
						</form>
					  </div>
					  <!-- /.box -->			

                    </div>  

		
		  </div>
		  <!-- /.row -->

	

        <div class="row">

   
        
        <div class="col-lg-12 col-12">
            <div class="box">
            
               <div class="box-body">  
          
                   
                        <div class="table-responsive">
                        <table id='tickets' class="table mt-0 table-hover no-wrap" data-page-size="10">
                            <thead>
                            <tr>
                                                        <th>#</th>
                                                        <th>Cost</th>                
                                                        <th>Direction</th>
                                                        <!-- <th>Product Name</th> -->
                                                        <th>Connection Name</th>
                                                        <th>Billable Calls</th>
                                                        <th>Total Calls</th>
                                                        <th>Currency </th>
                                                        <th>Billed Duration </th>
                                                        <th>Country </th>
                                                        <th>Tag </th>
                                                        <th>Billing Group </th>
                                                        <th>Action</th>

                                                        <!-- <th>Start Time</th>
                                                        <th>End Time</th> -->

                                    </tr>
                            </thead>
                          <tbody>
                            @foreach($report as $key => $list)

                            <tr>
                                <td>{{$key+1}}</td>
                                <td>${{$list->cost}}</td>
                                <td>{{$list->direction}}</td>
                                <!-- <td>{{$list->product_name}}</td> -->
                                <td>{{$list->connection_name}}</td>
                                <td>{{$list->billable_calls}}</td>
                                <td>{{$list->total_calls}}</td>
                                <td>{{$list->currency}}</td>
                                <td>{{$list->billed_duration}}</td>
                                <td>{{$list->country}}</td>
                                <td>{{$list->tag}}</td>
                                <td>{{$list->billing_group}}</td>
                                <td><a style="cursor:pointer;" href="{{$download_url}}"><i class="fa fa-download"></i></a></td>

                                <!-- <th>10th feb,2024</th>
                                <th>13th feb,2024</th> -->




                </tr>
@endforeach

                                
                            </tbody>
                         
                        </table>
                        
                        
                        </div>
                </div>
                
            </div>
        </div>
      

        </div>
<!-- /.row -->


</section>

<script src="https://cdn.jsdelivr.net/npm/imask"></script>
<script>
    var phoneInput = document.getElementById('mobile');
    var phoneMask = new IMask(phoneInput, {
        mask: '(000) 000-0000'
    }); 
    </script>
 

 <script>
    $(document).ready(function () {
        // Listen for changes in the "Aggregation Type" dropdown
        $('select[name="aggregation_type"]').change(function () {
            // Hide all divs
            $('[id^="div_"]').hide();
            
            // Get the selected value
            var selectedValue = $(this).val();
            
            // Show the corresponding div based on the selected value
            $('#div_' + selectedValue).show();
        });

        // Trigger the change event on page load
        $('select[name="aggregation_type"]').trigger('change');
    });
</script>


 


@endsection



