@extends('layouts.app')
@section('title', 'Recharge')

@section('content')
<style>
.nav-tabs-custom > .tab-content {
    background: #ffffff;
    padding: 1.25rem;
    border-radius: 0;
    min-height: 100px;
}    </style>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

<section class="content">
        <!--Call tming div starts-->
        <div class="box">
            <div class="box-body">
								<h4 class="box-title text-info mb-0"><i class="fa fa-edit me-15"></i>Edit Payment Method</h4> 
                                <a href="{{ url('trunking-payment-method') }}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye"></i> Payment Method</a>

								<hr class="my-15">
        <form id="stripeForm" class="form-horizontal" method="post">
            @csrf
            <input name="payment_method_id" type="hidden" value="{{$pmDetails->id}}"/>

        <div class="row">
           
        <div class="col-md-6">
                            <!-- <h4 class="box-title">Billing Info</h4> -->                           
                            <div class="box-body">
                        	<div class="row">
									<div class="col-lg-12 col-md-6 col-12">									                                       
                                         
                                            <div class="row ">
                                                <div class="form-group col-sm-4">
                                                    <label class="form-label">Ex. Month <span style="color:red;">*</span> </label>
                                                    <select id="exp_month" name="exp_month"
                                                        class="form-control">
                                                    <option value="-">--</option>
                                                    @for($i=1;$i<=12;$i++)
                                                    <option value="{{sprintf("%02d", $i)}}" 
                                                    {{isset($pmDetails->card->exp_month) &&  $pmDetails->card->exp_month == $i ? "selected='selected'" : ""}}     
                                                    >{{sprintf("%02d", $i)}}</option>
                                                    @endfor
                                                </select>
                                                </div>
                                                <div class="form-group col-sm-4">
                                                    <label class="form-label">Ex. Year<span style="color:red;">*</span> </label>
                                                    <select id="exp_year" name="exp_year"
                                                        class="form-control">
                                                    <option value="-">----</option>
                                                    @for($i=date("Y");$i<=date("Y")+20;$i++)
                                                        <option value="{{$i}}"
                                                        {{isset($pmDetails->card->exp_year) &&  $pmDetails->card->exp_year == $i ? "selected='selected'" : ""}}        
                                                        >{{sprintf("%02d", $i)}}</option>
                                                    @endfor
                                                </select>
                                                </div>
                                                <div class="form-group col-sm-4">
                                                    <div class="form-group @error('amount') has-error @enderror">
                                                        <label class="form-label">Amount </label>
                                                        <div class="controls">
														<input type="text" class="form-control" name="amount"id="amount" placeholder="100"data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers"> 
													</div>
                                                    </div>
                                                </div>
                                                <h3 class="box-title mt-10">General Info</h3>
										<h2><i class="fa fa-cc-visa text-info"></i>
											<i class="fa fa-cc-mastercard text-danger"></i>
											<i class="fa fa-cc-discover text-success"></i>
											<i class="fa fa-cc-amex text-warning"></i>
										</h2>
                                            </div>
                                         									
									</div>
									<!-- <div class="col-lg-4 col-md-6 col-12">
										<h3 class="box-title mt-10">General Info</h3>
										<h2><i class="fa fa-cc-visa text-info"></i>
											<i class="fa fa-cc-mastercard text-danger"></i>
											<i class="fa fa-cc-discover text-success"></i>
											<i class="fa fa-cc-amex text-warning"></i>
										</h2>

									</div> -->
								</div>
                                                              
                            </div>                                       
                        </div>             
                    <div class="col-md-6">               
                        <!-- <h4 class="box-title">Payment Method </h4> -->
                        <div class="box-body">                                                                   
                        <div class="row">              
                        <div class="form-group col-sm-6"id="add_edit_box_header">
                                                <label class="form-label">Full Name <span style="color:red;">*</span></label>
                                                <input type="text" maxlength="30" class="form-control "
                                                       name="full_name" value="{{isset($pmDetails->billing_details->name) ? $pmDetails->billing_details->name : ""}}"
                                                       id="full_name" placeholder="Full Name">
                                                <span id="message"></span>
                                            </div>             
                                                    <div class=" form-group col-sm-6">
                                                        <label class="form-label">Address<span style="color:red;">*</span> </label>
                                                        <input type="text" maxlength="100" class="form-control " name="line1"
                                                       value="{{isset($pmDetails->billing_details->address->line1) ? $pmDetails->billing_details->address->line1 : ""}}"
                                                       id="line1" placeholder="Address">
                                                        <span id="message"></span>
                                                    </div>                                                                                    
                                                    <div class="form-group col-sm-6">
                                                        <label class="form-label">Country<span style="color:red;">*</span> </label>
                                                       
                                                <select class="form-control " name="country" id="country">
                                                    <option>Select Country</option>
                                                </select>

                                                    </div>
                                                    <div class="form-group col-sm-6">
                                                        <label class="form-label">State <span style="color:red;">*</span></label>
                                                        <span id="state-code"><input class="form-control" value="{{isset($pmDetails->billing_details->address->state) ? $pmDetails->billing_details->address->state : ""}}" type="text" id="state" name="state"></span>

                                                    </div>                                                                                    
                                                    <div class="form-group col-sm-6">
                                                        <label class="form-label">City<span style="color:red;">*</span> </label>
                                                        <input type="text" maxlength="50" class="form-control " name="city"
                                                       value="{{isset($pmDetails->billing_details->address->city) ? $pmDetails->billing_details->address->city : ""}}" id="city"
                                                       placeholder="City">
                                                    </div>
                                                    <div class="form-group col-sm-6">
                                                        <label class="form-label">ZIP <span style="color:red;">*</span>  </label>
                                                        <input type="text" maxlength="20" class="form-control "
                                                       name="postal_code" value="{{isset($pmDetails->billing_details->address->postal_code) ? $pmDetails->billing_details->address->postal_code : ""}}"
                                                       id="postal_code" placeholder="Zip ">
                                                    </div>                                                
                                                </div>
							</div>                                    
                        </div>                            
                    </div>
                    <div class="row">
                                                <div class="form-group col-sm-12">                                                
                                                        <div class="col-md-12 text-end">
                                                        <button type="submit" class="btn btn-success ">Save</button>
                                                            <a href="{{url('trunking/payment-method')}}" type="button" class="btn btn-primary" >Cancel</a> 
                                                        </div>                                                
                                                </div>
                                            </div>	
                    </div>
                </div>
            </div>
        </div>
        <!--Call tming div ends-->
       </form>
    </section>
    <section class="waiting-section" style="display: none">
        <div class="waiting-box">
            <div class="payment-processing">
                <img src="{{asset ('assets/images/loader-30px.gif')}}"/>
                <p>Your Card is being Saved!</p>
            </div>
        </div>
    </section>
    <style>
        .content-wrapper {
            position: relative;
        }
        section.waiting-section {
            text-align: center;
            background-color: #ffffffbd;
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            z-index: 2;
        }
        section.waiting-section div.payment-processing, section.waiting-section div.payment-completed {
            padding-top: 20%;
        }
        section.waiting-section p {
            font-size: 16px;
        }
        section.waiting-section .payment-completed-text, section.waiting-section .redirect-timer {
            font-size: 26px;
        }
        /* Chrome, Safari, Edge, Opera */
        input::-webkit-outer-spin-button,
        input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }
        /* Firefox */
        input[type=number] {
            -moz-appearance: textfield;
        }
    </style>
    
        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
        <script src="{{asset('assets/js/pages/validation.js')}}"></script>
    <script src="{{asset('assets/js/pages/form-validation.js')}}"></script>
    <script>
        $(document).ready(function () {
            $("#stripeForm").submit(function (e) {
                e.preventDefault();
                $("section.waiting-section").show();
                $.ajax({
                    type: 'POST',
                    url: '{{url('trunking/stripe/update-card')}}',
                    data: $('#stripeForm').serialize(),
                    success: function (response) {
                        console.log(response);
                        if (response.success == true || response.success == 'true') {
                            toastr.success(response.message);
                            $("section.waiting-section .payment-processing").hide();
                            // window.location.href = "url('trunking/payment-method')";
                        } else {
                            $("section.waiting-section").hide();
                            $.each(response.errors, function (index, value) {
                                toastr.error(value);
                            });
                        }
                    },
                    error: function (response) {
                        $("section.waiting-section").hide();
                        toastr.error("There is problem with updating card");
                        console.log(response);
                    }
                });
            });
        });
    </script>

    <script src="{{ asset('asset/js/country-states.js') }}"></script>



    <script>
        var payMethodCountry = "{{isset($pmDetails->billing_details->address->country) ? $pmDetails->billing_details->address->country : ""}}";
        var payMethodState = "{{isset($pmDetails->billing_details->address->state) ? $pmDetails->billing_details->address->state : ""}}";
(function () {
    //country code for selected option
    let country_list = country_and_states['country'];
    let states_list = country_and_states['states'];
    // country name drop down
    let option =  '';
    option += '<option>select country</option>';
    for(let country_code in country_list){
        // set selected option user country
        let selected = (country_code == payMethodCountry) ? ' selected' : '';
        option += '<option value="'+country_code+'"'+selected+'>'+country_list[country_code]+'</option>';
    }
    document.getElementById('country').innerHTML = option;
    // state name drop down
    let text_box = '<input type="text" class="form-control" class="input-text" id="state">';
    let state_code_append_id = document.getElementById("state-code");
    function create_states_dropdown() {
        let country_code = document.getElementById("country").value;
        let states = states_list[country_code];
        // invalid country code or no states add textbox
        if(!states){
            state_code_append_id.innerHTML = text_box;
            return;
        }
        let option = '';
        if (states.length > 0) {
            option = '<select class="form-control" name="state" id="state">\n';
            for (let i = 0; i < states.length; i++) {
                let selected = (states[i].name == payMethodState) ? ' selected' : '';
                option += '<option value="'+states[i].name+'"'+selected+'>'+states[i].name+'</option>';
            }
            option += '</select>';
        } else {
            // create input textbox if no states 
            option = text_box
        }
        state_code_append_id.innerHTML = option;
    }
    // country change event
    const country_select = document.getElementById("country");
    country_select.addEventListener('change', create_states_dropdown);
    create_states_dropdown();
})();

function deletePaymentMethod(id) {
    if(confirm("Are you sure want to update this card info?")) {
        $.ajax({
            type: 'POST',
            url: '{{url('stripe/save-card')}}',
            data: $('#stripeForm').serialize(),
            success: function (response) {
                console.log(response);
                if (response.success == true || response.success == 'true') {
                    toastr.success("Payment method delete successfully.");
                    location.reload();
                } else {
                    toastr.error("Something went worng!!!");
                    console.log(response);
                }
            },
            error: function (response) {
                $("section.waiting-section").hide();
                toastr.error("Something went worng!!!");
                console.log(response);
            }
        });
    }
}
</script>



@endsection
