@extends('layouts.app')
@section('title', 'Sip Payment Method')

@section('content')

<!-- Main content -->
        <section class="content">

      <div class="row">
        
        <div class="col-12">
          <div class="box">
             <div class="box-header with-border">            
              <h4 class="box-title text-info mb-0"><i class="fa fa-list fa-sx"></i>  Payment Methods / Cards</h4> 
                    <a type="button"  style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5" href="{{url('trunking/add-payment-method')}}">Add Card</a>
            </div>
          
          </div>
        </div>
      </div>
      <!-- /.row -->
   
      <!-- Button trigger modal -->

      @if(count($paymentMethods) > 0 )
                @foreach($paymentMethods as $paymentMethod)
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="box box-primary box-solid collapsed-box">
                                <div class="box-header with-border">
                                    <h3 class="box-title">
                                        <img class="img-border rounded" onerror="this.src='{{url('/logo/card.png')}}'" 
                                             src="{{url('/logo/')}}/{{$paymentMethod->card->brand}}.png" width="25px;">
                                        {{isset($paymentMethod->card->brand) ? ucwords($paymentMethod->card->brand) : "" }} card ending in {{isset($paymentMethod->card->last4) ? $paymentMethod->card->last4 : "" }} </h3>
                                    <div class="box-tools pull-right">
                                        <span>Expired : <b>{{isset($paymentMethod->card->exp_month) ? $paymentMethod->card->exp_month : "" }}/{{isset($paymentMethod->card->exp_year) ? $paymentMethod->card->exp_year : "" }}</b></span>
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                            <i class="fa fa-plus"></i></button>
                                    </div>
                                </div>
                                <div class="box-body">
                                    <div class="row">
                                        <div class="col-xs-6" style="text-align: center;">
                                            <b>Name on Card</b> <br> {{isset($paymentMethod->billing_details->name) ? $paymentMethod->billing_details->name : "" }}
                                        </div>
                                        <div class="col-xs-6" style="text-align: center;">
                                            <b>Billing Address</b> <br>
                                            {{isset($paymentMethod->billing_details->address->city) ? $paymentMethod->billing_details->address->city : "" }}, {{isset($paymentMethod->billing_details->address->state) ? $paymentMethod->billing_details->address->state : "" }},<br>
                                            {{isset($paymentMethod->billing_details->address->line1) ? $paymentMethod->billing_details->address->line1 : "" }},<br>
                                            {{isset($paymentMethod->billing_details->address->country) ? $paymentMethod->billing_details->address->country : "" }}, {{isset($paymentMethod->billing_details->address->postal_code) ? $paymentMethod->billing_details->address->postal_code : "" }}
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-xs-12" style="text-align: right;">
                                            <a type="button" class="btn btn-primary openCardDelete" data-cardid="{{$paymentMethod->id}}">Remove</a>
                                            <a type="button" href="{{url('trunking/edit-payment-method')}}/{{$paymentMethod->id}}" class="btn btn-primary">Edit</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            @endif
            <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>

                <div class="modal-body">
                  <p>You are about to delete <b><i class="title"></i></b>Card.</p>
                  <p>Do you want to proceed?</p>
                  <input type="hidden" class="form-control" name="card_id" value="" id="card_id">
                  
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                  <button type="submit"name="submit" class="btn btn-danger btn-sm deleteCard">Delete</button>
                </div>
              </div>
            </div>
        </div>  
    </section>
 

    <script>
          $(".openCardDelete").click(function () {
            var card_id = $(this).data('cardid');
            $("#delete").modal('show');
            $("#card_id").val(card_id);

        });
        $(document).on("click", ".deleteCard", function () {
            var card = $("#card_id").val();

            var el = this;
            $.ajax({
                url: 'trunking/stripe/delete-payment-method/' + card,
                type: 'get',
                success: function (response) {
                    toastr.success('Payment method has been deleted successfully');
                    window.location.reload(1);
                }
            });
        });

      
    </script>



@endsection
