@extends('layouts.app')
@section('title', 'SIP Recharge')

@section('content')
<style>
.nav-tabs-custom > .tab-content {
    background: #ffffff;
    padding: 1.25rem;
    border-radius: 0;
    min-height: 100px;
}    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

<section class="content">
    <div class="row">           
        <div class="box">
            <div class="box-body">            
                <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Add  Balance</h4>
                <hr class="my-15">
                <form id="stripeForm" class="form-horizontal" method="post">
                    @csrf
                    <div class="row">
                        <div class="col-md-7">                        
                                <div class="box-body">  
                                <div class="row">
                                                    <div class="col-lg-12 col-md-6 col-12">
                                                                    <div class="row">
                                                                            <div class="form-group">
                                                                                <label for="exampleInputEmail1" class="form-label">Select Card</label>
                                                                                    <div class="input-group">
                                                                                        <div class="input-group-addon">
                                                                                            <i class="fa fa-credit-card"></i>
                                                                                        </div>
                                                                                        <select id="payment_method" name="payment_method"
                                                                                                class="form-select">
                                                                                            <option value="0">Add New</option>
                                                                                            @foreach($paymentMethods as $pm)
                                                                                                    <option value="{{$pm->id}}">XXXX XXXX
                                                                                                        XXXX {{$pm->card->last4}}</option>
                                                                                                @endforeach
                                                                                            </select>													
                                                                                    </div>
                                                                            </div>
                                                                    </div>
                                                                    <div class="row">
                                                                            <div class="col-md-6 form-group showOnlyOnNewCard">
                                                                                <label for="exampleInputEmail1" class="form-label">Card Number<span style="color:red;">*</span></label>
                                                                                <div class="controls">
                                                                                    <div class="input-group">
                                                                                        <div class="input-group-addon">
                                                                                            <i class="fa fa-credit-card"></i>
                                                                                        </div>
                                                                                        <input type="text" class="form-control"  placeholder="Card Number"name="number"id=""data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers"> 												
                                                                                    </div>
                                                                                    </div>
                                                                            </div>
                                                                            <div class="col-md-6 form-group showOnlyOnNewCard">
                                                                                <label for="exampleInputEmail1" class="form-label">Card Holder Name<span style="color:red;">*</span></label>
                                                                                    <div class="input-group">
                                                                                        <div class="input-group-addon">
                                                                                            <i class="fa fa-credit-card"></i>
                                                                                        </div>
                                                                                        <input type="text" class="form-control" name="name"id="name" placeholder="Card Holder Name">                                                                                     
                                                                                    </div>
                                                                            </div>
                                                                    </div>
                                                                    <div class="row">
                                                                    <div class="col-md-4 form-group showOnlyOnNewCard">
                                                                                <label for="exampleInputEmail1" class="form-label">Ex. Month<span style="color:red;">*</span></label>
                                                                                    <div class="input-group">
                                                                                      
                                                                                        <select id="exp_month" name="exp_month" class="form-select">
                                                                            <option value="-">--</option>
                                                                            @for($i=1;$i<=12;$i++)
                                                                                <option value="{{sprintf("%02d", $i)}}">{{sprintf("%02d", $i)}}</option>
                                                                            @endfor
                                                                        </select>                                                                                    </div>
                                                                            </div>
                                                                            <div class="col-md-4 form-group showOnlyOnNewCard">
                                                                                <label for="exampleInputEmail1" class="form-label">Ex. Year<span style="color:red;">*</span></label>
                                                                                    <div class="input-group">
                                                                                    <select id="exp_year" name="exp_year" class="form-select">
                                                                            <option value="-">--</option>
                                                                            @for($i=date("Y");$i<=date("Y")+20;$i++)
                                                                <option value="{{$i}}">{{sprintf("%02d", $i)}}</option>
                                                            @endfor
                                                                        </select>                                                                                     </div>
                                                                            </div>
                                                                            <div class="col-md-4 form-group showOnlyOnNewCard">
                                                                                <label for="exampleInputEmail1" class="form-label">CVV<span style="color:red;">*</span></label>
                                                                                    <div class="controls">
                                                                                     
                                                                                        <input type="text" class="form-control" name="cvc" placeholder="CVV" id="cvc"  minlength="3"maxlength="4"data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers">                                                                             </div>
                                                                    </div>
                                                                     </div>
                                                                    <div class="row">
                                                                            <div class="form-group">
                                                                                <label for="exampleInputEmail1" class="form-label">Amount<span style="color:red;">*</span></label>
                                                                                   
                                                                                    <div class="controls">
                                                                                    <input type="text" class="form-control" name="amount"id="amount" placeholder="100"data-validation-containsnumber-regex="(\d)+" data-validation-containsnumber-message="No Characters Allowed, Only Numbers"> 
                                                                                    </div>
                                                                                    
                                                                            </div>
                                                                    </div>   

                                                                    <div class="row">
                                                                <div class="col-12">
                                                                    <span class="showOnlyOnNewCard" style="color:red;"><b>Card information will be automatically saved for auto refill</b></span><br>
                                                                    <input type="hidden" class="form-control" name="request_type" value="recharge">
                                                                    <!-- <h3 class="box-title">General Info</h3> -->
                                                                    <h2><i class="fa fa-cc-visa text-info"></i>
                                                                        <i class="fa fa-cc-mastercard text-danger"></i>
                                                                        <i class="fa fa-cc-discover text-success"></i>
                                                                        <i class="fa fa-cc-amex text-warning"></i>
                                                                    </h2>
                                                                </div>
                                                            </div>          
                                                                            
                                                                    
                                                    </div>
                                </div>                                                                                       
                                </div>                                       
                        </div>             
                        <div class="col-md-5">               
                                <div class="box-body">                                       
                                <div class="row">                           
                                                        <div class=" form-group col-sm-6">
                                                            <label class="form-label">Address<span style="color:red;">*</span> </label>
                                                            <input type="text" maxlength="100" class="form-control address_info" name="line1"
                                                                value=""
                                                                id="line1" placeholder="Address">
                                                            <span id="message"></span>
                                                        </div>                                                                                    
                                                        <div class="form-group col-sm-6">
                                                            <label class="form-label">Country<span style="color:red;">*</span> </label>
                                                            <select class="form-select address_info" name="country" id="country">
                                                                <option>Select Country</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-sm-6">
                                                            <label class="form-label">State <span style="color:red;">*</span></label>
                                                            <span id="state-code"><input class="form-control address_info" type="text" id="state" name="state"></span>

                                                        </div>                                                                                    
                                                        <div class="form-group col-sm-6">
                                                            <label class="form-label">City<span style="color:red;">*</span> </label>
                                                            <input type="text" maxlength="50" class="form-control address_info" name="city"
                                                                value="" id="city"
                                                                placeholder="City">
                                                        </div>
                                                        <div class="form-group col-sm-6">
                                                            <label class="form-label">ZIP <span style="color:red;">*</span>  </label>
                                                            <input type="text" maxlength="20" class="form-control address_info"
                                                                name="postal_code" value=""
                                                                id="postal_code" placeholder="Zip">
                                                        </div>                                                
                                                    </div>                                                                                  
                                </div>
                            </div>
                        </div>
                        <input type="hidden" class="form-control" name="request_type" value="recharge">
						<button type="submit" class="btn btn-success"data-request="recharge"style="float:right;">Make Payment</button>

                    </div>
                </div>
            </div>
        </div>
        <!--Call tming div ends-->
    </form>
    </section>
 


    <section class="waiting-section" style="display: none">
        <div class="waiting-box">
            <div class="payment-processing">
                <img src="{{asset("assets/images/loader-30px.gif")}}"/>
                <p>Your payment is being processed!</p>
            </div>
            <div class="payment-completed" style="display: none">
                <img src="{{asset("assets/images/loader-30px.gif")}}"/>
                <p class="payment-completed-text">Thank you for your payment. We are updating your Wallet!</p>
                <p>You will be redirected in..</p>
                <p class="redirect-timer" data-countdown="5">5</p>
            </div>
        </div>
    </section>


    <style>
        .content-wrapper {
            position: relative;
        }
        section.waiting-section {
            text-align: center;
            background-color: #ffffffbd;
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            z-index: 2;
        }
        section.waiting-section div.payment-processing, section.waiting-section div.payment-completed {
            padding-top: 20%;
        }
        section.waiting-section p {
            font-size: 16px;
        }
        section.waiting-section .payment-completed-text, section.waiting-section .redirect-timer {
            font-size: 26px;
        }
        /* Chrome, Safari, Edge, Opera */
        input::-webkit-outer-spin-button,
        input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }
        /* Firefox */
        input[type=number] {
            -moz-appearance: textfield;
        }
    </style>
    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
    <script src="{{asset('assets/js/pages/validation.js')}}"></script>
    <script src="{{asset('assets/js/pages/form-validation.js')}}"></script>
    <script>
    $(document).ready(function () {
    $("#payment_method").on('change', function () {
        var selectedCardId = $(this).val();

        // Check if the selected card is 'Add New'
        if (selectedCardId == '0') {
            $(".showOnlyOnNewCard").show();
            $(".address_info").attr('disabled', false);
            $("#state").attr('disabled', false);

        } else {
            $(".showOnlyOnNewCard").hide();
            $(".address_info").attr('disabled', true);
            $("#state").attr('disabled', true);

            // Assume you have a JavaScript variable or JSON data with card details
            var cardDetails = <?php echo json_encode($paymentMethods); ?>; // Replace with actual card details
            // Find the selected card details
            var selectedCard = cardDetails.find(function (card) {
                return card.id == selectedCardId;
            });
            console.log('Card Details:', selectedCard);

            if (selectedCard) {
                         // Populate country, state, and address fields
            $('#country').val(selectedCard.billing_details.address.country);
            $('#state').val(selectedCard.billing_details.address.state);
            $('#city').val(selectedCard.billing_details.address.city);
            $('#postal_code').val(selectedCard.billing_details.address.postal_code);
            $('#line1').val(selectedCard.billing_details.address.line1);
            }
        }
    });
});

            
$("#stripeForm").submit(function (e) {
    e.preventDefault();
    $("section.waiting-section").show();

    // Add CSRF token to the data
    var formData = $('#stripeForm').serialize();
    formData += '&_token={{ csrf_token() }}';

    $.ajax({
        type: 'POST',
        url: '{{ url('trunking-recharge') }}',
        data: formData,
        success: function (response) {
            console.log(response);
            if (response.success === true) {
                toastr.success(response.message);
                $("section.waiting-section .payment-processing").hide();
                $("section.waiting-section .payment-completed").show();
                var timeleft = 5;
                var downloadTimer = setInterval(function () {
                    if (timeleft < 0) {
                        clearInterval(downloadTimer);
                        window.location.href = "trunking-wallet-transactions";
                    } else {
                        $("section.waiting-section .payment-completed p.redirect-timer").text(timeleft);
                    }
                    timeleft -= 1;
                }, 1000);
            } else {
                $("section.waiting-section").hide();
                $.each(response.errors, function (index, value) {
                    toastr.error(value);
                });
            }
        },
        error: function (response) {
            $("section.waiting-section").hide();
            toastr.error("There is a problem with processing payment");
            console.log(response);
        }
    });
});
    </script>
 

    <script src="{{ asset('assets/js/country-states.js') }}"></script>



    <script>
  
(function () {
    //country code for selected option
    let user_country_code = "IN";
    let country_list = country_and_states['country'];
    let states_list = country_and_states['states'];
    // country name drop down
    let option =  '';
    option += '<option>select country</option>';
    for(let country_code in country_list){
        // set selected option user country
        let selected = (country_code == user_country_code) ? ' selected' : '';
        option += '<option value="'+country_code+'"'+selected+'>'+country_list[country_code]+'</option>';
    }
    document.getElementById('country').innerHTML = option;
    // state name drop down
    let text_box = '<input type="text" class="form-control" class="input-text" id="state">';
    let state_code_append_id = document.getElementById("state-code");
    function create_states_dropdown() {
        let country_code = document.getElementById("country").value;
        let states = states_list[country_code];
        // invalid country code or no states add textbox
        if(!states){
            state_code_append_id.innerHTML = text_box;
            return;
        }
        let option = '';
        if (states.length > 0) {
            option = '<select class="form-control" name="state" id="state">\n';
            for (let i = 0; i < states.length; i++) {
                option += '<option value="'+states[i].name+'">'+states[i].name+'</option>';
            }
            option += '</select>';
        } else {
            // create input textbox if no states 
            option = text_box
        }
        state_code_append_id.innerHTML = option;
    }
    // country change event
    const country_select = document.getElementById("country");
    country_select.addEventListener('change', create_states_dropdown);
    create_states_dropdown();
})();
</script>



@endsection
