@extends('layouts.app')
@section('title', 'SmsAi Wallet Amount')

@section('content')
<style>
  #tickets {
    width: 100%;  /* Full width */
    table-layout: fixed;  /* Ensures all columns have the same width */
  }
  
  #tickets th, #tickets td {
    padding: 10px;
    text-align: left;
    overflow: hidden;
    text-overflow: ellipsis;  /* Prevents long text from overflowing */
    white-space: nowrap;
  }
</style>
<!-- Main content -->
        <section class="content">

      <div class="row">
        
        <div class="col-12">
          <div class="box">
           <div class="box-body">   
              <h4 class="box-title text-info mb-0"><i class="fa fa-list fa-sx"></i> Wallet Amount</h4> 
                  <hr class="my-15">   
              <div class="table-responsive">
                <table id="tickets" class="table mt-0 table-hover no-wrap" >
                  <thead>
                    <tr>
                                    <th>ID</th>
                                    <th>Currency Code</th>
                                    <th>Amount</th>


                            </tr>
                  </thead>
                  <tbody>
                 
                                    @foreach($walletAmount as $key => $walletAmount)
                                        <tr>
                                            <td>{{$key+1}}</td>
                                            <td>{{$walletAmount->currency_code}}</td>
                                            <td>{{$walletAmount->amount}}</td>

                                        </tr>
                                    @endforeach
                                                   
                  </tbody>
                </table>
              
                    </div><!-- /.box-body -->
            

              </div>
     
            </div>
          </div>
        </div>
      </div>
      <!-- /.row -->
   
      <!-- Button trigger modal -->



    <?php  ?>
        </div>
    </section>
 





@endsection
