@extends('layouts.app')
@section('title', 'Sms Ai Wallet Transactions')

@section('content')

<!-- Main content -->
        <section class="content">

      <div class="row">
        
        <div class="col-12">
          <div class="box">
           <div class="box-body">   
              <h4 class="box-title text-info mb-0"><i class="fa fa-list fa-sx"></i> Sms Ai Wallet Transactions</h4> 
                  <hr class="my-15">   
              <div class="table-responsive">
                <table id="tickets" class="table mt-0 table-hover no-wrap" >
                  <thead>
                    <tr>
                                    <th>ID</th>
                                    <th>Amount</th>
                                    <th>Transaction Type</th>
                                    <th>Description</th>
                                    <th>Time</th>

                            </tr>
                  </thead>
                  <tbody>
                  @if(isset($walletTransactions))
                                    @foreach($walletTransactions as $key => $walletTransaction)
                                        <tr>
                                            <td>{{$walletTransaction->id}}</td>
                                           <td>${{ number_format($walletTransaction->amount / 1, 2, '.', '') }}</td>
                                            <td>{{ucfirst($walletTransaction->transaction_type)}}</td>
                                            <td>{{$walletTransaction->description}}</td>
                                            <td>{{date('Y-m-d H:i',strtotime($walletTransaction->created_at))}}</td>
                                        </tr>
                                    @endforeach
                                @endif                       
                  </tbody>
                </table>
              
                    </div><!-- /.box-body -->
            

              </div>
     
            </div>
          </div>
        </div>
      </div>
      <!-- /.row -->
   
      <!-- Button trigger modal -->



    <?php  ?>
        </div>
    </section>
 





@endsection
