@extends('layouts.app')
@section('title', 'Edit Campaign')
@section('content')
<!-- Content Wrapper. Contains page content -->

<style>
    /* Style for the active state */
.btn-toggle.active {
    background-color: green; /* Set to the desired green color */
    color: white; /* Set to the desired text color */
    border-color: green; /* Set to the desired border color */
}

/* Style for the inactive state */
.btn-toggle:not(.active) {
    background-color: red; /* Set to the desired red color */
    color: white; /* Set to the desired text color */
    border-color: red; /* Set to the desired border color */
}
  </style>

<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <!-- Main content -->
    <section class="content">
        <div class="row">
        <div class="col-lg-12 col-12">
                <div class="box">

                        <form method="post" action="/smsai/campaign/update/{{$campaign_list[0]['id']}}">
                             @csrf
                             <div class="box-body"><!--bg-lightest-->
                             <h4 class="box-title text-info mb-0"><i class="fa fa-plus"></i> Edit Campaign</h4>
            <a href="{{url('sms-ai-campaign')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i> Campaigns</a>
            <hr class="my-15">

                    <div class="row col-md-12">
                        <div class="form-group col-md-6">
                            <label class="form-label">Name </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <input type="text" class="form-control" name="title" value="{{$campaign_list[0]['title']}}" id="campaign_name" required="">
                            </div>
                        </div>
                        <div class="form-group col-md-6">
                            <label class="form-label">Description </label>
                           <div class="input-group">
                                <textarea type="textarea" class="form-control" name="description"  id="campaign_description">{{$campaign_list[0]['description']}}</textarea>
                            </div>
                        </div>
                  
                        <div class="form-group col-md-6" id="show_predictive_status">
                            <label class="form-label">Status </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                <select name="status" class="form-select" id="status">
                                    <option @if($campaign_list[0]['status'] == 1) selected @endif  value="1">Active</option>
                                                <option @if($campaign_list[0]['status'] == 0) selected @endif  value="0">Inactive</option>
                                </select>
                            </div>
                        </div>


                        <div class="form-group col-md-3"  id="call_ratio_div">
                            <label class="form-label"id="label_id">Call Duration</label> 
                            <div class="input-group">
                             <span class="input-group-text @error('call_duration') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                <select name="call_duration" class="form-select" id="call_duration">
                                   <option @if($campaign_list[0]['call_duration'] == '30') selected @endif value="30">30 Sec</option>
                                   <option @if($campaign_list[0]['call_duration'] == '60') selected @endif value="60">1 Min</option>
                                   <option @if($campaign_list[0]['call_duration'] == '120') selected @endif value="120">2 Min</option>
                                   <option @if($campaign_list[0]['call_duration'] == '300') selected @endif value="300">5 Min</option>
                                   <option @if($campaign_list[0]['call_duration'] == '600') selected @endif value="600">10 Min</option>
                                   <option @if($campaign_list[0]['call_duration'] == '1200') selected @endif value="1200">20 Min</option>
                                   <option @if($campaign_list[0]['call_duration'] == '1800') selected @endif value="1800">30 Min</option>
                                </select>
                            </div>
                        </div>

                        


                        <div class="form-group col-md-3"  id="call_ratio_div">
                            <label class="form-label"id="label_id">Call Ratio</label> 
                            <div class="input-group">
                             <span class="input-group-text @error('call_ratio') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                <select name="call_ratio" class="form-select" id="call_ratio">
                                   @php
                                for($i=1;$i<61;$i++)
                                {
                                    @endphp
             <option @if($campaign_list[0]['call_ratio'] == $i) selected @endif value="{{$i}}">{{$i}}</option>';
                                @php

            }
                                    @endphp
                                </select>
                            </div>
                        </div>


                           <div class="form-group col-md-6"  id="call_ratio_div">
                            <label class="form-label"id="label_id">SMS AI Templates</label> 
                            <div class="input-group">
                             <span class="input-group-text @error('call_ratio') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                <select required name="sms_ai_template_id" class="form-select" id="sms_ai_template_id">
                                   @foreach($templates as $list)
                                   @if($list->status == 1)
             <option @if($campaign_list[0]['sms_ai_template_id'] == $list->id) selected @endif value="{{$list->id}}">{{$list->template_name}}</option>
             @endif
                                        @endforeach

                                </select>
                            </div>
                        </div>
                    
                        

                      
                  
                  
                    
                        <div class="form-group col-md-6">
                            <label class="form-label">Caller Id </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="caller_id" class="form-select" id="caller_id" required="">
                                    <option @if($campaign_list[0]['caller_id'] == 'custom') selected @endif value="custom">Custom</option>
                                                        <option @if($campaign_list[0]['caller_id'] == 'area_code') selected @endif value="area_code">Area Code</option>
                                                        <option @if($campaign_list[0]['caller_id'] == 'area_code_random') selected @endif value="area_code_random">AreaCode And Randomizer</option>
                                  
                                  

                                </select>
                            </div>
                        </div>
                        <div class="form-group col-md-6">
                            <label class="form-label">Custom Caller Id </label>
                            <div class="input-group">
                            <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                            <select required class="form-select" name="custom_caller_id" id="custom-caller-id">

@if(count($did_list) > 0)
            @foreach(array_reverse($did_list) as $key => $lists)
            <?php
             if($lists->sms_type == '0') 
                                    {
                                        continue;
                                    }
// Assuming $lists->cli contains the caller ID
$callerID = $lists->cli;

// Remove any non-digit characters from the caller ID
$callerID = preg_replace('/[^0-9]/', '', $callerID);

// Check if the caller ID is at least 10 digits long
if (strlen($callerID) >= 10) {
    // Extract the last 10 digits
    $lastTenDigits = substr($callerID, -10);

    // Format the last 10 digits as (999) 999-9999
    $formattedLastTenDigits = preg_replace('/(\d{3})(\d{3})(\d{4})/', '($1) $2-$3', $lastTenDigits);

    // Add a "+" sign in front of the original caller ID
    $formattedCallerID = '+' . substr($callerID, 0, -10) . $formattedLastTenDigits;

    // Output the formatted caller ID
    echo $formattedCallerID;
} else {
    // Handle cases where the caller ID is too short
    echo "Invalid caller ID";
}
echo $formattedCallerID;
?>

            <option  data-cnam="{{$lists->cnam}}" @if($campaign_list[0]['custom_caller_id'] == $lists->cli) selected @endif value="<?php echo $lists->cli ?>">{{$formattedCallerID}}        @php
                                        $role = Session::get('role');
                                    @endphp

@if(in_array($role, ['system_admin', 'system_administrator']))(<?php echo $lists->voip_provider ?>)
                                    @endif<?php if(!empty($lists->cnam)) echo '-'.$lists->cnam ?>
            
@if($lists->dest_type > 0)
    @if($lists->dest_type == 1)
        @foreach($extension_list as $extension)
            @if($lists->extension == $extension->id)
                -{{$extension->first_name}} {{$extension->last_name}} - {{$extension->extension}} 
            @endif
        @endforeach 
    @elseif($lists->dest_type == 4)
        {{$lists->forward_number}}
        @elseif($lists->dest_type == 11)
        Voice AI       
    @endif

@endif
            </option>
        @endforeach
    @endif
</select>
                        </div>
                        </div>
                   
                         <div class="col-md-6">
                                  <div class="form-group">
                                    <label class="form-label">Call Time </label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text"><i class="ti-user"></i></span>
                                        <input type="time" class="form-control" value="{{$campaign_list[0]['call_time_start']}}" name="call_time_start" id="timepicker">
                                    <span class="input-group-addon bg-primary text-white b-0">to</span>
                                    <input type="time" class="form-control" value="{{$campaign_list[0]['call_time_end']}}" name="call_time_end" id="timepicker3">
                                    </div>
                                </div>
                                </div>
     
                                    <div class="form-group col-md-6">
                                        <label class="form-label">Country Code </label>
                                       <div class="input-group">
                                       <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                            <select class="form-select"  name="country_code" id="country_code">
                                                                @if (is_array($phone_country))
                                                @foreach($phone_country as $code)
                                                <option @if($campaign_list[0]['country_code'] == $code->phonecode ) selected @endif value={{$code->phonecode}}>{{$code->name}} (+{{$code->phonecode}})
                                                </option>
                                                @endforeach
                                                @endif
                                            </select>
                                        </div>
                                    </div>
                    
                                <div class="form-group col-md-6">
                                    <label class="form-label">Time Based Calling </label>
                                   <div class="input-group">
                                   <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                        <select name="time_based_calling" class="form-select" id="time_based_calling" required="">
                                            <option @if($campaign_list[0]['time_based_calling'] == 1) selected @endif value="1">Yes</option>
                                    <option @if($campaign_list[0]['time_based_calling'] == 0) selected @endif value="0">No</option>
                                        </select>
                                    </div>
                                </div>
                           
                 
                 





                </div>

            
                    <div class="box-footer text-end">
                    <button type="submit" name="submit" value="Save" class="btn btn btn-primary waves-effect waves-light">Update</button>
                </div>
            </form>
                    </div>
                <div class="row lead_status">
                </div>
            
                    </div><!-- /.box-body -->
                </div><!-- /.box -->

            </div><!-- /.col -->
        </div><!-- /.row -->
    </section><!-- /.content -->
    <section class="content">

<div class="row">

 
  
  <div class="col-lg-12 col-12">
    <div class="box">
    
     <div class="box-body">           
        <div class="table-responsive">
          <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
            <thead>
              <tr>
                        <th>#</th>
                        <!-- <th>Campaign Name</th> -->
                        <th>List Name</th>
                        <th>Dialled Leads/Total Leads</th>                
                        <th>Status</th>
                        <th>Action</th>

                      </tr>
            </thead>
            <tbody>
            @foreach($no_of_campaign_list as $key => $campaignlst)
                          <tr>
                            <th scope="row">{{$key+1}}</th>
                            <td>{{$campaignlst->title}}</td>
                            <td>{{$campaignlst->sms_ai_lead_report_count}}/{{$campaignlst->total_leads}}</td>
                                                  <td>       @if($campaignlst->status == '0')
                                              <span class="badge badge-md badge-danger">Inactive</span>
                                          @else ($campaignlst->status == '1')
                                              <span class="badge badge-md badge-success">Active</span>
                                          @endif</td>
                                          <td>
                                       
                                  
                                             <a style="cursor:pointer;"
                                    class='openCampaignDelete' data-camid="{{$campaignlst->campaign_id}}" data-id="{{$campaignlst->id}}"  ><i class="fas fa-trash"></i></a> 
                                    <a style="cursor:pointer;color:blue;"  class='openrecycle'  data-camid={{$campaignlst->campaign_id}} data-id={{$campaignlst->id}}><i class="fas fa-recycle"></i></a> 
                                     <button type="button" data-campaignid="{{$campaignlst->campaign_id}}" data-listid="{{$campaignlst->id}}"class="btn btn-sm btn-toggle  @if($campaignlst->status == '1') active @endif" data-bs-toggle="button" aria-pressed="true" autocomplete="off">
                                  <div class="handle"></div>
                                  </button>
</label> </td>
                            
                       
                          </tr>


                      @endforeach
                   
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
   
</div>
<!-- /.row -->
<div class="modal fade" id="recycle" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="myModalLabel">Confirm Recycle</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
  
      <div class="modal-body">
      <p>You are about to recycle this <b><i class="title"></i></b>list.</p>
         <p>Do you want to proceed?</p>
         <input type="hidden" class="form-control" name="list_id_recycle" value="" id ="list_id_recycle" >
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit"name="submit" class="btn btn-danger btn-sm recycleListData">Recycle</button>
      </div>
      
    </div>
  </div>
</div>
<div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header">
  <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>
<form method="post" action="" enctype="multipart/form-data">
@csrf
<div class="modal-body">
<p>You are about to delete <b><i class="title"></i></b> list.</p>
   <p>Do you want to proceed?</p>
   <input type="hidden" class="form-control" name="list_id" value="" id ="list_id" >
                      <input type="hidden" class="form-control" name="camid" value="" id ="camid" > 
</div>
<div class="modal-footer">
  <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
  <button type="submit"name="submit" class="btn btn-danger btn-sm deleteCampaignList">Delete</button>
</div>
  </form>
</div>
</div>


</section>

<!-- /.content-wrapper -->
<script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

<script>
    const callerIdSelect = document.getElementById('caller_id');
    const customCallerIdSelect = document.getElementById('custom-caller-id');

    // Initially, set the disabled property based on the selected option
    customCallerIdSelect.disabled = callerIdSelect.value !== 'custom';

    // Add an event listener to the "Caller Id" select field
    callerIdSelect.addEventListener('change', function () {
        customCallerIdSelect.disabled = this.value !== 'custom';
    });
</script>
<script>
        $(".openCampaignDelete").click(function() {
        var delete_id = $(this).data('camid');
        var list_id = $(this).data('id');
        $("#delete").modal('show');
        $("#list_id").val(list_id);

    });

          $(document).on("click", ".deleteCampaignList" , function() {
    //if(confirm("Are you sure you want to delete this?")){
        var list_id = $('#list_id').val();

       //alert(group_id);
        var el = this;
        $.ajax({
            url: '/smsai/list/delete/'+list_id,
            type: 'get',
            success: function(response){
                 window.location.href = "/sms-ai-campaign";
            }
        });
     //   window.location.reload(1);
   
});



    
</script>


<script>
    $(function()
    {
        $("#tickets").on("click", ".btn-toggle", function ()
        {
            var status = $(this).hasClass('active') ? 1 : 0;

            var listid = $(this).data('listid');             

            $.ajax({
                type: "GET",
                dataType: "json",
                url: '/smsai/list/update-status/'+listid+'/'+status,
                success: function(data)
                {
                    if(data.status == 'true')
                    {
                        toastr.success(data.message);
                    }
                    else
                    {
                        toastr.error(data.message);

                    }

                    console.log(data.success);
                    window.location.reload(1);
                }
            });
        })
    })
    $(".openrecycle").click(function(){
    var delete_id = $(this).data('id');

    //alert(camid);

    $("#recycle").modal('show');
    $("#list_id_recycle").val(delete_id);
    $("#camid_recycle").val(camid);


});


     $(document).on("click", ".recycleListData" , function() {
    var list_id = $('#list_id_recycle').val();

   //alert(group_id);
    var el = this;
    $.ajax({
        url: '/smsai/list/recycle/'+list_id,
        type: 'get',
        success: function(response){
             window.location.reload(1);
        }
    });
 //   window.location.reload(1);

});

</script>

@endsection
