@extends('layouts.app')
@section('title', 'SMS AI Campaign')
@section('content')
<style>
.badge {
    font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;
    margin-top: 5px;
}

.btn-toggle.active {
    background-color: #2196f3;
    /* Set to the desired green color */
    color: white;
    /* Set to the desired text color */
    border-color: green;
    /* Set to the desired border color */
}

/* Style for the inactive state */
.btn-toggle:not(.active) {
    background-color: red;
    /* Set to the desired red color */
    color: white;
    /* Set to the desired text color */
    border-color: red;
    /* Set to the desired border color */
}
</style>

<style>
.lender-modal {
    border-radius: 10px;
    background-color: #fff;
}

@media (max-width: 576px) {
    .box-body .d-flex {
        flex-direction: column;
        align-items: flex-start;
    }
    .box-body .d-flex a {
        margin-top: 8px;
    }
}
</style>

<link href="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/css/bootstrap4-toggle.min.css"
    rel="stylesheet">

<!-- Main content -->

<section class="content">

    <div class="row">



        <div class="col-12">
            <div class="box">

                <div class="box-body">
                   <div class="d-flex justify-content-between align-items-center flex-wrap">
        <h4 class="box-title text-info mb-0">
            <i class="fa fa-user fa-sx"></i> SMS AI Campaign List
        </h4>
        <a href="{{ url('/smsai/campaign/add') }}" 
           class="btn btn-rounded btn-primary btn-bitbucket btn-sm mb-2">
            <i class="fa fa-plus"></i> Add SMS AI Campaign
        </a>
    </div>

                    <!-- <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> SMS AI Campaign List</h4>
                    <a href="{{ url('/smsai/campaign/add') }}" type="button" style="float:right"
                        class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i
                            class="fa fa-plus"></i> Add SMS AI Campaign</a> -->
                    <hr class="my-15">
                    <div class="table-responsive">
                        <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Total Lists</th>
                                    <th>Dialled Leads/Total Leads</th>

                                    <th>Hopper Count</th>
                                    <th>Schedule time</th>
                                    <th>Created date</th>
                                    <th>Status</th>
                                    <th>Action</th>

                                </tr>
                            </thead>
                            <tbody>
                                @foreach($campaign_list as $key => $campaign)
                                <tr>
                                    <th scope="row">{{$key+1}}</th>
                                    <td>{{$campaign->title}}</td>
                                    <td>{{$campaign->rowCountLeadReport}}</td>
                                    <td>
                                        @php
                                        $totalSmsAiListDataCount = 0;
                                        @endphp
                                        @if(isset($campaign->lead_reports))
                                        @foreach($campaign->lead_reports as $leadReport)
                                        @php
                                        $totalSmsAiListDataCount += $leadReport->sms_ai_list_data_count ?? 0;
                                        @endphp
                                        @endforeach
                                        {{ $campaign->sms_ai_lead_report_count }}/{{ $totalSmsAiListDataCount }}
                                        @else
                                        {{ $campaign->sms_ai_lead_report_count }}/0
                                        @endif
                                    </td>
                                    <td>{{$campaign->sms_ai_lead_temps_count}}</td>

                                    <td>{{date('g:i A',strtotime($campaign->call_time_start))}} to
                                        {{date('g:i A',strtotime($campaign->call_time_end))}}</td>
                                    <td>{{date('Y-m-d H:i',strtotime($campaign->updated_at))}}</td>
                                    <td>
                                        <button type="button" data-listid="{{$campaign->id}}"
                                            class="btn btn-sm btn-toggle  @if($campaign->status == '1') active @endif"
                                            data-bs-toggle="button" aria-pressed="true" autocomplete="off">
                                            <div class="handle"></div>
                                        </button>
                                    </td>
                                    <td>
                                        <div class="list-icons d-inline-flex">
                                            <a type="button" style="cursor:pointer;" data-bs-toggle="modal"
                                                data-bs-target="#myModal{{$campaign->id}}" data-id="{{$campaign->id}}"
                                                class="list-icons-item me-10"><i class="fa fa-eye fa-lg"></i></a>
                                            <div class="list-icons-item dropdown">
                                                <a href="#" class="list-icons-item dropdown-toggle"
                                                    data-bs-toggle="dropdown"><i class="fa fa-file-text"></i></a>
                                                <div class="dropdown-menu dropdown-menu-end">
                                                    <a class="dropdown-item" style="cursor:pointer;"
                                                        href="{{url('smsai/campaign/view')}}/{{$campaign->id}}"
                                                        data-id="{{$campaign->id}}"><i class="fa fa-edit fa-lg"></i>
                                                        Edit</a>
                                                    <div class="dropdown-divider"></div>
                                                    <a class="dropdown-item" style="cursor:pointer;"
                                                        href="{{url('smsai/campaign/copy')}}/{{$campaign->id}}"
                                                        data-id="{{$campaign->id}}"><i class="fa fa-copy fa-lg"></i>
                                                        Copy</a>
                                                    <!-- <div class="dropdown-divider"></div>                                          
                                          <a  class="dropdown-item reloadHopper"style="cursor:pointer;"data-campaign="{{$campaign->id}}" data-url="{{ route('reloadHopper', ['campaign'=>$campaign->id]) }}"><i class="fa fa-refresh fa-lg"></i> Reset</a> -->
                                                    <div class="dropdown-divider"></div>
                                                    <a class="dropdown-item openCampaignDelete" style="cursor:pointer;"
                                                        data-campaignid="{{$campaign->id}}"><i
                                                            class="fa fa-trash-o fa-lg"></i> Delete</a>


                                                </div>
                                            </div>
                                        </div>
                                    </td>


                                </tr>
                            <div id="myModal{{$campaign->id}}" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content lender-modal border-0 shadow-none">

      <!-- Modal Header -->
      <div class="modal-header py-3" style="border-bottom: 1px solid #bbb;">
        <h4 class="text-dark mb-0" style="font-weight: 400; font-size: 1.25rem;">
          <i class="icon-Cardboard-vr"><span class="path1"></span><span class="path2"></span></i> Campaign Details
        </h4>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>

      <!-- Modal Body -->
      <div class="modal-body pt-4">
        <div class="row">

          <!-- Left Column -->
          <div class="col-md-6">

            <div class="form-group">
              <i style="color:black;" class="ti-user"></i>
              <label class="form-label ms-1">Name</label>
              <p><span class="badge badge-sm badge-primary">{{ $campaign->title }}</span></p>
            </div>

            <div class="form-group">
              <i style="color:black;" class="ti-mobile"></i>
              <label class="form-label ms-1">Dialling Mode</label>
              <p><span class="badge badge-sm badge-primary">Ringless Voicemail</span></p>
            </div>

            <div class="form-group">
              <i style="color:black;" class="ti-timer"></i>
              <label class="form-label ms-1">Time Zone Rule</label>
              <p>
                <span class="badge badge-sm badge-{{ $campaign->time_based_calling == '1' ? 'success' : 'danger' }}">
                  {{ $campaign->time_based_calling == '1' ? 'Yes' : 'No' }}
                </span>
              </p>
            </div>

            <div class="form-group">
              <i style="color:black;" class="ti-mobile"></i>
              <label class="form-label ms-1">Caller ID</label>
              <p>
                <span class="badge badge-sm badge-primary">
                  @if($campaign->caller_id == 'custom') Custom
                  @elseif ($campaign->caller_id == 'area_code') Area Code
                  @elseif ($campaign->caller_id == 'area_code_random') Area Code & Randomizer
                  @elseif ($campaign->caller_id == 'area_code_3') Area Code +3
                  @elseif ($campaign->caller_id == 'area_code_4') Area Code +4
                  @elseif ($campaign->caller_id == 'area_code_5') Area Code +5
                  @endif
                </span>
              </p>
            </div>

            <div class="form-group">
              <i style="color:black;" class="ti-calendar"></i>
              <label class="form-label ms-1">Created Date</label>
              <p><span class="badge  badge-sm badge-primary">{{ date('Y-m-d H:i', strtotime($campaign->updated_at)) }}</span></p>
            </div>

          </div>

          <!-- Right Column -->
          <div class="col-md-6">

            <div class="form-group">
              <i style="color:black;" class="ti-timer"></i>
              <label class="form-label ms-1">Description</label>
              <p><span class="badge badge-sm badge-primary">{{ $campaign->description }}</span></p>
            </div>

            <div class="form-group">
              <i style="color:black;" class="ti-mobile"></i>
              <label class="form-label ms-1">Status</label>
              <p>
                <span class="badge badge-sm badge-{{ $campaign->status == '1' ? 'success' : 'danger' }}">
                  {{ $campaign->status == '1' ? 'Active' : 'Inactive' }}
                </span>
              </p>
            </div>

            <div class="form-group">
              <i style="color:black;" class="ti-email"></i>
              <label class="form-label ms-1">Call Time</label>
              <p>
                <span class="badge badge-sm badge-primary">
                  {{ date('g:i A', strtotime($campaign->call_time_start)) }} to {{ date('g:i A', strtotime($campaign->call_time_end)) }}
                </span>
              </p>
            </div>

            <div class="form-group">
              <i style="color:black;" class="ti-mobile"></i>
              <label class="form-label ms-1">Custom Caller ID</label>
              <p>
                <span class="badge badge-sm badge-primary">
                  @if($campaign->caller_id == 'custom') {{ $campaign->custom_caller_id }} @else NA @endif
                </span>
              </p>
            </div>

            <div class="form-group">
              <i style="color:black;" class="ti-list"></i>
              <label class="form-label ms-1">Total Leads</label>
              <p><span class="badge badge-sm badge-primary">{{ $campaign->rowCountLeadReport }}</span></p>
            </div>

          </div>

        </div>
      </div>

    </div>
  </div>
</div>

                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <div class="modal-body">
                        <p>You are about to delete <b><i class="title"></i></b> list.</p>
                        <p>Do you want to proceed?</p>
                        <input type="hidden" class="form-control" name="campaign_id" value="" id="campaign_id">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                        <button type="submit" name="submit" class="btn btn-danger btn-sm deleteList">Delete</button>
                    </div>

                </div>
            </div>
            <!-- /.row -->

</section>
<!-- /.content -->

<script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM="
    crossorigin="anonymous"></script>

<script>
$(".openCampaignDelete").click(function() {
    var delete_id = $(this).data('campaignid');
    $("#delete").modal('show');
    $("#campaign_id").val(delete_id);

});
</script>
<script>
$(function() {
    $("#tickets").on("click", ".btn-toggle", function() {
        console.log('hi');
        var status = $(this).hasClass('active') ? 1 : 0;
        var listid = $(this).data('listid');


        $.ajax({
            type: "GET",
            dataType: "json",
            url: '/smsai/campaign/update-status/' + listid + '/' + status,

            success: function(data) {
                if (data.status == 'true') {
                    toastr.success(data.message);
                } else {
                    toastr.error(data.message);

                }

                console.log(data.success);
                window.location.reload(1);
            }
        });
    })
})
$(document).on("click", ".deleteList", function() {
    // if (confirm("Are you sure you want to delete this record?")) {
    var campaign = $("#campaign_id").val();
    //alert(campaign);
    //var account_no = $(this).data('account_no');
    //alert(account_no);
    var el = this;
    $.ajax({
        url: 'smsai/campaign/delete/' + campaign,
        type: 'get',
        success: function(response) {
            toastr.success('Campaign has been deleted successfully');
            window.location.reload(1);
        }
    });
});
</script>


@endsection